/*
 * Decompiled with CFR 0.152.
 */
package gama.dependencies.kabeja.math;

import gama.dependencies.kabeja.dxf.helpers.Point;

public class NURBS {
    protected Point[] controlPoints;
    protected double[] knots;
    protected double[] weights;
    protected int degree;
    protected boolean closed = false;

    public NURBS(Point[] pointArray, double[] dArray, double[] dArray2, int n) {
        this.controlPoints = pointArray;
        this.knots = dArray;
        this.weights = dArray2;
        this.degree = n;
        if (this.weights.length == 0) {
            this.weights = new double[this.controlPoints.length];
        }
        int n2 = 0;
        while (n2 < dArray2.length) {
            if (dArray2[n2] == 0.0) {
                dArray2[n2] = 1.0;
            }
            ++n2;
        }
    }

    public double[] getBasicFunctions(int n, double d) {
        double[] dArray = new double[this.degree + 1];
        dArray[0] = 1.0;
        double[] dArray2 = new double[this.degree + 1];
        double[] dArray3 = new double[this.degree + 1];
        int n2 = 1;
        while (n2 <= this.degree) {
            dArray2[n2] = d - this.knots[n + 1 - n2];
            dArray3[n2] = this.knots[n + n2] - d;
            double d2 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                double d3 = dArray[n3] / (dArray3[n3 + 1] + dArray2[n2 - n3]);
                dArray[n3] = d2 + dArray3[n3 + 1] * d3;
                d2 = dArray2[n2 - n3] * d3;
                ++n3;
            }
            dArray[n2] = d2;
            ++n2;
        }
        return dArray;
    }

    public Point getPointAt(int n, double d) {
        Point point = new Point();
        double[] dArray = this.getBasicFunctions(n, d);
        double d2 = 0.0;
        int n2 = 0;
        while (n2 <= this.degree) {
            int n3 = n - this.degree + n2;
            double d3 = this.weights[n3];
            point.setX(point.getX() + dArray[n2] * this.controlPoints[n3].getX() * d3);
            point.setY(point.getY() + dArray[n2] * this.controlPoints[n3].getY() * d3);
            point.setZ(point.getZ() + dArray[n2] * this.controlPoints[n3].getZ() * d3);
            d2 += dArray[n2] * d3;
            ++n2;
        }
        point.setX(point.getX() / d2);
        point.setY(point.getY() / d2);
        point.setZ(point.getZ() / d2);
        return point;
    }

    public Point getPointAt(double d) {
        int n = this.findSpawnIndex(d);
        return this.getPointAt(n, d);
    }

    public int findSpawnIndex(double d) {
        if (d == this.knots[this.controlPoints.length + 1]) {
            return this.controlPoints.length;
        }
        int n = this.degree;
        int n2 = this.controlPoints.length + 1;
        int n3 = (n + n2) / 2;
        while (d < this.knots[n3] || d >= this.knots[n3 + 1]) {
            if (d < this.knots[n3]) {
                n2 = n3;
            } else {
                n = n3;
            }
            n3 = (n + n2) / 2;
        }
        return n3;
    }

    public Point[] getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(Point[] pointArray) {
        this.controlPoints = pointArray;
    }

    public double[] getKnots() {
        return this.knots;
    }

    public void setKnots(double[] dArray) {
        this.knots = dArray;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] dArray) {
        this.weights = dArray;
    }

    public int getDegree() {
        return this.degree;
    }

    public void setDegree(int n) {
        this.degree = n;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }
}

