/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.Emotion;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.spatial.SpatialQueries;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.util.Iterator;
import java.util.List;

@GamlAnnotations.inside(kinds={0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the name of the perception")}), @GamlAnnotations.facet(name="as", type={14}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a species")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean to tell when does the perceive is active")}), @GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="setting this facet to 'true' will allow 'perceive' to use concurrency with a parallel_bdi architecture; setting it to an integer will set the threshold under which they will be run sequentially (the default is initially 20, but can be fixed in the preferences). This facet is true by default.")}), @GamlAnnotations.facet(name="in", type={2, 13}, optional=true, doc={@GamlAnnotations.doc(value="a float or a geometry. If it is a float, it's a radius of a detection area. If it is a geometry, it is the area of detection of others species.")}), @GamlAnnotations.facet(name="emotion", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="The emotion needed to do the perception")}), @GamlAnnotations.facet(name="threshold", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Threshold linked to the emotion.")}), @GamlAnnotations.facet(name="target", type={16, 11}, of=11, optional=false, doc={@GamlAnnotations.doc(value="the list of the agent you want to perceive")})}, omissible="name")
@GamlAnnotations.doc(value="Allow the agent, with a bdi architecture, to perceive others agents", usages={@GamlAnnotations.usage(value="the basic syntax to perceive agents inside a circle of perception", examples={@GamlAnnotations.example(value="perceive name_of_perception target: the_agents_you_want_to_perceive in: distance when: condition {", isExecutable=false), @GamlAnnotations.example(value="\t//Here you are in the context of the perceived agents. To refer to the agent who does the perception, use myself.", isExecutable=false), @GamlAnnotations.example(value="\t//If you want to make an action (such as adding a belief for example), use ask myself{ do the_action}", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class PerceiveStatement
extends AbstractStatementSequence {
    public static final String PERCEIVE = "perceive";
    public static final String EMOTION = "emotion";
    public static final String THRESHOLD = "threshold";
    private RemoteSequence sequence = null;
    final IExpression _when;
    final IExpression _in;
    final IExpression emotion;
    final IExpression threshold;
    final IExpression parallel;
    private final IExpression target = this.getFacet(new String[]{"target"});

    public IExpression getWhen() {
        return this._when;
    }

    public IExpression getIn() {
        return this._in;
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    public void leaveScope(IScope iScope) {
        super.leaveScope(iScope);
    }

    public PerceiveStatement(IDescription iDescription) {
        super(iDescription);
        this._when = this.getFacet(new String[]{"when"});
        this._in = this.hasFacet("in") ? this.getFacet(new String[]{"in"}) : null;
        if (this.hasFacet("name")) {
            this.setName(this.getLiteral("name"));
        }
        this.emotion = this.getFacet(new String[]{EMOTION});
        this.threshold = this.getFacet(new String[]{THRESHOLD});
        this.parallel = this.getFacet(new String[]{"parallel"});
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Iterator iterator;
        if (this._when != null && !Cast.asBool((IScope)iScope, (Object)this._when.value(iScope)).booleanValue()) {
            return null;
        }
        if (this.emotion != null && !BdiUtils.hasEmotion(iScope, (Emotion)this.emotion.value(iScope)).booleanValue()) {
            return null;
        }
        if (this.threshold != null && (this.emotion == null || BdiUtils.getEmotion((IScope)iScope, (Emotion)((Emotion)this.emotion.value((IScope)iScope))).intensity < (Double)this.threshold.value(iScope))) {
            return null;
        }
        Object object = this.target.value(iScope);
        Object object2 = null;
        IAgent iAgent = iScope.getAgent();
        if (this._in != null) {
            object2 = this._in.value(iScope);
        }
        if (object2 instanceof Number) {
            IAgent iAgent2;
            Number number = (Number)object2;
            IList iList = GamaListFactory.create();
            double d = Cast.asFloat((IScope)iScope, (Object)number);
            if (object instanceof IContainer) {
                IContainer iContainer = (IContainer)object;
                iList = SpatialQueries.at_distance((IScope)iScope, (IContainer)iContainer, (Double)Cast.asFloat((IScope)iScope, (Object)object2));
            } else if (object instanceof IAgent && iAgent.euclidianDistanceTo((IShape)(iAgent2 = (IAgent)object)) <= d) {
                iList.add(object);
            }
            GamaExecutorService.execute((IScope)iScope, (IExecutable)this.sequence, (List)iList.listValue(iScope, Types.AGENT, false), null);
            return this;
        }
        if (object2 instanceof GamaGeometryType || object2 instanceof GamaShape) {
            IAgent iAgent3;
            IList iList = GamaListFactory.create();
            IShape iShape = Cast.asGeometry((IScope)iScope, (Object)object2);
            if (object instanceof IContainer) {
                IContainer iContainer = (IContainer)object;
                iList = SpatialQueries.overlapping((IScope)iScope, (IContainer)iContainer, (IShape)iShape);
            } else if (object instanceof IAgent && iShape.intersects((IShape)(iAgent3 = (IAgent)object))) {
                iList.add(object);
            }
            GamaExecutorService.execute((IScope)iScope, (IExecutable)this.sequence, (List)iList.listValue(iScope, Types.AGENT, false), null);
            return this;
        }
        ExecutionResult executionResult = null;
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            v0 = iContainer.iterable(iScope).iterator();
        } else if (object instanceof IAgent) {
            IAgent iAgent4 = (IAgent)object;
            v0 = this.transformAgentToList(iAgent4, iScope);
        } else {
            v0 = iterator = null;
        }
        if (iterator != null) {
            while (iterator.hasNext() && (executionResult = iScope.execute((IExecutable)this.sequence, (IAgent)iterator.next(), null)).passed()) {
            }
        }
        if (executionResult != null) {
            return executionResult.getValue();
        }
        return null;
    }

    Iterator<IAgent> transformAgentToList(IAgent iAgent, IScope iScope) {
        IList iList = GamaListFactory.create();
        iList.add((Object)iAgent);
        return iList.iterable(iScope).iterator();
    }

    public IExpression getParallel() {
        return this.parallel;
    }
}

