/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.Emotion;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the unconscious contagion")}), @GamlAnnotations.facet(name="emotion", type={546706}, optional=false, doc={@GamlAnnotations.doc(value="the emotion that will be copied with the contagion")}), @GamlAnnotations.facet(name="charisma", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The charisma value of the perceived agent (between 0 and 1)")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="A boolean value to get the emotion only with a certain condition")}), @GamlAnnotations.facet(name="threshold", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The threshold value to make the contagion")}), @GamlAnnotations.facet(name="decay", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The decay value of the emotion added to the agent")}), @GamlAnnotations.facet(name="receptivity", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The receptivity value of the current agent (between 0 and 1)")})}, omissible="name")
@GamlAnnotations.doc(value="enables to directly copy an emotion present in the perceived species.", examples={@GamlAnnotations.example(value="unconscious_contagion emotion:fearConfirmed; "), @GamlAnnotations.example(value="unconscious_contagion emotion:fearConfirmed charisma: 0.5 receptivity: 0.5;")})
public class UnconsciousContagionStatement
extends AbstractStatement {
    public static final String UNCONSCIOUSCONTAGION = "unconscious_contagion";
    public static final String EMOTION = "emotion";
    public static final String CHARISMA = "charisma";
    public static final String RECEPTIVITY = "receptivity";
    public static final String THRESHOLD = "threshold";
    public static final String DECAY = "decay";
    final IExpression name = this.getFacet(new String[]{"name"});
    final IExpression emotion = this.getFacet(new String[]{"emotion"});
    final IExpression charisma = this.getFacet(new String[]{"charisma"});
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression receptivity = this.getFacet(new String[]{"receptivity"});
    final IExpression threshold = this.getFacet(new String[]{"threshold"});
    final IExpression decay = this.getFacet(new String[]{"decay"});

    public UnconsciousContagionStatement(IDescription iDescription) {
        super(iDescription);
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent[] iAgentArray = iScope.getAgentsStack();
        IAgent iAgent = iAgentArray[iAgentArray.length - 2];
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.25;
        IScope iScope2 = null;
        if (iAgent != null) {
            iScope2 = iAgent.getScope().copy("in UnconsciousContagionStatement");
            iScope2.push(iAgent);
        }
        if (this.when != null && !Cast.asBool((IScope)iScope2, (Object)this.when.value(iScope2)).booleanValue() || this.emotion == null) {
            GAMA.releaseScope((IScope)iScope2);
            return null;
        }
        if (BdiUtils.hasEmotion(iScope, (Emotion)this.emotion.value(iScope)).booleanValue()) {
            d = (Double)(this.charisma != null ? this.charisma.value(iScope) : iScope.getAgent().getAttribute(CHARISMA));
            d2 = (Double)(this.receptivity != null ? this.receptivity.value(iScope2) : iAgent.getAttribute(RECEPTIVITY));
            if (this.threshold != null) {
                d3 = (Double)this.threshold.value(iScope2);
            }
            if (d * d2 >= d3) {
                Emotion emotion = BdiUtils.getEmotion(iScope, (Emotion)this.emotion.value(iScope));
                Emotion emotion2 = emotion.hasIntensity() ? new Emotion(emotion.getName(), emotion.getIntensity() * d * d2, emotion.getAbout(), emotion.getDecay()) : (Emotion)emotion.copy(iScope);
                emotion2.setAgentCause(iScope.getAgent());
                if (this.decay != null) {
                    emotion2.setDecay(BdiUtils.clamp((Double)this.decay.value(iScope2), 0.0, 1.0));
                }
                BdiUtils.addEmotion(iScope2, emotion2);
            }
        }
        GAMA.releaseScope((IScope)iScope2);
        return null;
    }
}

