/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.extension.bdi.Predicate;
import gama.extension.bdi.SimpleBdiPlanStatement;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Objects;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="The name of this BDI plan")}), @GamlAnnotations.variable(name="when", type=4, doc={@GamlAnnotations.doc(value="represent the when facet of a plan")}), @GamlAnnotations.variable(name="intention", type=546708, doc={@GamlAnnotations.doc(value="A string representing the current intention of this BDI plan")}), @GamlAnnotations.variable(name="finished_when", type=4, doc={@GamlAnnotations.doc(value="a string representing the finished condition of this plan")}), @GamlAnnotations.variable(name="instantaneous", type=3, doc={@GamlAnnotations.doc(value="indicates if the plan is instantaneous")})})
public class BDIPlan
implements IValue {
    private SimpleBdiPlanStatement planstatement;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", (Object)this.getName());
    }

    @GamlAnnotations.getter(value="name")
    public String getName() {
        return this.planstatement.getName();
    }

    @GamlAnnotations.getter(value="when")
    public String getWhen() {
        return this.planstatement._when == null ? null : this.planstatement._when.serializeToGaml(true);
    }

    @GamlAnnotations.getter(value="finished_when")
    public String getFinishedWhen() {
        return this.planstatement._executedwhen == null ? null : this.planstatement._executedwhen.serializeToGaml(true);
    }

    @GamlAnnotations.getter(value="intention")
    public Predicate getIntention(IScope iScope) {
        return (Predicate)(this.planstatement._intention == null ? null : this.planstatement._intention.value(iScope));
    }

    @GamlAnnotations.getter(value="instantaneous")
    public boolean getInstantaneous(IScope iScope) {
        return this.planstatement._instantaneous == null ? false : Cast.asBool((IScope)iScope, (Object)this.planstatement._instantaneous.value(iScope));
    }

    public SimpleBdiPlanStatement getPlanStatement() {
        return this.planstatement;
    }

    public BDIPlan() {
    }

    public BDIPlan(SimpleBdiPlanStatement simpleBdiPlanStatement) {
        this.planstatement = simpleBdiPlanStatement;
    }

    public void setSimpleBdiPlanStatement(SimpleBdiPlanStatement simpleBdiPlanStatement) {
        this.planstatement = simpleBdiPlanStatement;
    }

    public String toString() {
        return this.serializeToGaml(true);
    }

    public String serializeToGaml(boolean bl) {
        return "BDIPlan(" + this.planstatement.getName() + ")";
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.serializeToGaml(true);
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new BDIPlan(this.planstatement);
    }

    public boolean isSimilarName(BDIPlan bDIPlan) {
        if (this == bDIPlan) {
            return true;
        }
        return bDIPlan != null && Objects.equals((Object)this.planstatement, (Object)bDIPlan.planstatement);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.planstatement});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BDIPlan bDIPlan = (BDIPlan)object;
        return Objects.equals((Object)this.planstatement, (Object)bDIPlan.planstatement);
    }

    public IType<?> getGamlType() {
        return Types.get((int)-202);
    }
}

