/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.LawStatement;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Norm;
import gama.extension.bdi.Predicate;
import gama.extension.bdi.Sanction;
import gama.extension.bdi.SocialLink;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;

public class BdiUtils {
    public static int clamp(long l, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        return (int)Math.min((long)n2, Math.max(l, (long)n));
    }

    public static long clamp(long l, long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException(l2 + " > " + l3);
        }
        return Math.min(l3, Math.max(l, l2));
    }

    public static double clamp(double d, double d2, double d3) {
        if (!(d2 < d3)) {
            if (Double.isNaN(d2)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(d3)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(d2, d3) > 0) {
                throw new IllegalArgumentException(d2 + " > " + d3);
            }
        }
        return Math.min(d3, Math.max(d, d2));
    }

    public static float clamp(float f, float f2, float f3) {
        if (!(f2 < f3)) {
            if (Float.isNaN(f2)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Float.isNaN(f3)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Float.compare(f2, f3) > 0) {
                throw new IllegalArgumentException(f2 + " > " + f3);
            }
        }
        return Math.min(f3, Math.max(f, f2));
    }

    public static List<LawStatement> getLaws(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg("law_base") ? iScope.getListArg("law_base") : (List)iAgent.getAttribute("law_base");
    }

    public static List<Norm> getNorms(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg("norm_base") ? iScope.getListArg("norm_base") : (List)iAgent.getAttribute("norm_base");
    }

    public static List<Sanction> getSanctions(IScope iScope) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg("sanction_base") ? iScope.getListArg("sanction_base") : (List)iAgent.getAttribute("sanction_base");
    }

    public static IList<MentalState> getBase(IScope iScope, String string) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg(string) ? iScope.getListArg(string) : (IList)iAgent.getAttribute(string);
    }

    public static IList<Emotion> getEmotionBase(IScope iScope, String string) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg(string) ? iScope.getListArg(string) : (IList)iAgent.getAttribute(string);
    }

    public static IList<SocialLink> getSocialBase(IScope iScope, String string) {
        IAgent iAgent = iScope.getAgent();
        return iScope.hasArg(string) ? iScope.getListArg(string) : (IList)iAgent.getAttribute(string);
    }

    public static boolean removeFromBase(IScope iScope, MentalState mentalState, String string) {
        IList<MentalState> iList = BdiUtils.getBase(iScope, string);
        return iList.remove((Object)mentalState);
    }

    public static boolean removeFromBase(IScope iScope, Emotion emotion, String string) {
        IList<Emotion> iList = BdiUtils.getEmotionBase(iScope, string);
        return iList.remove((Object)emotion);
    }

    public static boolean removeFromBase(IScope iScope, SocialLink socialLink, String string) {
        IList<SocialLink> iList = BdiUtils.getSocialBase(iScope, string);
        return iList.remove((Object)socialLink);
    }

    public static boolean removeFromBase(IScope iScope, Norm norm) {
        List<Norm> list = BdiUtils.getNorms(iScope);
        return list.remove(norm);
    }

    public static boolean addToBase(IScope iScope, MentalState mentalState, String string) {
        return BdiUtils.addToBase(iScope, mentalState, BdiUtils.getBase(iScope, string));
    }

    public static boolean addToBase(IScope iScope, Emotion emotion, String string) {
        return BdiUtils.addToBase(iScope, emotion, BdiUtils.getEmotionBase(iScope, string));
    }

    public static boolean addToBase(IScope iScope, SocialLink socialLink, String string) {
        return BdiUtils.addToBase(iScope, socialLink, BdiUtils.getSocialBase(iScope, string));
    }

    public static boolean addToBase(IScope iScope, Norm norm) {
        List<Norm> list = BdiUtils.getNorms(iScope);
        return list.add(norm);
    }

    public static boolean addToBase(IScope iScope, MentalState mentalState, IList<MentalState> iList) {
        if (!iList.contains((Object)mentalState)) {
            return iList.add((Object)mentalState);
        }
        return false;
    }

    public static boolean addToBase(IScope iScope, Emotion emotion, IList<Emotion> iList) {
        iList.remove((Object)emotion);
        return iList.add((Object)emotion);
    }

    public static boolean addToBase(IScope iScope, SocialLink socialLink, IList<SocialLink> iList) {
        iList.remove((Object)socialLink);
        return iList.add((Object)socialLink);
    }

    public static Boolean addBelief(IScope iScope, MentalState mentalState) {
        Boolean bl = iScope.hasArg("use_emotions_architecture") ? iScope.getBoolArg("use_emotions_architecture") : (Boolean)iScope.getAgent().getAttribute("use_emotions_architecture");
        MentalState mentalState2 = null;
        if (mentalState == null) {
            return false;
        }
        if (bl.booleanValue()) {
            BdiUtils.createJoyFromPredicate(iScope, mentalState);
            BdiUtils.createSatisfactionFromMentalState(iScope, mentalState);
            BdiUtils.createPrideFromMentalState(iScope, mentalState);
            BdiUtils.createHappyForFromMentalState(iScope, mentalState);
        }
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "belief_base")) {
            if (mentalState3.getPredicate() == null || mentalState.getPredicate() == null || !mentalState3.getPredicate().equalsButNotTruth(mentalState.getPredicate())) continue;
            mentalState2 = mentalState3;
        }
        if (mentalState2 != null) {
            BdiUtils.removeFromBase(iScope, mentalState2, "belief_base");
        }
        if (BdiUtils.getBase(iScope, "intention_base").contains((Object)mentalState)) {
            BdiUtils.removeFromBase(iScope, mentalState, "desire_base");
            BdiUtils.removeFromBase(iScope, mentalState, "intention_base");
            iScope.getAgent().setAttribute("current_plan", null);
            iScope.getAgent().setAttribute("current_norm", null);
        }
        if (BdiUtils.getBase(iScope, "uncertainty_base").contains((Object)mentalState)) {
            BdiUtils.removeFromBase(iScope, mentalState, "uncertainty_base");
        }
        if (BdiUtils.getBase(iScope, "obligation_base").contains((Object)mentalState)) {
            BdiUtils.removeFromBase(iScope, mentalState, "obligation_base");
        }
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "uncertainty_base")) {
            if (mentalState3.getPredicate() == null || mentalState.getPredicate() == null || !mentalState3.getPredicate().equalsButNotTruth(mentalState.getPredicate())) continue;
            mentalState2 = mentalState3;
        }
        if (mentalState2 != null) {
            BdiUtils.removeFromBase(iScope, mentalState2, "uncertainty_base");
        }
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "intention_base")) {
            List<MentalState> list = null;
            List<MentalState> list2 = null;
            if (mentalState3.getPredicate() != null) {
                list = mentalState3.getSubintentions();
                list2 = mentalState3.getOnHoldUntil();
            }
            if (list != null && list.contains(mentalState)) {
                list.remove(mentalState);
            }
            if (list2 == null || !list2.contains(mentalState)) continue;
            list2.remove(mentalState);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState, "belief_base");
    }

    public static MentalState getBeliefMentalStateFromBase(IScope iScope, MentalState mentalState) {
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, "belief_base")) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                return mentalState2;
            }
        }
        return null;
    }

    public static Boolean addDesire(IScope iScope, MentalState mentalState, MentalState mentalState2) {
        if (mentalState != null && mentalState.getPredicate() != null) {
            if (mentalState.getPredicate().getSubintentions() == null) {
                mentalState.getPredicate().subintentions = GamaListFactory.create((IType)Types.get((int)546704));
            }
            if (mentalState2.getPredicate() != null) {
                mentalState2.getPredicate().setSuperIntention(mentalState);
            }
            mentalState.getPredicate().getSubintentions().add(mentalState2);
        }
        mentalState2.setOwner(iScope.getAgent());
        BdiUtils.addToBase(iScope, mentalState2, "desire_base");
        return false;
    }

    public static Boolean removeBelief(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "belief_base").remove((Object)mentalState);
    }

    public static Boolean removeIntention(IScope iScope, MentalState mentalState) {
        BdiUtils.getBase(iScope, "intention_base").remove((Object)mentalState);
        for (MentalState mentalState2 : BdiUtils.getBase(iScope, "intention_base")) {
            List<MentalState> list;
            if (mentalState2.getPredicate() == null) continue;
            List<MentalState> list2 = mentalState2.getSubintentions();
            if (list2 != null && list2.contains(mentalState)) {
                list2.remove(mentalState);
            }
            if ((list = mentalState2.getOnHoldUntil()) == null || !list.contains(mentalState)) continue;
            list.remove(mentalState);
        }
        return true;
    }

    public static Boolean clearIntention(IScope iScope) {
        BdiUtils.getBase(iScope, "intention_base").clear();
        iScope.getAgent().setAttribute("current_plan", null);
        return true;
    }

    public static boolean addEmotion(IScope iScope, Emotion emotion) {
        Emotion emotion2;
        Emotion emotion3 = emotion;
        if (emotion3 == null) {
            return false;
        }
        if (emotion.hasIntensity() && BdiUtils.hasEmotion(iScope, emotion).booleanValue() && (emotion2 = BdiUtils.getEmotion(iScope, emotion)).hasIntensity()) {
            emotion3 = new Emotion(emotion.getName(), Math.min(1.0, emotion.getIntensity() + emotion2.getIntensity()), emotion.getAbout(), emotion.getAgentCause());
            if (emotion2.getIntensity() >= emotion.getIntensity()) {
                emotion3.setDecay(emotion2.getDecay());
            } else {
                emotion3.setDecay(emotion.getDecay());
            }
        }
        emotion3.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, emotion3, "emotion_base");
    }

    public static Boolean hasEmotion(IScope iScope, Emotion emotion) {
        return BdiUtils.getEmotionBase(iScope, "emotion_base").contains((Object)emotion);
    }

    public static Emotion getEmotion(IScope iScope, Emotion emotion) {
        for (Emotion emotion2 : BdiUtils.getEmotionBase(iScope, "emotion_base")) {
            if (!emotion.equals(emotion2)) continue;
            return emotion2;
        }
        return null;
    }

    public static Boolean removeEmotion(IScope iScope, Emotion emotion) {
        return BdiUtils.getEmotionBase(iScope, "emotion_base").remove((Object)emotion);
    }

    public static Boolean addUncertainty(IScope iScope, MentalState mentalState) {
        Boolean bl = iScope.hasArg("use_emotions_architecture") ? iScope.getBoolArg("use_emotions_architecture") : (Boolean)iScope.getAgent().getAttribute("use_emotions_architecture");
        MentalState mentalState2 = null;
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "belief_base")) {
            if (mentalState3.getPredicate() == null || mentalState.getPredicate() == null || !mentalState3.getPredicate().equalsButNotTruth(mentalState.getPredicate())) continue;
            mentalState2 = mentalState3;
        }
        if (mentalState2 != null) {
            BdiUtils.removeFromBase(iScope, mentalState2, "belief_base");
        }
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "uncertainty_base")) {
            if (mentalState3.getPredicate() == null || mentalState.getPredicate() == null || !mentalState3.getPredicate().equalsButNotTruth(mentalState.getPredicate())) continue;
            mentalState2 = mentalState3;
        }
        if (mentalState2 != null) {
            BdiUtils.removeFromBase(iScope, mentalState2, "uncertainty_base");
        }
        if (bl.booleanValue()) {
            BdiUtils.createHopeFromMentalState(iScope, mentalState);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState, "uncertainty_base");
    }

    public static Boolean hasUncertainty(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "uncertainty_base").contains((Object)mentalState);
    }

    public static Boolean removeUncertainty(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "uncertainty_base").remove((Object)mentalState);
    }

    public static Boolean addIdeal(IScope iScope, MentalState mentalState) {
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState, "ideal_base");
    }

    public static Boolean hasIdeal(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "ideal_base").contains((Object)mentalState);
    }

    public static Boolean removeIdeal(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "ideal_base").remove((Object)mentalState);
    }

    public static Boolean hasObligation(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "obligation_base").contains((Object)mentalState);
    }

    public static Boolean removeObligation(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "obligation_base").remove((Object)mentalState);
    }

    public static boolean addSocialLink(IScope iScope, SocialLink socialLink) {
        boolean bl;
        if (socialLink == null) {
            return false;
        }
        boolean bl2 = socialLink.getLiking() >= -1.0 && socialLink.getLiking() <= 1.0;
        boolean bl3 = socialLink.getDominance() >= -1.0 && socialLink.getDominance() <= 1.0;
        boolean bl4 = socialLink.getSolidarity() >= 0.0 && socialLink.getSolidarity() <= 1.0;
        boolean bl5 = bl = socialLink.getFamiliarity() >= 0.0 && socialLink.getFamiliarity() <= 1.0;
        if (bl2 && bl3 && bl4 && bl && BdiUtils.getSocialLink(iScope, socialLink) == null) {
            return BdiUtils.addToBase(iScope, socialLink, "social_link_base");
        }
        return false;
    }

    public static SocialLink getSocialLink(IScope iScope, SocialLink socialLink) {
        for (SocialLink socialLink2 : BdiUtils.getSocialBase(iScope, "social_link_base")) {
            if (socialLink2.equals(socialLink)) {
                return socialLink2;
            }
            if (!socialLink2.equalsInAgent(socialLink)) continue;
            return socialLink2;
        }
        return null;
    }

    public static Boolean hasSocialLink(IScope iScope, SocialLink socialLink) {
        return BdiUtils.getSocialBase(iScope, "social_link_base").contains((Object)socialLink);
    }

    public static Boolean removeSocialLink(IScope iScope, SocialLink socialLink) {
        return BdiUtils.getSocialBase(iScope, "social_link_base").remove((Object)socialLink);
    }

    public static Boolean hasBelief(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "belief_base").contains((Object)mentalState);
    }

    public static Boolean hasDesire(IScope iScope, MentalState mentalState) {
        return BdiUtils.getBase(iScope, "desire_base").contains((Object)mentalState);
    }

    public static Boolean removeDesire(IScope iScope, MentalState mentalState) {
        BdiUtils.getBase(iScope, "desire_base").remove((Object)mentalState);
        BdiUtils.getBase(iScope, "intention_base").remove((Object)mentalState);
        for (MentalState mentalState2 : BdiUtils.getBase(iScope, "intention_base")) {
            List<MentalState> list;
            if (mentalState2.getPredicate() == null) continue;
            List<MentalState> list2 = mentalState2.getPredicate().getSubintentions();
            if (list2 != null && list2.contains(mentalState)) {
                list2.remove(mentalState);
            }
            if ((list = mentalState2.getPredicate().getOnHoldUntil()) == null || !list.contains(mentalState)) continue;
            list.remove(mentalState);
        }
        return true;
    }

    public static void updateSocialLink(IScope iScope, SocialLink socialLink) {
        BdiUtils.updateAppreciation(iScope, socialLink);
        BdiUtils.updateDominance(iScope, socialLink);
        BdiUtils.updateSolidarity(iScope, socialLink);
        BdiUtils.updateFamiliarity(iScope, socialLink);
    }

    private static void updateAppreciation(IScope iScope, SocialLink socialLink) {
        Double d;
        Boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        IAgent iAgent = socialLink.getAgent();
        Double d2 = 0.0;
        Double d3 = 0.0;
        Double d4 = 0.0;
        Double d5 = 0.0;
        Double d6 = 0.1;
        if (bl.booleanValue()) {
            d = (Double)iScope.getAgent().getAttribute("neurotism");
            d6 = 1.0 - d;
        }
        d = socialLink.getLiking();
        for (Emotion emotion : BdiUtils.getEmotionBase(iScope, "emotion_base")) {
            if (emotion.getAgentCause() == null || !emotion.getAgentCause().equals(iAgent)) continue;
            if ("joy".equals(emotion.getName()) || "hope".equals(emotion.getName())) {
                d2 = d2 + 1.0;
                d3 = d3 + emotion.getIntensity();
            }
            if (!"sadness".equals(emotion.getName()) && !"fear".equals(emotion.getName())) continue;
            d4 = d4 + 1.0;
            d5 = d5 + emotion.getIntensity();
        }
        d3 = d2 != 0.0 ? d3 / d2 : 0.0;
        d5 = d4 != 0.0 ? d5 / d4 : 0.0;
        d = BdiUtils.clamp(d + Maths.abs((Double)d) * (1.0 - Maths.abs((Double)d)) * socialLink.getSolidarity() + d6 * (1.0 - Maths.abs((Double)d)) * (d3 - d5), -1.0, 1.0);
        socialLink.setLiking(d);
    }

    private static void updateDominance(IScope iScope, SocialLink socialLink) {
        double d;
        Boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        IAgent iAgent = socialLink.getAgent();
        IScope iScope2 = null;
        if (iAgent != null) {
            iScope2 = iAgent.getScope().copy("in SimpleBdiArchitecture");
            iScope2.push(iAgent);
        }
        IAgent iAgent2 = iScope.getAgent();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.1;
        if (bl.booleanValue()) {
            d = (Double)iScope.getAgent().getAttribute("neurotism");
            d6 = 1.0 - d;
        }
        d = socialLink.getDominance();
        for (Emotion emotion : BdiUtils.getEmotionBase(iScope, "emotion_base")) {
            if (emotion.getAgentCause() == null || !emotion.getAgentCause().equals(iAgent) || !"sadness".equals(emotion.getName()) && !"fear".equals(emotion.getName())) continue;
            d4 += 1.0;
            d5 += emotion.getIntensity().doubleValue();
        }
        if (iScope2 != null) {
            for (Emotion emotion : BdiUtils.getEmotionBase(iScope2, "emotion_base")) {
                if (emotion.getAgentCause() == null || !emotion.getAgentCause().equals(iAgent2) || !"sadness".equals(emotion.getName()) && !"fear".equals(emotion.getName())) continue;
                d2 += 1.0;
                d3 += emotion.getIntensity().doubleValue();
            }
        }
        d3 = d2 != 0.0 ? d3 / d2 : 0.0;
        d5 = d4 != 0.0 ? d5 / d4 : 0.0;
        d = BdiUtils.clamp(d + d6 * Maths.abs((Double)d) * (d3 - d5), 1.0, 1.0);
        socialLink.setDominance(d);
        GAMA.releaseScope((IScope)iScope2);
    }

    private static void updateSolidarity(IScope iScope, SocialLink socialLink) {
        double d;
        double d2;
        Boolean bl = iScope.hasArg("use_personality") ? iScope.getBoolArg("use_personality") : (Boolean)iScope.getAgent().getAttribute("use_personality");
        IAgent iAgent = socialLink.getAgent();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.1;
        if (bl.booleanValue()) {
            d2 = (Double)iScope.getAgent().getAttribute("openness");
            d9 = 1.0 - d2;
        }
        d2 = 0.1;
        if (bl.booleanValue()) {
            d = (Double)iScope.getAgent().getAttribute("neurotism");
            d2 = 1.0 - d;
        }
        d = socialLink.getSolidarity();
        for (Object object : BdiUtils.getEmotionBase(iScope, "emotion_base")) {
            if (((Emotion)object).getAgentCause() == null || !((Emotion)object).getAgentCause().equals(iAgent) || !"sadness".equals(((Emotion)object).getName()) && !"fear".equals(((Emotion)object).getName())) continue;
            d7 += 1.0;
            d8 += ((Emotion)object).getIntensity().doubleValue();
        }
        for (Object object : BdiUtils.getBase(iScope, "belief_base")) {
            if (((MentalState)object).getMentalState() != null && ((MentalState)object).getMentalState().getOwner() != null && ((MentalState)object).getMentalState().getOwner().equals(iAgent) && "Belief".equals(((MentalState)object).getMentalState().getModality())) {
                for (MentalState mentalState : BdiUtils.getBase(iScope, "belief_base")) {
                    if (mentalState.getPredicate() != null && ((MentalState)object).getMentalState().getPredicate() != null && mentalState.getPredicate().equals(((MentalState)object).getMentalState().getPredicate())) {
                        d3 += 1.0;
                        d6 += 1.0;
                    }
                    if (mentalState.getPredicate() == null || ((MentalState)object).getMentalState().getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(((MentalState)object).getMentalState().getPredicate())) continue;
                    d5 += 1.0;
                    d6 += 1.0;
                }
            }
            if (((MentalState)object).getMentalState() != null && ((MentalState)object).getMentalState().getOwner() != null && ((MentalState)object).getMentalState().getOwner().equals(iAgent) && "Desire".equals(((MentalState)object).getMentalState().getModality())) {
                for (MentalState mentalState : BdiUtils.getBase(iScope, "desire_base")) {
                    if (mentalState.getPredicate() != null && ((MentalState)object).getMentalState().getPredicate() != null && mentalState.getPredicate().equals(((MentalState)object).getMentalState().getPredicate())) {
                        d3 += 1.0;
                        d6 += 1.0;
                    }
                    if (mentalState.getPredicate() == null || ((MentalState)object).getMentalState().getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(((MentalState)object).getMentalState().getPredicate())) continue;
                    d5 += 1.0;
                    d6 += 1.0;
                }
            }
            if (((MentalState)object).getMentalState() != null && ((MentalState)object).getMentalState().getOwner() != null && ((MentalState)object).getMentalState().getOwner().equals(iAgent) && "Uncertainty".equals(((MentalState)object).getMentalState().getModality())) {
                for (MentalState mentalState : BdiUtils.getBase(iScope, "uncertainty_base")) {
                    if (mentalState.getPredicate() != null && ((MentalState)object).getMentalState().getPredicate() != null && mentalState.getPredicate().equals(((MentalState)object).getMentalState().getPredicate())) {
                        d3 += 1.0;
                        d6 += 1.0;
                    }
                    if (mentalState.getPredicate() == null || ((MentalState)object).getMentalState().getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(((MentalState)object).getMentalState().getPredicate())) continue;
                    d5 += 1.0;
                    d6 += 1.0;
                }
            }
            if (((MentalState)object).getMentalState() == null || ((MentalState)object).getMentalState().getOwner() == null || !((MentalState)object).getMentalState().getOwner().equals(iAgent) || !"Ideal".equals(((MentalState)object).getMentalState().getModality())) continue;
            for (MentalState mentalState : BdiUtils.getBase(iScope, "ideal_base")) {
                if (mentalState.getPredicate() != null && ((MentalState)object).getMentalState().getPredicate() != null && mentalState.getPredicate().equals(((MentalState)object).getMentalState().getPredicate())) {
                    d3 += 1.0;
                    d6 += 1.0;
                }
                if (mentalState.getPredicate() == null || ((MentalState)object).getMentalState().getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(((MentalState)object).getMentalState().getPredicate())) continue;
                d5 += 1.0;
                d6 += 1.0;
            }
        }
        d8 = d7 != 0.0 ? (d8 /= d7) : 0.0;
        if (d6 != 0.0) {
            d4 = (d3 - d5) / d6;
        }
        if ((d += d * (1.0 - d) * (d9 * d4 - d2 * d8)) > 1.0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        socialLink.setSolidarity(d);
    }

    private static void updateFamiliarity(IScope iScope, SocialLink socialLink) {
        Double d = socialLink.getFamiliarity();
        if ((d = Double.valueOf(d * (1.0 + socialLink.getLiking()))) > 1.0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (socialLink.getFamiliarity() == 0.0) {
            d = 0.1;
        }
        socialLink.setFamiliarity(d);
    }

    private static void createJoyFromPredicate(IScope iScope, MentalState mentalState) {
        Boolean bl;
        Boolean bl2 = bl = iScope.hasArg("use_personality") ? iScope.getBoolArg("use_personality") : (Boolean)iScope.getAgent().getAttribute("use_personality");
        if (mentalState.getPredicate() != null) {
            if (BdiUtils.getBase(iScope, "desire_base").contains((Object)mentalState)) {
                Emotion emotion = new Emotion("joy", mentalState.getPredicate());
                IAgent iAgent = mentalState.getPredicate().getAgentCause();
                if (iAgent != null) {
                    emotion.setAgentCause(iAgent);
                }
                Double d = 1.0;
                Double d2 = 0.0;
                if (bl.booleanValue()) {
                    Double d3 = (Double)iScope.getAgent().getAttribute("neurotism");
                    MentalState mentalState2 = null;
                    for (MentalState mentalState3 : BdiUtils.getBase(iScope, "desire_base")) {
                        if (mentalState3.getPredicate() == null || !mentalState.getPredicate().equals(mentalState3.getPredicate())) continue;
                        mentalState2 = mentalState3;
                    }
                    if (mentalState2 != null && mentalState2.getStrength() >= 0.0 && mentalState.getStrength() >= 0.0) {
                        d = mentalState.getStrength() * mentalState2.getStrength() * (1.0 + (0.5 - d3));
                        if (d > 1.0) {
                            d = 1.0;
                        }
                        if (d < 0.0) {
                            d = 0.0;
                        }
                    }
                    d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d3 * d;
                }
                emotion.setIntensity(d);
                emotion.setDecay(d2);
                BdiUtils.addEmotion(iScope, emotion);
                BdiUtils.createGratificationGratitudeFromJoy(iScope, emotion);
            } else {
                for (MentalState mentalState4 : BdiUtils.getBase(iScope, "desire_base")) {
                    if (mentalState4.getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(mentalState4.getPredicate())) continue;
                    Emotion emotion = new Emotion("sadness", mentalState.getPredicate());
                    IAgent iAgent = mentalState.getPredicate().getAgentCause();
                    if (iAgent != null) {
                        emotion.setAgentCause(iAgent);
                    }
                    Double d = 1.0;
                    Double d4 = 0.0;
                    if (bl.booleanValue()) {
                        Double d5 = (Double)iScope.getAgent().getAttribute("neurotism");
                        MentalState mentalState5 = mentalState4;
                        if (mentalState5.getStrength() >= 0.0 && mentalState.getStrength() >= 0.0) {
                            d = mentalState.getStrength() * mentalState5.getStrength() * (1.0 + (0.5 - d5));
                            if (d > 1.0) {
                                d = 1.0;
                            }
                            if (d < 0.0) {
                                d = 0.0;
                            }
                        }
                        d4 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d5 * d;
                    }
                    emotion.setIntensity(d);
                    emotion.setDecay(d4);
                    BdiUtils.addEmotion(iScope, emotion);
                    BdiUtils.createRemorseAngerFromSadness(iScope, emotion);
                }
            }
        }
    }

    private static void createHopeFromMentalState(IScope iScope, MentalState mentalState) {
        Boolean bl;
        Boolean bl2 = bl = iScope.hasArg("use_personality") ? iScope.getBoolArg("use_personality") : (Boolean)iScope.getAgent().getAttribute("use_personality");
        if (mentalState.getPredicate() != null) {
            if (BdiUtils.getBase(iScope, "desire_base").contains((Object)mentalState)) {
                Emotion emotion = new Emotion("hope", mentalState.getPredicate());
                IAgent iAgent = mentalState.getPredicate().getAgentCause();
                if (iAgent != null) {
                    emotion.setAgentCause(iAgent);
                }
                Double d = 1.0;
                Double d2 = 0.0;
                if (bl.booleanValue()) {
                    Double d3 = (Double)iScope.getAgent().getAttribute("neurotism");
                    MentalState mentalState2 = null;
                    for (MentalState mentalState3 : BdiUtils.getBase(iScope, "desire_base")) {
                        if (mentalState3.getPredicate() == null || !mentalState.getPredicate().equals(mentalState3.getPredicate())) continue;
                        mentalState2 = mentalState3;
                    }
                    if (mentalState2 != null && mentalState2.getStrength() >= 0.0 && mentalState.getStrength() >= 0.0) {
                        d = mentalState.getStrength() * mentalState2.getStrength() * (1.0 + (0.5 - d3));
                        if (d > 1.0) {
                            d = 1.0;
                        }
                        if (d < 0.0) {
                            d = 0.0;
                        }
                    }
                    d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d3 * d;
                }
                emotion.setIntensity(d);
                emotion.setDecay(d2);
                BdiUtils.addEmotion(iScope, emotion);
            } else {
                for (MentalState mentalState4 : BdiUtils.getBase(iScope, "desire_base")) {
                    if (mentalState4.getPredicate() == null || !mentalState.getPredicate().equalsButNotTruth(mentalState4.getPredicate())) continue;
                    Emotion emotion = new Emotion("fear", mentalState.getPredicate());
                    IAgent iAgent = mentalState.getPredicate().getAgentCause();
                    if (iAgent != null) {
                        emotion.setAgentCause(iAgent);
                    }
                    Double d = 1.0;
                    Double d4 = 0.0;
                    if (bl.booleanValue()) {
                        Double d5 = (Double)iScope.getAgent().getAttribute("neurotism");
                        MentalState mentalState5 = mentalState4;
                        if (mentalState5.getStrength() >= 0.0 && mentalState.getStrength() >= 0.0) {
                            d = mentalState.getStrength() * mentalState5.getStrength() * (1.0 + (0.5 - d5));
                            if (d > 1.0) {
                                d = 1.0;
                            }
                            if (d < 0.0) {
                                d = 0.0;
                            }
                        }
                        d4 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d5 * d;
                    }
                    emotion.setIntensity(d);
                    emotion.setDecay(d4);
                    BdiUtils.addEmotion(iScope, emotion);
                }
            }
        }
    }

    private static void createSatisfactionFromMentalState(IScope iScope, MentalState mentalState) {
        Boolean bl;
        Boolean bl2 = bl = iScope.hasArg("use_personality") ? iScope.getBoolArg("use_personality") : (Boolean)iScope.getAgent().getAttribute("use_personality");
        if (mentalState.getPredicate() != null) {
            IList iList = BdiUtils.getEmotionBase(iScope, "emotion_base").copy(iScope);
            for (Emotion emotion : iList) {
                Double d;
                Double d2;
                IAgent iAgent;
                Emotion emotion2;
                Emotion emotion3;
                if ("hope".equals(emotion.getName())) {
                    if (emotion.getAbout() != null && emotion.getAbout().equalsEmotions(mentalState.getPredicate())) {
                        emotion3 = null;
                        emotion2 = null;
                        iAgent = emotion.getAgentCause();
                        if (!emotion.hasIntensity()) {
                            emotion3 = new Emotion("satisfaction", emotion.getAbout());
                            if (iAgent != null) {
                                emotion3.setAgentCause(iAgent);
                            }
                            emotion2 = new Emotion("joy", emotion.getAbout());
                            if (iAgent != null) {
                                emotion2.setAgentCause(iAgent);
                            }
                        } else {
                            emotion3 = new Emotion("satisfaction", (double)emotion.getIntensity(), emotion.getAbout());
                            if (iAgent != null) {
                                emotion3.setAgentCause(iAgent);
                            }
                            emotion2 = new Emotion("joy", (double)emotion.getIntensity(), emotion.getAbout());
                            if (iAgent != null) {
                                emotion2.setAgentCause(iAgent);
                            }
                        }
                        d2 = 0.0;
                        if (bl.booleanValue()) {
                            d = (Double)iScope.getAgent().getAttribute("neurotism");
                            d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * emotion3.getIntensity();
                        }
                        emotion3.setDecay(d2);
                        emotion2.setDecay(d2);
                        BdiUtils.addEmotion(iScope, emotion3);
                        BdiUtils.addEmotion(iScope, emotion2);
                        BdiUtils.removeEmotion(iScope, emotion);
                    }
                    if (emotion.getAbout() != null && emotion.getAbout().equalsButNotTruth(mentalState.getPredicate())) {
                        emotion3 = null;
                        emotion2 = null;
                        iAgent = emotion.getAgentCause();
                        if (!emotion.hasIntensity()) {
                            emotion3 = new Emotion("disappointment", emotion.getAbout());
                            if (iAgent != null) {
                                emotion3.setAgentCause(iAgent);
                            }
                            emotion2 = new Emotion("sadness", emotion.getAbout());
                            if (iAgent != null) {
                                emotion2.setAgentCause(iAgent);
                            }
                        } else {
                            emotion3 = new Emotion("disappointment", (double)emotion.getIntensity(), emotion.getAbout());
                            if (iAgent != null) {
                                emotion3.setAgentCause(iAgent);
                            }
                            emotion2 = new Emotion("sadness", (double)emotion.getIntensity(), emotion.getAbout());
                            if (iAgent != null) {
                                emotion2.setAgentCause(iAgent);
                            }
                        }
                        d2 = 0.0;
                        if (bl.booleanValue()) {
                            d = (Double)iScope.getAgent().getAttribute("neurotism");
                            d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * emotion3.getIntensity();
                        }
                        emotion3.setDecay(d2);
                        emotion2.setDecay(d2);
                        BdiUtils.addEmotion(iScope, emotion3);
                        BdiUtils.addEmotion(iScope, emotion2);
                        BdiUtils.removeEmotion(iScope, emotion);
                    }
                }
                if (!"fear".equals(emotion.getName())) continue;
                if (emotion.getAbout() != null && emotion.getAbout().equalsEmotions(mentalState.getPredicate())) {
                    emotion3 = null;
                    emotion2 = null;
                    iAgent = emotion.getAgentCause();
                    if (!emotion.hasIntensity()) {
                        emotion3 = new Emotion("fear_confirmed", emotion.getAbout());
                        if (iAgent != null) {
                            emotion3.setAgentCause(iAgent);
                        }
                        emotion2 = new Emotion("sadness", emotion.getAbout());
                        if (iAgent != null) {
                            emotion2.setAgentCause(iAgent);
                        }
                    } else {
                        emotion3 = new Emotion("fear_confirmed", (double)emotion.getIntensity(), emotion.getAbout());
                        if (iAgent != null) {
                            emotion3.setAgentCause(iAgent);
                        }
                        emotion2 = new Emotion("sadness", (double)emotion.getIntensity(), emotion.getAbout());
                        if (iAgent != null) {
                            emotion2.setAgentCause(iAgent);
                        }
                    }
                    d2 = 0.0;
                    if (bl.booleanValue()) {
                        d = (Double)iScope.getAgent().getAttribute("neurotism");
                        d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * emotion3.getIntensity();
                    }
                    emotion3.setDecay(d2);
                    emotion2.setDecay(d2);
                    BdiUtils.addEmotion(iScope, emotion3);
                    BdiUtils.addEmotion(iScope, emotion2);
                    BdiUtils.removeEmotion(iScope, emotion);
                }
                if (emotion.getAbout() == null || !emotion.getAbout().equalsButNotTruth(mentalState.getPredicate())) continue;
                emotion3 = null;
                emotion2 = null;
                iAgent = emotion.getAgentCause();
                if (!emotion.hasIntensity()) {
                    emotion3 = new Emotion("relief", emotion.getAbout());
                    if (iAgent != null) {
                        emotion3.setAgentCause(iAgent);
                    }
                    emotion2 = new Emotion("joy", emotion.getAbout());
                    if (iAgent != null) {
                        emotion2.setAgentCause(iAgent);
                    }
                } else {
                    emotion3 = new Emotion("relief", (double)emotion.getIntensity(), emotion.getAbout());
                    if (iAgent != null) {
                        emotion3.setAgentCause(iAgent);
                    }
                    emotion2 = new Emotion("joy", (double)emotion.getIntensity(), emotion.getAbout());
                    if (iAgent != null) {
                        emotion2.setAgentCause(iAgent);
                    }
                }
                d2 = 0.0;
                if (bl.booleanValue()) {
                    d = (Double)iScope.getAgent().getAttribute("neurotism");
                    d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * emotion3.getIntensity();
                }
                emotion3.setDecay(d2);
                emotion2.setDecay(d2);
                BdiUtils.addEmotion(iScope, emotion3);
                BdiUtils.addEmotion(iScope, emotion2);
                BdiUtils.removeEmotion(iScope, emotion);
            }
        }
    }

    public static Boolean addObligation(IScope iScope, MentalState mentalState) {
        mentalState.setOwner(iScope.getAgent());
        BdiUtils.clearIntention(iScope);
        IAgent iAgent = iScope.getAgent();
        iAgent.setAttribute("current_plan", null);
        return BdiUtils.addToBase(iScope, mentalState, "obligation_base");
    }

    public static void createEmotionsRelatedToOthers(IScope iScope) {
        for (SocialLink socialLink : BdiUtils.getSocialBase(iScope, "social_link_base")) {
            IAgent iAgent = socialLink.getAgent();
            if (iAgent == null) {
                return;
            }
            IScope iScope2 = null;
            iScope2 = iAgent.getScope().copy("in SimpleBdiArchitecture");
            iScope2.push(iAgent);
            double d = Math.signum(socialLink.getLiking());
            for (Emotion emotion : BdiUtils.getEmotionBase(iScope2, "emotion_base")) {
                if (!"joy".equals(emotion.getName()) && !"sadness".equals(emotion.getName())) continue;
                Emotion emotion2 = new Emotion(BdiUtils.getNewEmotionNameToCreateHappyFor(emotion.getName(), d > 0.0), emotion.getIntensity() * d * socialLink.getLiking(), emotion.getAbout(), iAgent);
                emotion2.setDecay(0.0);
                BdiUtils.addEmotion(iScope, emotion2);
            }
            GAMA.releaseScope((IScope)iScope2);
        }
    }

    private static String getNewEmotionNameToCreateHappyFor(String string, boolean bl) {
        if ("joy".equals(string)) {
            return bl ? "happy_for" : "resentment";
        }
        if ("sadness".equals(string)) {
            return bl ? "sorry_for" : "gloating";
        }
        return null;
    }

    private static void createHappyForFromMentalState(IScope iScope, MentalState mentalState) {
        boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        if (mentalState.getEmotion() == null) {
            return;
        }
        Emotion emotion = mentalState.getEmotion();
        if (!"joy".equals(emotion.getName()) && !"sadness".equals(emotion.getName())) {
            return;
        }
        IAgent iAgent = emotion.getOwner();
        if (iAgent == null) {
            return;
        }
        for (SocialLink socialLink : BdiUtils.getSocialBase(iScope, "social_link_base")) {
            if (!iAgent.equals(socialLink.getAgent())) continue;
            double d = Math.abs(socialLink.getLiking());
            double d2 = Math.signum(socialLink.getLiking());
            String string = BdiUtils.getNewEmotionNameToCreateHappyFor(emotion.getName(), d2 > 0.0);
            Emotion emotion2 = new Emotion(string, emotion.getAbout(), iAgent);
            Double d3 = 1.0;
            Double d4 = 0.0;
            if (bl) {
                double d5 = (Double)iScope.getAgent().getAttribute("neurotism");
                double d6 = (Double)iScope.getAgent().getAttribute("agreeableness");
                d3 = BdiUtils.clamp(emotion.getIntensity() * d * (1.0 - d2 * (0.5 - d6)), 0.0, 1.0);
                d4 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d5 * emotion2.getIntensity();
            }
            emotion2.setIntensity(d3);
            emotion2.setDecay(d4);
            BdiUtils.addEmotion(iScope, emotion2);
        }
    }

    private static void createPrideFromMentalState(IScope iScope, MentalState mentalState2) {
        Boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        Predicate predicate = mentalState2.getPredicate();
        if (predicate == null) {
            return;
        }
        for (MentalState mentalState3 : BdiUtils.getBase(iScope, "ideal_base").stream().filter(mentalState -> mentalState != null && mentalState.getPredicate().equals(predicate)).toList()) {
            double d = Math.abs(mentalState3.getStrength());
            double d2 = 1.0;
            double d3 = 0.0;
            if (bl.booleanValue()) {
                Double d4 = (Double)iScope.getAgent().getAttribute("neurotism");
                Double d5 = (Double)iScope.getAgent().getAttribute("openness");
                d2 = BdiUtils.clamp(mentalState2.getStrength() * d * (1.0 + (0.5 - d5)), 0.0, 1.0);
                d3 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d4 * -1.0;
            }
            if (mentalState3.getStrength() > 0.0) {
                if (mentalState2.getPredicate().getAgentCause() != null && mentalState2.getPredicate().getAgentCause().equals(iScope.getAgent())) {
                    BdiUtils.addEmotionForCreatingPride(iScope, "pride", d2, d3, mentalState2.getPredicate(), iScope.getAgent());
                }
                if (mentalState2.getPredicate().getAgentCause() != null) {
                    BdiUtils.addEmotionForCreatingPride(iScope, "admiration", d2, d3, mentalState2.getPredicate(), mentalState2.getPredicate().getAgentCause());
                }
            }
            if (!(mentalState3.getStrength() < 1.0)) continue;
            if (mentalState2.getPredicate().getAgentCause() != null && mentalState2.getPredicate().getAgentCause().equals(iScope.getAgent())) {
                BdiUtils.addEmotionForCreatingPride(iScope, "shame", d2, d3, mentalState2.getPredicate(), iScope.getAgent());
            }
            if (mentalState2.getPredicate().getAgentCause() == null) continue;
            BdiUtils.addEmotionForCreatingPride(iScope, "reproach", d2, d3, mentalState2.getPredicate(), mentalState2.getPredicate().getAgentCause());
        }
    }

    private static void addEmotionForCreatingPride(IScope iScope, String string, double d, double d2, Predicate predicate, IAgent iAgent) {
        Emotion emotion = new Emotion(string, predicate);
        emotion.setAgentCause(iAgent);
        emotion.setIntensity(d);
        emotion.setDecay(d2);
        BdiUtils.addEmotion(iScope, emotion);
    }

    private static void createGratificationGratitudeFromJoy(IScope iScope, Emotion emotion) {
        Boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        IList iList = BdiUtils.getEmotionBase(iScope, "emotion_base").copy(iScope);
        for (Emotion emotion2 : iList) {
            Double d;
            Double d2;
            Double d3;
            Emotion emotion3;
            if ("pride".equals(emotion2.getName()) && emotion2.getAbout() != null && emotion.getAbout() != null && emotion.getAbout().getAgentCause() != null && emotion2.getAbout().equals(emotion.getAbout()) && emotion.getAbout().getAgentCause().equals(iScope.getAgent())) {
                emotion3 = new Emotion("gratification", emotion2.getAbout());
                emotion3.setAgentCause(emotion.getAgentCause());
                d3 = 1.0;
                d2 = 0.0;
                if (bl.booleanValue()) {
                    d = (Double)iScope.getAgent().getAttribute("neurotism");
                    if (emotion.hasIntensity() && emotion2.hasIntensity()) {
                        d3 = emotion.getIntensity() * emotion2.getIntensity();
                    }
                    d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * d3;
                }
                emotion3.setIntensity(d3);
                emotion3.setDecay(d2);
                BdiUtils.addEmotion(iScope, emotion3);
            }
            if (!"admiration".equals(emotion2.getName()) || emotion2.getAbout() == null || emotion.getAbout() == null || emotion.getAbout().getAgentCause() == null || emotion2.getAbout().getAgentCause() == null || !emotion2.getAbout().equals(emotion.getAbout()) || !emotion.getAbout().getAgentCause().equals(emotion2.getAbout().getAgentCause())) continue;
            emotion3 = new Emotion("gratitude", emotion2.getAbout());
            emotion3.setAgentCause(emotion.getAgentCause());
            d3 = 1.0;
            d2 = 0.0;
            if (bl.booleanValue()) {
                d = (Double)iScope.getAgent().getAttribute("neurotism");
                if (emotion.hasIntensity() && emotion2.hasIntensity()) {
                    d3 = emotion.getIntensity() * emotion2.getIntensity();
                }
                d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * d3;
            }
            emotion3.setIntensity(d3);
            emotion3.setDecay(d2);
            BdiUtils.addEmotion(iScope, emotion3);
        }
    }

    private static void createRemorseAngerFromSadness(IScope iScope, Emotion emotion) {
        Boolean bl = iScope.hasArg("use_personality") ? iScope.getBoolArg("use_personality") : (Boolean)iScope.getAgent().getAttribute("use_personality");
        IList iList = BdiUtils.getEmotionBase(iScope, "emotion_base").copy(iScope);
        for (Emotion emotion2 : iList) {
            Double d;
            Double d2;
            Double d3;
            Emotion emotion3;
            if ("shame".equals(emotion2.getName()) && emotion2.getAbout() != null && emotion.getAbout() != null && emotion.getAbout().getAgentCause() != null && emotion2.getAbout().equals(emotion.getAbout()) && emotion.getAbout().getAgentCause().equals(iScope.getAgent())) {
                emotion3 = new Emotion("remorse", emotion2.getAbout());
                emotion3.setAgentCause(emotion.getAgentCause());
                d3 = 1.0;
                d2 = 0.0;
                if (bl.booleanValue()) {
                    d = (Double)iScope.getAgent().getAttribute("neurotism");
                    if (emotion.hasIntensity() && emotion2.hasIntensity()) {
                        d3 = emotion.getIntensity() * emotion2.getIntensity();
                    }
                    d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * d3;
                }
                emotion3.setIntensity(d3);
                emotion3.setDecay(d2);
                BdiUtils.addEmotion(iScope, emotion3);
            }
            if (!"reproach".equals(emotion2.getName()) || emotion2.getAbout() == null || emotion.getAbout() == null || emotion.getAbout().getAgentCause() == null || emotion2.getAbout().getAgentCause() == null || !emotion2.getAbout().equals(emotion.getAbout()) || !emotion.getAbout().getAgentCause().equals(emotion2.getAbout().getAgentCause())) continue;
            emotion3 = new Emotion("anger", emotion2.getAbout());
            emotion3.setAgentCause(emotion.getAgentCause());
            d3 = 1.0;
            d2 = 0.0;
            if (bl.booleanValue()) {
                d = (Double)iScope.getAgent().getAttribute("neurotism");
                if (emotion.hasIntensity() && emotion2.hasIntensity()) {
                    d3 = emotion.getIntensity() * emotion2.getIntensity();
                }
                d2 = iScope.getSimulation().getTimeStep(iScope) * 2.8E-4 * d * d3;
            }
            emotion3.setIntensity(d3);
            emotion3.setDecay(d2);
            BdiUtils.addEmotion(iScope, emotion3);
        }
    }
}

