/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.Emotion;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the emotional contagion")}), @GamlAnnotations.facet(name="emotion_detected", type={546706}, optional=false, doc={@GamlAnnotations.doc(value="the emotion that will start the contagion")}), @GamlAnnotations.facet(name="emotion_created", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="the emotion that will be created with the contagion")}), @GamlAnnotations.facet(name="charisma", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The charisma value of the perceived agent (between 0 and 1)")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="A boolean value to get the emotion only with a certain condition")}), @GamlAnnotations.facet(name="threshold", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The threshold value to make the contagion")}), @GamlAnnotations.facet(name="decay", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The decay value of the emotion added to the agent")}), @GamlAnnotations.facet(name="intensity", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The intensity value of the emotion created to the agent")}), @GamlAnnotations.facet(name="receptivity", type={2}, optional=true, doc={@GamlAnnotations.doc(value="The receptivity value of the current agent (between 0 and 1)")})}, omissible="name")
@GamlAnnotations.doc(value="enables to make conscious or unconscious emotional contagion", examples={@GamlAnnotations.example(value="emotional_contagion emotion_detected:fearConfirmed;"), @GamlAnnotations.example(value="emotional_contagion emotion_detected:fear emotion_created:fearConfirmed;"), @GamlAnnotations.example(value="emotional_contagion emotion_detected:fear emotion_created:fearConfirmed charisma: 0.5 receptivity: 0.5;")})
public class EmotionalContagion
extends AbstractStatement {
    public static final String EMOTIONALCONTAGION = "emotional_contagion";
    public static final String EMOTIONDETECTED = "emotion_detected";
    public static final String EMOTIONCREATED = "emotion_created";
    public static final String CHARISMA = "charisma";
    public static final String RECEPTIVITY = "receptivity";
    public static final String THRESHOLD = "threshold";
    public static final String DECAY = "decay";
    public static final String INTENSITY = "intensity";
    final IExpression nameExpr = this.getFacet(new String[]{"name"});
    final IExpression emotionDetected = this.getFacet(new String[]{"emotion_detected"});
    final IExpression emotionCreated = this.getFacet(new String[]{"emotion_created"});
    final IExpression charisma = this.getFacet(new String[]{"charisma"});
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression receptivity = this.getFacet(new String[]{"receptivity"});
    final IExpression threshold = this.getFacet(new String[]{"threshold"});
    final IExpression decay = this.getFacet(new String[]{"decay"});
    final IExpression intensity = this.getFacet(new String[]{"intensity"});

    public EmotionalContagion(IDescription iDescription) {
        super(iDescription);
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent[] iAgentArray = iScope.getAgentsStack();
        IAgent iAgent = iAgentArray[iAgentArray.length - 2];
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 0.25;
        IScope iScope2 = null;
        double d4 = 0.0;
        double d5 = 0.0;
        if (iAgent != null) {
            iScope2 = iAgent.getScope().copy("of EmotionalContagion");
            iScope2.push(iAgent);
        }
        if ((this.when == null || Cast.asBool((IScope)iScope2, (Object)this.when.value(iScope2)).booleanValue()) && this.emotionDetected != null && BdiUtils.hasEmotion(iScope, (Emotion)this.emotionDetected.value(iScope)).booleanValue()) {
            Emotion emotion = BdiUtils.getEmotion(iScope, (Emotion)this.emotionDetected.value(iScope));
            d = this.charisma != null ? ((Double)this.charisma.value(iScope)).doubleValue() : ((Double)iScope.getAgent().getAttribute(CHARISMA)).doubleValue();
            if (this.receptivity != null) {
                d2 = (Double)this.receptivity.value(iScope2);
            } else if (iAgent != null) {
                d2 = (Double)iAgent.getAttribute(RECEPTIVITY);
            }
            if (this.threshold != null) {
                d3 = (Double)this.threshold.value(iScope2);
            }
            if (d * d2 >= d3) {
                Emotion emotion2;
                if (this.decay != null) {
                    d4 = (Double)this.decay.value(iScope2);
                }
                if (this.emotionCreated != null) {
                    emotion2 = (Emotion)this.emotionCreated.value(iScope);
                    if (this.decay == null) {
                        d4 = emotion.getDecay();
                    }
                    if (this.intensity != null) {
                        d5 = BdiUtils.clamp((Double)this.intensity.value(iScope2), 0.0, 1.0);
                    }
                    emotion2.setIntensity(d5);
                } else {
                    emotion2 = emotion.hasIntensity() ? new Emotion(emotion.getName(), emotion.getIntensity() * d * d2, emotion.getAbout(), emotion.getDecay()) : (Emotion)emotion.copy(iScope);
                }
                emotion2.setAgentCause(iScope.getAgent());
                emotion2.setDecay(BdiUtils.clamp(d4, 0.0, 1.0));
                BdiUtils.addEmotion(iScope2, emotion2);
            }
        }
        GAMA.releaseScope((IScope)iScope2);
        return null;
    }
}

