/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.bdi.SimpleBdiArchitecture;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;

@GamlAnnotations.inside(kinds={0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="when", type={3}, optional=true), @GamlAnnotations.facet(name="finished_when", type={3}, optional=true), @GamlAnnotations.facet(name="priority", type={2}, optional=true), @GamlAnnotations.facet(name="name", type={-201}, optional=true), @GamlAnnotations.facet(name="intention", type={546704}, optional=true), @GamlAnnotations.facet(name="emotion", type={546706}, optional=true), @GamlAnnotations.facet(name="threshold", type={2}, optional=true), @GamlAnnotations.facet(name="instantaneous", type={3}, optional=true)}, omissible="name")
@validator(value=SimpleBdiPlanValidator.class)
@GamlAnnotations.doc(value="define an action plan performed by an agent using the BDI engine")
public class SimpleBdiPlanStatement
extends AbstractStatementSequence {
    public static final String INTENTION = "intention";
    public static final String EMOTION = "emotion";
    public static final String THRESHOLD = "threshold";
    final IExpression _when = this.getFacet(new String[]{"when"});
    final IExpression _priority = this.getFacet(new String[]{"priority"});
    final IExpression _executedwhen = this.getFacet(new String[]{"finished_when"});
    final IExpression _instantaneous = this.getFacet(new String[]{"instantaneous"});
    final IExpression _intention = this.getFacet(new String[]{"intention"});
    final IExpression _emotion = this.getFacet(new String[]{"emotion"});
    final IExpression _threshold = this.getFacet(new String[]{"threshold"});

    public IExpression getPriorityExpression() {
        return this._priority;
    }

    public IExpression getContextExpression() {
        return this._when;
    }

    public IExpression getExecutedExpression() {
        return this._executedwhen;
    }

    public IExpression getInstantaneousExpression() {
        return this._instantaneous;
    }

    public IExpression getIntentionExpression() {
        return this._intention;
    }

    public IExpression getEmotionExpression() {
        return this._emotion;
    }

    public IExpression getThreshold() {
        return this._threshold;
    }

    public SimpleBdiPlanStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (this._when == null || Cast.asBool((IScope)iScope, (Object)this._when.value(iScope)).booleanValue()) {
            return super.privateExecuteIn(iScope);
        }
        return null;
    }

    public Double computePriority(IScope iScope) throws GamaRuntimeException {
        return Cast.asFloat((IScope)iScope, (Object)this._priority.value(iScope));
    }

    public static class SimpleBdiPlanValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
            SpeciesDescription speciesDescription = statementDescription.getSpeciesContext();
            SkillDescription skillDescription = speciesDescription.getControl();
            if (!SimpleBdiArchitecture.class.isAssignableFrom(skillDescription.getJavaBase())) {
                statementDescription.error("A plan can only be defined in a simple_bdi architecture species", "gaml.wrong.context.issue");
                return;
            }
        }
    }
}

