/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Predicate;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.System;
import gama.gaml.statements.AbstractStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@GamlAnnotations.inside(kinds={0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="belief", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory belief")}), @GamlAnnotations.facet(name="beliefs", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory beliefs")}), @GamlAnnotations.facet(name="new_obligation", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The predicate that will be added as an obligation")}), @GamlAnnotations.facet(name="new_obligations", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The list of predicates that will be added as obligations")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value=" ")}), @GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="setting this facet to 'true' will allow 'perceive' to use concurrency with a parallel_bdi architecture; setting it to an integer will set the threshold under which they will be run sequentially (the default is initially 20, but can be fixed in the preferences). This facet is true by default.")}), @GamlAnnotations.facet(name="strength", type={2, 1}, optional=true, doc={@GamlAnnotations.doc(value="The stregth of the mental state created")}), @GamlAnnotations.facet(name="lifetime", type={1}, optional=true, doc={@GamlAnnotations.doc(value="the lifetime value of the mental state created")}), @GamlAnnotations.facet(name="threshold", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Threshold linked to the obedience value.")}), @GamlAnnotations.facet(name="all", type={3}, optional=true, doc={@GamlAnnotations.doc(value="add an obligation for each belief")}), @GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="The name of the law")})}, omissible="name")
@GamlAnnotations.doc(value="enables to add a desire or a belief or to remove a belief, a desire or an intention if the agent gets the belief or/and desire or/and condition mentioned.", examples={@GamlAnnotations.example(value="rule belief: new_predicate(\"test\") when: flip(0.5) new_desire: new_predicate(\"test\");")})
public class LawStatement
extends AbstractStatement {
    public static final String LAW = "law";
    public static final String BELIEF = "belief";
    public static final String BELIEFS = "beliefs";
    public static final String NEW_OBLIGATION = "new_obligation";
    public static final String NEW_OBLIGATIONS = "new_obligations";
    public static final String STRENGTH = "strength";
    public static final String LIFETIME = "lifetime";
    public static final String THRESHOLD = "threshold";
    public static final String ALL = "all";
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression parallel;
    final IExpression belief = this.getFacet(new String[]{"belief"});
    final IExpression beliefs = this.getFacet(new String[]{"beliefs"});
    final IExpression newObligation = this.getFacet(new String[]{"new_obligation"});
    final IExpression newObligations = this.getFacet(new String[]{"new_obligations"});
    final IExpression strength = this.getFacet(new String[]{"strength"});
    final IExpression lifetime = this.getFacet(new String[]{"lifetime"});
    final IExpression threshold = this.getFacet(new String[]{"threshold"});
    final IExpression all;

    public IExpression getContextExpression() {
        return this.when;
    }

    public IExpression getBeliefExpression() {
        return this.belief;
    }

    public IExpression getObligationExpression() {
        return this.newObligation;
    }

    public IExpression getParallel() {
        return this.parallel;
    }

    public IExpression getThreshold() {
        return this.threshold;
    }

    public LawStatement(IDescription iDescription) {
        super(iDescription);
        this.parallel = this.getFacet(new String[]{"parallel"});
        this.all = this.getFacet(new String[]{ALL});
        this.setName(iDescription.getName());
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (this.newObligation == null && this.newObligations == null) {
            return null;
        }
        if (this.when != null && !Cast.asBool((IScope)iScope, (Object)this.when.value(iScope)).booleanValue()) {
            return null;
        }
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        MentalState mentalState = new MentalState("Belief");
        if (this.belief != null) {
            mentalState.setPredicate((Predicate)this.belief.value(iScope));
            if (BdiUtils.hasBelief(iScope, mentalState).booleanValue()) {
                for (Object object : BdiUtils.getBase(iScope, "belief_base")) {
                    if (!mentalState.getPredicate().equals(((MentalState)object).getPredicate())) continue;
                    arrayList.add(((MentalState)object).getPredicate());
                }
            }
        }
        if (!(this.belief != null && !BdiUtils.hasBelief(iScope, mentalState).booleanValue() || this.beliefs != null && !this.hasBeliefs(iScope, (List)this.beliefs.value(iScope)) || this.threshold != null && !((Double)iScope.getAgent().getAttribute("obedience") >= (Double)this.threshold.value(iScope)))) {
            Object object;
            if (this.newObligation != null) {
                object = (Predicate)this.newObligation.value(iScope);
                if (this.all != null && Cast.asBool((IScope)iScope, (Object)this.all.value(iScope)).booleanValue()) {
                    for (Object object2 : arrayList) {
                        this.addNewObligation(iScope, (Predicate)object, (IMap<String, Object>)((IMap)System.opCopy((IScope)iScope, ((Predicate)object2).getValues())));
                    }
                } else {
                    this.addNewObligation(iScope, (Predicate)object, null);
                }
            }
            if (this.newObligations != null) {
                object = (List)this.newObligations.value(iScope);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    object2 = (Predicate)iterator.next();
                    this.addNewObligation(iScope, (Predicate)object2, null);
                }
            }
        }
        return null;
    }

    private void addNewObligation(IScope iScope, Predicate predicate, IMap<String, Object> iMap) {
        MentalState mentalState = new MentalState("Obligation", predicate);
        if (iMap != null) {
            mentalState.getPredicate().setValues(iMap);
        }
        if (this.strength != null) {
            mentalState.setStrength(Cast.asFloat((IScope)iScope, (Object)this.strength.value(iScope)));
        }
        if (this.lifetime != null) {
            mentalState.setLifeTime(Cast.asInt((IScope)iScope, (Object)this.lifetime.value(iScope)));
        }
        if (!BdiUtils.hasObligation(iScope, mentalState).booleanValue()) {
            BdiUtils.addObligation(iScope, mentalState);
            BdiUtils.clearIntention(iScope);
            IAgent iAgent = iScope.getAgent();
            iAgent.setAttribute("current_plan", null);
            iAgent.setAttribute("current_norm", null);
        }
    }

    private boolean hasBeliefs(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Belief", predicate);
            if (BdiUtils.hasBelief(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

