/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.extension.bdi.NormStatement;
import gama.extension.bdi.Predicate;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Objects;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="The name of this norm")}), @GamlAnnotations.variable(name="intention", type=546704, doc={@GamlAnnotations.doc(value="A string representing the current intention of this Norm")}), @GamlAnnotations.variable(name="obligation", type=546704, doc={@GamlAnnotations.doc(value="A string representing the current obligation of this Norm")}), @GamlAnnotations.variable(name="finished_when", type=4, doc={@GamlAnnotations.doc(value="represents the condition when a norm is finished")}), @GamlAnnotations.variable(name="instantaneous", type=3, doc={@GamlAnnotations.doc(value="indicates if the norm is instantaneous")}), @GamlAnnotations.variable(name="lifetime", type=1, doc={@GamlAnnotations.doc(value="the lifetim during which the norm is considered violated when it has been violated")})})
public class Norm
implements IValue {
    private NormStatement normStatement;
    private Boolean isViolated;
    private Integer lifetimeViolation;
    private Boolean noLifetime;
    private Boolean isApplied;
    private Boolean isSanctioned;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", (Object)this.getName());
    }

    @GamlAnnotations.getter(value="name")
    public String getName() {
        return this.normStatement.getName();
    }

    @GamlAnnotations.getter(value="lifetime")
    public Integer getLifetime(IScope iScope) {
        return this.lifetimeViolation;
    }

    @GamlAnnotations.getter(value="when")
    public String getWhen() {
        return this.normStatement._when.serializeToGaml(true);
    }

    @GamlAnnotations.getter(value="intention")
    public Predicate getIntention(IScope iScope) {
        if (this.normStatement != null && this.normStatement._intention != null) {
            return (Predicate)this.normStatement._intention.value(iScope);
        }
        return null;
    }

    @GamlAnnotations.getter(value="obligation")
    public Predicate getObligation(IScope iScope) {
        if (this.normStatement != null && this.normStatement._obligation != null) {
            return (Predicate)this.normStatement._obligation.value(iScope);
        }
        return null;
    }

    @GamlAnnotations.getter(value="finished_when")
    public String getFinishedWhen() {
        if (this.normStatement != null && this.normStatement._executedwhen != null) {
            return this.normStatement._executedwhen.serializeToGaml(true);
        }
        return null;
    }

    @GamlAnnotations.getter(value="instantaneous")
    public boolean getInstantaneous(IScope iScope) {
        return this.normStatement._instantaneous == null ? false : Cast.asBool((IScope)iScope, (Object)this.normStatement._instantaneous.value(iScope));
    }

    public NormStatement getNormStatement() {
        return this.normStatement;
    }

    public Boolean getViolated() {
        return this.isViolated;
    }

    public Boolean getApplied() {
        return this.isApplied;
    }

    public Boolean getSanctioned() {
        return this.isSanctioned;
    }

    public Norm(NormStatement normStatement) {
        this.normStatement = normStatement;
        this.lifetimeViolation = -1;
        this.isViolated = false;
        this.noLifetime = true;
        this.isApplied = false;
        this.isSanctioned = false;
    }

    public Norm(NormStatement normStatement, IScope iScope) {
        this.normStatement = normStatement;
        this.isViolated = false;
        this.isApplied = false;
        this.isSanctioned = false;
        if (normStatement._lifetime != null) {
            this.lifetimeViolation = (Integer)normStatement._lifetime.value(iScope);
            this.noLifetime = false;
        } else {
            this.lifetimeViolation = -1;
            this.noLifetime = true;
        }
    }

    public void setViolation(Boolean bl) {
        this.isViolated = bl;
        this.isApplied = bl == false;
    }

    public void setSanctioned(Boolean bl) {
        this.isSanctioned = bl;
    }

    public void sanctioned() {
        this.isSanctioned = true;
    }

    public void violated(IScope iScope) {
        this.isViolated = true;
        this.isApplied = false;
        this.lifetimeViolation = this.normStatement._lifetime != null ? (Integer)this.normStatement._lifetime.value(iScope) : Integer.valueOf(1);
        this.noLifetime = false;
    }

    public void applied(IScope iScope) {
        this.isApplied = true;
        this.isViolated = false;
        this.lifetimeViolation = -1;
        this.noLifetime = false;
    }

    public void updateLifeime() {
        if (!this.noLifetime.booleanValue() && this.isViolated.booleanValue()) {
            this.lifetimeViolation = this.lifetimeViolation - 1;
        }
        if (this.lifetimeViolation < 0 && !this.noLifetime.booleanValue()) {
            this.isViolated = false;
            this.isSanctioned = false;
            this.noLifetime = true;
        }
    }

    public String serializeToGaml(boolean bl) {
        return "Norm(" + String.valueOf((Object)this.normStatement) + ")";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isApplied, this.isSanctioned, this.isViolated, this.lifetimeViolation, this.noLifetime, this.normStatement});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Norm norm = (Norm)object;
        return Objects.equals((Object)this.normStatement, (Object)norm.normStatement);
    }

    public IType<?> getGamlType() {
        return Types.get((int)546710);
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "Norm(" + String.valueOf((Object)this.normStatement) + ")";
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new Norm(this.normStatement);
    }
}

