/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Objects;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="agent", type=11, doc={@GamlAnnotations.doc(value="the agent with who there is a social link")}), @GamlAnnotations.variable(name="liking", type=2, doc={@GamlAnnotations.doc(value="the liking value of the link")}), @GamlAnnotations.variable(name="dominance", type=2, doc={@GamlAnnotations.doc(value="the dominance value of the link")}), @GamlAnnotations.variable(name="solidarity", type=2, doc={@GamlAnnotations.doc(value="the solidarity value of the link")}), @GamlAnnotations.variable(name="familiarity", type=2, doc={@GamlAnnotations.doc(value="the familiarity value of the link")}), @GamlAnnotations.variable(name="trust", type=2, doc={@GamlAnnotations.doc(value="the trust value of the link")})})
public class SocialLink
implements IValue {
    IAgent agent;
    double liking = 0.0;
    double dominance = 0.0;
    double solidarity = 0.0;
    double familiarity = 0.0;
    double trust = 0.0;
    private boolean hasLiking = false;
    private boolean hasDominance = false;
    private boolean hasSolidarity = false;
    private boolean hasFamiliarity = false;
    private boolean hasTrust = false;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "agent", (Object)this.agent, "liking", (Object)this.liking, "dominance", (Object)this.dominance, "solidarity", (Object)this.solidarity).add("trust", this.trust).add("familiarity", this.familiarity);
    }

    @GamlAnnotations.getter(value="agent")
    public IAgent getAgent() {
        return this.agent;
    }

    @GamlAnnotations.getter(value="liking")
    public double getLiking() {
        return this.liking;
    }

    @GamlAnnotations.getter(value="dominance")
    public double getDominance() {
        return this.dominance;
    }

    @GamlAnnotations.getter(value="solidarity")
    public double getSolidarity() {
        return this.solidarity;
    }

    @GamlAnnotations.getter(value="familiarity")
    public double getFamiliarity() {
        return this.familiarity;
    }

    @GamlAnnotations.getter(value="trust")
    public double getTrust() {
        return this.trust;
    }

    public boolean hasLiking() {
        return this.hasLiking;
    }

    public boolean hasDominance() {
        return this.hasDominance;
    }

    public boolean hasSolidarity() {
        return this.hasSolidarity;
    }

    public boolean hasFamiliarity() {
        return this.hasFamiliarity;
    }

    public boolean hasTrust() {
        return this.hasTrust;
    }

    public void setAgent(IAgent iAgent) {
        this.agent = iAgent;
    }

    public void setLiking(double d) {
        this.liking = d;
        this.hasLiking = true;
    }

    public void setDominance(double d) {
        this.dominance = d;
        this.hasDominance = true;
    }

    public void setSolidarity(double d) {
        this.solidarity = d;
        this.hasSolidarity = true;
    }

    public void setFamiliarity(double d) {
        this.familiarity = d;
        this.hasFamiliarity = true;
    }

    public void setTrust(double d) {
        this.trust = d;
        this.hasTrust = true;
    }

    public SocialLink() {
        this.agent = null;
    }

    public SocialLink(IAgent iAgent) {
        this.agent = iAgent;
    }

    public SocialLink(IAgent iAgent, double d, double d2, double d3, double d4) {
        this.agent = iAgent;
        this.liking = d;
        this.hasLiking = true;
        this.dominance = d2;
        this.hasDominance = true;
        this.solidarity = d3;
        this.hasSolidarity = true;
        this.familiarity = d4;
        this.hasFamiliarity = true;
    }

    public SocialLink(IAgent iAgent, double d, double d2, double d3, double d4, double d5) {
        this.agent = iAgent;
        this.liking = d;
        this.hasLiking = true;
        this.dominance = d2;
        this.hasDominance = true;
        this.solidarity = d3;
        this.hasSolidarity = true;
        this.familiarity = d4;
        this.hasFamiliarity = true;
        this.trust = d5;
        this.hasTrust = true;
    }

    public String toString() {
        return this.serializeToGaml(true);
    }

    public String serializeToGaml(boolean bl) {
        return "(" + String.valueOf(this.agent) + "," + this.liking + "," + this.dominance + "," + this.solidarity + "," + this.familiarity + "," + this.trust + ")";
    }

    public IType<?> getGamlType() {
        return Types.get((int)546707);
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "(" + String.valueOf(this.agent) + "," + this.liking + "," + this.dominance + "," + this.solidarity + "," + this.familiarity + ")";
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new SocialLink(this.agent, this.liking, this.dominance, this.solidarity, this.familiarity);
    }

    public int hashCode() {
        return Objects.hash(this.agent, this.liking, this.dominance, this.solidarity, this.familiarity, this.trust, this.hasLiking, this.hasDominance, this.hasSolidarity, this.hasFamiliarity, this.hasTrust);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SocialLink socialLink = (SocialLink)object;
        if (!(this.agent == null || socialLink.getAgent() != null && this.agent.equals(socialLink.getAgent()))) {
            return false;
        }
        if (this.hasLiking && (!socialLink.hasLiking() || this.liking != socialLink.getLiking())) {
            return false;
        }
        if (this.hasDominance && (!socialLink.hasDominance() || this.dominance != socialLink.getDominance())) {
            return false;
        }
        if (this.hasSolidarity && (!socialLink.hasSolidarity() || this.solidarity != socialLink.getSolidarity())) {
            return false;
        }
        if (this.hasFamiliarity && (!socialLink.hasFamiliarity() || this.familiarity != socialLink.getFamiliarity())) {
            return false;
        }
        return !this.hasTrust || socialLink.hasTrust() && this.trust == socialLink.getTrust();
    }

    public boolean equalsInAgent(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SocialLink socialLink = (SocialLink)object;
        if (this.agent != null) {
            return this.agent.equals(socialLink.getAgent());
        }
        return this.agent == socialLink.getAgent();
    }
}

