/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Predicate;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.System;
import gama.gaml.statements.AbstractStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

@GamlAnnotations.inside(symbols={"simple_bdi", "parallel_bdi"}, kinds={0, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="belief", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory belief")}), @GamlAnnotations.facet(name="desire", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory desire")}), @GamlAnnotations.facet(name="emotion", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory emotion")}), @GamlAnnotations.facet(name="uncertainty", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory uncertainty")}), @GamlAnnotations.facet(name="ideal", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory ideal")}), @GamlAnnotations.facet(name="obligation", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The mandatory obligation")}), @GamlAnnotations.facet(name="desires", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory desires")}), @GamlAnnotations.facet(name="beliefs", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory beliefs")}), @GamlAnnotations.facet(name="emotions", type={5}, of=546706, optional=true, doc={@GamlAnnotations.doc(value="The mandatory emotions")}), @GamlAnnotations.facet(name="uncertainties", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory uncertainties")}), @GamlAnnotations.facet(name="ideals", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory ideals")}), @GamlAnnotations.facet(name="obligations", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The mandatory obligations")}), @GamlAnnotations.facet(name="new_desire", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The desire that will be added")}), @GamlAnnotations.facet(name="new_belief", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The belief that will be added")}), @GamlAnnotations.facet(name="new_emotion", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="The emotion that will be added")}), @GamlAnnotations.facet(name="new_uncertainty", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The uncertainty that will be added")}), @GamlAnnotations.facet(name="new_ideal", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The ideal that will be added")}), @GamlAnnotations.facet(name="new_desires", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The desire that will be added")}), @GamlAnnotations.facet(name="new_beliefs", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The belief that will be added")}), @GamlAnnotations.facet(name="new_emotions", type={5}, of=546706, optional=true, doc={@GamlAnnotations.doc(value="The emotion that will be added")}), @GamlAnnotations.facet(name="new_uncertainties", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The uncertainty that will be added")}), @GamlAnnotations.facet(name="new_ideals", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The ideals that will be added")}), @GamlAnnotations.facet(name="remove_beliefs", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The belief that will be removed")}), @GamlAnnotations.facet(name="remove_desires", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The desire that will be removed")}), @GamlAnnotations.facet(name="remove_emotions", type={5}, of=546706, optional=true, doc={@GamlAnnotations.doc(value="The emotion that will be removed")}), @GamlAnnotations.facet(name="remove_ideals", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The ideals that will be removed")}), @GamlAnnotations.facet(name="remove_obligations", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The obligation that will be removed")}), @GamlAnnotations.facet(name="remove_uncertainties", type={5}, of=546704, optional=true, doc={@GamlAnnotations.doc(value="The uncertainty that will be removed")}), @GamlAnnotations.facet(name="remove_belief", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The belief that will be removed")}), @GamlAnnotations.facet(name="remove_ideal", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The ideal that will be removed")}), @GamlAnnotations.facet(name="remove_desire", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The desire that will be removed")}), @GamlAnnotations.facet(name="remove_intention", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The intention that will be removed")}), @GamlAnnotations.facet(name="remove_emotion", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="The emotion that will be removed")}), @GamlAnnotations.facet(name="remove_uncertainty", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The uncertainty that will be removed")}), @GamlAnnotations.facet(name="remove_obligation", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The obligation that will be removed")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value=" ")}), @GamlAnnotations.facet(name="threshold", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Threshold linked to the emotion.")}), @GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="setting this facet to 'true' will allow 'perceive' to use concurrency with a parallel_bdi architecture; setting it to an integer will set the threshold under which they will be run sequentially (the default is initially 20, but can be fixed in the preferences). This facet is true by default.")}), @GamlAnnotations.facet(name="strength", type={2, 1, 5}, optional=true, doc={@GamlAnnotations.doc(value="The stregth of the mental state created")}), @GamlAnnotations.facet(name="lifetime", type={1, 5}, optional=true, doc={@GamlAnnotations.doc(value="the lifetime value of the mental state created")}), @GamlAnnotations.facet(name="all", type={3}, optional=true, doc={@GamlAnnotations.doc(value="add a desire for each belief")}), @GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="The name of the rule")})}, omissible="name")
@GamlAnnotations.doc(value="enables to add a desire or a belief or to remove a belief, a desire or an intention if the agent gets the belief or/and desire or/and condition mentioned.")
public class RuleStatement
extends AbstractStatement {
    public static final String RULE = "rule";
    public static final String BELIEF = "belief";
    public static final String DESIRE = "desire";
    public static final String EMOTION = "emotion";
    public static final String UNCERTAINTY = "uncertainty";
    public static final String IDEAL = "ideal";
    public static final String OBLIGATION = "obligation";
    public static final String RULES = "rules";
    public static final String BELIEFS = "beliefs";
    public static final String DESIRES = "desires";
    public static final String EMOTIONS = "emotions";
    public static final String UNCERTAINTIES = "uncertainties";
    public static final String IDEALS = "ideals";
    public static final String OBLIGATIONS = "obligations";
    public static final String NEW_DESIRE = "new_desire";
    public static final String NEW_BELIEF = "new_belief";
    public static final String NEW_EMOTION = "new_emotion";
    public static final String NEW_UNCERTAINTY = "new_uncertainty";
    public static final String NEW_IDEAL = "new_ideal";
    public static final String REMOVE_BELIEF = "remove_belief";
    public static final String REMOVE_DESIRE = "remove_desire";
    public static final String REMOVE_INTENTION = "remove_intention";
    public static final String REMOVE_EMOTION = "remove_emotion";
    public static final String REMOVE_UNCERTAINTY = "remove_uncertainty";
    public static final String REMOVE_IDEAL = "remove_ideal";
    public static final String REMOVE_OBLIGATION = "remove_obligation";
    public static final String NEW_DESIRES = "new_desires";
    public static final String NEW_BELIEFS = "new_beliefs";
    public static final String NEW_EMOTIONS = "new_emotions";
    public static final String NEW_UNCERTAINTIES = "new_uncertainties";
    public static final String NEW_IDEALS = "new_ideals";
    public static final String REMOVE_BELIEFS = "remove_beliefs";
    public static final String REMOVE_DESIRES = "remove_desires";
    public static final String REMOVE_EMOTIONS = "remove_emotions";
    public static final String REMOVE_UNCERTAINTIES = "remove_uncertainties";
    public static final String REMOVE_IDEALS = "remove_ideals";
    public static final String REMOVE_OBLIGATIONS = "remove_obligations";
    public static final String STRENGTH = "strength";
    public static final String THRESHOLD = "threshold";
    public static final String ALL = "all";
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression parallel;
    final IExpression belief = this.getFacet(new String[]{"belief"});
    final IExpression desire = this.getFacet(new String[]{"desire"});
    final IExpression emotion = this.getFacet(new String[]{"emotion"});
    final IExpression uncertainty = this.getFacet(new String[]{"uncertainty"});
    final IExpression ideal = this.getFacet(new String[]{"ideal"});
    final IExpression obligation = this.getFacet(new String[]{"obligation"});
    final IExpression beliefs = this.getFacet(new String[]{"beliefs"});
    final IExpression desires = this.getFacet(new String[]{"desires"});
    final IExpression emotions = this.getFacet(new String[]{"emotions"});
    final IExpression uncertainties = this.getFacet(new String[]{"uncertainties"});
    final IExpression ideals = this.getFacet(new String[]{"ideals"});
    final IExpression obligations = this.getFacet(new String[]{"obligations"});
    final IExpression newBelief = this.getFacet(new String[]{"new_belief"});
    final IExpression newDesire = this.getFacet(new String[]{"new_desire"});
    final IExpression newEmotion = this.getFacet(new String[]{"new_emotion"});
    final IExpression newUncertainty = this.getFacet(new String[]{"new_uncertainty"});
    final IExpression newIdeal = this.getFacet(new String[]{"new_ideal"});
    final IExpression removeBelief = this.getFacet(new String[]{"remove_belief"});
    final IExpression removeDesire = this.getFacet(new String[]{"remove_desire"});
    final IExpression removeIntention = this.getFacet(new String[]{"remove_intention"});
    final IExpression removeEmotion = this.getFacet(new String[]{"remove_emotion"});
    final IExpression removeUncertainty = this.getFacet(new String[]{"remove_uncertainty"});
    final IExpression removeIdeal = this.getFacet(new String[]{"remove_ideal"});
    final IExpression removeObligation = this.getFacet(new String[]{"remove_obligation"});
    final IExpression newBeliefs = this.getFacet(new String[]{"new_beliefs"});
    final IExpression newDesires = this.getFacet(new String[]{"new_desires"});
    final IExpression newEmotions = this.getFacet(new String[]{"new_emotions"});
    final IExpression newUncertainties = this.getFacet(new String[]{"new_uncertainties"});
    final IExpression newIdeals = this.getFacet(new String[]{"new_ideals"});
    final IExpression removeBeliefs = this.getFacet(new String[]{"remove_beliefs"});
    final IExpression removeDesires = this.getFacet(new String[]{"remove_desires"});
    final IExpression removeEmotions = this.getFacet(new String[]{"remove_emotions"});
    final IExpression removeUncertainties = this.getFacet(new String[]{"remove_uncertainties"});
    final IExpression removeIdeals = this.getFacet(new String[]{"remove_ideals"});
    final IExpression removeObligations = this.getFacet(new String[]{"remove_obligations"});
    final IExpression strength = this.getFacet(new String[]{"strength"});
    final IExpression threshold = this.getFacet(new String[]{"threshold"});
    final IExpression all;
    final IExpression lifetime = this.getFacet(new String[]{"lifetime"});

    public RuleStatement(IDescription iDescription) {
        super(iDescription);
        this.parallel = this.getFacet(new String[]{"parallel"});
        this.all = this.getFacet(new String[]{ALL});
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object2;
        MentalState mentalState5;
        MentalState mentalState22;
        if (this.when != null && !Cast.asBool((IScope)iScope, (Object)this.when.value(iScope)).booleanValue()) {
            return null;
        }
        if (this.newBelief == null && this.newDesire == null && this.newEmotion == null && this.newUncertainty == null && this.removeBelief == null && this.removeDesire == null && this.removeIntention == null && this.removeEmotion == null && this.removeUncertainty == null && this.newBeliefs == null && this.newDesires == null && this.newEmotions == null && this.newUncertainties == null && this.removeBeliefs == null && this.removeDesires == null && this.removeEmotions == null && this.removeUncertainties == null) {
            return null;
        }
        if (this.emotion != null && BdiUtils.hasEmotion(iScope, (Emotion)this.emotion.value(iScope)).booleanValue()) {
            return null;
        }
        boolean bl = this.all != null && Cast.asBool((IScope)iScope, (Object)this.all.value(iScope)) != false;
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
        ArrayList<Predicate> arrayList2 = new ArrayList<Predicate>();
        ArrayList<Predicate> arrayList3 = new ArrayList<Predicate>();
        MentalState mentalState3 = new MentalState("Belief");
        if (this.belief != null) {
            mentalState3.setPredicate((Predicate)this.belief.value(iScope));
            if (BdiUtils.hasBelief(iScope, mentalState3).booleanValue()) {
                for (MentalState mentalState22 : BdiUtils.getBase(iScope, "belief_base")) {
                    if (mentalState22.getPredicate() == null || !mentalState3.getPredicate().equals(mentalState22.getPredicate())) continue;
                    arrayList.add(mentalState22.getPredicate());
                }
            } else {
                return null;
            }
        }
        mentalState22 = new MentalState("Desire");
        if (this.desire != null) {
            mentalState22.setPredicate((Predicate)this.desire.value(iScope));
            if (!BdiUtils.hasDesire(iScope, mentalState22).booleanValue()) {
                return null;
            }
        }
        MentalState mentalState4 = new MentalState("Uncertainty");
        if (this.uncertainty != null) {
            mentalState4.setPredicate((Predicate)this.uncertainty.value(iScope));
            if (BdiUtils.hasUncertainty(iScope, mentalState4).booleanValue()) {
                arrayList2 = new ArrayList();
                for (MentalState mentalState5 : BdiUtils.getBase(iScope, "uncertainty_base")) {
                    if (mentalState5.getPredicate() == null || !mentalState3.getPredicate().equals(mentalState5.getPredicate())) continue;
                    arrayList2.add(mentalState5.getPredicate());
                }
            } else {
                return null;
            }
        }
        mentalState5 = new MentalState("Ideal");
        if (this.ideal != null) {
            mentalState5.setPredicate((Predicate)this.ideal.value(iScope));
            if (BdiUtils.hasIdeal(iScope, mentalState5).booleanValue()) {
                arrayList3 = new ArrayList();
                for (Object object2 : BdiUtils.getBase(iScope, "ideal_base")) {
                    if (((MentalState)object2).getPredicate() == null || !mentalState3.getPredicate().equals(((MentalState)object2).getPredicate())) continue;
                    arrayList3.add(((MentalState)object2).getPredicate());
                }
            } else {
                return null;
            }
        }
        object2 = new MentalState("Obligation");
        if (this.obligation != null) {
            ((MentalState)object2).setPredicate((Predicate)this.obligation.value(iScope));
            if (!BdiUtils.hasObligation(iScope, (MentalState)object2).booleanValue()) {
                return null;
            }
        }
        if (this.beliefs != null && !this.hasBeliefs(iScope, (List)this.beliefs.value(iScope))) {
            return null;
        }
        if (this.desires != null && !this.hasDesires(iScope, (List)this.desires.value(iScope))) {
            return null;
        }
        if (this.uncertainties != null && !this.hasUncertainties(iScope, (List)this.uncertainties.value(iScope))) {
            return null;
        }
        if (this.ideals != null && !this.hasIdeals(iScope, (List)this.ideals.value(iScope))) {
            return null;
        }
        if (this.obligations != null && !this.hasObligations(iScope, (List)this.obligations.value(iScope))) {
            return null;
        }
        if (this.emotions != null && !this.hasEmotions(iScope, (List)this.emotions.value(iScope))) {
            return null;
        }
        if (this.threshold != null && (this.emotion == null || BdiUtils.getEmotion((IScope)iScope, (Emotion)((Emotion)this.emotion.value((IScope)iScope))).intensity < (Double)this.threshold.value(iScope))) {
            return null;
        }
        this.addSinglePredicates(iScope, bl, arrayList, arrayList2, arrayList3);
        this.removeSinglePredicates(iScope, bl, arrayList, arrayList2, arrayList3);
        this.addPredicateLists(iScope);
        this.removePredicateLists(iScope);
        return null;
    }

    private void removePredicateLists(IScope iScope) {
        List list6;
        List list22;
        List list3;
        List list42;
        Object object2;
        List list5 = this.removeBeliefs != null ? (List)this.removeBeliefs.value(iScope) : Collections.emptyList();
        for (Object object2 : list5) {
            list42 = new MentalState("Belief", (Predicate)object2);
            BdiUtils.removeBelief(iScope, (MentalState)((Object)list42));
        }
        object2 = this.removeDesires != null ? (List)this.removeDesires.value(iScope) : Collections.emptyList();
        list42 = object2.iterator();
        while (list42.hasNext()) {
            list3 = (Predicate)list42.next();
            list22 = new MentalState("Desire", (Predicate)((Object)list3));
            BdiUtils.removeDesire(iScope, (MentalState)((Object)list22));
        }
        list3 = this.removeEmotions != null ? (List)this.removeEmotions.value(iScope) : Collections.emptyList();
        for (List list42 : list3) {
            BdiUtils.removeEmotion(iScope, list42);
        }
        list42 = this.removeUncertainties != null ? (List)this.removeUncertainties.value(iScope) : Collections.emptyList();
        for (List list22 : list42) {
            Object object3 = new MentalState("Uncertainty", (Predicate)((Object)list22));
            BdiUtils.removeUncertainty(iScope, (MentalState)object3);
        }
        list22 = this.removeIdeals != null ? (List)this.removeIdeals.value(iScope) : Collections.emptyList();
        for (List list6 : list22) {
            MentalState mentalState = new MentalState("Ideal", (Predicate)((Object)list6));
            BdiUtils.removeIdeal(iScope, mentalState);
        }
        list6 = this.removeObligations != null ? (List)this.removeObligations.value(iScope) : Collections.emptyList();
        for (Object object3 : list6) {
            MentalState mentalState = new MentalState("Obligation", (Predicate)object3);
            BdiUtils.removeObligation(iScope, mentalState);
        }
    }

    private void addPredicateLists(IScope iScope) {
        Object object2;
        if (this.newDesires != null) {
            object2 = (List)this.newDesires.value(iScope);
            this.addPredicateList(iScope, (List<Predicate>)object2, "Desire", mentalState -> {
                Boolean bl = BdiUtils.addDesire(iScope, null, mentalState);
            });
        }
        if (this.newBeliefs != null) {
            object2 = (List)this.newBeliefs.value(iScope);
            this.addPredicateList(iScope, (List<Predicate>)object2, "Belief", mentalState -> {
                Boolean bl = BdiUtils.addBelief(iScope, mentalState);
            });
        }
        if (this.newEmotions != null) {
            for (Object object2 : (List)this.newEmotions.value(iScope)) {
                BdiUtils.addEmotion(iScope, (Emotion)object2);
            }
        }
        if (this.newUncertainties != null) {
            object2 = (List)this.newUncertainties.value(iScope);
            this.addPredicateList(iScope, (List<Predicate>)object2, "Uncertainty", mentalState -> {
                Boolean bl = BdiUtils.addUncertainty(iScope, mentalState);
            });
        }
        if (this.newIdeals != null) {
            object2 = (List)this.newIdeals.value(iScope);
            this.addPredicateList(iScope, (List<Predicate>)object2, "Ideal", mentalState -> {
                Boolean bl = BdiUtils.addIdeal(iScope, mentalState);
            });
        }
    }

    private void addPredicateList(IScope iScope, List<Predicate> list, String string, Consumer<MentalState> consumer) {
        int n = 0;
        for (Predicate predicate : list) {
            Object object;
            Object object2;
            MentalState mentalState = new MentalState(string, predicate);
            if (this.strength != null) {
                Number number;
                object2 = this.strength.value(iScope);
                if (object2 instanceof Number) {
                    object = (Number)object2;
                    number = object;
                } else {
                    number = ((List)this.strength.value(iScope)).get(n);
                }
                mentalState.setStrength(Cast.asFloat((IScope)iScope, (Object)number));
            }
            if (this.lifetime != null) {
                Object object3;
                object2 = this.lifetime.value(iScope);
                if (object2 instanceof List) {
                    object = (List)object2;
                    object3 = object.get(n);
                } else {
                    object3 = this.lifetime.value(iScope);
                }
                mentalState.setLifeTime(Cast.asInt((IScope)iScope, (Object)object3));
            }
            consumer.accept(mentalState);
            ++n;
        }
    }

    private MentalState prepareToRemove(IScope iScope, Predicate predicate, String string, IMap<String, Object> iMap) {
        MentalState mentalState = new MentalState(string, predicate);
        if (iMap != null) {
            mentalState.getPredicate().setValues(iMap);
        }
        return mentalState;
    }

    private void removeSinglePredicates(IScope iScope, boolean bl, List<Predicate> list, List<Predicate> list2, List<Predicate> list3) {
        Predicate predicate;
        Predicate predicate2 = this.removeBelief != null ? (Predicate)this.removeBelief.value(iScope) : null;
        Predicate predicate3 = this.removeDesire != null ? (Predicate)this.removeDesire.value(iScope) : null;
        Predicate predicate4 = this.removeUncertainty != null ? (Predicate)this.removeUncertainty.value(iScope) : null;
        Predicate predicate5 = this.removeIdeal != null ? (Predicate)this.removeIdeal.value(iScope) : null;
        Predicate predicate6 = predicate = this.removeObligation != null ? (Predicate)this.removeObligation.value(iScope) : null;
        if (bl) {
            IMap iMap;
            for (Predicate object2 : list2) {
                iMap = (IMap)System.opCopy((IScope)iScope, object2.getValues());
                if (predicate2 != null) {
                    BdiUtils.removeBelief(iScope, this.prepareToRemove(iScope, predicate2, "Belief", (IMap<String, Object>)iMap));
                }
                if (predicate3 != null) {
                    BdiUtils.removeDesire(iScope, this.prepareToRemove(iScope, predicate3, "Desire", (IMap<String, Object>)iMap));
                }
                if (predicate5 != null) {
                    BdiUtils.removeIdeal(iScope, this.prepareToRemove(iScope, predicate5, "Ideal", (IMap<String, Object>)iMap));
                }
                if (predicate == null) continue;
                BdiUtils.removeObligation(iScope, this.prepareToRemove(iScope, predicate, "Obligation", (IMap<String, Object>)iMap));
            }
            for (Predicate predicate7 : list3) {
                iMap = (IMap)System.opCopy((IScope)iScope, predicate7.getValues());
                if (predicate2 != null) {
                    BdiUtils.removeBelief(iScope, this.prepareToRemove(iScope, predicate2, "Belief", (IMap<String, Object>)iMap));
                }
                if (predicate3 != null) {
                    BdiUtils.removeDesire(iScope, this.prepareToRemove(iScope, predicate3, "Desire", (IMap<String, Object>)iMap));
                }
                if (predicate4 != null) {
                    BdiUtils.removeUncertainty(iScope, this.prepareToRemove(iScope, predicate4, "Uncertainty", (IMap<String, Object>)iMap));
                }
                if (predicate == null) continue;
                BdiUtils.removeObligation(iScope, this.prepareToRemove(iScope, predicate, "Obligation", (IMap<String, Object>)iMap));
            }
            for (Predicate predicate8 : list) {
                iMap = (IMap)System.opCopy((IScope)iScope, predicate8.getValues());
                if (predicate3 != null) {
                    BdiUtils.removeDesire(iScope, this.prepareToRemove(iScope, predicate3, "Desire", (IMap<String, Object>)iMap));
                }
                if (predicate4 != null) {
                    BdiUtils.removeUncertainty(iScope, this.prepareToRemove(iScope, predicate4, "Uncertainty", (IMap<String, Object>)iMap));
                }
                if (predicate5 != null) {
                    BdiUtils.removeIdeal(iScope, this.prepareToRemove(iScope, predicate5, "Ideal", (IMap<String, Object>)iMap));
                }
                if (predicate == null) continue;
                BdiUtils.removeObligation(iScope, this.prepareToRemove(iScope, predicate, "Obligation", (IMap<String, Object>)iMap));
            }
        } else {
            if (predicate2 != null) {
                BdiUtils.removeBelief(iScope, this.prepareToRemove(iScope, predicate2, "Belief", null));
            }
            if (predicate3 != null) {
                BdiUtils.removeDesire(iScope, this.prepareToRemove(iScope, predicate3, "Desire", null));
            }
            if (predicate4 != null) {
                BdiUtils.removeUncertainty(iScope, this.prepareToRemove(iScope, predicate4, "Uncertainty", null));
            }
            if (predicate5 != null) {
                BdiUtils.removeIdeal(iScope, this.prepareToRemove(iScope, predicate5, "Ideal", null));
            }
            if (predicate != null) {
                BdiUtils.removeObligation(iScope, this.prepareToRemove(iScope, predicate, "Obligation", null));
            }
        }
        if (this.removeIntention != null) {
            Predicate predicate9 = (Predicate)this.removeIntention.value(iScope);
            MentalState mentalState = new MentalState("Intention", predicate9);
            BdiUtils.removeIntention(iScope, mentalState);
        }
        if (this.removeEmotion != null) {
            Emotion emotion = (Emotion)this.removeEmotion.value(iScope);
            BdiUtils.removeEmotion(iScope, emotion);
        }
    }

    private void addSinglePredicates(IScope iScope, boolean bl, List<Predicate> list, List<Predicate> list2, List<Predicate> list3) {
        Predicate predicate;
        Predicate predicate2 = this.newDesire != null ? (Predicate)this.newDesire.value(iScope) : null;
        Predicate predicate3 = this.newBelief != null ? (Predicate)this.newBelief.value(iScope) : null;
        Predicate predicate4 = this.newUncertainty != null ? (Predicate)this.newUncertainty.value(iScope) : null;
        Predicate predicate5 = predicate = this.newIdeal != null ? (Predicate)this.newIdeal.value(iScope) : null;
        if (bl) {
            IMap iMap;
            for (Predicate object : list) {
                iMap = (IMap)System.opCopy((IScope)iScope, object.getValues());
                if (this.newDesire != null) {
                    BdiUtils.addDesire(iScope, null, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
                }
                if (this.newUncertainty != null) {
                    BdiUtils.addUncertainty(iScope, this.preparePredicateToAdd(iScope, predicate4, "Uncertainty", (IMap<String, Object>)iMap));
                }
                if (this.newIdeal == null) continue;
                BdiUtils.addIdeal(iScope, this.preparePredicateToAdd(iScope, predicate, "Ideal", (IMap<String, Object>)iMap));
            }
            for (Predicate predicate6 : list2) {
                iMap = (IMap)System.opCopy((IScope)iScope, predicate6.getValues());
                if (this.newDesire != null) {
                    BdiUtils.addDesire(iScope, null, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
                }
                if (this.newBelief != null) {
                    BdiUtils.addDesire(iScope, null, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
                }
                if (this.newIdeal == null) continue;
                BdiUtils.addIdeal(iScope, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
            }
            for (Predicate predicate7 : list3) {
                iMap = (IMap)System.opCopy((IScope)iScope, predicate7.getValues());
                if (this.newDesire != null) {
                    BdiUtils.addDesire(iScope, null, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
                }
                if (this.newBelief != null) {
                    BdiUtils.addBelief(iScope, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
                }
                if (this.newUncertainty == null) continue;
                BdiUtils.addUncertainty(iScope, this.preparePredicateToAdd(iScope, predicate2, "Desire", (IMap<String, Object>)iMap));
            }
        } else {
            if (this.newDesire != null) {
                BdiUtils.addDesire(iScope, null, this.preparePredicateToAdd(iScope, predicate2, "Desire", null));
            }
            if (this.newBelief != null) {
                BdiUtils.addBelief(iScope, this.preparePredicateToAdd(iScope, predicate3, "Belief", null));
            }
            if (this.newUncertainty != null) {
                BdiUtils.addUncertainty(iScope, this.preparePredicateToAdd(iScope, predicate4, "Uncertainty", null));
            }
            if (this.newIdeal != null) {
                BdiUtils.addIdeal(iScope, this.preparePredicateToAdd(iScope, predicate, "Ideal", null));
            }
        }
        if (this.newEmotion != null) {
            Emotion emotion = (Emotion)this.newEmotion.value(iScope);
            BdiUtils.addEmotion(iScope, emotion);
        }
    }

    private MentalState preparePredicateToAdd(IScope iScope, Predicate predicate, String string, IMap<String, Object> iMap) {
        MentalState mentalState = new MentalState(string, predicate);
        if (iMap != null) {
            mentalState.getPredicate().setValues(iMap);
        }
        if (this.strength != null) {
            mentalState.setStrength(Cast.asFloat((IScope)iScope, (Object)this.strength.value(iScope)));
        }
        if (this.lifetime != null) {
            mentalState.setLifeTime(Cast.asInt((IScope)iScope, (Object)this.lifetime.value(iScope)));
        }
        return mentalState;
    }

    private boolean hasBeliefs(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Belief", predicate);
            if (BdiUtils.hasBelief(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean hasDesires(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Desire", predicate);
            if (BdiUtils.hasDesire(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean hasUncertainties(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Uncertainty", predicate);
            if (BdiUtils.hasUncertainty(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean hasIdeals(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Ideal", predicate);
            if (BdiUtils.hasIdeal(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean hasObligations(IScope iScope, List<Predicate> list) {
        for (Predicate predicate : list) {
            MentalState mentalState = new MentalState("Uncertainty", predicate);
            if (BdiUtils.hasUncertainty(iScope, mentalState).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private boolean hasEmotions(IScope iScope, List<Emotion> list) {
        for (Emotion emotion : list) {
            if (BdiUtils.hasEmotion(iScope, emotion).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public IExpression getParallel() {
        return this.parallel;
    }
}

