/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.bdi.BDIPlan;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.CopingStatement;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.LawStatement;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Norm;
import gama.extension.bdi.NormStatement;
import gama.extension.bdi.PerceiveStatement;
import gama.extension.bdi.Predicate;
import gama.extension.bdi.RuleStatement;
import gama.extension.bdi.Sanction;
import gama.extension.bdi.SanctionStatement;
import gama.extension.bdi.SimpleBdiPlanStatement;
import gama.extension.bdi.SocialLink;
import gama.gaml.architecture.reflex.ReflexArchitecture;
import gama.gaml.compilation.ISymbol;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.operators.Random;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="plan_persistence", type=2, init="1.0", doc={@GamlAnnotations.doc(value="plan persistence")}), @GamlAnnotations.variable(name="intention_persistence", type=2, init="1.0", doc={@GamlAnnotations.doc(value="intention persistence")}), @GamlAnnotations.variable(name="probabilistic_choice", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if the choice is deterministic or probabilistic")}), @GamlAnnotations.variable(name="use_emotions_architecture", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if emotions are automaticaly computed")}), @GamlAnnotations.variable(name="use_social_architecture", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if social relations are automaticaly computed")}), @GamlAnnotations.variable(name="use_personality", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if the personnality is used")}), @GamlAnnotations.variable(name="use_persistence", type=3, init="false", doc={@GamlAnnotations.doc(value="indicates if the persistence coefficient is computed with personality (false) or with the value given by the modeler")}), @GamlAnnotations.variable(name="obedience", type=2, init="1.0", doc={@GamlAnnotations.doc(value="an obedience value. By default, it is computed with personality")}), @GamlAnnotations.variable(name="charisma", type=2, init="1.0", doc={@GamlAnnotations.doc(value="a charisma value. By default, it is computed with personality")}), @GamlAnnotations.variable(name="receptivity", type=2, init="1.0", doc={@GamlAnnotations.doc(value="a receptivity value. By default, it is computed with personality")}), @GamlAnnotations.variable(name="openness", type=2, init="0.5", doc={@GamlAnnotations.doc(value="an openness value for the personality")}), @GamlAnnotations.variable(name="conscientiousness", type=2, init="0.5", doc={@GamlAnnotations.doc(value="a conscientiousness value for the personality")}), @GamlAnnotations.variable(name="extroversion", type=2, init="0.5", doc={@GamlAnnotations.doc(value="an extraversion value for the personality")}), @GamlAnnotations.variable(name="agreeableness", type=2, init="0.5", doc={@GamlAnnotations.doc(value="an agreeableness value for the personality")}), @GamlAnnotations.variable(name="neurotism", type=2, init="0.5", doc={@GamlAnnotations.doc(value="a neurotism value for the personality")}), @GamlAnnotations.variable(name="belief_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the belief base of the agent")}), @GamlAnnotations.variable(name="thinking", type=5, init="[]", doc={@GamlAnnotations.doc(value="the list of the last thoughts of the agent")}), @GamlAnnotations.variable(name="intention_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the intention base of the agent")}), @GamlAnnotations.variable(name="emotion_base", type=5, of=546706, init="[]", doc={@GamlAnnotations.doc(value="the emotion base of the agent")}), @GamlAnnotations.variable(name="desire_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the desire base of the agent")}), @GamlAnnotations.variable(name="obligation_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the obligation base of the agent")}), @GamlAnnotations.variable(name="uncertainty_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the uncertainty base of the agent")}), @GamlAnnotations.variable(name="ideal_base", type=5, of=546708, init="[]", doc={@GamlAnnotations.doc(value="the ideal base of the agent")}), @GamlAnnotations.variable(name="law_base", type=5, of=0, init="[]", doc={@GamlAnnotations.doc(value="the law base of the agent")}), @GamlAnnotations.variable(name="plan_base", type=5, of=-202, init="[]", doc={@GamlAnnotations.doc(value="the plan base of the agent")}), @GamlAnnotations.variable(name="norm_base", type=5, of=546710, init="[]", doc={@GamlAnnotations.doc(value="the norm base of the agent")}), @GamlAnnotations.variable(name="sanction_base", type=5, of=546711, init="[]", doc={@GamlAnnotations.doc(value="the sanction base of the agent")}), @GamlAnnotations.variable(name="social_link_base", type=5, of=546707, init="[]", doc={@GamlAnnotations.doc(value="the social link base of the agent")}), @GamlAnnotations.variable(name="current_plan", type=0, doc={@GamlAnnotations.doc(value="thecurrent plan of the agent")}), @GamlAnnotations.variable(name="current_norm", type=0, doc={@GamlAnnotations.doc(value="the current norm of the agent")})})
@GamlAnnotations.skill(name="simple_bdi", concept={"bdi", "architecture"})
@GamlAnnotations.doc(value="this architecture enables to define a behaviour using BDI. It is an implementation of the BEN architecture (Behaviour with Emotions and Norms)")
public class SimpleBdiArchitecture
extends ReflexArchitecture {
    public static final String SIMPLE_BDI = "simple_bdi";
    public static final String PLAN = "plan";
    public static final String PRIORITY = "priority";
    public static final String FINISHEDWHEN = "finished_when";
    public static final String PERSISTENCE_COEFFICIENT_PLANS = "plan_persistence";
    public static final String PERSISTENCE_COEFFICIENT_INTENTIONS = "intention_persistence";
    public static final String USE_EMOTIONS_ARCHITECTURE = "use_emotions_architecture";
    public static final String USE_SOCIAL_ARCHITECTURE = "use_social_architecture";
    public static final String USE_PERSONALITY = "use_personality";
    public static final String USE_PERSISTENCE = "use_persistence";
    public static final String OBEDIENCE = "obedience";
    public static final String CHARISMA = "charisma";
    public static final String RECEPTIVITY = "receptivity";
    public static final String OPENNESS = "openness";
    public static final String CONSCIENTIOUSNESS = "conscientiousness";
    public static final String EXTRAVERSION = "extroversion";
    public static final String AGREEABLENESS = "agreeableness";
    public static final String NEUROTISM = "neurotism";
    public static final String PROBABILISTIC_CHOICE = "probabilistic_choice";
    public static final String INSTANTANEOUS = "instantaneous";
    public static final String LAST_THOUGHTS = "thinking";
    public static final Integer LAST_THOUGHTS_SIZE = 5;
    public static final String EMOTION = "emotion";
    public static final String SOCIALLINK = "social_link";
    public static final String PREDICATE = "predicate";
    public static final String PREDICATE_NAME = "name";
    public static final String PREDICATE_VALUE = "value";
    public static final String PREDICATE_PRIORITY = "priority";
    public static final String PREDICATE_PARAMETERS = "parameters";
    public static final String ON_HOLD_UNTIL = "on_hold_until";
    public static final String AGENT_CAUSE = "cause";
    public static final String MENTAL_STATE = "mental_state";
    public static final String PREDICATE_TODO = "todo";
    public static final String PREDICATE_SUBINTENTION = "subintention";
    public static final String SUBINTENTIONS = "subintentions";
    public static final String SUPERINTENTION = "super_intention";
    public static final String PREDICATE_DATE = "date";
    public static final String BELIEF_BASE = "belief_base";
    public static final String IDEAL_BASE = "ideal_base";
    public static final String REMOVE_DESIRE_AND_INTENTION = "desire_also";
    public static final String DESIRE_BASE = "desire_base";
    public static final String OBLIGATION_BASE = "obligation_base";
    public static final String INTENTION_BASE = "intention_base";
    public static final String EMOTION_BASE = "emotion_base";
    public static final String SOCIALLINK_BASE = "social_link_base";
    public static final String EVERY_VALUE = "every_possible_value";
    public static final String PLAN_BASE = "plan_base";
    public static final String NORM_BASE = "norm_base";
    public static final String SANCTION_BASE = "sanction_base";
    public static final String CURRENT_PLAN = "current_plan";
    public static final String CURRENT_NORM = "current_norm";
    public static final String UNCERTAINTY_BASE = "uncertainty_base";
    public static final String LAW_BASE = "law_base";
    public static final String OWNER = "owner";
    protected final List<BDIPlan> _plans = new ArrayList<BDIPlan>();
    protected final List<PerceiveStatement> _perceptions = new ArrayList<PerceiveStatement>();
    protected final List<RuleStatement> _rules = new ArrayList<RuleStatement>();
    protected final List<CopingStatement> _coping = new ArrayList<CopingStatement>();
    protected final List<LawStatement> _laws = new ArrayList<LawStatement>();
    protected final List<Norm> _norms = new ArrayList<Norm>();
    protected final List<Sanction> _sanctions = new ArrayList<Sanction>();
    protected int _plansNumber = 0;
    protected int _perceptionNumber = 0;
    protected boolean iscurrentplaninstantaneous = false;
    protected int _lawsNumber = 0;
    protected int _rulesNumber = 0;
    protected int _copingNumber = 0;
    protected int _normNumber = 0;
    protected int _sanctionNumber = 0;

    protected void clearBehaviors() {
        super.clearBehaviors();
        this._plans.clear();
        this._rules.clear();
        this._coping.clear();
        this._perceptions.clear();
        this._laws.clear();
        this._norms.clear();
        this._sanctions.clear();
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.clearBehaviors();
        for (ISymbol iSymbol : iterable) {
            this.addBehavior((IStatement)iSymbol);
        }
    }

    public void addBehavior(IStatement iStatement) {
        if (iStatement instanceof SimpleBdiPlanStatement) {
            this._plans.add(new BDIPlan((SimpleBdiPlanStatement)iStatement));
            ++this._plansNumber;
        } else if (iStatement instanceof PerceiveStatement) {
            this._perceptions.add((PerceiveStatement)iStatement);
            ++this._perceptionNumber;
        } else if (iStatement instanceof RuleStatement) {
            this._rules.add((RuleStatement)iStatement);
            ++this._rulesNumber;
        } else if (iStatement instanceof CopingStatement) {
            this._coping.add((CopingStatement)iStatement);
            ++this._copingNumber;
        } else if (iStatement instanceof LawStatement) {
            this._laws.add((LawStatement)iStatement);
            ++this._lawsNumber;
        } else if (iStatement instanceof NormStatement) {
            this._norms.add(new Norm((NormStatement)iStatement));
            ++this._normNumber;
        } else if (iStatement instanceof SanctionStatement) {
            this._sanctions.add(new Sanction((SanctionStatement)iStatement));
            ++this._sanctionNumber;
        } else {
            super.addBehavior(iStatement);
        }
    }

    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        Object object;
        Boolean bl;
        super.executeOn(iScope);
        IAgent iAgent = iScope.getAgent();
        if (iAgent.dead()) {
            return null;
        }
        Boolean bl2 = bl = iScope.hasArg(USE_PERSONALITY) ? iScope.getBoolArg(USE_PERSONALITY) : (Boolean)iScope.getAgent().getAttribute(USE_PERSONALITY);
        if (bl.booleanValue()) {
            object = (Double)iScope.getAgent().getAttribute(EXTRAVERSION);
            Double d = (Double)iScope.getAgent().getAttribute(NEUROTISM);
            Double d2 = (Double)iScope.getAgent().getAttribute(CONSCIENTIOUSNESS);
            Double d3 = (Double)iScope.getAgent().getAttribute(AGREEABLENESS);
            iScope.getAgent().setAttribute(CHARISMA, object);
            iScope.getAgent().setAttribute(RECEPTIVITY, (Object)(1.0 - d));
            iScope.getAgent().setAttribute(PERSISTENCE_COEFFICIENT_PLANS, (Object)Maths.sqrt((IScope)iScope, (Double)d2));
            iScope.getAgent().setAttribute(PERSISTENCE_COEFFICIENT_INTENTIONS, (Object)Maths.sqrt((IScope)iScope, (Double)d2));
            iScope.getAgent().setAttribute(OBEDIENCE, (Object)Maths.sqrt((IScope)iScope, (Double)((d2 + d3) * 0.5)));
        }
        if (this._sanctionNumber > 0) {
            iScope.getAgent().setAttribute(SANCTION_BASE, this._sanctions);
        }
        if (this._perceptionNumber > 0) {
            int n = 0;
            while (n < this._perceptionNumber) {
                this._perceptions.get(n).executeOn(iScope);
                if (iAgent.dead()) {
                    return null;
                }
                ++n;
            }
        }
        if (this._rulesNumber > 0) {
            int n = 0;
            while (n < this._rulesNumber) {
                this._rules.get(n).executeOn(iScope);
                if (iAgent.dead()) {
                    return null;
                }
                ++n;
            }
        }
        if (this._lawsNumber > 0) {
            int n = 0;
            while (n < this._lawsNumber) {
                this._laws.get(n).executeOn(iScope);
                if (iAgent.dead()) {
                    return null;
                }
                ++n;
            }
        }
        this.updateSocialLinks(iScope);
        if (this._copingNumber > 0) {
            int n = 0;
            while (n < this._copingNumber) {
                this._coping.get(n).executeOn(iScope);
                if (iAgent.dead()) {
                    return null;
                }
                ++n;
            }
        }
        object = this.executePlans(iScope);
        if (!iScope.getAgent().dead()) {
            this.updateNormViolation(iScope);
            this.updateNormLifetime(iScope);
            this.updateLifeTimePredicates(iScope);
            this.updateEmotionsIntensity(iScope);
        }
        return object;
    }

    protected final Object executePlans(IScope iScope) {
        Object object = null;
        if (this._plansNumber <= 0 && this._normNumber <= 0) {
            return object;
        }
        boolean bl = true;
        while (bl) {
            Object object2;
            bl = false;
            IAgent iAgent = this.getCurrentAgent(iScope);
            if (iAgent.dead()) {
                return null;
            }
            iAgent.setAttribute(LAW_BASE, this._laws);
            iAgent.setAttribute(PLAN_BASE, this._plans);
            iAgent.setAttribute(NORM_BASE, this._norms);
            iAgent.setAttribute(SANCTION_BASE, this._sanctions);
            Boolean bl2 = (Boolean)iAgent.getAttribute(USE_PERSISTENCE);
            IList iList = iScope.hasArg(INTENTION_BASE) ? iScope.getListArg(INTENTION_BASE) : (IList)iAgent.getAttribute(INTENTION_BASE);
            Double d = 1.0;
            Double d2 = 1.0;
            if (bl2.booleanValue()) {
                d = iScope.hasArg(PERSISTENCE_COEFFICIENT_PLANS) ? iScope.getFloatArg(PERSISTENCE_COEFFICIENT_PLANS) : (Double)iAgent.getAttribute(PERSISTENCE_COEFFICIENT_PLANS);
                d2 = iScope.hasArg(PERSISTENCE_COEFFICIENT_INTENTIONS) ? iScope.getFloatArg(PERSISTENCE_COEFFICIENT_INTENTIONS) : (Double)iAgent.getAttribute(PERSISTENCE_COEFFICIENT_INTENTIONS);
            }
            BDIPlan bDIPlan = (BDIPlan)iAgent.getAttribute(CURRENT_PLAN);
            Norm norm = (Norm)iAgent.getAttribute(CURRENT_NORM);
            Boolean bl3 = Random.opFlip((IScope)iScope, (Double)d2);
            while (!bl3.booleanValue() && iList.size() > 0) {
                bl3 = Random.opFlip((IScope)iScope, (Double)d2);
                if (iList.size() <= 0) continue;
                int n = iList.size() - 1;
                object2 = ((MentalState)iList.get(n)).getPredicate();
                iList.remove(n);
                String string = "check what happens if I remove: " + String.valueOf(object2);
                this.addThoughts(iScope, string);
                bDIPlan = null;
                iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                norm = null;
                iAgent.setAttribute(CURRENT_NORM, (Object)norm);
            }
            MentalState mentalState = this.currentIntention(iScope) != null ? this.currentIntention(iScope) : new MentalState("Intention", this.currentIntention(iScope));
            if (this.testOnHold(iScope, mentalState) || this.currentIntention(iScope) == null || this.currentIntention(iScope).getPredicate() == null || this.listExecutablePlans(iScope).isEmpty() && this.listExecutableNorms(iScope).isEmpty()) {
                if (!this.selectObligationWithHighestPriority(iScope)) {
                    this.selectDesireWithHighestPriority(iScope);
                }
                bDIPlan = null;
                iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                norm = null;
                iAgent.setAttribute(CURRENT_NORM, (Object)norm);
            }
            bDIPlan = (BDIPlan)iAgent.getAttribute(CURRENT_PLAN);
            norm = (Norm)iAgent.getAttribute(CURRENT_NORM);
            object2 = Random.opFlip((IScope)iScope, (Double)d);
            if (!((Boolean)object2).booleanValue()) {
                if (bDIPlan != null) {
                    this.addThoughts(iScope, "check what happens if I stop: " + bDIPlan.getName());
                }
                bDIPlan = this.selectExecutablePlanWithHighestPriority(iScope);
                iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                if (bDIPlan != null) {
                    this.addThoughts(iScope, "lets do instead " + bDIPlan.getName());
                }
            }
            if (this.currentIntention(iScope) == null) {
                this.addThoughts(iScope, "I want nothing...");
                return null;
            }
            if (norm == null && this.currentIntention(iScope) != null && this.currentIntention(iScope).getPredicate() == null) {
                if (!this.selectObligationWithHighestPriority(iScope)) {
                    this.selectDesireWithHighestPriority(iScope);
                }
                if (this.currentIntention(iScope) != null && this.currentIntention(iScope).getPredicate() == null) {
                    this.addThoughts(iScope, "I want nothing...");
                    return null;
                }
                norm = this.selectExecutableNormWithHighestPriority(iScope);
                iAgent.setAttribute(CURRENT_NORM, (Object)norm);
                if (this.currentIntention(iScope) != null && bDIPlan != null) {
                    this.addThoughts(iScope, "ok, new intention: " + String.valueOf(this.currentIntention(iScope).getPredicate()) + " with norm " + norm.getName());
                }
            }
            if (norm == null && bDIPlan == null && this.currentIntention(iScope) != null && this.currentIntention(iScope).getPredicate() == null) {
                this.selectDesireWithHighestPriority(iScope);
                if (this.currentIntention(iScope) != null && this.currentIntention(iScope).getPredicate() == null) {
                    this.addThoughts(iScope, "I want nothing...");
                    return null;
                }
                bDIPlan = this.selectExecutablePlanWithHighestPriority(iScope);
                iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                if (this.currentIntention(iScope) != null && bDIPlan != null) {
                    this.addThoughts(iScope, "ok, new intention: " + String.valueOf(this.currentIntention(iScope).getPredicate()) + " with plan " + bDIPlan.getName());
                }
            }
            if (this.currentIntention(iScope) != null && bDIPlan == null && this.currentIntention(iScope).getPredicate() != null) {
                norm = this.selectExecutableNormWithHighestPriority(iScope);
                iAgent.setAttribute(CURRENT_NORM, (Object)norm);
                if (norm == null) {
                    bDIPlan = this.selectExecutablePlanWithHighestPriority(iScope);
                    iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                } else {
                    iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
                }
                if (norm != null) {
                    this.addThoughts(iScope, "use norm : " + norm.getName());
                }
                if (bDIPlan != null) {
                    this.addThoughts(iScope, "use plan : " + bDIPlan.getName());
                }
            }
            if (norm != null && !iAgent.dead()) {
                object = norm.getNormStatement().executeOn(iScope);
                boolean bl4 = false;
                if (norm.getNormStatement().getExecutedExpression() != null) {
                    bl4 = Cast.asBool((IScope)iScope, (Object)norm.getNormStatement().getExecutedExpression().value(iScope));
                }
                if (this.iscurrentplaninstantaneous) {
                    bl = true;
                }
                if (bl4) {
                    norm = null;
                    iAgent.setAttribute(CURRENT_NORM, (Object)norm);
                }
            }
            if (bDIPlan == null || iAgent.dead()) continue;
            object = bDIPlan.getPlanStatement().executeOn(iScope);
            boolean bl5 = false;
            if (bDIPlan.getPlanStatement().getExecutedExpression() != null) {
                bl5 = Cast.asBool((IScope)iScope, (Object)bDIPlan.getPlanStatement().getExecutedExpression().value(iScope));
            }
            if (this.iscurrentplaninstantaneous) {
                bl = true;
            }
            if (!bl5) continue;
            bDIPlan = null;
            iAgent.setAttribute(CURRENT_PLAN, (Object)bDIPlan);
        }
        return object;
    }

    protected final boolean selectMentalStateWithHighestPriority(IScope iScope, String string, boolean bl, Function<NormStatement, Predicate> function) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        Boolean bl2 = iScope.getBoolArgIfExists(PROBABILISTIC_CHOICE, ((Boolean)iAgent.getAttribute(PROBABILISTIC_CHOICE)).booleanValue());
        List list = this.getPlans(iScope) == null ? Collections.emptyList() : this.getPlans(iScope);
        List<Norm> list2 = BdiUtils.getNorms(iScope);
        if (list2 == null) {
            return false;
        }
        IList iList = GamaListFactory.create();
        IList<MentalState> iList2 = BdiUtils.getBase(iScope, string);
        IList<MentalState> iList3 = BdiUtils.getBase(iScope, INTENTION_BASE);
        if (bl2.booleanValue()) {
            MentalState mentalState22;
            if (iList2.isEmpty()) {
                return false;
            }
            for (MentalState mentalState22 : iList2) {
                Predicate predicate = mentalState22.getPredicate();
                if (bl) {
                    list.stream().filter(bDIPlan -> ((Predicate)bDIPlan.getPlanStatement().getIntentionExpression().value(iScope)).equalsIntentionPlan(predicate)).forEach(arg_0 -> SimpleBdiArchitecture.lambda$1((List)iList, mentalState22, arg_0));
                }
                list2.stream().filter(norm -> ((Predicate)function.apply(norm.getNormStatement())).equalsIntentionPlan(predicate)).forEach(arg_0 -> SimpleBdiArchitecture.lambda$3((List)iList, mentalState22, arg_0));
            }
            mentalState22 = (MentalState)iList2.firstValue(iScope);
            double[] dArray = iList.stream().mapToDouble(mentalState -> mentalState.getStrength()).toArray();
            IList iList4 = GamaListFactory.create((IScope)iScope, (IType)Types.FLOAT, (double[])dArray);
            int n = Random.opRndChoice((IScope)iScope, (IList)iList4);
            mentalState22 = (MentalState)iList.get(n);
            double d = ((MentalState)iList.get(n)).getStrength();
            if (iList.size() > iList3.size()) {
                while (iList3.contains((Object)mentalState22)) {
                    int n2 = Random.opRndChoice((IScope)iScope, (IList)iList4);
                    mentalState22 = (MentalState)iList.get(n2);
                    d = ((MentalState)iList.get(n2)).getStrength();
                }
            }
            return this.addInMentalStateBase(iScope, mentalState22, d, string);
        }
        iScope.getRandom().shuffleInPlace(iList2);
        this.addMentalStatesWithMatchingIntentions(iScope, iList2, (List<MentalState>)iList, bl);
        double d = Double.MIN_VALUE;
        if (iList.isEmpty() || iList3 == null) {
            return false;
        }
        MentalState mentalState3 = null;
        for (MentalState mentalState4 : iList) {
            if (!(mentalState4.getStrength() > d) || iList3.contains((Object)mentalState4)) continue;
            d = mentalState4.getStrength();
            mentalState3 = mentalState4;
        }
        if (mentalState3 == null) {
            return false;
        }
        return this.addInMentalStateBase(iScope, mentalState3, d, string);
    }

    private void addMentalStatesWithMatchingIntentions(IScope iScope, IList<MentalState> iList, List<MentalState> list, boolean bl) {
        List list2 = this.getPlans(iScope) == null ? Collections.emptyList() : this.getPlans(iScope);
        List<Norm> list3 = BdiUtils.getNorms(iScope);
        for (MentalState mentalState : iList) {
            if (bl) {
                list2.stream().filter(bDIPlan -> bDIPlan != null && bDIPlan.getPlanStatement() != null).map(bDIPlan -> bDIPlan.getPlanStatement().getIntentionExpression()).filter(iExpression -> iExpression == null || iExpression.value(iScope) == null || ((Predicate)iExpression.value(iScope)).equalsIntentionPlan(mentalState.getPredicate())).forEach(iExpression -> {
                    boolean bl = list.add(mentalState);
                });
            }
            list3.stream().filter(norm -> norm != null && norm.getNormStatement() != null).map(norm -> norm.getNormStatement()).filter(normStatement -> normStatement.getIntentionExpression() == null || normStatement.getIntentionExpression().value(iScope) == null || normStatement.getObligationExpression() != null && ((Predicate)normStatement.getObligationExpression().value(iScope)).equalsIntentionPlan(mentalState)).forEach(normStatement -> {
                boolean bl = list.add(mentalState);
            });
        }
    }

    private boolean addInMentalStateBase(IScope iScope, MentalState mentalState2, double d, String string) {
        MentalState mentalState3 = null;
        IList<MentalState> iList = BdiUtils.getBase(iScope, INTENTION_BASE);
        IList<MentalState> iList2 = BdiUtils.getBase(iScope, string);
        Predicate predicate = mentalState2.getPredicate();
        int n = mentalState2.getLifeTime();
        if (predicate != null) {
            mentalState3 = new MentalState("Intention", predicate, (Double)d, n, iScope.getAgent());
        }
        if (mentalState2.getMentalState() != null) {
            mentalState3 = new MentalState("Intention", mentalState2.getMentalState(), (Double)d, n, iScope.getAgent());
        }
        if (predicate != null) {
            if (predicate.getSubintentions() == null && !iList.contains((Object)mentalState3)) {
                iList.addValue(iScope, (Object)mentalState3);
                return true;
            }
            predicate.getSubintentions().stream().filter(mentalState -> !iList2.contains(mentalState)).forEach(mentalState -> iList2.addValue(iScope, mentalState));
            predicate.setOnHoldUntil(predicate.getSubintentions());
            if (!iList.contains((Object)mentalState3)) {
                iList.addValue(iScope, (Object)mentalState3);
                return true;
            }
        }
        return false;
    }

    protected final boolean selectDesireWithHighestPriority(IScope iScope) {
        return this.selectMentalStateWithHighestPriority(iScope, DESIRE_BASE, true, normStatement -> (Predicate)normStatement.getIntentionExpression().value(iScope));
    }

    protected final boolean selectObligationWithHighestPriority(IScope iScope) {
        return this.selectMentalStateWithHighestPriority(iScope, DESIRE_BASE, false, normStatement -> (Predicate)normStatement.getObligationExpression().value(iScope));
    }

    protected final BDIPlan selectExecutablePlanWithHighestPriority(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        Boolean bl = iScope.hasArg(PROBABILISTIC_CHOICE) ? iScope.getBoolArg(PROBABILISTIC_CHOICE) : (Boolean)iAgent.getAttribute(PROBABILISTIC_CHOICE);
        BDIPlan bDIPlan = null;
        double d = Double.MIN_VALUE;
        ArrayList<BDIPlan> arrayList = new ArrayList<BDIPlan>();
        IList iList = GamaListFactory.create((IType)Types.FLOAT);
        ArrayList<BDIPlan> arrayList2 = new ArrayList<BDIPlan>(this._plans);
        iScope.getRandom().shuffleInPlace(arrayList2);
        for (BDIPlan bDIPlan2 : arrayList2) {
            boolean bl2;
            SimpleBdiPlanStatement simpleBdiPlanStatement = bDIPlan2.getPlanStatement();
            boolean bl3 = simpleBdiPlanStatement.getContextExpression() == null || Cast.asBool((IScope)iScope, (Object)simpleBdiPlanStatement.getContextExpression().value(iScope)) != false;
            boolean bl4 = simpleBdiPlanStatement.getIntentionExpression() == null || simpleBdiPlanStatement.getIntentionExpression().value(iScope) == null || ((Predicate)simpleBdiPlanStatement.getIntentionExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate());
            boolean bl5 = simpleBdiPlanStatement.getEmotionExpression() == null || BdiUtils.getEmotionBase(iScope, EMOTION_BASE).contains(simpleBdiPlanStatement.getEmotionExpression().value(iScope));
            boolean bl6 = bl2 = simpleBdiPlanStatement.getThreshold() == null || simpleBdiPlanStatement.getEmotionExpression() != null && BdiUtils.getEmotion((IScope)iScope, (Emotion)((Emotion)simpleBdiPlanStatement.getEmotionExpression().value((IScope)iScope))).intensity >= (Double)simpleBdiPlanStatement.getThreshold().value(iScope);
            if (!bl3 || !bl4 || !bl5 || !bl2) continue;
            if (bl.booleanValue()) {
                arrayList.add(bDIPlan2);
                continue;
            }
            double d2 = 1.0;
            if (simpleBdiPlanStatement.getFacet(new String[]{"priority"}) != null) {
                d2 = Cast.asFloat((IScope)iScope, (Object)simpleBdiPlanStatement.getPriorityExpression().value(iScope));
            }
            if (!(d < d2)) continue;
            d = d2;
            bDIPlan = bDIPlan2;
        }
        if (bl.booleanValue() && !arrayList.isEmpty()) {
            for (BDIPlan bDIPlan2 : arrayList) {
                if (bDIPlan2.getPlanStatement().hasFacet("priority")) {
                    iList.add((Object)Cast.asFloat((IScope)iScope, (Object)bDIPlan2.getPlanStatement().getPriorityExpression().value(iScope)));
                    continue;
                }
                iList.add((Object)1.0);
            }
            int n = Random.opRndChoice((IScope)iScope, (IList)iList);
            bDIPlan = (BDIPlan)arrayList.get(n);
        }
        this.iscurrentplaninstantaneous = false;
        if (bDIPlan != null && bDIPlan.getPlanStatement().getFacet(new String[]{INSTANTANEOUS}) != null) {
            this.iscurrentplaninstantaneous = Cast.asBool((IScope)iScope, (Object)bDIPlan.getPlanStatement().getInstantaneousExpression().value(iScope));
        }
        return bDIPlan;
    }

    protected final Norm selectExecutableNormWithHighestPriority(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        Double d = (Double)iScope.getAgent().getAttribute(OBEDIENCE);
        Boolean bl = (Boolean)iScope.getTypedArgIfExists(PROBABILISTIC_CHOICE, 3, (Object)((Boolean)iAgent.getAttribute(PROBABILISTIC_CHOICE)));
        Object object2 = null;
        double d2 = Double.MIN_VALUE;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IList iList = GamaListFactory.create((IType)Types.FLOAT);
        for (Norm object3 : BdiUtils.getNorms(iScope)) {
            object3.setSanctioned(false);
        }
        ArrayList<Norm> arrayList2 = new ArrayList<Norm>(this._norms);
        iScope.getRandom().shuffleInPlace(arrayList2);
        for (Object object4 : arrayList2) {
            double d3;
            boolean bl2;
            NormStatement normStatement = ((Norm)object4).getNormStatement();
            boolean bl3 = normStatement.getContextExpression() == null || Cast.asBool((IScope)iScope, (Object)normStatement.getContextExpression().value(iScope)) != false;
            boolean bl4 = false;
            if (normStatement.getIntentionExpression() != null && normStatement.getIntentionExpression().value(iScope) != null) {
                bl4 = ((Predicate)normStatement.getIntentionExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate());
            }
            boolean bl5 = false;
            if (normStatement.getObligationExpression() != null && normStatement.getObligationExpression().value(iScope) != null && BdiUtils.hasObligation(iScope, new MentalState("Obligation", (Predicate)normStatement.getObligationExpression().value(iScope))).booleanValue()) {
                bl5 = ((Predicate)normStatement.getObligationExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate());
            }
            boolean bl6 = bl2 = normStatement.getThreshold() == null || d >= (Double)normStatement.getThreshold().value(iScope);
            if (bl3 && bl5 && bl2) {
                if (bl.booleanValue()) {
                    arrayList.add(object4);
                } else {
                    d3 = 1.0;
                    if (normStatement.getFacet(new String[]{"priority"}) != null) {
                        d3 = Cast.asFloat((IScope)iScope, (Object)normStatement.getPriorityExpression().value(iScope));
                    }
                    if (d2 < d3) {
                        d2 = d3;
                        object2 = object4;
                    }
                }
            }
            if (!bl3 || !bl4 || !bl2) continue;
            if (bl.booleanValue()) {
                arrayList.add(object4);
                continue;
            }
            d3 = 1.0;
            if (normStatement.getFacet(new String[]{"priority"}) != null) {
                d3 = Cast.asFloat((IScope)iScope, (Object)normStatement.getPriorityExpression().value(iScope));
            }
            if (!(d2 < d3)) continue;
            d2 = d3;
            object2 = object4;
        }
        if (bl.booleanValue() && !arrayList.isEmpty()) {
            for (Object object4 : arrayList) {
                if (((Norm)object4).getNormStatement().hasFacet("priority")) {
                    iList.add((Object)Cast.asFloat((IScope)iScope, (Object)((Norm)object4).getNormStatement().getPriorityExpression().value(iScope)));
                    continue;
                }
                iList.add((Object)1.0);
            }
            int n = Random.opRndChoice((IScope)iScope, (IList)iList);
            object2 = (Norm)arrayList.get(n);
        }
        this.iscurrentplaninstantaneous = false;
        if (object2 != null && ((Norm)object2).getNormStatement().getFacet(new String[]{INSTANTANEOUS}) != null) {
            this.iscurrentplaninstantaneous = Cast.asBool((IScope)iScope, (Object)((Norm)object2).getNormStatement().getInstantaneousExpression().value(iScope));
        }
        return object2;
    }

    protected void updateLifeTimePredicates(IScope iScope) {
        for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
            mentalState.isUpdated = false;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
            mentalState.isUpdated = false;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            mentalState.isUpdated = false;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, UNCERTAINTY_BASE)) {
            mentalState.isUpdated = false;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, OBLIGATION_BASE)) {
            mentalState.isUpdated = false;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
            mentalState.updateLifetime();
        }
        for (MentalState mentalState : this.listBeliefsLifeTimeNull(iScope)) {
            BdiUtils.removeBelief(iScope, mentalState);
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
            mentalState.updateLifetime();
        }
        for (MentalState mentalState : this.listDesiresLifeTimeNull(iScope)) {
            BdiUtils.removeDesire(iScope, mentalState);
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            mentalState.updateLifetime();
        }
        for (MentalState mentalState : this.listIntentionsLifeTimeNull(iScope)) {
            BdiUtils.removeIntention(iScope, mentalState);
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, UNCERTAINTY_BASE)) {
            mentalState.updateLifetime();
        }
        for (MentalState mentalState : this.listUncertaintyLifeTimeNull(iScope)) {
            BdiUtils.removeUncertainty(iScope, mentalState);
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, OBLIGATION_BASE)) {
            mentalState.updateLifetime();
        }
        for (MentalState mentalState : this.listObligationLifeTimeNull(iScope)) {
            BdiUtils.removeObligation(iScope, mentalState);
        }
    }

    private List<MentalState> listBeliefsLifeTimeNull(IScope iScope) {
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
            if (mentalState.getLifeTime() != 0) continue;
            arrayList.add(mentalState);
        }
        return arrayList;
    }

    private List<MentalState> listDesiresLifeTimeNull(IScope iScope) {
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
            if (mentalState.getLifeTime() != 0) continue;
            arrayList.add(mentalState);
        }
        return arrayList;
    }

    private List<MentalState> listIntentionsLifeTimeNull(IScope iScope) {
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            if (mentalState.getLifeTime() != 0) continue;
            arrayList.add(mentalState);
        }
        return arrayList;
    }

    private List<MentalState> listUncertaintyLifeTimeNull(IScope iScope) {
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        for (MentalState mentalState : BdiUtils.getBase(iScope, UNCERTAINTY_BASE)) {
            if (mentalState.getLifeTime() != 0) continue;
            arrayList.add(mentalState);
        }
        return arrayList;
    }

    private List<MentalState> listObligationLifeTimeNull(IScope iScope) {
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        for (MentalState mentalState : BdiUtils.getBase(iScope, OBLIGATION_BASE)) {
            if (mentalState.getLifeTime() != 0) continue;
            arrayList.add(mentalState);
        }
        return arrayList;
    }

    protected final List<SimpleBdiPlanStatement> listExecutablePlans(IScope iScope) {
        ArrayList<SimpleBdiPlanStatement> arrayList = new ArrayList<SimpleBdiPlanStatement>();
        ArrayList<BDIPlan> arrayList2 = new ArrayList<BDIPlan>(this._plans);
        iScope.getRandom().shuffleInPlace(arrayList2);
        for (BDIPlan bDIPlan : arrayList2) {
            SimpleBdiPlanStatement simpleBdiPlanStatement = bDIPlan.getPlanStatement();
            if (simpleBdiPlanStatement.getContextExpression() != null && !Cast.asBool((IScope)iScope, (Object)simpleBdiPlanStatement.getContextExpression().value(iScope)).booleanValue() || this.currentIntention(iScope) == null || simpleBdiPlanStatement.getIntentionExpression() != null && (Predicate)simpleBdiPlanStatement.getIntentionExpression().value(iScope) != null && !((Predicate)simpleBdiPlanStatement.getIntentionExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate())) continue;
            arrayList.add(simpleBdiPlanStatement);
        }
        return arrayList;
    }

    protected final List<NormStatement> listExecutableNorms(IScope iScope) {
        ArrayList<NormStatement> arrayList = new ArrayList<NormStatement>();
        ArrayList<Norm> arrayList2 = new ArrayList<Norm>(this._norms);
        iScope.getRandom().shuffleInPlace(arrayList2);
        for (Norm norm : arrayList2) {
            NormStatement normStatement = norm.getNormStatement();
            if (normStatement.getContextExpression() != null && !Cast.asBool((IScope)iScope, (Object)normStatement.getContextExpression().value(iScope)).booleanValue() || this.currentIntention(iScope) == null) continue;
            if (normStatement.getIntentionExpression() != null && normStatement.getIntentionExpression().value(iScope) != null && ((Predicate)normStatement.getIntentionExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate())) {
                arrayList.add(normStatement);
            }
            if (normStatement.getObligationExpression() == null || normStatement.getObligationExpression().value(iScope) == null || !((Predicate)normStatement.getObligationExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate())) continue;
            arrayList.add(normStatement);
        }
        return arrayList;
    }

    public IList<String> getThoughts(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IList iList = (IList)iAgent.getAttribute(LAST_THOUGHTS);
        return iList;
    }

    public IList<String> addThoughts(IScope iScope, String string) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        IList iList = (IList)iAgent.getAttribute(LAST_THOUGHTS);
        IList iList2 = GamaListFactory.create((IType)Types.STRING);
        iList2.add((Object)string);
        if (iList != null && iList.size() > 0) {
            iList2.addAll((Collection)iList.subList(0, Math.min(LAST_THOUGHTS_SIZE - 1, iList.size())));
        }
        iAgent.setAttribute(LAST_THOUGHTS, (Object)iList2);
        return iList2;
    }

    private void removeIntention(IScope iScope, MentalState mentalState, boolean bl) {
        IList<MentalState> iList = BdiUtils.getBase(iScope, DESIRE_BASE);
        IList<MentalState> iList2 = BdiUtils.getBase(iScope, INTENTION_BASE);
        iList.remove((Object)mentalState);
        iList2.remove((Object)mentalState);
        if (bl) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                List<MentalState> list;
                List<MentalState> list2 = mentalState2.getPredicate().getSubintentions();
                if (list2 != null && list2.contains(mentalState)) {
                    list2.remove(mentalState);
                }
                if ((list = mentalState2.getPredicate().getOnHoldUntil()) == null || !list.contains(mentalState)) continue;
                list.remove(mentalState);
            }
        }
    }

    public boolean testOnHold(IScope iScope, MentalState mentalState) {
        MentalState mentalState22;
        List<MentalState> list;
        if (mentalState == null) {
            return false;
        }
        if (mentalState.getPredicate() == null) {
            return false;
        }
        if (mentalState.onHoldUntil == null) {
            return false;
        }
        IList<MentalState> iList = BdiUtils.getBase(iScope, DESIRE_BASE);
        List<MentalState> list2 = mentalState.getPredicate().onHoldUntil;
        if (mentalState.getPredicate().getValues() != null && list2 != null) {
            if (mentalState.getPredicate().getValues().containsKey((Object)"and")) {
                if (list2.size() == 0) {
                    this.removeIntention(iScope, mentalState, true);
                    return false;
                }
                return true;
            }
            if (mentalState.getPredicate().getValues().containsKey((Object)"or")) {
                if (list2.size() <= 1) {
                    if (iList.contains((Object)list2.get(0))) {
                        iList.remove((Object)list2.get(0));
                    }
                    this.removeIntention(iScope, mentalState, list2.size() == 1);
                    return false;
                }
                return true;
            }
        }
        if (!((list = mentalState.onHoldUntil) instanceof ArrayList)) {
            return false;
        }
        if (iList.isEmpty()) {
            return false;
        }
        for (MentalState mentalState22 : list) {
            if (!iList.contains((Object)mentalState22)) continue;
            return true;
        }
        this.addThoughts(iScope, "no more subintention for" + String.valueOf(mentalState));
        mentalState22 = this.getCurrentAgent(iScope);
        Object object = (BDIPlan)mentalState22.getAttribute(CURRENT_PLAN);
        object = null;
        mentalState22.setAttribute(CURRENT_PLAN, object);
        return false;
    }

    @GamlAnnotations.action(name="get_plans", doc={@GamlAnnotations.doc(value="get the list of plans.", returns="the list of BDI plans.", examples={@GamlAnnotations.example(value="get_plans()")})})
    public List<BDIPlan> getPlans(IScope iScope) {
        return this._plans;
    }

    @GamlAnnotations.action(name="get_plan", args={@GamlAnnotations.arg(name="plan_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="the name of the plan to get")})}, doc={@GamlAnnotations.doc(value="get the first plan with the given name", returns="a BDIPlan", examples={@GamlAnnotations.example(value="get_plan(name)")})})
    public BDIPlan getPlan(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists("plan_name", 4);
        for (BDIPlan bDIPlan : this._plans) {
            if (!bDIPlan.getPlanStatement().getName().equals(string)) continue;
            return bDIPlan;
        }
        return null;
    }

    @GamlAnnotations.action(name="is_current_plan", args={@GamlAnnotations.arg(name="plan_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="the name of the plan to test")})}, doc={@GamlAnnotations.doc(value="tell if the current plan has the same name as tested", returns="true if the current plan has the same name", examples={@GamlAnnotations.example(value="is_current_plan(name)")})})
    public Boolean isCurrentPlan(IScope iScope) {
        String string = (String)iScope.getTypedArgIfExists("plan_name", 4);
        for (BDIPlan bDIPlan : this._plans) {
            if (!bDIPlan.getPlanStatement().getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="get_current_plan", doc={@GamlAnnotations.doc(value="get the current plan.", returns="the current plans.", examples={@GamlAnnotations.example(value="get_current_plan()")})})
    public BDIPlan getCurrentPlans(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        BDIPlan bDIPlan = (BDIPlan)iAgent.getAttribute(CURRENT_PLAN);
        return bDIPlan;
    }

    @GamlAnnotations.action(name="add_belief", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as a belief")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add the predicate in the belief base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState = predicate != null ? new MentalState("Belief", predicate) : new MentalState("Belief");
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        if (d != null) {
            mentalState.setStrength(d);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addBelief(iScope, mentalState);
    }

    @GamlAnnotations.action(name="add_directly_belief", args={@GamlAnnotations.arg(name="belief", type=546708, optional=true, doc={@GamlAnnotations.doc(value="belief to add in th belief base")})}, doc={@GamlAnnotations.doc(value="add the belief in the belief base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDirectlyBelief(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists("belief", 546708);
        if (mentalState != null && "Belief".equals(mentalState.getModality())) {
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addBelief(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_belief_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as a belief")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add the predicate in the belief base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddBeliefMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        Integer n = (Integer)iScope.getTypedArgIfExists("lifetime", 1);
        MentalState mentalState2 = new MentalState("Belief", mentalState);
        if (d != null) {
            mentalState2.setStrength(d);
        }
        if (n != null) {
            mentalState2.setLifeTime(n);
        }
        mentalState2.setOwner(iScope.getAgent());
        return BdiUtils.addBelief(iScope, mentalState2);
    }

    @GamlAnnotations.action(name="add_belief_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add as a belief")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add the belief about an emotion in the belief base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddBeliefEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)(iScope.hasArg(EMOTION) ? iScope.getArg(EMOTION, 546706) : null);
        Double d = (Double)(iScope.hasArg("strength") ? iScope.getArg("strength", 2) : null);
        int n = (Integer)(iScope.hasArg("lifetime") ? iScope.getArg("lifetime", 1) : Integer.valueOf(-1));
        MentalState mentalState = emotion != null ? new MentalState("Belief", emotion) : new MentalState("Belief");
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        if (d != null) {
            mentalState.setStrength(d);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addBelief(iScope, mentalState);
    }

    @GamlAnnotations.action(name="has_belief", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Belief", predicate);
        if (predicate != null) {
            return BdiUtils.hasBelief(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_belief_with_name", args={@GamlAnnotations.arg(name="belief_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicate is in the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="has_belief_with_name(\"has_water\")")})})
    public Boolean hasBeliefName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists(PREDICATE_NAME, 4);
        if (string != null) {
            MentalState mentalState = new MentalState("Belief", new Predicate(string));
            return BdiUtils.hasBelief(iScope, mentalState);
        }
        return null;
    }

    @GamlAnnotations.action(name="has_belief_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="check if the mental state is in the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestBeliefMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Belief", mentalState);
        if (mentalState != null) {
            return BdiUtils.hasBelief(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="get_belief", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to get")})}, doc={@GamlAnnotations.doc(value="return the belief about the predicate in the belief base (if several, returns the first one).", returns="the belief about the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_belief(new_predicate(\"has_water\", true))")})})
    public MentalState getBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        if (predicate == null) {
            return null;
        }
        for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
            if (mentalState.getPredicate() == null) continue;
            if (predicate.equals(mentalState.getPredicate())) {
                return mentalState;
            }
            if (!predicate.equalsButNotTruth(mentalState.getPredicate())) continue;
            return mentalState;
        }
        return null;
    }

    @GamlAnnotations.action(name="get_belief_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to get")})}, doc={@GamlAnnotations.doc(value="return the belief about the mental state in the belief base (if several, returns the first one).", returns="the belief about the mental state if it is in the base.", examples={@GamlAnnotations.example(value="get_belief(new_mental_state(\"Desire\", predicate1))")})})
    public MentalState getBeliefMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        return BdiUtils.getBeliefMentalStateFromBase(iScope, mentalState);
    }

    @GamlAnnotations.action(name="get_belief_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=false, doc={@GamlAnnotations.doc(value="emotion about which the belief to get is")})}, doc={@GamlAnnotations.doc(value="return the belief about the emotion in the belief base (if several, returns the first one).", returns="the belief about the emotion if it is in the base.", examples={@GamlAnnotations.example(value="get_belief(new_mental_state(\"Desire\", predicate1))")})})
    public MentalState getBeliefEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        if (emotion != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
                if (mentalState.getMentalState() == null || !emotion.equals(mentalState.getEmotion())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_belief_with_name", args={@GamlAnnotations.arg(name="belief_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="get the predicate in the belief base (if several, returns the first one).", returns="the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_belief_with_name(\"has_water\")")})})
    public MentalState getBeliefName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArg("belief_name", 4);
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_beliefs_with_name", args={@GamlAnnotations.arg(name="belief_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicates to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates in the belief base with the given name.", returns="the list of beliefs (mental state).", examples={@GamlAnnotations.example(value="get_belief(\"has_water\")")})})
    public IList<MentalState> getBeliefsName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("belief_name", 4);
        IList iList = GamaListFactory.create();
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_beliefs", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates in the belief base", returns="the list of beliefs (mental state).", examples={@GamlAnnotations.example(value="get_beliefs(\"has_water\")")})})
    public IList<MentalState> getBeliefs(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        IList iList = GamaListFactory.create();
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, BELIEF_BASE)) {
                if (mentalState.getPredicate() == null) continue;
                if (predicate.equals(mentalState.getPredicate())) {
                    iList.add((Object)mentalState);
                }
                if (!predicate.equalsButNotTruth(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_beliefs_metal_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="get the list of bliefs in the belief base containing the mental state", returns="the list of beliefs (mental state).", examples={@GamlAnnotations.example(value="get_beliefs_mental_state(\"has_water\")")})})
    public IList<MentalState> getBeliefsMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        IList iList = GamaListFactory.create();
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, BELIEF_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                iList.add((Object)mentalState2);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="is_current_intention", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is the current intention (last entry of intention base).", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean iscurrentIntention(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        Predicate predicate2 = this.currentIntention(iScope) != null ? this.currentIntention(iScope).getPredicate() : null;
        if (predicate != null && predicate2 != null) {
            return predicate.equals(predicate2);
        }
        return false;
    }

    @GamlAnnotations.action(name="is_current_intention_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="check if the mental state is the current intention (last entry of intention base).", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean iscurrentIntentionMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = this.currentIntention(iScope).getMentalState();
        if (mentalState != null && mentalState2 != null) {
            return mentalState.equals(mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="get_current_intention", doc={@GamlAnnotations.doc(value="returns the current intention (last entry of intention base).", returns="the current intention", examples={@GamlAnnotations.example(value="")})})
    public MentalState currentIntention(IScope iScope) throws GamaRuntimeException {
        IList<MentalState> iList = BdiUtils.getBase(iScope, INTENTION_BASE);
        if (iList == null) {
            return null;
        }
        if (!iList.isEmpty()) {
            return (MentalState)iList.lastValue(iScope);
        }
        return null;
    }

    @GamlAnnotations.action(name="has_desire", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestDesire(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        if (predicate != null) {
            MentalState mentalState = new MentalState("Desire", predicate);
            return BdiUtils.getBase(iScope, DESIRE_BASE).contains((Object)mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_desire_with_name", args={@GamlAnnotations.arg(name="desire_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the prediate is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="has_desire_with_name(\"has_water\")")})})
    public Boolean hasDesireName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("desire_name", 4);
        if (string != null) {
            MentalState mentalState = new MentalState("Desire", new Predicate(string));
            return BdiUtils.hasDesire(iScope, mentalState);
        }
        return null;
    }

    @GamlAnnotations.action(name="has_desire_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="check if the mental state is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestDesireMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            MentalState mentalState2 = new MentalState("Desire", mentalState);
            return BdiUtils.getBase(iScope, DESIRE_BASE).contains((Object)mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="current_intention_on_hold", args={@GamlAnnotations.arg(name="until", type=0, optional=true, doc={@GamlAnnotations.doc(value="the current intention is put on hold (fited plan are not considered) until specific condition is reached. Can be an expression (which will be tested), a list (of subintentions), or nil (by default the condition will be the current list of subintentions of the intention)")})}, doc={@GamlAnnotations.doc(value="puts the current intention on hold until the specified condition is reached or all subintentions are reached (not in desire base anymore).", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primOnHoldIntention(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = null;
        if (this.currentIntention(iScope) != null) {
            mentalState = this.currentIntention(iScope);
        }
        if (mentalState != null) {
            Predicate predicate = (Predicate)iScope.getTypedArgIfExists("until", 546704);
            if (predicate == null) {
                List<MentalState> list = mentalState.subintentions;
                if (list != null && !list.isEmpty()) {
                    mentalState.onHoldUntil = list;
                }
            } else {
                if (mentalState.onHoldUntil == null) {
                    mentalState.onHoldUntil = GamaListFactory.create((IType)Types.get((int)546708));
                }
                if (mentalState.getSubintentions() == null) {
                    mentalState.subintentions = GamaListFactory.create((IType)Types.get((int)546708));
                }
                MentalState mentalState2 = new MentalState("Intention", mentalState.getPredicate());
                MentalState mentalState3 = new MentalState("Desire", predicate);
                mentalState3.setSuperIntention(mentalState2);
                mentalState.onHoldUntil.add(mentalState3);
                mentalState.getSubintentions().add(mentalState3);
                BdiUtils.addToBase(iScope, mentalState3, DESIRE_BASE);
            }
        }
        return true;
    }

    @GamlAnnotations.action(name="add_subintention", args={@GamlAnnotations.arg(name="predicate", type=546708, optional=false, doc={@GamlAnnotations.doc(value="the intention that receives the sub_intention")}), @GamlAnnotations.arg(name="subintention", type=546704, optional=false, doc={@GamlAnnotations.doc(value="the predicate to add as a subintention to the intention")}), @GamlAnnotations.arg(name="add_as_desire", type=3, optional=true, doc={@GamlAnnotations.doc(value="add the subintention as a desire as well (by default, false) ")})}, doc={@GamlAnnotations.doc(value="adds the predicates in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean addSubIntention(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState4;
        MentalState mentalState2 = (MentalState)iScope.getTypedArgIfExists(PREDICATE, 546708);
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE_SUBINTENTION, 546704);
        if (mentalState2 == null || predicate == null) {
            return false;
        }
        boolean bl = (Boolean)iScope.getTypedArgIfExists("add_as_desire", 3, (Object)false);
        MentalState mentalState3 = null;
        for (MentalState mentalState4 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            if (mentalState4 == null || !mentalState2.equals(mentalState4)) continue;
            mentalState3 = mentalState4;
            break;
        }
        if (mentalState3 == null) {
            return false;
        }
        if (mentalState2.getSubintentions() == null) {
            mentalState2.subintentions = GamaListFactory.create((IType)Types.get((int)546708));
        }
        mentalState4 = new MentalState("Desire", predicate);
        predicate.setSuperIntention(mentalState3);
        mentalState2.getSubintentions().add(mentalState4);
        mentalState4.strength = mentalState3.strength;
        if (bl) {
            BdiUtils.addToBase(iScope, mentalState4, DESIRE_BASE);
        }
        return true;
    }

    @GamlAnnotations.action(name="add_desire", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as a desire")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")}), @GamlAnnotations.arg(name="todo", type=546704, optional=true, doc={@GamlAnnotations.doc(value="add the desire as a subintention of this parameter")})}, doc={@GamlAnnotations.doc(value="adds the predicates is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDesire(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        if (predicate != null) {
            Predicate predicate2 = (Predicate)iScope.getTypedArgIfExists(PREDICATE_TODO, 546704);
            MentalState mentalState = new MentalState("Desire", predicate);
            MentalState mentalState2 = new MentalState("Intention", predicate2);
            if (d != null) {
                mentalState.setStrength(d);
            }
            if (n > 0) {
                mentalState.setLifeTime(n);
            }
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addDesire(iScope, mentalState2, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_directly_desire", args={@GamlAnnotations.arg(name="desire", type=546708, optional=true, doc={@GamlAnnotations.doc(value="desire to add in th belief base")})}, doc={@GamlAnnotations.doc(value="add the desire in the desire base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDirectlyDesire(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists("desire", 546708);
        if (mentalState != null && "Desire".equals(mentalState.getModality())) {
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addDesire(iScope, null, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_desire_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental_state to add as a desire")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the desire")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the desire")}), @GamlAnnotations.arg(name="todo", type=546704, optional=true, doc={@GamlAnnotations.doc(value="add the desire as a subintention of this parameter")})}, doc={@GamlAnnotations.doc(value="adds the mental state is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDesireMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        if (mentalState != null) {
            Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE_TODO, 546704);
            MentalState mentalState2 = new MentalState("Desire", mentalState);
            MentalState mentalState3 = new MentalState("Intention", predicate);
            if (d != null) {
                mentalState2.setStrength(d);
            }
            if (n > 0) {
                mentalState2.setLifeTime(n);
            }
            mentalState2.setOwner(iScope.getAgent());
            return BdiUtils.addDesire(iScope, mentalState3, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_desire_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add as a desire")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the desire")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the desire")}), @GamlAnnotations.arg(name="todo", type=546704, optional=true, doc={@GamlAnnotations.doc(value="add the desire as a subintention of this parameter")})}, doc={@GamlAnnotations.doc(value="adds the emotion in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDesireEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        if (emotion != null) {
            Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE_TODO, 546704);
            MentalState mentalState = new MentalState("Desire", emotion);
            MentalState mentalState2 = new MentalState("Intention", predicate);
            if (d != null) {
                mentalState.setStrength(d);
            }
            if (n > 0) {
                mentalState.setLifeTime(n);
            }
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addDesire(iScope, mentalState2, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="get_desire", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="get the predicates is in the desire base (if several, returns the first one).", returns="the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_desire(new_predicate(\"has_water\", true))")})})
    public MentalState getDesire(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_desire_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="get the mental state is in the desire base (if several, returns the first one).", returns="the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_desire(new_predicate(\"has_water\", true))")})})
    public MentalState getDesireMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                return mentalState2;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_desires", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="name of the predicates to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates is in the desire base", returns="the list of deires.", examples={@GamlAnnotations.example(value="get_desires(\"has_water\")")})})
    public IList<MentalState> getDesires(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        IList iList = GamaListFactory.create();
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_desires_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="name of the mental states to check")})}, doc={@GamlAnnotations.doc(value="get the list of mental states is in the desire base", returns="the list of mental states.", examples={@GamlAnnotations.example(value="get_desires_mental_state(\"Belief\",predicte1)")})})
    public IList<MentalState> getDesiresMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        IList iList = GamaListFactory.create();
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                iList.add((Object)mentalState2);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_desire_with_name", args={@GamlAnnotations.arg(name="desire_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="get the predicates is in the belief base (if several, returns the first one).", returns="the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_desire_with_name(\"has_water\")")})})
    public MentalState getDesireName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("desire_name", 4);
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_desires_with_name", args={@GamlAnnotations.arg(name="desire_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicates to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates is in the belief base with the given name.", returns="the list of predicates.", examples={@GamlAnnotations.example(value="get_belief(\"has_water\")")})})
    public List<MentalState> getDesiresName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("desire_name", 4);
        IList iList = GamaListFactory.create();
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, DESIRE_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add(mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="remove_belief", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove")})}, doc={@GamlAnnotations.doc(value="removes the predicate from the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            MentalState mentalState = new MentalState("Belief", predicate);
            return BdiUtils.removeBelief(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_belief_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to remove")})}, doc={@GamlAnnotations.doc(value="removes the mental state from the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveBeliefMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            MentalState mentalState2 = new MentalState("Belief", mentalState);
            return BdiUtils.removeBelief(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="replace_belief", args={@GamlAnnotations.arg(name="old_predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to remove")}), @GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to add")})}, doc={@GamlAnnotations.doc(value="replace the old predicate by the new one.", returns="true if the old predicate is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primPlaceBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)iScope.getTypedArgIfExists("old_predicate", 546704);
        boolean bl = true;
        bl = predicate != null ? BdiUtils.getBase(iScope, BELIEF_BASE).remove((Object)new MentalState("Belief", predicate)) : false;
        Predicate predicate2 = (Predicate)iScope.getTypedArgIfExists(PREDICATE, 546704);
        if (predicate2 == null) {
            return bl;
        }
        MentalState mentalState = new MentalState("Belief", predicate2);
        if (BdiUtils.getBase(iScope, INTENTION_BASE).contains((Object)new MentalState("Intention", predicate2))) {
            BdiUtils.removeFromBase(iScope, mentalState, DESIRE_BASE);
            BdiUtils.removeFromBase(iScope, mentalState, INTENTION_BASE);
        }
        if (BdiUtils.getBase(iScope, DESIRE_BASE).contains((Object)new MentalState("Desire", predicate2))) {
            BdiUtils.removeFromBase(iScope, mentalState, DESIRE_BASE);
        }
        for (MentalState mentalState2 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            List<MentalState> list;
            if (mentalState2.getPredicate() == null) continue;
            List<MentalState> list2 = mentalState2.getPredicate().getSubintentions();
            if (list2 != null && list2.contains(mentalState)) {
                list2.remove(mentalState);
            }
            if ((list = mentalState2.getPredicate().getOnHoldUntil()) == null || !list.contains(mentalState)) continue;
            list.remove(mentalState);
        }
        return BdiUtils.addToBase(iScope, mentalState, BELIEF_BASE);
    }

    @GamlAnnotations.action(name="remove_desire", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove from desire base")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveDesire(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            MentalState mentalState = new MentalState("Desire", predicate);
            return BdiUtils.removeDesire(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_desire_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to remove from desire base")})}, doc={@GamlAnnotations.doc(value="removes the mental state from the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveDesireMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            MentalState mentalState2 = new MentalState("Desire", mentalState);
            return BdiUtils.removeDesire(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_intention", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIntention(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        Double d = (Double)(iScope.hasArg("strength") ? iScope.getArg("strength", 2) : null);
        int n = (Integer)(iScope.hasArg("lifetime") ? iScope.getArg("lifetime", 1) : Integer.valueOf(-1));
        MentalState mentalState = predicate != null ? new MentalState("Intention", predicate) : new MentalState("Intention");
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState, INTENTION_BASE);
    }

    @GamlAnnotations.action(name="add_intention_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as an intention")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIntentionMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState2 = mentalState != null ? new MentalState("Intention", mentalState) : new MentalState("Intention");
        if (d != null) {
            mentalState2.setStrength(d);
        }
        if (n > 0) {
            mentalState2.setLifeTime(n);
        }
        mentalState2.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState2, INTENTION_BASE);
    }

    @GamlAnnotations.action(name="add_intention_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add as an intention")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the desire base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIntentionEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState = emotion != null ? new MentalState("Intention", emotion) : new MentalState("Intention");
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addToBase(iScope, mentalState, INTENTION_BASE);
    }

    @GamlAnnotations.action(name="get_intention", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="get the predicates in the intention base (if several, returns the first one).", returns="the mental state if it is in the base.", examples={@GamlAnnotations.example(value="get_intention(new_predicate(\"has_water\", true))")})})
    public MentalState getIntention(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_intention_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="get the mental state is in the intention base (if several, returns the first one).", returns="the mental state if it is in the base.", examples={@GamlAnnotations.example(value="get_belief(new_predicate(\"has_water\", true))")})})
    public MentalState getIntentionMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                return mentalState2;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_intentions", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="name of the predicates to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates is in the intention base", returns="the list of intentions.", examples={@GamlAnnotations.example(value="get_intentions(\"has_water\")")})})
    public IList<MentalState> getIntentions(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        IList iList = GamaListFactory.create();
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_intentions_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="get the list of mental state is in the intention base", returns="the list of intentions.", examples={@GamlAnnotations.example(value="get_intentions_mental_state(\"Desire\",predicate1)")})})
    public IList<MentalState> getIntentionsMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        IList iList = GamaListFactory.create();
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                iList.add((Object)mentalState2);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="get_intention_with_name", args={@GamlAnnotations.arg(name="intention_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="get the predicates is in the belief base (if several, returns the first one).", returns="the predicate if it is in the base.", examples={@GamlAnnotations.example(value="get_intention_with_name(\"has_water\")")})})
    public MentalState getIntentionName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("intention_name", 4);
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_intentions_with_name", args={@GamlAnnotations.arg(name="intention_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicates to check")})}, doc={@GamlAnnotations.doc(value="get the list of predicates is in the belief base with the given name.", returns="the list of predicates.", examples={@GamlAnnotations.example(value="get_belief(\"has_water\")")})})
    public List<MentalState> getIntentionsName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("intention_name", 4);
        IList iList = GamaListFactory.create();
        if (string != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, INTENTION_BASE)) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add(mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.action(name="remove_intention", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="intention's predicate to remove")}), @GamlAnnotations.arg(name="desire_also", type=3, optional=true, doc={@GamlAnnotations.doc(value="removes also desire")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the intention base.", returns="true if it is removed from the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveIntention(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Intention", predicate);
        if (predicate == null) {
            return false;
        }
        Boolean bl = iScope.getBoolArgIfExists(REMOVE_DESIRE_AND_INTENTION, false);
        if (bl.booleanValue()) {
            BdiUtils.getBase(iScope, DESIRE_BASE).remove((Object)mentalState);
            BdiUtils.getBase(iScope, OBLIGATION_BASE).remove((Object)mentalState);
        }
        if (this.currentIntention(iScope) != null && predicate.equals(this.currentIntention(iScope).getPredicate())) {
            iScope.getAgent().setAttribute(CURRENT_PLAN, null);
            iScope.getAgent().setAttribute(CURRENT_NORM, null);
        }
        for (MentalState mentalState2 : BdiUtils.getBase(iScope, INTENTION_BASE)) {
            List<MentalState> list;
            if (mentalState2.getPredicate() == null) continue;
            List<MentalState> list2 = mentalState2.getPredicate().getSubintentions();
            if (list2 != null && list2.contains(mentalState)) {
                list2.remove(mentalState);
            }
            if ((list = mentalState2.getPredicate().getOnHoldUntil()) == null || !list.contains(mentalState)) continue;
            list.remove(mentalState);
        }
        BdiUtils.getBase(iScope, INTENTION_BASE).remove((Object)mentalState);
        return true;
    }

    @GamlAnnotations.action(name="remove_intention_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="intention's mental state to remove")}), @GamlAnnotations.arg(name="desire_also", type=3, optional=false, doc={@GamlAnnotations.doc(value="removes also desire")})}, doc={@GamlAnnotations.doc(value="removes the mental state from the intention base.", returns="true if it is removed from the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveIntentionMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Intention", mentalState);
        if (mentalState != null) {
            Boolean bl = iScope.hasArg(REMOVE_DESIRE_AND_INTENTION) ? iScope.getBoolArg(REMOVE_DESIRE_AND_INTENTION) : false;
            BdiUtils.getBase(iScope, INTENTION_BASE).remove((Object)mentalState2);
            if (bl.booleanValue()) {
                BdiUtils.getBase(iScope, DESIRE_BASE).remove((Object)mentalState2);
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_beliefs", doc={@GamlAnnotations.doc(value="clear the belief base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearBelief(IScope iScope) {
        BdiUtils.getBase(iScope, BELIEF_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="clear_desires", doc={@GamlAnnotations.doc(value="clear the desire base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearDesire(IScope iScope) {
        BdiUtils.getBase(iScope, DESIRE_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="clear_intentions", doc={@GamlAnnotations.doc(value="clear the intention base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearIntention(IScope iScope) {
        BdiUtils.getBase(iScope, INTENTION_BASE).clear();
        iScope.getAgent().setAttribute(CURRENT_PLAN, null);
        return true;
    }

    @GamlAnnotations.action(name="remove_all_beliefs", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveAllBelief(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            MentalState mentalState = new MentalState("Belief", predicate);
            BdiUtils.getBase(iScope, BELIEF_BASE).removeAllOccurrencesOfValue(iScope, (Object)mentalState);
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_emotions", doc={@GamlAnnotations.doc(value="clear the emotion base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearEmotion(IScope iScope) {
        BdiUtils.getEmotionBase(iScope, EMOTION_BASE).clear();
        return true;
    }

    protected void updateEmotionsIntensity(IScope iScope) {
        for (Emotion emotion : BdiUtils.getEmotionBase(iScope, EMOTION_BASE)) {
            emotion.decayIntensity();
        }
        for (Emotion emotion : this.listEmotionsNull(iScope)) {
            BdiUtils.removeFromBase(iScope, emotion, EMOTION_BASE);
        }
    }

    protected void computeEmotions(IScope iScope) {
        Boolean bl;
        IAgent iAgent = this.getCurrentAgent(iScope);
        Boolean bl2 = bl = iScope.hasArg(USE_EMOTIONS_ARCHITECTURE) ? iScope.getBoolArg(USE_EMOTIONS_ARCHITECTURE) : (Boolean)iAgent.getAttribute(USE_EMOTIONS_ARCHITECTURE);
        if (bl.booleanValue()) {
            BdiUtils.createEmotionsRelatedToOthers(iScope);
        }
    }

    private List<Emotion> listEmotionsNull(IScope iScope) {
        ArrayList<Emotion> arrayList = new ArrayList<Emotion>();
        for (Emotion emotion : BdiUtils.getEmotionBase(iScope, EMOTION_BASE)) {
            if (!(emotion.getIntensity() <= 0.0) || emotion.getIntensity() == -1.0) continue;
            arrayList.add(emotion);
        }
        return arrayList;
    }

    @GamlAnnotations.action(name="add_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add to the base")})}, doc={@GamlAnnotations.doc(value="add the emotion to the emotion base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        return BdiUtils.addEmotion(iScope, emotion);
    }

    @GamlAnnotations.action(name="has_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to check")})}, doc={@GamlAnnotations.doc(value="check if the emotion is in the belief base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)(iScope.hasArg(EMOTION) ? iScope.getArg(EMOTION, 546706) : null);
        if (emotion != null) {
            return BdiUtils.hasEmotion(iScope, emotion);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_emotion_with_name", args={@GamlAnnotations.arg(name="emotion_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the emotion to check")})}, doc={@GamlAnnotations.doc(value="check if the emotion is in the emotion base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="has_belief_with_name(\"has_water\")")})})
    public Boolean hasEmotionName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("emotion_name", 4);
        if (string != null) {
            Emotion emotion = new Emotion(string);
            return BdiUtils.hasEmotion(iScope, emotion);
        }
        return null;
    }

    @GamlAnnotations.action(name="get_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=false, doc={@GamlAnnotations.doc(value="emotion to get")})}, doc={@GamlAnnotations.doc(value="get the emotion in the emotion base (if several, returns the first one).", returns="the emotion if it is in the base.", examples={@GamlAnnotations.example(value="get_belief(new_predicate(\"has_water\", true))")})})
    public Emotion getEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)(iScope.hasArg(EMOTION) ? iScope.getArg(EMOTION, 546706) : null);
        if (emotion != null) {
            for (Emotion emotion2 : BdiUtils.getEmotionBase(iScope, EMOTION_BASE)) {
                if (!emotion.equals(emotion2)) continue;
                return emotion2;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_emotion_with_name", args={@GamlAnnotations.arg(name="emotion_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the emotion to check")})}, doc={@GamlAnnotations.doc(value="get the emotion is in the emotion base (if several, returns the first one).", returns="the emotion if it is in the base.", examples={@GamlAnnotations.example(value="get_emotion_with_name(\"fear\")")})})
    public Emotion getEmotionName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("emotion_name", 4);
        if (string != null) {
            for (Emotion emotion : BdiUtils.getEmotionBase(iScope, EMOTION_BASE)) {
                if (!string.equals(emotion.getName())) continue;
                return emotion;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="remove_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to remove")})}, doc={@GamlAnnotations.doc(value="removes the emotion from the emotion base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)(iScope.hasArg(EMOTION) ? iScope.getArg(EMOTION, 546706) : null);
        if (emotion != null) {
            return BdiUtils.removeEmotion(iScope, emotion);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_uncertainty", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to add")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add a predicate in the uncertainty base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddUncertainty(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        Double d = (Double)(iScope.hasArg("strength") ? iScope.getArg("strength", 2) : null);
        int n = (Integer)(iScope.hasArg("lifetime") ? iScope.getArg("lifetime", 1) : Integer.valueOf(-1));
        MentalState mentalState = predicate != null ? new MentalState("Uncertainty", predicate) : new MentalState("Uncertainty");
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addUncertainty(iScope, mentalState);
    }

    @GamlAnnotations.action(name="add_directly_uncertainty", args={@GamlAnnotations.arg(name="uncertainty", type=546708, optional=true, doc={@GamlAnnotations.doc(value="uncertainty to add in the uncertainty base")})}, doc={@GamlAnnotations.doc(value="add the uncertainty in the uncertainty base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDirectlyUncertainty(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists("uncertainty", 546708);
        if (mentalState != null && "Uncertainty".equals(mentalState.getModality())) {
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addUncertainty(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_uncertainty_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to add as an uncertainty")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add a predicate in the uncertainty base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddUncertaintyMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState2 = mentalState != null ? new MentalState("Uncertainty", mentalState) : new MentalState("Uncertainty");
        if (d != null) {
            mentalState2.setStrength(d);
        }
        if (n > 0) {
            mentalState2.setLifeTime(n);
        }
        mentalState2.setOwner(iScope.getAgent());
        return BdiUtils.addUncertainty(iScope, mentalState2);
    }

    @GamlAnnotations.action(name="add_uncertainty_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add as an uncertainty")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the stregth of the belief")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the belief")})}, doc={@GamlAnnotations.doc(value="add a predicate in the uncertainty base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddUncertaintyEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        Double d = (Double)iScope.getTypedArgIfExists("strength", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState = emotion != null ? new MentalState("Uncertainty", emotion) : new MentalState("Uncertainty");
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addUncertainty(iScope, mentalState);
    }

    @GamlAnnotations.action(name="get_uncertainty", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to return")})}, doc={@GamlAnnotations.doc(value="get the predicates is in the uncertainty base (if several, returns the first one).", returns="the uncertainty (mental state) if it is in the base.", examples={@GamlAnnotations.example(value="get_uncertainty(new_predicate(\"has_water\", true))")})})
    public MentalState getUncertainty(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, UNCERTAINTY_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_uncertainty_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to return")})}, doc={@GamlAnnotations.doc(value="get the mental state is in the uncertainty base (if several, returns the first one).", returns="the mental state if it is in the base.", examples={@GamlAnnotations.example(value="get_uncertainty(new_predicate(\"has_water\", true))")})})
    public MentalState getUncertaintyMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, UNCERTAINTY_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                return mentalState2;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="has_uncertainty", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the uncertainty base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestUncertainty(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Uncertainty", predicate);
        if (predicate != null) {
            return BdiUtils.hasUncertainty(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_uncertainty_with_name", args={@GamlAnnotations.arg(name="uncertainty_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the uncertainty to check")})}, doc={@GamlAnnotations.doc(value="check if the predicate is in the uncertainty base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="has_uncertainty_with_name(\"has_water\")")})})
    public Boolean hasUncertaintyName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("uncertainty_name", 4);
        if (string != null) {
            MentalState mentalState = new MentalState("Uncertainty", new Predicate(string));
            return BdiUtils.hasUncertainty(iScope, mentalState);
        }
        return null;
    }

    @GamlAnnotations.action(name="has_uncertainty_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="check if the mental state is in the uncertainty base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestUncertaintyMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Uncertainty", mentalState);
        if (mentalState != null) {
            return BdiUtils.hasUncertainty(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_uncertainty", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the uncertainty base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveUncertainty(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Uncertainty", predicate);
        if (predicate != null) {
            return BdiUtils.removeUncertainty(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_uncertainty_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to remove")})}, doc={@GamlAnnotations.doc(value="removes the mental state from the uncertainty base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveUncertaintyMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Uncertainty", mentalState);
        if (mentalState != null) {
            return BdiUtils.removeUncertainty(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_uncertainties", doc={@GamlAnnotations.doc(value="clear the uncertainty base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearUncertainty(IScope iScope) {
        BdiUtils.getBase(iScope, UNCERTAINTY_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="add_ideal", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as an ideal")}), @GamlAnnotations.arg(name="praiseworthiness", type=2, optional=true, doc={@GamlAnnotations.doc(value="the praiseworthiness value of the ideal")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the ideal")})}, doc={@GamlAnnotations.doc(value="add a predicate in the ideal base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIdeal(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        Double d = (Double)(iScope.hasArg("praiseworthiness") ? iScope.getArg("praiseworthiness", 2) : null);
        int n = (Integer)(iScope.hasArg("lifetime") ? iScope.getArg("lifetime", 1) : Integer.valueOf(-1));
        MentalState mentalState = predicate != null ? new MentalState("Ideal", predicate) : new MentalState();
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addIdeal(iScope, mentalState);
    }

    @GamlAnnotations.action(name="add_directly_ideal", args={@GamlAnnotations.arg(name="ideal", type=546708, optional=true, doc={@GamlAnnotations.doc(value="ideal to add in the ideal base")})}, doc={@GamlAnnotations.doc(value="add the ideal in the ideal base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddDirectlyIdeal(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists("ideal", 546708);
        if (mentalState != null && "Ideal".equals(mentalState.getModality())) {
            mentalState.setOwner(iScope.getAgent());
            return BdiUtils.addIdeal(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="add_ideal_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to add as an ideal")}), @GamlAnnotations.arg(name="praiseworthiness", type=2, optional=true, doc={@GamlAnnotations.doc(value="the praiseworthiness value of the ideal")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the ideal")})}, doc={@GamlAnnotations.doc(value="add a predicate in the ideal base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIdealMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        Double d = (Double)iScope.getTypedArgIfExists("praiseworthiness", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState2 = mentalState != null ? new MentalState("Ideal", mentalState) : new MentalState();
        if (d != null) {
            mentalState2.setStrength(d);
        }
        if (n > 0) {
            mentalState2.setLifeTime(n);
        }
        mentalState2.setOwner(iScope.getAgent());
        return BdiUtils.addIdeal(iScope, mentalState2);
    }

    @GamlAnnotations.action(name="add_ideal_emotion", args={@GamlAnnotations.arg(name="emotion", type=546706, optional=true, doc={@GamlAnnotations.doc(value="emotion to add as an ideal")}), @GamlAnnotations.arg(name="praiseworthiness", type=2, optional=true, doc={@GamlAnnotations.doc(value="the praiseworthiness value of the ideal")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the ideal")})}, doc={@GamlAnnotations.doc(value="add a predicate in the ideal base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddIdealEmotion(IScope iScope) throws GamaRuntimeException {
        Emotion emotion = (Emotion)iScope.getTypedArgIfExists(EMOTION, 546706);
        Double d = (Double)iScope.getTypedArgIfExists("praiseworthiness", 2);
        int n = (Integer)iScope.getTypedArgIfExists("lifetime", 1, (Object)-1);
        MentalState mentalState = emotion != null ? new MentalState("Ideal", emotion) : new MentalState();
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addIdeal(iScope, mentalState);
    }

    @GamlAnnotations.action(name="get_ideal", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to check ad an ideal")})}, doc={@GamlAnnotations.doc(value="get the ideal about the predicate in the ideal base (if several, returns the first one).", returns="the ideal if it is in the base.", examples={@GamlAnnotations.example(value="get_ideal(new_predicate(\"has_water\", true))")})})
    public MentalState getIdeal(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, IDEAL_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="get_ideal_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=false, doc={@GamlAnnotations.doc(value="mental state to return")})}, doc={@GamlAnnotations.doc(value="get the mental state in the ideal base (if several, returns the first one).", returns="the ideal (mental state) if it is in the base.", examples={@GamlAnnotations.example(value="get_ideal(new_predicate(\"has_water\", true))")})})
    public MentalState getIdealMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        if (mentalState != null) {
            for (MentalState mentalState2 : BdiUtils.getBase(iScope, IDEAL_BASE)) {
                if (mentalState2.getMentalState() == null || !mentalState.equals(mentalState2.getMentalState())) continue;
                return mentalState2;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="has_ideal", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the ideal base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestIdeal(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Ideal", predicate);
        if (predicate != null) {
            return BdiUtils.hasIdeal(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_ideal_with_name", args={@GamlAnnotations.arg(name="ideal_name", type=4, optional=false, doc={@GamlAnnotations.doc(value="name of the predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicate is in the ideal base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="has_belief_with_name(\"has_water\")")})})
    public Boolean hasIdealName(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getTypedArgIfExists("ideal_name", 4);
        if (string != null) {
            MentalState mentalState = new MentalState("Ideal", new Predicate(string));
            return BdiUtils.hasIdeal(iScope, mentalState);
        }
        return null;
    }

    @GamlAnnotations.action(name="has_ideal_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="mental state to check")})}, doc={@GamlAnnotations.doc(value="check if the mental state is in the ideal base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestIdealMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Ideal", mentalState);
        if (mentalState != null) {
            return BdiUtils.hasIdeal(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_ideal", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the ideal base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveIdeal(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Ideal", predicate);
        if (predicate != null) {
            return BdiUtils.removeIdeal(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_ideal_mental_state", args={@GamlAnnotations.arg(name="mental_state", type=546708, optional=true, doc={@GamlAnnotations.doc(value="metal state to remove")})}, doc={@GamlAnnotations.doc(value="removes the mental state from the ideal base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveIdealMentalState(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = (MentalState)iScope.getTypedArgIfExists(MENTAL_STATE, 546708);
        MentalState mentalState2 = new MentalState("Ideal", mentalState);
        if (mentalState != null) {
            return BdiUtils.removeIdeal(iScope, mentalState2);
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_ideals", doc={@GamlAnnotations.doc(value="clear the ideal base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearIdeal(IScope iScope) {
        BdiUtils.getBase(iScope, IDEAL_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="add_obligation", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to add as an obligation")}), @GamlAnnotations.arg(name="strength", type=2, optional=true, doc={@GamlAnnotations.doc(value="the strength value of the obligation")}), @GamlAnnotations.arg(name="lifetime", type=1, optional=true, doc={@GamlAnnotations.doc(value="the lifetime of the obligation")})}, doc={@GamlAnnotations.doc(value="add a predicate in the ideal base.", returns="true it works.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddObligation(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        Double d = (Double)(iScope.hasArg("strength") ? iScope.getArg("strength", 2) : null);
        int n = (Integer)(iScope.hasArg("lifetime") ? iScope.getArg("lifetime", 1) : Integer.valueOf(-1));
        MentalState mentalState = predicate != null ? new MentalState("Obligation", predicate) : new MentalState();
        if (d != null) {
            mentalState.setStrength(d);
        }
        if (n > 0) {
            mentalState.setLifeTime(n);
        }
        mentalState.setOwner(iScope.getAgent());
        return BdiUtils.addObligation(iScope, mentalState);
    }

    @GamlAnnotations.action(name="get_obligation", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=false, doc={@GamlAnnotations.doc(value="predicate to return")})}, doc={@GamlAnnotations.doc(value="get the predicates in the obligation base (if several, returns the first one).", returns="the obligation (mental state) if it is in the base.", examples={@GamlAnnotations.example(value="get_obligation(new_predicate(\"has_water\", true))")})})
    public MentalState getObligation(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        if (predicate != null) {
            for (MentalState mentalState : BdiUtils.getBase(iScope, OBLIGATION_BASE)) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="has_obligation", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to check")})}, doc={@GamlAnnotations.doc(value="check if the predicates is in the obligation base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestObligation(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Obligation", predicate);
        if (predicate != null) {
            return BdiUtils.hasObligation(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_obligation", args={@GamlAnnotations.arg(name="predicate", type=546704, optional=true, doc={@GamlAnnotations.doc(value="predicate to remove")})}, doc={@GamlAnnotations.doc(value="removes the predicates from the obligation base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveObligation(IScope iScope) throws GamaRuntimeException {
        Predicate predicate = (Predicate)(iScope.hasArg(PREDICATE) ? iScope.getArg(PREDICATE, 546704) : null);
        MentalState mentalState = new MentalState("Obligation", predicate);
        if (predicate != null) {
            return BdiUtils.removeObligation(iScope, mentalState);
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_obligations", doc={@GamlAnnotations.doc(value="clear the obligation base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearObligation(IScope iScope) {
        BdiUtils.getBase(iScope, OBLIGATION_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="add_social_link", args={@GamlAnnotations.arg(name="social_link", type=546707, optional=true, doc={@GamlAnnotations.doc(value="social link to add to the base")})}, doc={@GamlAnnotations.doc(value="add the social link to the social link base.", returns="true if it is added in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primAddSocialLink(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink = (SocialLink)iScope.getTypedArgIfExists(SOCIALLINK, 546707);
        return BdiUtils.addSocialLink(iScope, socialLink);
    }

    @GamlAnnotations.action(name="get_social_link", args={@GamlAnnotations.arg(name="social_link", type=546707, optional=false, doc={@GamlAnnotations.doc(value="social link to check")})}, doc={@GamlAnnotations.doc(value="get the social link (if several, returns the first one).", returns="the social link if it is in the base.", examples={@GamlAnnotations.example(value="get_social_link(new_social_link(agentA))")})})
    public SocialLink getSocialLink(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink = (SocialLink)(iScope.hasArg(SOCIALLINK) ? iScope.getArg(SOCIALLINK, 546707) : null);
        if (socialLink != null) {
            return BdiUtils.getSocialLink(iScope, socialLink);
        }
        return null;
    }

    @GamlAnnotations.action(name="get_social_link_with_agent", args={@GamlAnnotations.arg(name="agent", type=11, optional=false, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")})}, doc={@GamlAnnotations.doc(value="get the social link with the agent concerned (if several, returns the first one).", returns="the social link if it is in the base.", examples={@GamlAnnotations.example(value="get_social_link_with_agent(agentA)")})})
    public SocialLink getSocialLinkWithAgent(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        if (iAgent != null) {
            return BdiUtils.getSocialLink(iScope, new SocialLink(iAgent));
        }
        return null;
    }

    @GamlAnnotations.action(name="has_social_link", args={@GamlAnnotations.arg(name="social_link", type=546707, optional=true, doc={@GamlAnnotations.doc(value="social link to check")})}, doc={@GamlAnnotations.doc(value="check if the social link base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestSocialWithAgent(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink = (SocialLink)(iScope.hasArg(SOCIALLINK) ? iScope.getArg(SOCIALLINK, 546707) : null);
        if (socialLink != null) {
            return BdiUtils.hasSocialLink(iScope, socialLink);
        }
        return false;
    }

    @GamlAnnotations.action(name="has_social_link_with_agent", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I want to check if I have a social link")})}, doc={@GamlAnnotations.doc(value="check if the social link base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primTestSocial(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        if (iAgent != null) {
            return BdiUtils.hasSocialLink(iScope, new SocialLink(iAgent));
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_social_link", args={@GamlAnnotations.arg(name="social_link", type=546707, optional=true, doc={@GamlAnnotations.doc(value="social link to remove")})}, doc={@GamlAnnotations.doc(value="removes the social link from the social relation base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveSocialLinkWithAgent(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink = (SocialLink)(iScope.hasArg(SOCIALLINK) ? iScope.getArg(SOCIALLINK, 546707) : null);
        if (socialLink != null) {
            return BdiUtils.removeSocialLink(iScope, socialLink);
        }
        return false;
    }

    @GamlAnnotations.action(name="remove_social_link_with_agent", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get the social link to remove")})}, doc={@GamlAnnotations.doc(value="removes the social link from the social relation base.", returns="true if it is in the base.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primRemoveSocialLink(IScope iScope) throws GamaRuntimeException {
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        if (iAgent != null) {
            return BdiUtils.removeSocialLink(iScope, new SocialLink(iAgent));
        }
        return false;
    }

    @GamlAnnotations.action(name="clear_social_links", doc={@GamlAnnotations.doc(value="clear the intention base", returns="true if the base is cleared correctly", examples={@GamlAnnotations.example(value="")})})
    public Boolean primClearSocialLinks(IScope iScope) {
        BdiUtils.getSocialBase(iScope, SOCIALLINK_BASE).clear();
        return true;
    }

    @GamlAnnotations.action(name="change_liking", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")}), @GamlAnnotations.arg(name="liking", type=2, optional=true, doc={@GamlAnnotations.doc(value="a value to change the liking value")})}, doc={@GamlAnnotations.doc(value="changes the liking value of the social relation with the agent specified.", returns="true if it worked.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primChangeLiking(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink;
        Double d;
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        Double d2 = d = iScope.hasArg("liking") ? iScope.getArg("liking", 2) : Double.valueOf(0.0);
        if (iAgent != null && (socialLink = BdiUtils.getSocialLink(iScope, new SocialLink(iAgent))) != null) {
            socialLink.setLiking(socialLink.getLiking() + d);
            if (socialLink.getLiking() > 1.0) {
                socialLink.setLiking(1.0);
            }
            if (socialLink.getLiking() < -1.0) {
                socialLink.setLiking(-1.0);
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="change_dominance", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")}), @GamlAnnotations.arg(name="dominance", type=2, optional=true, doc={@GamlAnnotations.doc(value="a value to change the dominance value")})}, doc={@GamlAnnotations.doc(value="changes the dominance value of the social relation with the agent specified.", returns="true if it worked.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primChangeDominance(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink;
        Double d;
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        Double d2 = d = iScope.hasArg("dominance") ? iScope.getArg("dominance", 2) : Double.valueOf(0.0);
        if (iAgent != null && (socialLink = BdiUtils.getSocialLink(iScope, new SocialLink(iAgent))) != null) {
            socialLink.setDominance(socialLink.getDominance() + d);
            if (socialLink.getDominance() > 1.0) {
                socialLink.setDominance(1.0);
            }
            if (socialLink.getDominance() < -1.0) {
                socialLink.setDominance(-1.0);
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="change_solidarity", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")}), @GamlAnnotations.arg(name="solidarity", type=2, optional=true, doc={@GamlAnnotations.doc(value="a value to change the solidarity value")})}, doc={@GamlAnnotations.doc(value="changes the solidarity value of the social relation with the agent specified.", returns="true if it worked.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primChangeSolidarity(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink;
        Double d;
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        Double d2 = d = iScope.hasArg("solidarity") ? iScope.getArg("solidarity", 2) : Double.valueOf(0.0);
        if (iAgent != null && (socialLink = BdiUtils.getSocialLink(iScope, new SocialLink(iAgent))) != null) {
            socialLink.setSolidarity(socialLink.getSolidarity() + d);
            if (socialLink.getSolidarity() > 1.0) {
                socialLink.setSolidarity(1.0);
            }
            if (socialLink.getSolidarity() < 0.0) {
                socialLink.setSolidarity(-1.0);
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="change_familiarity", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")}), @GamlAnnotations.arg(name="familiarity", type=2, optional=true, doc={@GamlAnnotations.doc(value="a value to change the familiarity value")})}, doc={@GamlAnnotations.doc(value="changes the familiarity value of the social relation with the agent specified.", returns="true if it worked.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primChangeFamiliarity(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink;
        Double d;
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        Double d2 = d = iScope.hasArg("familiarity") ? iScope.getArg("familiarity", 2) : Double.valueOf(0.0);
        if (iAgent != null && (socialLink = BdiUtils.getSocialLink(iScope, new SocialLink(iAgent))) != null) {
            socialLink.setFamiliarity(socialLink.getFamiliarity() + d);
            if (socialLink.getFamiliarity() > 1.0) {
                socialLink.setFamiliarity(1.0);
            }
            if (socialLink.getFamiliarity() < 0.0) {
                socialLink.setFamiliarity(0.0);
            }
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(name="change_trust", args={@GamlAnnotations.arg(name="agent", type=11, optional=true, doc={@GamlAnnotations.doc(value="an agent with who I get a social link")}), @GamlAnnotations.arg(name="trust", type=2, optional=true, doc={@GamlAnnotations.doc(value="a value to change the trust value")})}, doc={@GamlAnnotations.doc(value="changes the trust value of the social relation with the agent specified.", returns="true if it worked.", examples={@GamlAnnotations.example(value="")})})
    public Boolean primChangeTrust(IScope iScope) throws GamaRuntimeException {
        SocialLink socialLink;
        Double d;
        IAgent iAgent = (IAgent)(iScope.hasArg("agent") ? iScope.getArg("agent", 11) : null);
        Double d2 = d = iScope.hasArg("trust") ? iScope.getArg("trust", 2) : Double.valueOf(0.0);
        if (iAgent != null && (socialLink = BdiUtils.getSocialLink(iScope, new SocialLink(iAgent))) != null) {
            double d3 = Math.min(1.0, Math.max(-1.0, socialLink.getTrust() + d));
            socialLink.setTrust(d3);
            return true;
        }
        return false;
    }

    private List<SocialLink> listSocialAgentDead(IScope iScope) {
        ArrayList<SocialLink> arrayList = new ArrayList<SocialLink>();
        for (SocialLink socialLink : BdiUtils.getSocialBase(iScope, SOCIALLINK_BASE)) {
            if (!socialLink.getAgent().dead()) continue;
            arrayList.add(socialLink);
        }
        return arrayList;
    }

    protected void updateSocialLinks(IScope iScope) {
        Boolean bl;
        IAgent iAgent = this.getCurrentAgent(iScope);
        Boolean bl2 = bl = iScope.hasArg(USE_SOCIAL_ARCHITECTURE) ? iScope.getBoolArg(USE_SOCIAL_ARCHITECTURE) : (Boolean)iAgent.getAttribute(USE_SOCIAL_ARCHITECTURE);
        if (bl.booleanValue()) {
            for (SocialLink socialLink : this.listSocialAgentDead(iScope)) {
                BdiUtils.removeFromBase(iScope, socialLink, SOCIALLINK_BASE);
            }
        }
    }

    public void updateNormViolation(IScope iScope) {
        IAgent iAgent = this.getCurrentAgent(iScope);
        Norm norm = (Norm)iAgent.getAttribute(CURRENT_NORM);
        for (Norm norm2 : BdiUtils.getNorms(iScope)) {
            NormStatement normStatement = norm2.getNormStatement();
            if (normStatement == null) continue;
            boolean bl = normStatement.getContextExpression() == null || Cast.asBool((IScope)iScope, (Object)normStatement.getContextExpression().value(iScope)) != false;
            boolean bl2 = false;
            if (this.currentIntention(iScope) == null || normStatement.getIntentionExpression() == null || normStatement.getIntentionExpression().value(iScope) == null || ((Predicate)normStatement.getIntentionExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate())) {
                bl2 = true;
            }
            boolean bl3 = false;
            if (this.currentIntention(iScope) != null && normStatement.getObligationExpression() != null && normStatement.getObligationExpression().value(iScope) != null) {
                bl3 = ((Predicate)normStatement.getObligationExpression().value(iScope)).equalsIntentionPlan(this.currentIntention(iScope).getPredicate());
            }
            if ((!bl || !bl2) && (!bl || !bl3)) continue;
            if (norm == null || !((Object)((Object)normStatement)).equals((Object)norm.getNormStatement())) {
                norm2.violated(iScope);
                continue;
            }
            if (!((Object)((Object)normStatement)).equals((Object)norm.getNormStatement())) continue;
            norm2.applied(iScope);
        }
    }

    public void updateNormLifetime(IScope iScope) {
        for (Norm norm : BdiUtils.getNorms(iScope)) {
            if (norm == null) continue;
            norm.updateLifeime();
        }
    }

    public boolean init(IScope iScope) throws GamaRuntimeException {
        super.init(iScope);
        return true;
    }

    public void verifyBehaviors(ISpecies iSpecies) {
    }

    private static /* synthetic */ void lambda$1(List list, MentalState mentalState, BDIPlan bDIPlan) {
        boolean bl = list.add(mentalState);
    }

    private static /* synthetic */ void lambda$3(List list, MentalState mentalState, Norm norm) {
        boolean bl = list.add(mentalState);
    }
}

