/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMap;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.extension.bdi.MentalState;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="the name of the predicate")}), @GamlAnnotations.variable(name="is_true", type=3, doc={@GamlAnnotations.doc(value="the truth value of the predicate")}), @GamlAnnotations.variable(name="values", type=10, doc={@GamlAnnotations.doc(value="the values attached to the predicate")}), @GamlAnnotations.variable(name="date", type=2, doc={@GamlAnnotations.doc(value="the date of the predicate")}), @GamlAnnotations.variable(name="subintentions", type=5, doc={@GamlAnnotations.doc(value="the subintentions of the predicate")}), @GamlAnnotations.variable(name="on_hold_until", type=5, doc={@GamlAnnotations.doc(value="the list of intention that must be fullfiled before resuming to an intention related to this predicate")}), @GamlAnnotations.variable(name="super_intention", type=0, doc={@GamlAnnotations.doc(value="the super-intention of the predicate")}), @GamlAnnotations.variable(name="cause", type=11, doc={@GamlAnnotations.doc(value="the agent causing the predicate")})})
public class Predicate
implements IValue {
    String name;
    IMap<String, Object> values;
    Double date;
    List<MentalState> onHoldUntil;
    List<MentalState> subintentions;
    MentalState superIntention;
    IAgent agentCause;
    boolean is_true = true;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", (Object)this.name, "is_true", (Object)this.is_true, "values", this.values, "date", (Object)this.date).add("subintentions", this.subintentions).add("on_hold_until", this.onHoldUntil).add("super_intention", (Object)this.superIntention).add("cause", (Object)this.agentCause);
    }

    @GamlAnnotations.getter(value="name")
    public String getName() {
        return this.name;
    }

    @GamlAnnotations.getter(value="values")
    public IMap<String, Object> getValues() {
        return this.values;
    }

    @GamlAnnotations.getter(value="is_true")
    public Boolean getIs_True() {
        return this.is_true;
    }

    @GamlAnnotations.getter(value="date")
    public Double getDate() {
        return this.date;
    }

    @GamlAnnotations.getter(value="subintentions")
    public List<MentalState> getSubintentions() {
        return this.subintentions;
    }

    @GamlAnnotations.getter(value="super_intention")
    public MentalState getSuperIntention() {
        return this.superIntention;
    }

    @GamlAnnotations.getter(value="cause")
    public IAgent getAgentCause() {
        return this.agentCause;
    }

    public List<MentalState> getOnHoldUntil() {
        return this.onHoldUntil;
    }

    public void setSuperIntention(MentalState mentalState) {
        this.superIntention = mentalState;
    }

    public void setOnHoldUntil(List<MentalState> list) {
        this.onHoldUntil = list;
    }

    public void setValues(IMap<String, Object> iMap) {
        this.values = iMap;
    }

    public void setIs_True(Boolean bl) {
        this.is_true = bl;
    }

    public void setDate(Double d) {
        this.date = d;
    }

    public void setSubintentions(List<MentalState> list) {
        this.subintentions = list;
    }

    @GamlAnnotations.setter(value="cause")
    public void setAgentCause(IAgent iAgent) {
        this.agentCause = iAgent;
    }

    public Predicate() {
        this.name = "";
        this.agentCause = null;
    }

    public Predicate(String string) {
        this.name = string;
        this.agentCause = null;
    }

    public Predicate(String string, boolean bl) {
        this.name = string;
        this.is_true = bl;
        this.agentCause = null;
    }

    public Predicate(String string, IMap<String, Object> iMap) {
        this.name = string;
        this.values = iMap;
        this.agentCause = null;
    }

    public Predicate(String string, IAgent iAgent) {
        this.name = string;
        this.agentCause = iAgent;
    }

    public Predicate(String string, IMap<String, Object> iMap, Boolean bl) {
        this.name = string;
        this.values = iMap;
        this.is_true = bl;
        this.agentCause = null;
    }

    public Predicate(String string, IMap<String, Object> iMap, IAgent iAgent) {
        this.name = string;
        this.values = iMap;
        this.agentCause = iAgent;
    }

    public Predicate(String string, IMap<String, Object> iMap, Boolean bl, IAgent iAgent) {
        this.name = string;
        this.values = iMap;
        this.is_true = bl;
        this.agentCause = iAgent;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "predicate(" + this.name + (String)(this.values == null ? "" : "," + String.valueOf(this.values)) + (String)(this.agentCause == null ? "" : "," + String.valueOf(this.agentCause)) + "," + this.is_true + ")";
    }

    public String serializeToGaml(boolean bl) {
        return this.toString();
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.toString();
    }

    public Predicate copy(IScope iScope) throws GamaRuntimeException {
        return new Predicate(this.name, this.values == null ? null : ((GamaMap)this.values).copy(iScope));
    }

    public Predicate copy() throws GamaRuntimeException {
        if (this.values != null && this.agentCause != null) {
            return new Predicate(this.name, (IMap<String, Object>)((GamaMap)this.values).copy(GAMA.getRuntimeScope()), this.is_true, this.agentCause);
        }
        if (this.values != null) {
            return new Predicate(this.name, (IMap<String, Object>)((GamaMap)this.values).copy(GAMA.getRuntimeScope()));
        }
        return new Predicate(this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)object;
        if (!Objects.equals(this.name, predicate.name) || this.is_true != predicate.is_true) {
            return false;
        }
        if (this.values == null && this.agentCause == null || predicate.values == null && predicate.agentCause == null) {
            return true;
        }
        if (this.values != null && predicate.values != null && !this.values.isEmpty() && !predicate.values.isEmpty()) {
            Set set = this.values.keySet();
            set.retainAll(predicate.values.keySet());
            for (String string : set) {
                if ((this.values.get((Object)string) != null || predicate.values.get((Object)string) == null) && this.values.get((Object)string).equals(predicate.values.get((Object)string))) continue;
                return false;
            }
            return true;
        }
        return this.agentCause == null || predicate.agentCause == null || this.agentCause.equals(predicate.agentCause);
    }

    public boolean equalsIntentionPlan(Object object) {
        return this.equals(object);
    }

    public boolean equalsButNotTruth(Object object) {
        if (object == this) {
            return false;
        }
        if (!(object instanceof Predicate)) {
            return false;
        }
        Predicate predicate = (Predicate)object;
        if (!Objects.equals(this.name, predicate.name) || this.is_true == predicate.is_true) {
            return false;
        }
        if (this.agentCause == null || predicate.agentCause == null) {
            return true;
        }
        if (this.values == null || predicate.values == null) {
            return true;
        }
        Set set = this.values.keySet();
        set.retainAll(predicate.values.keySet());
        for (String string : set) {
            if ((this.values.get((Object)string) != null || predicate.values.get((Object)string) == null) && this.values.get((Object)string).equals(predicate.values.get((Object)string))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsEmotions(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Predicate predicate = (Predicate)object;
        if (!Objects.equals(this.name, predicate.name) || this.is_true != predicate.is_true) {
            return false;
        }
        if (this.values != null && predicate.values != null) {
            Set set = this.values.keySet();
            set.retainAll(predicate.values.keySet());
            for (String string : set) {
                if ((this.values.get((Object)string) != null || predicate.values.get((Object)string) == null) && this.values.get((Object)string).equals(predicate.values.get((Object)string))) continue;
                return false;
            }
        }
        return true;
    }

    public IType<?> getGamlType() {
        return Types.get((int)546704);
    }
}

