/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.extension.bdi.CopingStatement;
import gama.extension.bdi.LawStatement;
import gama.extension.bdi.PerceiveStatement;
import gama.extension.bdi.RuleStatement;
import gama.extension.bdi.SimpleBdiArchitecture;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.util.List;

@GamlAnnotations.skill(name="parallel_bdi", concept={"bdi", "architecture"})
@GamlAnnotations.doc(value="compute the bdi architecture in parallel. This skill inherit all actions and variables from SimpleBdiArchitecture")
public class SimpleBdiArchitectureParallel
extends SimpleBdiArchitecture {
    public static final String PARALLEL_BDI = "parallel_bdi";
    IExpression parallel = ConstantExpressionDescription.TRUE_EXPR_DESCRIPTION;

    public void preStep(IScope iScope, IPopulation<? extends IAgent> iList) {
        IExpression iExpression;
        Object object;
        IExpression iExpression2 = iList.getSpecies().getSchedule();
        IList iList2 = iExpression2 == null ? iList : Cast.asList((IScope)iScope, (Object)iExpression2.value(iScope));
        GamaExecutorService.execute((IScope)iScope, (IExecutable)new UpdateLifeTimePredicates(null), (List)iList2, (IExpression)this.parallel);
        GamaExecutorService.execute((IScope)iScope, (IExecutable)new UpdateEmotionsIntensity(null), (List)iList2, (IExpression)this.parallel);
        if (this._reflexes != null) {
            for (IStatement iStatement : this._reflexes) {
                if (iScope.interrupted()) continue;
                GamaExecutorService.execute((IScope)iScope, (IExecutable)iStatement, (List)iList2, (IExpression)ConstantExpressionDescription.FALSE_EXPR_DESCRIPTION);
            }
        }
        if (this._perceptionNumber > 0) {
            int n = 0;
            while (n < this._perceptionNumber) {
                if (!iScope.interrupted()) {
                    object = (PerceiveStatement)((Object)this._perceptions.get(n));
                    iExpression = ((PerceiveStatement)((Object)object)).getParallel() == null ? this.parallel : ((PerceiveStatement)((Object)object)).getParallel();
                    GamaExecutorService.execute((IScope)iScope, (IExecutable)object, (List)iList2, (IExpression)iExpression);
                }
                ++n;
            }
        }
        if (this._rulesNumber > 0) {
            int n = 0;
            while (n < this._rulesNumber) {
                object = (RuleStatement)((Object)this._rules.get(n));
                iExpression = ((RuleStatement)((Object)object)).getParallel() == null ? this.parallel : ((RuleStatement)((Object)object)).getParallel();
                GamaExecutorService.execute((IScope)iScope, (IExecutable)object, (List)iList2, (IExpression)iExpression);
                ++n;
            }
        }
        if (this._lawsNumber > 0) {
            int n = 0;
            while (n < this._lawsNumber) {
                object = (LawStatement)((Object)this._laws.get(n));
                iExpression = ((LawStatement)((Object)object)).getParallel() == null ? this.parallel : ((LawStatement)((Object)object)).getParallel();
                GamaExecutorService.execute((IScope)iScope, (IExecutable)object, (List)iList2, (IExpression)iExpression);
                ++n;
            }
        }
        GamaExecutorService.execute((IScope)iScope, (IExecutable)new UpdateSocialLinks(null), (List)iList2, (IExpression)this.parallel);
        if (this._copingNumber > 0) {
            int n = 0;
            while (n < this._copingNumber) {
                object = (CopingStatement)((Object)this._coping.get(n));
                iExpression = ((CopingStatement)((Object)object)).getParallel() == null ? this.parallel : ((CopingStatement)((Object)object)).getParallel();
                GamaExecutorService.execute((IScope)iScope, (IExecutable)object, (List)iList2, (IExpression)iExpression);
                ++n;
            }
        }
    }

    @Override
    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        Object object;
        Boolean bl = iScope.getBoolArgIfExists("use_personality", ((Boolean)iScope.getAgent().getAttribute("use_personality")).booleanValue());
        if (bl.booleanValue()) {
            object = (Double)iScope.getAgent().getAttribute("extroversion");
            Double d = (Double)iScope.getAgent().getAttribute("neurotism");
            Double d2 = (Double)iScope.getAgent().getAttribute("conscientiousness");
            Double d3 = (Double)iScope.getAgent().getAttribute("agreeableness");
            iScope.getAgent().setAttribute("charisma", object);
            iScope.getAgent().setAttribute("receptivity", (Object)(1.0 - d));
            iScope.getAgent().setAttribute("plan_persistence", (Object)Maths.sqrt((IScope)iScope, (Double)d2));
            iScope.getAgent().setAttribute("intention_persistence", (Object)Maths.sqrt((IScope)iScope, (Double)d2));
            iScope.getAgent().setAttribute("obedience", (Object)Maths.sqrt((IScope)iScope, (Double)((d2 + d3) * 0.5)));
        }
        object = this.executePlans(iScope);
        if (!iScope.getAgent().dead()) {
            this.updateNormViolation(iScope);
            this.updateNormLifetime(iScope);
        }
        return object;
    }

    public class UpdateEmotions
    extends AbstractStatement {
        public UpdateEmotions(IDescription iDescription) {
            super(iDescription);
        }

        protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
            return null;
        }
    }

    public class UpdateEmotionsIntensity
    extends AbstractStatement {
        public UpdateEmotionsIntensity(IDescription iDescription) {
            super(iDescription);
        }

        protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
            SimpleBdiArchitectureParallel.this.updateEmotionsIntensity(iScope);
            return null;
        }
    }

    public class UpdateLifeTimePredicates
    extends AbstractStatement {
        public UpdateLifeTimePredicates(IDescription iDescription) {
            super(iDescription);
        }

        protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
            SimpleBdiArchitectureParallel.this.updateLifeTimePredicates(iScope);
            return null;
        }
    }

    public class UpdateSocialLinks
    extends AbstractStatement {
        public UpdateSocialLinks(IDescription iDescription) {
            super(iDescription);
        }

        protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
            SimpleBdiArchitectureParallel.this.updateSocialLinks(iScope);
            return null;
        }
    }
}

