/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.bdi.BDIPlan;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Predicate;
import gama.extension.bdi.SimpleBdiArchitecture;
import gama.extension.bdi.SocialLink;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.Map;

public class BdiOperators {
    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="creates a new predicate with a given name and adidtional properties (values, agent causing the predicate, whether it is true...)", masterDoc=true, examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\")", isExecutable=false)})
    public static Predicate newPredicate(String string) throws GamaRuntimeException {
        return new Predicate(string);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given properties (name, values)", examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\", map([\"val1\"::23]) )", isExecutable=false)})
    public static Predicate newPredicate(String string, IMap iMap) throws GamaRuntimeException {
        return new Predicate(string, (IMap<String, Object>)iMap);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given is_true (name, is_true)", examples={@GamlAnnotations.example(value="new_predicate(\"hasWater\", true)", isExecutable=false)})
    public static Predicate newPredicate(String string, Boolean bl) throws GamaRuntimeException {
        return new Predicate(string, bl);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given properties (name, cause agent)", examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\", agent1)", isExecutable=false)})
    public static Predicate newPredicate(String string, IAgent iAgent) throws GamaRuntimeException {
        return new Predicate(string, iAgent);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given properties (name, values, is_true)", examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\", [\"time\"::10], true)", isExecutable=false)})
    public static Predicate newPredicate(String string, IMap iMap, Boolean bl) throws GamaRuntimeException {
        return new Predicate(string, (IMap<String, Object>)iMap, bl);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given properties (name, values, agent_cause)", examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\", [\"time\"::10], agentA)", isExecutable=false)})
    public static Predicate newPredicate(String string, IMap iMap, IAgent iAgent) throws GamaRuntimeException {
        return new Predicate(string, (IMap<String, Object>)iMap, iAgent);
    }

    @GamlAnnotations.operator(value={"new_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new predicate with the given properties (name, values, is_true, agent_cause)", examples={@GamlAnnotations.example(value="new_predicate(\"people to meet\", [\"time\"::10], true, agentA)", isExecutable=false)})
    public static Predicate newPredicate(String string, IMap iMap, Boolean bl, IAgent iAgent) throws GamaRuntimeException {
        return new Predicate(string, (IMap<String, Object>)iMap, bl, iAgent);
    }

    @GamlAnnotations.operator(value={"with_truth"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the is_true value of the given predicate", examples={@GamlAnnotations.example(value="predicate with_truth false", isExecutable=false)})
    public static Predicate withTruth(Predicate predicate, Boolean bl) throws GamaRuntimeException {
        predicate.is_true = bl;
        return predicate;
    }

    @GamlAnnotations.operator(value={"with_values"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the parameters of the given predicate", examples={@GamlAnnotations.example(value="predicate with_values [\"time\"::10]", isExecutable=false)})
    public static Predicate withValues(Predicate predicate, IMap iMap) throws GamaRuntimeException {
        predicate.setValues((IMap<String, Object>)iMap);
        return predicate;
    }

    @GamlAnnotations.operator(value={"add_values"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="add a new value to the map of the given predicate", examples={@GamlAnnotations.example(value="predicate add_values [\"time\"::10];", isExecutable=false)})
    public static Predicate addValues(Predicate predicate, IMap iMap) throws GamaRuntimeException {
        if (iMap != null && predicate != null) {
            predicate.getValues().putAll((Map)iMap);
        }
        return predicate;
    }

    @GamlAnnotations.operator(value={"not"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="create a new predicate with the inverse truth value", examples={@GamlAnnotations.example(value="not predicate1", isExecutable=false)})
    public static Predicate not(Predicate predicate) {
        predicate.setIs_True(predicate.getIs_True() == false);
        return predicate;
    }

    @GamlAnnotations.operator(value={"and"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="create a new predicate from two others by including them as subintentions", examples={@GamlAnnotations.example(value="predicate1 and predicate2", isExecutable=false)})
    public static Predicate and(Predicate predicate, Predicate predicate2) {
        Predicate predicate3 = new Predicate(predicate.getName() + "_and_" + predicate2.getName());
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        MentalState mentalState = new MentalState("Intention", predicate);
        MentalState mentalState2 = new MentalState("Intention", predicate2);
        arrayList.add(mentalState);
        arrayList.add(mentalState2);
        predicate3.setSubintentions(arrayList);
        IMap iMap = GamaMapFactory.create();
        iMap.put((Object)"and", (Object)true);
        predicate3.setValues((IMap<String, Object>)iMap);
        return predicate3;
    }

    @GamlAnnotations.operator(value={"or"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="create a new predicate from two others by including them as subintentions. It's an exclusive \"or\" ", examples={@GamlAnnotations.example(value="predicate1 or predicate2", isExecutable=false)})
    public static Predicate or(Predicate predicate, Predicate predicate2) {
        Predicate predicate3 = new Predicate(predicate.getName() + "_or_" + predicate2.getName());
        ArrayList<MentalState> arrayList = new ArrayList<MentalState>();
        MentalState mentalState = new MentalState("Intention", predicate);
        MentalState mentalState2 = new MentalState("Intention", predicate2);
        arrayList.add(mentalState);
        arrayList.add(mentalState2);
        predicate3.setSubintentions(arrayList);
        IMap iMap = GamaMapFactory.create();
        iMap.put((Object)"or", (Object)true);
        predicate3.setValues((IMap<String, Object>)iMap);
        return predicate3;
    }

    @GamlAnnotations.operator(value={"eval_when"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="evaluate the facet when of a given plan", examples={@GamlAnnotations.example(value="eval_when(plan1)", isExecutable=false)})
    public static Boolean evalWhen(IScope iScope, BDIPlan bDIPlan) {
        if (bDIPlan.getPlanStatement().getContextExpression() != null && !Cast.asBool((IScope)iScope, (Object)bDIPlan.getPlanStatement().getContextExpression().value(iScope)).booleanValue()) {
            return false;
        }
        return true;
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (at least its name, and eventually intensity, parameters...)", masterDoc=true, examples={@GamlAnnotations.example(value="new_emotion(\"joy\")", isExecutable=false)})
    @GamlAnnotations.test(value="emotion e <- new_emotion(\"joy\"); assert e.name = \"joy\"; assert e.intensity  = -1.0;")
    public static Emotion newEmotion(String string) throws GamaRuntimeException {
        return new Emotion(string);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, intensity)", usages={@GamlAnnotations.usage(value="a new emotion with a name and an initial intensity: ", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",12.3)", isExecutable=false)})})
    @GamlAnnotations.test(value="new_emotion('joy',12.3).intensity = 12.3")
    public static Emotion newEmotion(String string, Double d) throws GamaRuntimeException {
        return new Emotion(string, d);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, about)", usages={@GamlAnnotations.usage(value="a new emotion with a given name and the predicate it is about ", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",estFood)", isExecutable=false), @GamlAnnotations.example(value="new_emotion(\"joy\",agent1)", isExecutable=false)})})
    public static Emotion newEmotion(String string, Predicate predicate) throws GamaRuntimeException {
        return new Emotion(string, predicate);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name and cause agent)", usages={@GamlAnnotations.usage(value="a new emotion with a given name and the agent which has caused this emotion ", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",agent1)", isExecutable=false)})})
    public static Emotion newEmotion(String string, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, iAgent);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name,intensity,about)", usages={@GamlAnnotations.usage(value="Various combinations are possible to create the emotion: (name,intensity,about), (name,about,cause), (name,intensity,cause)... ", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",12.3,eatFood)", isExecutable=false), @GamlAnnotations.example(value="new_emotion(\"joy\",eatFood,agent1)", isExecutable=false), @GamlAnnotations.example(value="new_emotion(\"joy\",12.3,agent1)", isExecutable=false)})})
    public static Emotion newEmotion(String string, Double d, Predicate predicate) throws GamaRuntimeException {
        return new Emotion(string, (double)d, predicate);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name,intensity,decay)", usages={@GamlAnnotations.usage(value="A decay value value can be added to define a new emotion.", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",12.3,4.0)", isExecutable=false)})})
    public static Emotion newEmotion(String string, Double d, Double d2) throws GamaRuntimeException {
        return new Emotion(string, (double)d, d2);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, about, cause agent)")
    public static Emotion newEmotion(String string, Predicate predicate, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, predicate, iAgent);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name,intensity,cause agent)")
    public static Emotion newEmotion(String string, Double d, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, (double)d, iAgent);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, intensity, about,  decay)", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",12.3,eatFood,4.0)", isExecutable=false)})
    public static Emotion newEmotion(String string, Double d, Predicate predicate, Double d2) throws GamaRuntimeException {
        return new Emotion(string, (double)d, predicate, d2);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name,intensity, decay, cause agent)", examples={@GamlAnnotations.example(value="emotion(\"joy\", 12.3, 4, agent1)", isExecutable=false)})
    public static Emotion newEmotion(String string, Double d, Double d2, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, (double)d, d2, iAgent);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, intensity, about, cause  agent)", examples={@GamlAnnotations.example(value="new_emotion(\"joy\",12.3,eatFood,agent1)", isExecutable=false)})
    public static Emotion newEmotion(String string, Double d, Predicate predicate, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, (double)d, predicate, iAgent);
    }

    @GamlAnnotations.operator(value={"new_emotion"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new emotion with the given properties (name, intensity, about, decay, cause  agent)", examples={@GamlAnnotations.example(value="emotion(\"joy\",12.3,eatFood,4,agent1)", isExecutable=false)})
    public static Emotion newEmotion(String string, Double d, Predicate predicate, Double d2, IAgent iAgent) throws GamaRuntimeException {
        return new Emotion(string, d, predicate, d2, iAgent);
    }

    @GamlAnnotations.operator(value={"with_agent_cause"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the agentCause value of the given emotion", examples={@GamlAnnotations.example(value="new_emotion with_agent_cause agentA", isExecutable=false)})
    public static Emotion withAgentCause(Emotion emotion, IAgent iAgent) throws GamaRuntimeException {
        emotion.agentCause = iAgent;
        return emotion;
    }

    @GamlAnnotations.operator(value={"with_intensity"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the intensity value of the given emotion", examples={@GamlAnnotations.example(value="emotion with_intensity 12", isExecutable=false)})
    public static Emotion withIntensity(Emotion emotion, double d) throws GamaRuntimeException {
        emotion.intensity = d;
        return emotion;
    }

    @GamlAnnotations.operator(value={"with_decay"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the decay value of the given emotion", examples={@GamlAnnotations.example(value="emotion with_decay 12", isExecutable=false)})
    public static Emotion withDecay(Emotion emotion, double d) throws GamaRuntimeException {
        emotion.decay = d;
        return emotion;
    }

    @GamlAnnotations.operator(value={"with_about"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the about value of the given emotion", examples={@GamlAnnotations.example(value="emotion with_about predicate1", isExecutable=false)})
    public static Emotion withAbout(Emotion emotion, Predicate predicate) throws GamaRuntimeException {
        emotion.about = predicate;
        return emotion;
    }

    @GamlAnnotations.operator(value={"new_social_link"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="creates a new social link with another agent (eventually given additional parameters such as the appreciation, dominance, solidarity, and familiarity values).", masterDoc=true, examples={@GamlAnnotations.example(value="new_social_link(agentA)", isExecutable=false)})
    public static SocialLink newSocialLink(IAgent iAgent) throws GamaRuntimeException {
        return new SocialLink(iAgent);
    }

    @GamlAnnotations.operator(value={"new_social_link"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="creates a new social link toward another agent with given appreciation, dominance, solidarity, and familiarity values", examples={@GamlAnnotations.example(value="new_social_link(agentA,0.0,-0.1,0.2,0.1)", isExecutable=false)})
    public static SocialLink newSocialLink(IAgent iAgent, double d, double d2, double d3, double d4) throws GamaRuntimeException {
        return new SocialLink(iAgent, d, d2, d3, d4);
    }

    @GamlAnnotations.operator(value={"with_agent"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the agent value of the given social link", examples={@GamlAnnotations.example(value="social_link with_agent agentA", isExecutable=false)})
    public static SocialLink withAgent(SocialLink socialLink, IAgent iAgent) {
        socialLink.setAgent(iAgent);
        return socialLink;
    }

    @GamlAnnotations.operator(value={"with_liking"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the liking value of the given social link", examples={@GamlAnnotations.example(value="social_link with_liking 0.4", isExecutable=false)})
    public static SocialLink withLiking(SocialLink socialLink, double d) throws GamaRuntimeException {
        if (d >= -1.0 && d <= 1.0) {
            socialLink.setLiking(d);
        }
        return socialLink;
    }

    @GamlAnnotations.operator(value={"with_dominance"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the dominance value of the given social link", examples={@GamlAnnotations.example(value="social_link with_dominance 0.4", isExecutable=false)})
    public static SocialLink withDominance(SocialLink socialLink, double d) throws GamaRuntimeException {
        if (d >= -1.0 && d < 1.0) {
            socialLink.setDominance(d);
        }
        return socialLink;
    }

    @GamlAnnotations.operator(value={"with_solidarity"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the solidarity value of the given social link", examples={@GamlAnnotations.example(value="social_link with_solidarity 0.4", isExecutable=false)})
    public static SocialLink withSolidarity(SocialLink socialLink, double d) throws GamaRuntimeException {
        if (d >= 0.0 && d <= 1.0) {
            socialLink.setSolidarity(d);
        }
        return socialLink;
    }

    @GamlAnnotations.operator(value={"with_familiarity"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the familiarity value of the given social link", examples={@GamlAnnotations.example(value="social_link with_familiarity 0.4", isExecutable=false)})
    public static SocialLink withFamiliarity(SocialLink socialLink, double d) throws GamaRuntimeException {
        if (d >= 0.0 && d <= 1.0) {
            socialLink.setFamiliarity(d);
        }
        return socialLink;
    }

    @GamlAnnotations.operator(value={"with_trust"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the trust value of the given social link", examples={@GamlAnnotations.example(value="social_link with_trust 0.4", isExecutable=false)})
    public static SocialLink withTrust(SocialLink socialLink, double d) throws GamaRuntimeException {
        if (d >= -1.0 && d <= 1.0) {
            socialLink.setTrust(d);
        }
        return socialLink;
    }

    @GamlAnnotations.operator(value={"get_agent"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the agent value of the given social link", examples={@GamlAnnotations.example(value="get_agent(social_link1)", isExecutable=false)})
    public static IAgent getAgent(SocialLink socialLink) {
        if (socialLink != null) {
            return socialLink.getAgent();
        }
        return null;
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="creates a new mental state with a given modality (e.g. belief or desire) and various properties (a predicate it is about, a strength, a lifetime, an ower agent  and an emotion it is about", masterDoc=true, examples={@GamlAnnotations.example(value="new_mental_state(\"belief\")", isExecutable=false)})
    public static MentalState newMentalState(String string) throws GamaRuntimeException {
        return new MentalState(string);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate) throws GamaRuntimeException {
        return new MentalState(string, predicate);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate and strength", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, 0.5)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Double d) throws GamaRuntimeException {
        return new MentalState(string, predicate, d);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate and owner agent", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, predicate, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate and lifetime", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Integer n) throws GamaRuntimeException {
        return new MentalState(string, predicate, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate, strength, and owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, 12.3, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Double d, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, predicate, d, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate, strength andd lifetime", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, 12.4, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Double d, Integer n) throws GamaRuntimeException {
        return new MentalState(string, predicate, d, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate, lifetime, and owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", raining, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, predicate, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional predicate, strength, lifetime and owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\",raining, 12.3, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Predicate predicate, Double d, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, predicate, d, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState) throws GamaRuntimeException {
        return new MentalState(string, mentalState);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state  with an additional mental state it is about and a strength", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 12.3)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Double d) throws GamaRuntimeException {
        return new MentalState(string, mentalState, d);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about and the owner  agent", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, mentalState, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about and a lifetime", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Integer n) throws GamaRuntimeException {
        return new MentalState(string, mentalState, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about, a stength, and an owner agent", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 12.2, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Double d, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, mentalState, d, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about, a stength, and a lifetime.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 12.3, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Double d, Integer n) throws GamaRuntimeException {
        return new MentalState(string, mentalState, d, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about, a stength, and an owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, mentalState, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional mental state it is about, a stength, lifetime, and an owner agent", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", mental_state1, 12.3, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, MentalState mentalState, Double d, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, mentalState, d, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion) throws GamaRuntimeException {
        return new MentalState(string, emotion);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about and a strength.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, 12.3)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Double d) throws GamaRuntimeException {
        return new MentalState(string, emotion, d);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about and an owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, emotion, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about and a lifetime.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\",  my_joy, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Integer n) throws GamaRuntimeException {
        return new MentalState(string, emotion, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about, a stength, and an owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, 12.3, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Double d, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, emotion, d, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about, a strength, and a lifetime.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, 12.3, 10)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Double d, Integer n) throws GamaRuntimeException {
        return new MentalState(string, emotion, d, (int)n);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about, a lifetime, and an owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, emotion, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"new_mental_state"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="a new mental state with an additional emotion it is about, a strength, a lifetime, and an owner agent.", examples={@GamlAnnotations.example(value="new_mental_state(\"belief\", my_joy, 12.3, 10, agent1)", isExecutable=false)})
    public static MentalState newMentalState(String string, Emotion emotion, Double d, Integer n, IAgent iAgent) throws GamaRuntimeException {
        return new MentalState(string, emotion, d, (int)n, iAgent);
    }

    @GamlAnnotations.operator(value={"set_modality"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the modality value of the given mental state", examples={@GamlAnnotations.example(value="mental state set_modality belief", isExecutable=false)})
    public static MentalState setModalitity(MentalState mentalState, String string) {
        mentalState.setModality(string);
        return mentalState;
    }

    @GamlAnnotations.operator(value={"set_predicate"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the predicate value of the given mental state", examples={@GamlAnnotations.example(value="mental state set_predicate pred1", isExecutable=false)})
    public static MentalState setPredicate(MentalState mentalState, Predicate predicate) {
        mentalState.setPredicate(predicate);
        return mentalState;
    }

    @GamlAnnotations.operator(value={"set_strength"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the strength value of the given mental state", examples={@GamlAnnotations.example(value="mental state set_strength 1.0", isExecutable=false)})
    public static MentalState setStrength(MentalState mentalState, Double d) {
        mentalState.setStrength(d);
        return mentalState;
    }

    @GamlAnnotations.operator(value={"set_lifetime"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="change the lifetime value of the given mental state", examples={@GamlAnnotations.example(value="mental state set_lifetime 1", isExecutable=false)})
    public static MentalState setLifetime(MentalState mentalState, int n) {
        mentalState.setLifeTime(n);
        return mentalState;
    }

    @GamlAnnotations.operator(value={"get_plan_name"}, can_be_const=true, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the name of a given plan", examples={@GamlAnnotations.example(value="get_plan_name(agent.current_plan)", isExecutable=false)})
    public static String getPlanName(BDIPlan bDIPlan) {
        if (bDIPlan != null && bDIPlan.getPlanStatement() != null) {
            return bDIPlan.getPlanStatement().getName();
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_beliefs_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of beliefs in the belief base which predicate has the given name.", returns="the list of beliefs (mental state).", examples={@GamlAnnotations.example(value="get_beliefs_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getBeliefsName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_belief_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the belief in the belief base with the given name.", returns="the belief (mental state).", examples={@GamlAnnotations.example(value="get_belief_with_name_op(self,\"has_water\")", equals="nil")})
    public static MentalState getBeliefName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_belief_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the belief in the belief base with the given predicate.", returns="the belief (mental state).", examples={@GamlAnnotations.example(value="get_belief_op(self,predicate(\"has_water\"))", equals="nil")})
    public static MentalState getBelief(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_beliefs_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the beliefs in the belief base with the given predicate.", returns="the list of belief (mental state).", examples={@GamlAnnotations.example(value="get_beliefs_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getBeliefs(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_desires_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of desires in the desire base which predicate has the given name.", returns="the list of desires (mental state).", examples={@GamlAnnotations.example(value="get_desires_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getDesiresName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_desire_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the desire in the desire base with the given name.", returns="the desire (mental state).", examples={@GamlAnnotations.example(value="get_desire_with_name_op(self,\"has_water\")", equals="nil")})
    public static MentalState getDesireName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_desire_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the desire in the desire base with the given predicate.", returns="the belief (mental state).", examples={@GamlAnnotations.example(value="get_belief_op(self,predicate(\"has_water\"))", equals="nil")})
    public static MentalState getDesire(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_desires_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the desires in the desire base with the given predicate.", returns="the list of desire (mental state).", examples={@GamlAnnotations.example(value="get_desires_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getDesires(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_uncertainties_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of uncertainties in the uncertainty base which predicate has the given name.", returns="the list of uncertainties (mental state).", examples={@GamlAnnotations.example(value="get_uncertainties_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getUncertaintiesName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_uncertainty_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the uncertainty in the uncertainty base with the given name.", returns="the unertainty (mental state).", examples={@GamlAnnotations.example(value="get_uncertainty_with_name_op(self,\"has_water\")", equals="nil")})
    public static MentalState getUncertaintyName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_uncertainty_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the uncertainty in the uncertainty base with the given predicate.", returns="the uncertainty (mental state).", examples={@GamlAnnotations.example(value="get_uncertainty_op(self,predicate(\"has_water\"))", equals="nil")})
    public static MentalState getUncertainty(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_uncertainties_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the uncertainties in the uncertainty base with the given predicate.", returns="the list of uncertainties (mental state).", examples={@GamlAnnotations.example(value="get_uncertainties_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getUncertainties(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_ideals_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of ideals in the ideal base which predicate has the given name.", returns="the list of ideals (mental state).", examples={@GamlAnnotations.example(value="get_ideals_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getIdealsName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_ideal_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the ideal in the ideal base with the given name.", returns="the ideal (mental state).", examples={@GamlAnnotations.example(value="get_ideal_with_name_op(self,\"has_water\")", equals="nil")})
    public static MentalState getIdealName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_ideal_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the ideal in the ideal base with the given name.", returns="the ideal (mental state).", examples={@GamlAnnotations.example(value="get_ideal_op(self,predicate(\"has_water\"))", equals="nil")})
    public static MentalState getIdeal(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_ideals_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the ideal in the ideal base with the given name.", returns="the list of ideals (mental state).", examples={@GamlAnnotations.example(value="get_ideals_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getIdeals(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_obligations_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of obligations in the obligation base which predicate has the given name.", returns="the list of obligations (mental state).", examples={@GamlAnnotations.example(value="get_obligations_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getObligationsName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_obligation_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the obligation in the obligation base with the given name.", returns="the obligation (mental state).", examples={@GamlAnnotations.example(value="get_obligation_with_name_op(self,\"has_water\")", equals="nil")})
    public static MentalState getObligationName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_obligation_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the obligation in the obligation base with the given predicate.", returns="the obligation (mental state).", examples={@GamlAnnotations.example(value="get_obligation_op(self,predicate(\"has_water\"))", equals="nil")})
    public static MentalState getObligation(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_obligations_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the obligations in the obligation base with the given predicate.", returns="the list of obligations (mental state).", examples={@GamlAnnotations.example(value="get_obligations_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getObligations(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_intentions_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the list of intentions in the intention base which predicate has the given name.", returns="the list of intentions (mental state).", examples={@GamlAnnotations.example(value="get_intentions_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static IList<MentalState> getIntentionsName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (string != null) {
            IList iList2 = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_intention_with_name_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the intention in the intention base with the given name.", returns="the intention (mental state).", examples={@GamlAnnotations.example(value="get_intention_with_name_op(self,\"has_water\")", isExecutable=false)})
    public static MentalState getIntentionName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_intention_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the intention in the intention base with the given predicate.", returns="the intention (mental state).", examples={@GamlAnnotations.example(value="get_intention_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static MentalState getIntention(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                return mentalState;
            }
        }
        return null;
    }

    @GamlAnnotations.operator(value={"get_intentions_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the intentions in the intention base with the given predicate.", returns="the list of intentions (mental state).", examples={@GamlAnnotations.example(value="get_intentions_op(self,predicate(\"has_water\"))", isExecutable=false)})
    public static IList<MentalState> getIntentions(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        IList iList = GamaListFactory.create();
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return iList;
        }
        if (predicate != null) {
            IList iList2 = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList2) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                iList.add((Object)mentalState);
            }
        }
        return iList;
    }

    @GamlAnnotations.operator(value={"get_current_intention_op"}, can_be_const=true, content_type=546708, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="get the current intention.", returns="the current intention (mental state).", examples={@GamlAnnotations.example(value="get_current_intention_op(self)", equals="nil")})
    public static MentalState getCurrentIntention(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return null;
        }
        IList iList = (IList)iAgent.getAttribute("intention_base");
        if (!iList.isEmpty()) {
            return (MentalState)iList.lastValue(iScope);
        }
        return null;
    }

    @GamlAnnotations.operator(value={"has_belief_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is a belief about the given predicate.", returns="true if a belief already exists.", examples={@GamlAnnotations.example(value="has_belief_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasBelief(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_belief_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is a belief about the given name.", returns="true if a belief already exists.", examples={@GamlAnnotations.example(value="has_belief_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasBeliefName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("belief_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_desire_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is a desire about the given predicate.", returns="true if a desire already exists.", examples={@GamlAnnotations.example(value="has_desire_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasDesire(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_desire_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is a desire about the given name.", returns="true if a desire already exists.", examples={@GamlAnnotations.example(value="has_desire_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasDesireName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("desire_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_uncertainty_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an uncertainty about the given predicate.", returns="true if an uncertainty already exists.", examples={@GamlAnnotations.example(value="has_uncertainty_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasUncertainty(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_uncertainty_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an uncertainty about the given name.", returns="true if an uncertainty already exists.", examples={@GamlAnnotations.example(value="has_uncertainty_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasUncertaintyName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("uncertainty_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_ideal_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an ideal about the given predicate.", returns="true if an ideal already exists.", examples={@GamlAnnotations.example(value="has_ideal_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasIdeal(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_ideal_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an ideal about the given name.", returns="true if an ideal already exists.", examples={@GamlAnnotations.example(value="has_ideal_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasIdealName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("ideal_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_intention_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an intention about the given predicate.", returns="true if an intention already exists.", examples={@GamlAnnotations.example(value="has_intention_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasIntention(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_intention_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an intention about the given name.", returns="true if an intention already exists.", examples={@GamlAnnotations.example(value="has_intention_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasIntentionName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("intention_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_obligation_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an obligation about the given predicate.", returns="true if an obligation already exists.", examples={@GamlAnnotations.example(value="has_obligation_op(self,predicate(\"has_water\"))", equals="false")})
    public static Boolean hasObligation(IScope iScope, IAgent iAgent, Predicate predicate) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (predicate != null) {
            IList iList = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !predicate.equals(mentalState.getPredicate())) continue;
                bl = true;
            }
        }
        return bl;
    }

    @GamlAnnotations.operator(value={"has_obligation_with_name_op"}, can_be_const=true, content_type=3, category={"BDI"}, concept={"bdi"})
    @GamlAnnotations.doc(value="indicates if there already is an obligation about the given name.", returns="true if an obligation already exists.", examples={@GamlAnnotations.example(value="has_obligation_with_name_op(self,\"has_water\")", equals="false")})
    public static Boolean hasObligationName(IScope iScope, IAgent iAgent, String string) throws GamaRuntimeException {
        boolean bl = false;
        if (!(iAgent.getSpecies().getArchitecture() instanceof SimpleBdiArchitecture)) {
            return bl;
        }
        if (string != null) {
            IList iList = (IList)iAgent.getAttribute("obligation_base");
            for (MentalState mentalState : iList) {
                if (mentalState.getPredicate() == null || !string.equals(mentalState.getPredicate().getName())) continue;
                bl = true;
            }
        }
        return bl;
    }
}

