/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.LawStatement;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Norm;
import gama.extension.bdi.Predicate;
import gama.extension.bdi.Sanction;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import java.util.Optional;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the enforcement")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="A boolean value to enforce only with a certain condition")}), @GamlAnnotations.facet(name="norm", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The norm to enforce")}), @GamlAnnotations.facet(name="obligation", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The obligation to enforce")}), @GamlAnnotations.facet(name="law", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The law to enforce")}), @GamlAnnotations.facet(name="sanction", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The sanction to apply if the norm is violated")}), @GamlAnnotations.facet(name="reward", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The positive sanction to apply if the norm has been followed")})})
@GamlAnnotations.doc(value="apply a sanction if the norm specified is violated, or a reward if the norm is applied by the perceived agent", examples={@GamlAnnotations.example(value="focus var:speed; //where speed is a variable from a species that is being perceived")})
public class EnforcementStatement
extends AbstractStatement {
    public static final String ENFORCEMENT = "enforcement";
    public static final String NORM = "norm";
    public static final String SANCTION = "sanction";
    public static final String REWARD = "reward";
    public static final String OBLIGATION = "obligation";
    public static final String LAW = "law";
    final IExpression nameExpr = this.getFacet(new String[]{"name"});
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression norm = this.getFacet(new String[]{"norm"});
    final IExpression sanction = this.getFacet(new String[]{"sanction"});
    final IExpression reward = this.getFacet(new String[]{"reward"});
    final IExpression obligation = this.getFacet(new String[]{"obligation"});
    final IExpression law = this.getFacet(new String[]{"law"});

    public EnforcementStatement(IDescription iDescription) {
        super(iDescription);
    }

    /*
     * WARNING - void declaration
     */
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = null;
        if (this.when == null || Cast.asBool((IScope)iScope, (Object)this.when.value(iScope)).booleanValue()) {
            MentalState mentalState;
            Object object2;
            IAgent[] iAgentArray = iScope.getAgentsStack();
            IAgent iAgent = iAgentArray[iAgentArray.length - 2];
            IScope iScope2 = null;
            if (iAgent != null) {
                iScope2 = iAgent.getScope().copy("in EnforcementStatement");
                iScope2.push(iAgent);
            }
            if (this.norm != null) {
                for (Norm norm : BdiUtils.getNorms(iScope)) {
                    void var8_13;
                    if (!norm.getName().equals(this.norm.value(iScope2))) continue;
                    if (norm.getViolated().booleanValue() && this.sanction != null) {
                        Object object3 = this.sanction.value(iScope2);
                    } else {
                        if (!norm.getApplied().booleanValue() || this.reward == null) continue;
                        Object object4 = this.reward.value(iScope2);
                    }
                    object2 = BdiUtils.getSanctions(iScope2).stream().filter(sanction -> object4.equals(sanction.getName())).findFirst();
                    if (!((Optional)object2).isPresent()) continue;
                    object = ((Sanction)((Optional)object2).get()).getSanctionStatement().executeOn(iScope2);
                    break;
                }
            }
            if (this.obligation != null && BdiUtils.hasObligation(iScope, mentalState = new MentalState(OBLIGATION, (Predicate)this.obligation.value(iScope))).booleanValue()) {
                for (Norm norm : BdiUtils.getNorms(iScope)) {
                    if (!mentalState.getPredicate().equals(norm.getObligation(iScope)) || norm.getSanctioned().booleanValue()) continue;
                    if (norm.getApplied().booleanValue() && this.reward != null) {
                        object2 = this.reward.value(iScope2);
                    } else {
                        if (this.sanction == null) continue;
                        object2 = this.sanction.value(iScope2);
                    }
                    Optional<Sanction> optional = BdiUtils.getSanctions(iScope2).stream().filter(sanction -> object2.equals(sanction.getName())).findFirst();
                    if (optional.isPresent()) {
                        object = optional.get().getSanctionStatement().executeOn(iScope2);
                        break;
                    }
                    norm.sanctioned();
                }
            }
            if (this.law != null) {
                double d = (Double)iScope.getAgent().getAttribute("obedience");
                for (LawStatement lawStatement : BdiUtils.getLaws(iScope)) {
                    if (!lawStatement.getName().equals(this.law.value(iScope2))) continue;
                    object = this.applySanctionOrReward(iScope, iScope2, lawStatement, d);
                    break;
                }
            }
            GAMA.releaseScope((IScope)iScope2);
        }
        return object;
    }

    private Object applySanctionOrReward(IScope iScope, IScope iScope2, LawStatement lawStatement, double d) {
        block4: {
            block3: {
                boolean bl;
                boolean bl2 = lawStatement.getContextExpression() == null || Cast.asBool((IScope)iScope, (Object)lawStatement.getContextExpression().value(iScope)) != false;
                boolean bl3 = lawStatement.getBeliefExpression() == null || lawStatement.getBeliefExpression().value(iScope) == null || BdiUtils.hasBelief(iScope, new MentalState("Belief", (Predicate)lawStatement.getBeliefExpression().value(iScope))) != false;
                boolean bl4 = lawStatement.getObligationExpression() == null || lawStatement.getObligationExpression().value(iScope) == null || BdiUtils.hasObligation(iScope, new MentalState("Obligation", (Predicate)lawStatement.getObligationExpression().value(iScope))) != false;
                boolean bl5 = lawStatement.getThreshold() == null || lawStatement.getThreshold().value(iScope) == null || d >= (Double)lawStatement.getThreshold().value(iScope);
                boolean bl6 = bl = bl2 && bl3 && bl4 && bl5;
                if (!bl) break block3;
                if (this.reward == null) break block4;
                for (Sanction sanction : BdiUtils.getSanctions(iScope2)) {
                    if (!sanction.getName().equals(this.reward.value(iScope2))) continue;
                    return sanction.getSanctionStatement().executeOn(iScope2);
                }
                break block4;
            }
            if (this.sanction != null) {
                for (Sanction sanction : BdiUtils.getSanctions(iScope2)) {
                    if (!sanction.getName().equals(this.sanction.value(iScope2))) continue;
                    return sanction.getSanctionStatement().executeOn(iScope2);
                }
            }
        }
        return null;
    }
}

