/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.MentalState;
import gama.extension.bdi.Predicate;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;
import java.util.function.BiConsumer;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="id", type={4}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the focus")}), @GamlAnnotations.facet(name="var", type={0, 5, 16}, optional=true, doc={@GamlAnnotations.doc(value="the variable of the perceived agent you want to add to your beliefs")}), @GamlAnnotations.facet(name="expression", type={0}, optional=true, doc={@GamlAnnotations.doc(value="an expression that will be the value kept in the belief")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="A boolean value to focus only with a certain condition")}), @GamlAnnotations.facet(name="lifetime", type={1}, optional=true, doc={@GamlAnnotations.doc(value="the lifetime value of the created belief")}), @GamlAnnotations.facet(name="truth", type={3}, optional=true, doc={@GamlAnnotations.doc(value="the truth value of the created belief")}), @GamlAnnotations.facet(name="agent_cause", type={11}, optional=true, doc={@GamlAnnotations.doc(value="the value of the agent causing the created belief (can be nil")}), @GamlAnnotations.facet(name="belief", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The predicate to focus on the beliefs of the other agent")}), @GamlAnnotations.facet(name="desire", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The predicate to focus on the desires of the other agent")}), @GamlAnnotations.facet(name="emotion", type={546706}, optional=true, doc={@GamlAnnotations.doc(value="The emotion to focus on the emotions of the other agent")}), @GamlAnnotations.facet(name="uncertainty", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The predicate to focus on the uncertainties of the other agent")}), @GamlAnnotations.facet(name="ideal", type={546704}, optional=true, doc={@GamlAnnotations.doc(value="The predicate to focus on the ideals of the other agent")}), @GamlAnnotations.facet(name="is_uncertain", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean to indicate if the mental state created is an uncertainty")}), @GamlAnnotations.facet(name="strength", type={2, 1}, optional=true, doc={@GamlAnnotations.doc(value="The priority of the created predicate")})})
@GamlAnnotations.doc(value="enables to directly add a belief from the variable of a perceived species.", examples={@GamlAnnotations.example(value="focus var:speed /*where speed is a variable from a species that is being perceived*/")})
public class FocusStatement
extends AbstractStatement {
    public static final String FOCUS = "focus";
    public static final String STRENGTH = "strength";
    public static final String EXPRESSION = "expression";
    public static final String VAR = "var";
    public static final String BELIEF = "belief";
    public static final String DESIRE = "desire";
    public static final String UNCERTAINTY = "uncertainty";
    public static final String IDEAL = "ideal";
    public static final String EMOTION = "emotion";
    public static final String LIFETIME = "lifetime";
    public static final String TRUTH = "truth";
    public static final String AGENTCAUSE = "agent_cause";
    public static final String ISUNCERTAIN = "is_uncertain";
    final IExpression nameExpression = this.getFacet(new String[]{"id"});
    final IExpression variable = this.getFacet(new String[]{"var"});
    final IExpression expression = this.getFacet(new String[]{"expression"});
    final IExpression belief = this.getFacet(new String[]{"belief"});
    final IExpression desire = this.getFacet(new String[]{"desire"});
    final IExpression uncertainty = this.getFacet(new String[]{"uncertainty"});
    final IExpression ideal = this.getFacet(new String[]{"ideal"});
    final IExpression emotion = this.getFacet(new String[]{"emotion"});
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression strength = this.getFacet(new String[]{"strength"});
    final IExpression lifetime = this.getFacet(new String[]{"lifetime"});
    final IExpression truth = this.getFacet(new String[]{"truth"});
    final IExpression agentCause = this.getFacet(new String[]{"agent_cause"});
    final IExpression isUncertain = this.getFacet(new String[]{"is_uncertain"});

    public FocusStatement(IDescription iDescription) {
        super(iDescription);
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        IAgent[] iAgentArray;
        if (this.when != null && !Cast.asBool((IScope)iScope, (Object)this.when.value(iScope)).booleanValue()) {
            return null;
        }
        IAgent iAgent = iAgentArray[(iAgentArray = iScope.getAgentsStack()).length > 2 ? 1 : 0];
        IScope iScope2 = null;
        if (iAgent != null) {
            iScope2 = iAgent.getScope().copy("in FocusStatement");
            iScope2.push(iAgent);
        }
        if (this.variable != null) {
            Object object = this.variable.value(iScope);
            if (object instanceof IContainer) {
                IContainer iContainer = (IContainer)object;
                this.buildAndAddBeliefFromVariableList(iScope, iScope2, iContainer);
            } else {
                this.buildAndAddBeliefFromSingleVariable(iScope, iScope2);
            }
        } else if (this.belief != null || this.desire != null || this.uncertainty != null || this.ideal != null || this.emotion != null || this.expression != null) {
            this.buildAndAddBeliefFromFacets(iScope, iScope2);
        } else {
            this.buildAndAddDefaultBelief(iScope, iScope2);
        }
        GAMA.releaseScope((IScope)iScope2);
        return null;
    }

    private void buildAndAddBeliefFromFacets(IScope iScope, IScope iScope2) {
        Object object;
        if (this.belief != null) {
            object = new MentalState("Belief");
            ((MentalState)object).setPredicate((Predicate)this.belief.value(iScope));
            if (BdiUtils.hasBelief(iScope, (MentalState)object).booleanValue()) {
                this.addMentalState(iScope, iScope2, iScope, (List)BdiUtils.getBase(iScope, "belief_base"), (Object)object, (BiConsumer)(mentalState, mentalState2) -> mentalState.setMentalState((MentalState)mentalState2));
            }
        }
        if (this.desire != null) {
            object = new MentalState("Desire");
            ((MentalState)object).setPredicate((Predicate)this.desire.value(iScope));
            if (BdiUtils.hasDesire(iScope, (MentalState)object).booleanValue()) {
                this.addMentalState(iScope, iScope2, iScope, (List)BdiUtils.getBase(iScope, "desire_base"), (Object)object, (BiConsumer)(mentalState, mentalState2) -> mentalState.setMentalState((MentalState)mentalState2));
            }
        }
        if (this.uncertainty != null) {
            object = new MentalState("Uncertainty");
            ((MentalState)object).setPredicate((Predicate)this.uncertainty.value(iScope));
            if (BdiUtils.hasUncertainty(iScope, (MentalState)object).booleanValue()) {
                this.addMentalState(iScope, iScope2, iScope, (List)BdiUtils.getBase(iScope, "uncertainty_base"), (Object)object, (BiConsumer)(mentalState, mentalState2) -> mentalState.setMentalState((MentalState)mentalState2));
            }
        }
        if (this.ideal != null) {
            object = new MentalState("Ideal");
            ((MentalState)object).setPredicate((Predicate)this.ideal.value(iScope));
            if (BdiUtils.hasIdeal(iScope, (MentalState)object).booleanValue()) {
                this.addMentalState(iScope, iScope2, iScope, (List)BdiUtils.getBase(iScope, "ideal_base"), (Object)object, (BiConsumer)(mentalState, mentalState2) -> mentalState.setMentalState((MentalState)mentalState2));
            }
        }
        if (this.emotion != null && BdiUtils.hasEmotion(iScope, (Emotion)(object = (Emotion)this.emotion.value(iScope))).booleanValue()) {
            this.addMentalState(iScope, iScope2, iScope, (List)BdiUtils.getEmotionBase(iScope, "emotion_base"), (Object)object, (BiConsumer)(mentalState, emotion) -> mentalState.setEmotion((Emotion)emotion));
        }
        if (this.expression != null) {
            object = this.nameExpression != null ? (String)this.nameExpression.value(iScope) : "expression_" + iScope.getAgent().getSpeciesName();
            IMap iMap = GamaMapFactory.create((IType)Types.NO_TYPE, (IType)Types.NO_TYPE, (int)1);
            iMap.put((Object)"expression_value", this.expression.value(iScope));
            Predicate predicate = new Predicate((String)object, (IMap<String, Object>)iMap);
            if (this.truth != null) {
                predicate.setIs_True(Cast.asBool((IScope)iScope, (Object)this.truth.value(iScope)));
            }
            predicate.setAgentCause(this.agentCause != null ? (IAgent)this.agentCause.value(iScope) : iScope.getAgent());
        }
    }

    private <T> void addMentalState(IScope iScope, IScope iScope2, IScope iScope3, List<T> list, T t, BiConsumer<MentalState, T> biConsumer) {
        MentalState mentalState = null;
        mentalState = this.isUncertain != null && (Boolean)this.isUncertain.value(iScope2) != false ? new MentalState("Uncertainty") : new MentalState("Belief");
        for (T t2 : list) {
            if (!t2.equals(t)) continue;
            t = t2;
        }
        biConsumer.accept(mentalState, (MentalState)t);
        if (this.strength != null) {
            mentalState.setStrength(Cast.asFloat((IScope)iScope, (Object)this.strength.value(iScope)));
        }
        if (this.lifetime != null) {
            mentalState.setLifeTime(Cast.asInt((IScope)iScope3, (Object)this.lifetime.value(iScope)));
        }
        if (this.isUncertain != null && ((Boolean)this.isUncertain.value(iScope2)).booleanValue()) {
            if (!BdiUtils.hasUncertainty(iScope2, mentalState).booleanValue()) {
                BdiUtils.addUncertainty(iScope2, mentalState);
            }
        } else if (!BdiUtils.hasBelief(iScope2, mentalState).booleanValue()) {
            BdiUtils.addBelief(iScope2, mentalState);
        }
    }

    private void buildAndAddDefaultBelief(IScope iScope, IScope iScope2) {
        String string = null;
        if (this.nameExpression != null) {
            string = (String)this.nameExpression.value(iScope);
        }
        Predicate predicate = new Predicate(string);
        if (this.truth != null) {
            predicate.setIs_True(Cast.asBool((IScope)iScope, (Object)this.truth.value(iScope)));
        }
        predicate.setAgentCause(this.agentCause != null ? (IAgent)this.agentCause.value(iScope) : iScope.getAgent());
        this.addBelief(iScope2, iScope2, iScope, predicate);
    }

    private void buildAndAddBeliefFromSingleVariable(IScope iScope, IScope iScope2) {
        String string = this.nameExpression != null ? (String)this.nameExpression.value(iScope) : this.variable.getName() + "_" + iScope.getAgent().getSpeciesName();
        String string2 = this.variable.getName();
        IMap iMap = GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE, (int)1);
        iMap.put((Object)(string2 + "_value"), this.expression != null ? this.expression.value(iScope) : this.variable.value(iScope));
        Predicate predicate = new Predicate(string, (IMap<String, Object>)iMap);
        if (this.truth != null) {
            predicate.setIs_True(Cast.asBool((IScope)iScope, (Object)this.truth.value(iScope)));
        }
        predicate.setAgentCause(this.agentCause != null ? (IAgent)this.agentCause.value(iScope) : iScope.getAgent());
        this.addBelief(iScope, iScope2, iScope, predicate);
    }

    private void addBelief(IScope iScope, IScope iScope2, IScope iScope3, Predicate predicate) {
        if (this.isUncertain != null && ((Boolean)this.isUncertain.value(iScope2)).booleanValue()) {
            MentalState mentalState = this.strength != null ? new MentalState("Uncertainty", predicate, Cast.asFloat((IScope)iScope, (Object)this.strength.value(iScope))) : new MentalState("Uncertainty", predicate);
            if (this.lifetime != null) {
                mentalState.setLifeTime(Cast.asInt((IScope)iScope2, (Object)this.lifetime.value(iScope)));
            }
            if (!BdiUtils.hasUncertainty(iScope2, mentalState).booleanValue()) {
                BdiUtils.addUncertainty(iScope2, mentalState);
            }
        } else {
            MentalState mentalState = this.strength != null ? new MentalState("Belief", predicate, Cast.asFloat((IScope)iScope, (Object)this.strength.value(iScope))) : new MentalState("Belief", predicate);
            if (this.lifetime != null) {
                mentalState.setLifeTime(Cast.asInt((IScope)iScope3, (Object)this.lifetime.value(iScope)));
            }
            if (!BdiUtils.hasBelief(iScope2, mentalState).booleanValue()) {
                BdiUtils.addBelief(iScope2, mentalState);
            }
        }
    }

    private void buildAndAddBeliefFromVariableList(IScope iScope, IScope iScope2, IContainer iContainer) {
        IMap iMap = GamaMapFactory.create((IType)Types.STRING, (IType)Types.NO_TYPE, (int)1);
        IList iList = iContainer.listValue(iScope, null, true);
        int n = 0;
        while (n < iList.length(iScope)) {
            iMap.put((Object)("test" + n + "_value"), (Object)Cast.asInt((IScope)iScope, (Object)iList.get(n)));
            ++n;
        }
        Predicate predicate = new Predicate((String)(this.nameExpression != null ? (String)this.nameExpression.value(iScope) : this.variable.getName() + "_" + iScope.getAgent().getSpeciesName()), (IMap<String, Object>)iMap.copy(iScope));
        if (this.truth != null) {
            predicate.setIs_True(Cast.asBool((IScope)iScope, (Object)this.truth.value(iScope)));
        }
        predicate.setAgentCause(this.agentCause != null ? (IAgent)this.agentCause.value(iScope) : iScope.getAgent());
        this.addBelief(iScope, iScope2, iScope, predicate);
    }
}

