/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.extension.bdi.Predicate;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Objects;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="name", type=4, doc={@GamlAnnotations.doc(value="the name of the emotion")}), @GamlAnnotations.variable(name="intensity", type=2, doc={@GamlAnnotations.doc(value="the intensity of the emotion (between 0 and 1)")}), @GamlAnnotations.variable(name="about", type=546704, doc={@GamlAnnotations.doc(value="the predicate about which is the emotion")}), @GamlAnnotations.variable(name="decay", type=2, doc={@GamlAnnotations.doc(value="the decay value of the emotion")}), @GamlAnnotations.variable(name="cause", type=11, doc={@GamlAnnotations.doc(value="the agent causing the emotion")}), @GamlAnnotations.variable(name="owner", type=11, doc={@GamlAnnotations.doc(value="the agent owning the emotion")})})
public class Emotion
implements IValue {
    public static final String DECAY = "decay";
    public static final String ABOUT = "about";
    String name;
    double intensity = -1.0;
    Predicate about;
    double decay = 0.0;
    IAgent agentCause;
    IAgent owner;
    private boolean hasIntensity = false;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "name", (Object)this.name, "intensity", (Object)this.intensity, ABOUT, (Object)(this.about == null ? null : this.about.getName()), DECAY, (Object)this.decay).add("cause", (Object)this.agentCause).add("owner", (Object)this.owner);
    }

    @GamlAnnotations.getter(value="name")
    public String getName() {
        return this.name;
    }

    @GamlAnnotations.getter(value="intensity")
    public Double getIntensity() {
        return this.intensity;
    }

    @GamlAnnotations.getter(value="about")
    public Predicate getAbout() {
        return this.about;
    }

    @GamlAnnotations.getter(value="decay")
    public Double getDecay() {
        return this.decay;
    }

    @GamlAnnotations.getter(value="cause")
    public IAgent getAgentCause() {
        return this.agentCause;
    }

    @GamlAnnotations.getter(value="owner")
    public IAgent getOwner() {
        return this.owner;
    }

    public boolean hasIntensity() {
        return this.hasIntensity;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIntensity(double d) {
        this.intensity = d;
        this.hasIntensity = true;
    }

    public void setAbout(Predicate predicate) {
        this.about = predicate;
    }

    public void setDecay(double d) {
        this.decay = d;
    }

    public void setAgentCause(IAgent iAgent) {
        this.agentCause = iAgent;
    }

    public void setOwner(IAgent iAgent) {
        this.owner = iAgent;
    }

    public Emotion() {
        this.name = "";
        this.about = null;
        this.agentCause = null;
        this.owner = null;
    }

    public Emotion(String string) {
        this.name = string;
        this.about = null;
        this.agentCause = null;
        this.owner = null;
    }

    public Emotion(String string, double d) {
        this.name = string;
        this.intensity = d;
        this.about = null;
        this.agentCause = null;
        this.owner = null;
        this.hasIntensity = true;
    }

    public Emotion(String string, Predicate predicate) {
        this.name = string;
        this.about = predicate;
        this.agentCause = null;
        this.owner = null;
    }

    public Emotion(String string, IAgent iAgent) {
        this.name = string;
        this.about = null;
        this.agentCause = iAgent;
        this.owner = null;
    }

    public Emotion(String string, double d, double d2) {
        this.name = string;
        this.about = null;
        this.agentCause = null;
        this.owner = null;
        this.decay = d2;
        this.intensity = d;
        this.hasIntensity = true;
    }

    public Emotion(String string, double d, Predicate predicate) {
        this.name = string;
        this.about = predicate;
        this.agentCause = null;
        this.owner = null;
        this.intensity = d;
        this.hasIntensity = true;
    }

    public Emotion(String string, Predicate predicate, IAgent iAgent) {
        this.name = string;
        this.about = predicate;
        this.agentCause = iAgent;
        this.owner = null;
    }

    public Emotion(String string, double d, IAgent iAgent) {
        this.name = string;
        this.about = null;
        this.owner = null;
        this.intensity = d;
        this.hasIntensity = true;
        this.agentCause = iAgent;
    }

    public Emotion(String string, double d, Predicate predicate, double d2) {
        this.name = string;
        this.intensity = d;
        this.hasIntensity = true;
        this.about = predicate;
        this.agentCause = null;
        this.owner = null;
        this.decay = d2;
    }

    public Emotion(String string, double d, double d2, IAgent iAgent) {
        this.about = null;
        this.owner = null;
        this.name = string;
        this.decay = d2;
        this.intensity = d;
        this.hasIntensity = true;
        this.agentCause = iAgent;
    }

    public Emotion(String string, double d, Predicate predicate, IAgent iAgent) {
        this.name = string;
        this.owner = null;
        this.intensity = d;
        this.hasIntensity = true;
        this.agentCause = iAgent;
        this.about = predicate;
    }

    public Emotion(String string, double d, Predicate predicate, double d2, IAgent iAgent) {
        this.name = string;
        this.owner = null;
        this.decay = d2;
        this.about = predicate;
        this.intensity = d;
        this.hasIntensity = true;
        this.agentCause = iAgent;
    }

    public void decayIntensity() {
        this.intensity -= this.decay;
    }

    public String toString() {
        return this.serializeToGaml(true);
    }

    public String serializeToGaml(boolean bl) {
        if (this.intensity > 0.0) {
            return "emotion(" + this.name + "," + this.intensity + "," + String.valueOf(this.about) + "," + this.decay + "," + String.valueOf(this.agentCause) + "," + String.valueOf(this.owner) + ")";
        }
        return "emotion(" + this.name + "," + String.valueOf(this.about) + "," + this.decay + "," + String.valueOf(this.agentCause) + "," + String.valueOf(this.owner) + ")";
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.name;
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        return new Emotion(this.name, this.intensity, this.about, this.decay, this.agentCause);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Emotion emotion = (Emotion)object;
        if (!Objects.equals(this.name, emotion.name)) {
            return false;
        }
        if (this.about != null && (emotion.about == null || !this.about.equalsEmotions(emotion.about)) || this.about == null && emotion.about != null) {
            return false;
        }
        return Objects.equals(this.owner, emotion.owner);
    }

    public IType<?> getGamlType() {
        return Types.get((int)546706);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

