/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.extension.bdi.Emotion;
import gama.extension.bdi.Predicate;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.List;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="modality", type=4, doc={@GamlAnnotations.doc(value="the modality of the mental state")}), @GamlAnnotations.variable(name="predicate", type=546704, doc={@GamlAnnotations.doc(value="the predicate about which is the mental state")}), @GamlAnnotations.variable(name="mental_state", type=546708, doc={@GamlAnnotations.doc(value="the mental state about which is the mental state")}), @GamlAnnotations.variable(name="emotion", type=546706, doc={@GamlAnnotations.doc(value="the emotion about which is the mental state")}), @GamlAnnotations.variable(name="owner", type=11, doc={@GamlAnnotations.doc(value="the owner of the mental state")}), @GamlAnnotations.variable(name="strength", type=2, doc={@GamlAnnotations.doc(value="the strength value related to the mental state")}), @GamlAnnotations.variable(name="lifetime", type=1, doc={@GamlAnnotations.doc(value="the lifetime of the mental state")})})
public class MentalState
implements IValue {
    public static final String STRENGTH = "strength";
    String modality;
    Predicate predicate;
    Double strength;
    int lifetime = -1;
    boolean isUpdated = false;
    MentalState mental;
    Emotion emo;
    IAgent owner;
    List<MentalState> onHoldUntil;
    List<MentalState> subintentions;
    MentalState superIntention;

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "modality", (Object)this.modality, "mental_state", (Object)this.mental, "predicate", (Object)(this.predicate == null ? null : this.predicate.getName()), "emotion", this.emo == null ? null : this.emo.name).add(STRENGTH, (Object)this.strength).add("owner", (Object)this.owner).add("lifetime", this.lifetime);
    }

    @GamlAnnotations.getter(value="modality")
    public String getModality() {
        return this.modality;
    }

    @GamlAnnotations.getter(value="predicate")
    public Predicate getPredicate() {
        return this.predicate;
    }

    @GamlAnnotations.getter(value="mental_state")
    public MentalState getMentalState() {
        return this.mental;
    }

    @GamlAnnotations.getter(value="emotion")
    public Emotion getEmotion() {
        return this.emo;
    }

    @GamlAnnotations.getter(value="strength")
    public Double getStrength() {
        return this.strength;
    }

    @GamlAnnotations.getter(value="lifetime")
    public int getLifeTime() {
        return this.lifetime;
    }

    @GamlAnnotations.getter(value="owner")
    public IAgent getOwner() {
        return this.owner;
    }

    @GamlAnnotations.getter(value="subintentions")
    public List<MentalState> getSubintentions() {
        return this.subintentions;
    }

    @GamlAnnotations.getter(value="superIntention")
    public MentalState getSuperIntention() {
        return this.superIntention;
    }

    public List<MentalState> getOnHoldUntil() {
        return this.onHoldUntil;
    }

    public void setModality(String string) {
        this.modality = string;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public void setMentalState(MentalState mentalState) {
        this.mental = mentalState;
    }

    public void setEmotion(Emotion emotion) {
        this.emo = emotion;
    }

    public void setStrength(Double d) {
        this.strength = d;
    }

    public void setLifeTime(int n) {
        this.lifetime = n;
    }

    public void setOwner(IAgent iAgent) {
        this.owner = iAgent;
    }

    public void setSubintentions(List<MentalState> list) {
        this.subintentions = list;
    }

    public void setSuperIntention(MentalState mentalState) {
        this.superIntention = mentalState;
    }

    public void setOnHoldUntil(List<MentalState> list) {
        this.onHoldUntil = list;
    }

    public void updateLifetime() {
        if (this.lifetime > 0 && !this.isUpdated) {
            --this.lifetime;
            this.isUpdated = true;
        }
    }

    public MentalState() {
        this.modality = "";
        this.predicate = null;
        this.mental = null;
        this.strength = 1.0;
        this.owner = null;
        this.emo = null;
    }

    public MentalState(String string) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = 1.0;
        this.owner = null;
        this.emo = null;
    }

    public MentalState(String string, Predicate predicate) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = 1.0;
        this.owner = null;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = 1.0;
        this.owner = null;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = 1.0;
        this.owner = null;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, IAgent iAgent) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = 1.0;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = 1.0;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = 1.0;
        this.owner = iAgent;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, Double d) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = d;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, Double d) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = d;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, Double d) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = d;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, int n) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.lifetime = n;
        this.strength = 1.0;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, int n) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.lifetime = n;
        this.strength = 1.0;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, int n) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.lifetime = n;
        this.strength = 1.0;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, Double d, int n) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = d;
        this.lifetime = n;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, Double d, int n) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = d;
        this.lifetime = n;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, Double d, int n) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = d;
        this.lifetime = n;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, Double d, IAgent iAgent) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = d;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, Double d, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = d;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, Double d, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = d;
        this.owner = iAgent;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = 1.0;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = 1.0;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = 1.0;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = emotion;
    }

    public MentalState(String string, Predicate predicate, Double d, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = predicate;
        this.mental = null;
        this.strength = d;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, MentalState mentalState, Double d, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = mentalState;
        this.strength = d;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = null;
    }

    public MentalState(String string, Emotion emotion, Double d, int n, IAgent iAgent) {
        this.modality = string;
        this.predicate = null;
        this.mental = null;
        this.strength = d;
        this.lifetime = n;
        this.owner = iAgent;
        this.emo = emotion;
    }

    public String toString() {
        return this.serializeToGaml(true);
    }

    public String serializeToGaml(boolean bl) {
        return this.modality + "(" + String.valueOf(this.predicate == null ? "" : this.predicate) + String.valueOf(this.mental == null ? "" : this.mental) + String.valueOf(this.emo == null ? "" : this.emo) + "," + String.valueOf(this.owner == null ? "" : this.owner) + "," + String.valueOf(this.strength) + "," + this.lifetime + ")";
    }

    public IType<?> getGamlType() {
        return Types.get((int)546708);
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.modality + "(" + String.valueOf(this.predicate == null ? "" : this.predicate) + String.valueOf(this.mental == null ? "" : this.mental) + String.valueOf(this.emo == null ? "" : this.emo) + "," + String.valueOf(this.owner == null ? "" : this.owner) + "," + String.valueOf(this.strength) + "," + this.lifetime + ")";
    }

    public IValue copy(IScope iScope) throws GamaRuntimeException {
        MentalState mentalState = new MentalState(this.modality);
        mentalState.setLifeTime(this.lifetime);
        mentalState.setStrength(this.strength);
        mentalState.setOwner(this.owner);
        if (this.predicate != null) {
            mentalState.setPredicate(this.predicate);
            return mentalState;
        }
        if (this.mental != null) {
            mentalState.setMentalState(this.mental);
        } else if (this.emo != null) {
            mentalState.setEmotion(this.emo);
        }
        return mentalState;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MentalState mentalState = (MentalState)object;
        if (this.predicate == null && mentalState.getPredicate() != null || this.predicate != null && mentalState.getPredicate() == null) {
            return false;
        }
        if (this.predicate != null && mentalState.getPredicate() != null && !mentalState.getPredicate().equals(this.predicate)) {
            return false;
        }
        if (this.mental == null && mentalState.getMentalState() != null) {
            return false;
        }
        if (this.mental != null && mentalState.getMentalState() == null) {
            return false;
        }
        if (this.mental != null && mentalState.getMentalState() != null && !mentalState.getMentalState().equals(this.mental)) {
            return false;
        }
        if (this.emo == null && mentalState.getEmotion() != null) {
            return false;
        }
        if (this.emo != null && mentalState.getEmotion() == null) {
            return false;
        }
        if (this.emo != null && mentalState.getEmotion() != null && !mentalState.getEmotion().equals(this.emo)) {
            return false;
        }
        return this.owner == null || mentalState.getOwner() == null || mentalState.getOwner().equals(this.owner);
    }
}

