/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.bdi;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.bdi.BdiUtils;
import gama.extension.bdi.SocialLink;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={3, 11})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="the identifier of the socialize statement")}), @GamlAnnotations.facet(name="liking", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the appreciation value of the created social link")}), @GamlAnnotations.facet(name="dominance", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the dominance value of the created social link")}), @GamlAnnotations.facet(name="solidarity", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the solidarity value of the created social link")}), @GamlAnnotations.facet(name="familiarity", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the familiarity value of the created social link")}), @GamlAnnotations.facet(name="trust", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the trust value of the created social link")}), @GamlAnnotations.facet(name="agent", type={11}, optional=true, doc={@GamlAnnotations.doc(value="the agent value of the created social link")}), @GamlAnnotations.facet(name="when", type={3}, optional=true, doc={@GamlAnnotations.doc(value="A boolean value to socialize only with a certain condition")})}, omissible="name")
@GamlAnnotations.doc(value="enables to directly add a social link from a perceived agent.", examples={@GamlAnnotations.example(value="do socialize;")})
public class SocializeStatement
extends AbstractStatement {
    public static final String SOCIALIZE = "socialize";
    public static final String LIKING = "liking";
    public static final String DOMINANCE = "dominance";
    public static final String SOLIDARITY = "solidarity";
    public static final String FAMILIARITY = "familiarity";
    public static final String TRUST = "trust";
    public static final String AGENT = "agent";
    final IExpression name = this.getFacet(new String[]{"name"});
    final IExpression appreciation = this.getFacet(new String[]{"liking"});
    final IExpression dominance = this.getFacet(new String[]{"dominance"});
    final IExpression when = this.getFacet(new String[]{"when"});
    final IExpression solidarity = this.getFacet(new String[]{"solidarity"});
    final IExpression familiarity = this.getFacet(new String[]{"familiarity"});
    final IExpression trust = this.getFacet(new String[]{"trust"});
    final IExpression agent = this.getFacet(new String[]{"agent"});

    public SocializeStatement(IDescription iDescription) {
        super(iDescription);
    }

    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (this.when != null && !Cast.asBool((IScope)iScope, (Object)this.when.value(iScope)).booleanValue()) {
            return null;
        }
        IAgent[] iAgentArray = iScope.getAgentsStack();
        IAgent iAgent = iAgentArray[iAgentArray.length - 2];
        IScope iScope2 = null;
        if (iAgent != null) {
            iScope2 = iAgent.getScope().copy("in SocializeStatement");
            iScope2.push(iAgent);
        }
        if (!iScope.getAgent().equals(iAgent)) {
            SocialLink socialLink = new SocialLink(iScope.getAgent());
            if (!BdiUtils.hasSocialLink(iScope2, socialLink).booleanValue()) {
                if (this.appreciation != null) {
                    socialLink.setLiking(Cast.asFloat((IScope)iScope2, (Object)this.appreciation.value(iScope2)));
                }
                if (this.dominance != null) {
                    socialLink.setDominance(Cast.asFloat((IScope)iScope2, (Object)this.dominance.value(iScope2)));
                }
                if (this.solidarity != null) {
                    socialLink.setSolidarity(Cast.asFloat((IScope)iScope2, (Object)this.solidarity.value(iScope2)));
                }
                if (this.familiarity != null) {
                    socialLink.setFamiliarity(Cast.asFloat((IScope)iScope2, (Object)this.familiarity.value(iScope2)));
                }
                if (this.trust != null) {
                    socialLink.setTrust(Cast.asFloat((IScope)iScope2, (Object)this.trust.value(iScope2)));
                }
                if (this.agent != null) {
                    socialLink.setAgent((IAgent)this.agent.value(iScope2));
                }
                BdiUtils.addSocialLink(iScope2, socialLink);
            } else {
                socialLink = BdiUtils.getSocialLink(iScope2, socialLink);
                BdiUtils.updateSocialLink(iScope2, socialLink);
            }
        }
        GAMA.releaseScope((IScope)iScope2);
        return null;
    }
}

