/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.utils.sql;

import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.ISqlConnector;
import gama.extension.database.utils.sql.SqlConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class SqlUtils {
    public static final Map<String, ISqlConnector> externalConnectors = new HashMap<String, ISqlConnector>();

    public static SqlConnection createConnectionObject(IScope iScope, Map<String, Object> map) throws GamaRuntimeException {
        String string = ((String)map.get("dbtype")).toLowerCase();
        String string2 = (String)map.get("host");
        String string3 = (String)map.get("port");
        String string4 = (String)map.get("database");
        String string5 = (String)map.get("user");
        String string6 = (String)map.get("passwd");
        boolean bl = map.containsKey("transform") ? (Boolean)map.get("transform") : true;
        SqlConnection sqlConnection = null;
        ISqlConnector iSqlConnector = externalConnectors.get(string);
        if (iSqlConnector == null) {
            throw GamaRuntimeException.error((String)("GAMA does not support databases of type: " + string), (IScope)iScope);
        }
        sqlConnection = iSqlConnector.connection(iScope, string, string2, string3, string4, string5, string6, bl);
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("SqlUtils.createConnection:" + sqlConnection.toString()));
        }
        sqlConnection.setParams(map);
        return sqlConnection;
    }

    public static SqlConnection createConnectionObject(IScope iScope) throws GamaRuntimeException {
        Map map = (Map)iScope.getArg("params", 10);
        return SqlUtils.createConnectionObject(iScope, map);
    }

    public static Geometry read(byte[] byArray) throws IOException, ParseException {
        WKBReader wKBReader = new WKBReader();
        Geometry geometry = wKBReader.read(byArray);
        return geometry;
    }

    public static Geometry inputStream2Geometry(InputStream inputStream) throws Exception {
        Geometry geometry = null;
        if (inputStream != null) {
            byte[] byArray = new byte[255];
            int n = 0;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            if (byArray2.length < 5) {
                throw new Exception("Invalid geometry inputStream - less than five bytes");
            }
            byte[] byArray3 = new byte[4];
            System.arraycopy(byArray2, 0, byArray3, 0, 4);
            boolean bl = byArray2[4] == 0;
            int n2 = 0;
            if (bl) {
                byte[] byArray4 = byArray3;
                int n3 = byArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    var9_13 = byArray4[n4];
                    n2 = (n2 << 8) + (var9_13 & 0xFF);
                    ++n4;
                }
            } else {
                var9_13 = 0;
                while (var9_13 < byArray3.length) {
                    n2 += (byArray3[var9_13] & 0xFF) << 8 * var9_13;
                    ++var9_13;
                }
            }
            WKBReader wKBReader = new WKBReader();
            byte[] byArray5 = new byte[byArray2.length - 4];
            System.arraycopy(byArray2, 4, byArray5, 0, byArray5.length);
            geometry = wKBReader.read(byArray5);
            geometry.setSRID(n2);
        }
        return geometry;
    }

    static IList<Object> transform(IScope iScope, IProjection iProjection, IList<? super IList<Object>> iList, boolean bl) throws GamaRuntimeException {
        try {
            IList iList2 = GamaListFactory.create();
            IList iList3 = GamaListFactory.create();
            IList iList4 = (IList)iList.get(0);
            IList iList5 = (IList)iList.get(1);
            IList iList6 = (IList)iList.get(2);
            int n = iList4.size();
            int n2 = iList6.size();
            iList2.add((Object)iList4);
            iList2.add((Object)iList5);
            int n3 = 0;
            while (n3 < n2) {
                IList iList7 = (IList)iList6.get(n3);
                IList iList8 = GamaListFactory.create();
                int n4 = 0;
                while (n4 < n) {
                    if ("GEOMETRY".equalsIgnoreCase((String)iList5.get(n4))) {
                        Geometry geometry = (Geometry)iList7.get(n4);
                        geometry = bl ? iProjection.inverseTransform(geometry) : iProjection.transform(geometry);
                        iList8.add((Object)geometry);
                    } else {
                        iList8.add(iList7.get(n4));
                    }
                    ++n4;
                }
                iList3.add((Object)iList8);
                ++n3;
            }
            iList2.add((Object)iList3);
            return iList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLConnection.Gis2Absolute: " + exception.toString()), (IScope)iScope);
        }
    }
}

