/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import gama.extension.database.utils.sql.mysql.MySqlConnector;
import gama.extension.database.utils.sql.postgres.PostgresConnector;
import gama.extension.database.utils.sql.sqlite.SqliteConnector;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        SqlUtils.externalConnectors.put("mysql", new MySqlConnector());
        SqlUtils.externalConnectors.put("postgres", new PostgresConnector());
        SqlUtils.externalConnectors.put("postgis", new PostgresConnector());
        SqlUtils.externalConnectors.put("sqlite", new SqliteConnector());
        GeometryUtils.addEnvelopeComputer((iScope, object) -> {
            if (!(object instanceof IMap)) {
                return null;
            }
            IMap iMap = (IMap)object;
            Envelope3D envelope3D = null;
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (SqlConnection sqlConnection = SqlUtils.createConnectionObject(iScope, (Map<String, Object>)iMap);){
                    IList<? super IList<? super IList>> iList = sqlConnection.selectDB(iScope, (String)iMap.get((Object)"select"));
                    envelope3D = SqlConnection.getBounds(iList);
                    IProjection iProjection = iScope.getSimulation().getProjectionFactory().fromParams(iScope, (Map)iMap, envelope3D);
                    envelope3D = iProjection.getProjectedEnvelope();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                throw GamaRuntimeException.error((String)"Error in creating the world envelope from DataBase.", (IScope)iScope);
            }
            return envelope3D;
        });
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

