/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.utils.sql.sqlite;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.sqlite.SQLiteConfig;

public class SqliteConnection
extends SqlConnection {
    public static final String SQLITE = "sqlite";

    public SqliteConnection(String string, String string2, Boolean bl) {
        super(string, string2, bl);
    }

    public SqliteConnection(String string, String string2, String string3, Boolean bl) {
        super(string, string2, bl);
        this.extension = string3;
    }

    @Override
    public Connection connectDB() throws ClassNotFoundException, InstantiationException, SQLException, IllegalAccessException {
        Connection connection = null;
        try {
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig sQLiteConfig = new SQLiteConfig();
            connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbName, sQLiteConfig.toProperties());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new ClassNotFoundException(classNotFoundException.toString());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new SQLException(sQLException.toString());
        }
        return connection;
    }

    @Override
    protected IList<IList<Object>> resultSet2GamaList(ResultSetMetaData resultSetMetaData, ResultSet resultSet) {
        IList iList = GamaListFactory.create((IType)Types.LIST.of((IType)Types.LIST));
        try {
            List<Integer> list = this.getGeometryColumns(resultSetMetaData);
            int n = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                IList iList2 = GamaListFactory.create();
                int n2 = 1;
                while (n2 <= n) {
                    if (list.contains(n2)) {
                        iList2.add((Object)SqlUtils.read(resultSet.getBytes(n2)));
                    } else {
                        iList2.add(resultSet.getObject(n2));
                    }
                    ++n2;
                }
                iList.add((Object)iList2);
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, null);
        }
        return iList;
    }

    @Override
    protected boolean colIsGeometryType(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return SQLITE.equalsIgnoreCase(this.vender) && resultSetMetaData.getColumnType(n) == 2004;
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList, IList<Object> iList2) throws GamaRuntimeException {
        int n = iList.size();
        Object object = "INSERT INTO ";
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        StringBuilder stringBuilder2 = new StringBuilder();
        if (iList2.size() != n) {
            throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
        }
        int n2 = 0;
        while (n2 < n) {
            if (n2 == n - 1) {
                stringBuilder2.append(iList.get(n2));
            } else {
                stringBuilder2.append(iList.get(n2));
                stringBuilder2.append(",");
            }
            ++n2;
        }
        stringBuilder.append((CharSequence)stringBuilder2).append(" FROM ").append(string).append(" LIMIT 1 ;");
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("SqliteConnection.getInsertString.select command:" + stringBuilder.toString()));
        }
        try {
            IList<Object> iList3 = this.getColumnTypeName(iScope, connection, string, iList);
            StringBuilder stringBuilder3 = new StringBuilder();
            int n3 = 0;
            while (n3 < n) {
                if (iList2.get(n3) == null) {
                    stringBuilder3.append("NULL");
                } else if (SqliteConnection.isTextType((String)iList3.get(n3))) {
                    String string2 = iList2.get(n3).toString();
                    string2 = string2.replace("'", "''");
                    stringBuilder3.append("'");
                    stringBuilder3.append(string2);
                    stringBuilder3.append("'");
                } else {
                    stringBuilder3.append(iList2.get(n3));
                }
                if (n3 != n - 1) {
                    stringBuilder3.append(",");
                }
                ++n3;
            }
            object = (String)object + string + "(" + String.valueOf(stringBuilder2) + ") VALUES(" + String.valueOf(stringBuilder3) + ")";
            if (DEBUG.IS_ON()) {
                DEBUG.OUT((Object)("SqliteConnection.getInsertString:" + (String)object));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("SqliteConnection.insertBD " + sQLException.toString()), (IScope)iScope);
        }
        return object;
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO ");
        Object object = "SELECT ";
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        object = (String)object + " *  FROM " + string + " LIMIT 1 ;";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((String)object);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IList<Object> iList2 = this.getColumnName(resultSetMetaData);
            IList<Object> iList3 = this.getColumnTypeName(iScope, connection, string, iList2);
            int n = iList2.size();
            if (iList.size() != iList2.size()) {
                throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
            }
            if (DEBUG.IS_ON()) {
                DEBUG.OUT((Object)("list of column Name:" + String.valueOf(iList2)));
                DEBUG.OUT((Object)("list of column type:" + String.valueOf(iList3)));
            }
            int n2 = 0;
            while (n2 < n) {
                if (iList.get(n2) == null) {
                    stringBuilder3.append("NULL");
                } else if (SqliteConnection.isTextType((String)iList3.get(n2))) {
                    String string2 = iList.get(n2).toString();
                    string2 = string2.replace("'", "''");
                    stringBuilder3.append("'");
                    stringBuilder3.append(string2);
                    stringBuilder3.append("'");
                } else {
                    stringBuilder3.append(iList.get(n2));
                }
                stringBuilder2.append(iList2.get(n2));
                if (n2 != n - 1) {
                    stringBuilder2.append(",");
                    stringBuilder3.append(",");
                }
                ++n2;
            }
            stringBuilder.append(string).append("(").append((CharSequence)stringBuilder2).append(") ").append("VALUES(").append((CharSequence)stringBuilder3).append(")");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("SqliteConnection.getInsertString:" + sQLException.toString()), (IScope)iScope);
        }
        return stringBuilder.toString();
    }

    private IList<Object> getColumnTypeName(IScope iScope, Connection connection, String string, IList<Object> iList) throws SQLException {
        int n = iList.size();
        IList iList2 = GamaListFactory.create();
        String string2 = "PRAGMA table_info(" + string + ");";
        IList<? super IList<? super IList>> iList3 = this.selectDB(iScope, connection, string2);
        IList iList4 = (IList)iList3.get(2);
        Throwable throwable = null;
        Object var11_12 = null;
        try (Statement statement = connection.createStatement();){
            int n2 = iList4.size();
            int n3 = 0;
            while (n3 < n) {
                String string3 = ((String)iList.get(n3)).trim();
                int n4 = 0;
                while (n4 < n2) {
                    IList iList5 = (IList)iList4.get(n4);
                    String string4 = ((String)iList5.get(1)).trim();
                    String string5 = ((String)iList5.get(2)).trim();
                    if (string3.equalsIgnoreCase(string4)) {
                        if ("BLOB".equalsIgnoreCase(string5) || "GEOMETRY".equalsIgnoreCase(string5) || "POINT".equalsIgnoreCase(string5) || "LINESTRING".equalsIgnoreCase(string5) || "POLYGON".equalsIgnoreCase(string5) || "MULTIPOINT".equalsIgnoreCase(string5) || "MULTILINESTRING".equalsIgnoreCase(string5) || "MULTIPOLYGON".equalsIgnoreCase(string5) || "GEOMETRYCOLLECTION".equalsIgnoreCase(string5)) {
                            iList2.add((Object)"GEOMETRY");
                        } else {
                            iList2.add((Object)string5);
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return iList2;
    }

    @Override
    public void close() throws Exception {
    }
}

