/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.utils.sql.postgres;

import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class PostgresConnection
extends SqlConnection {
    public static final String POSTGRES = "postgres";
    public static final String POSTGIS = "postgis";
    private static final String WKT2GEO = "ST_GeomFromText";
    JDBCDataStore dataStore;

    public PostgresConnection(IScope iScope, String string, String string2, String string3, String string4, String string5, String string6, Boolean bl) {
        super(string, string2, string3, string4, string5, string6, bl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("dbtype", POSTGIS);
        hashMap.put("host", string2);
        hashMap.put("port", string3);
        hashMap.put("schema", "public");
        hashMap.put("database", string4);
        hashMap.put("user", string5);
        hashMap.put("passwd", string6);
        try {
            this.dataStore = (JDBCDataStore)DataStoreFinder.getDataStore(hashMap);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error((String)"Error in  creating the PostGres/PostGIS connection.", (IScope)iScope);
        }
    }

    @Override
    public Connection connectDB() throws ClassNotFoundException, InstantiationException, SQLException, IllegalAccessException {
        Connection connection = null;
        try {
            connection = this.dataStore.getConnection(Transaction.AUTO_COMMIT);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return connection;
    }

    @Override
    protected IList<IList<Object>> resultSet2GamaList(ResultSetMetaData resultSetMetaData, ResultSet resultSet) {
        IList iList = GamaListFactory.create((IType)Types.LIST);
        try {
            List<Integer> list = this.getGeometryColumns(resultSetMetaData);
            int n = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                IList iList2 = GamaListFactory.create();
                int n2 = 1;
                while (n2 <= n) {
                    if (list.contains(n2)) {
                        iList2.add((Object)SqlUtils.read(resultSet.getBytes(n2)));
                    } else {
                        iList2.add(resultSet.getObject(n2));
                    }
                    ++n2;
                }
                iList.add((Object)iList2);
            }
        }
        catch (Exception exception) {}
        return iList;
    }

    @Override
    protected boolean colIsGeometryType(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return !(!POSTGRES.equalsIgnoreCase(this.vender) && !POSTGIS.equalsIgnoreCase(this.vender) || resultSetMetaData.getColumnType(n) != 1111 && resultSetMetaData.getColumnType(n) != -2);
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList, IList<Object> iList2) throws GamaRuntimeException {
        int n = iList.size();
        Object object = "INSERT INTO ";
        Object object2 = "SELECT ";
        StringBuilder stringBuilder = new StringBuilder();
        if (iList2.size() != n) {
            throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(iList.get(n2));
            if (n2 < n - 1) {
                stringBuilder.append(",");
            }
            ++n2;
        }
        object2 = (String)object2 + String.valueOf(stringBuilder) + " FROM " + string + " LIMIT 1 ;";
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("PostgresConnection.getInsertString.select command:" + (String)object2));
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((String)object2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IList<Object> iList3 = this.getColumnName(resultSetMetaData);
            IList<Object> iList4 = this.getColumnTypeName(resultSetMetaData);
            if (DEBUG.IS_ON()) {
                DEBUG.OUT((Object)("list of column Name:" + String.valueOf(iList3)));
                DEBUG.OUT((Object)("list of column type:" + String.valueOf(iList4)));
            }
            StringBuilder stringBuilder2 = new StringBuilder(0);
            IProjection iProjection = this.getSavingGisProjection(iScope);
            int n3 = 0;
            while (n3 < n) {
                if (iList2.get(n3) == null) {
                    stringBuilder2.append("NULL");
                } else if ("GEOMETRY".equalsIgnoreCase((String)iList4.get(n3))) {
                    var18_21 = new WKTReader();
                    Geometry geometry = var18_21.read(iList2.get(n3).toString());
                    if (this.transformed.booleanValue()) {
                        geometry = iProjection.inverseTransform(geometry);
                    }
                    stringBuilder2.append(WKT2GEO);
                    stringBuilder2.append("('");
                    stringBuilder2.append(geometry);
                    stringBuilder2.append("')");
                } else if (PostgresConnection.isTextType((String)iList4.get(n3))) {
                    var18_21 = iList2.get(n3).toString();
                    var18_21 = ((String)var18_21).replaceAll("'", "''");
                    stringBuilder2.append("'");
                    stringBuilder2.append((String)var18_21);
                    stringBuilder2.append("'");
                } else {
                    stringBuilder2.append(iList2.get(n3));
                }
                if (n3 != n - 1) {
                    stringBuilder2.append(",");
                }
                ++n3;
            }
            object = (String)object + string + "(" + String.valueOf(stringBuilder) + ") VALUES(" + String.valueOf(stringBuilder2) + ")";
            if (DEBUG.IS_ON()) {
                DEBUG.OUT((Object)("PostgresConection.getInsertString:" + (String)object));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("PostgresConnection.getInsertString:" + sQLException.toString()), (IScope)iScope);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw GamaRuntimeException.error((String)("PostgresConnection.getInsertString:" + parseException.toString()), (IScope)iScope);
        }
        return object;
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        Object object = "INSERT INTO ";
        Object object2 = "SELECT ";
        object2 = (String)object2 + " *  FROM " + string + " LIMIT 1 ;";
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("PostgresConnection.getInsertString.select command:" + (String)object2));
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((String)object2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IList<Object> iList2 = this.getColumnName(resultSetMetaData);
            IList<Object> iList3 = this.getColumnTypeName(resultSetMetaData);
            int n = iList2.size();
            if (iList.size() != iList2.size()) {
                throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = 0;
            while (n2 < n) {
                if (iList.get(n2) == null) {
                    stringBuilder2.append("NULL");
                } else if ("GEOMETRY".equalsIgnoreCase((String)iList3.get(n2))) {
                    var16_18 = new WKTReader();
                    Geometry geometry = var16_18.read(iList.get(n2).toString());
                    if (this.transformed.booleanValue()) {
                        geometry = this.getSavingGisProjection(iScope).inverseTransform(geometry);
                    }
                    stringBuilder2.append(WKT2GEO);
                    stringBuilder2.append("('");
                    stringBuilder2.append(geometry);
                    stringBuilder2.append("')");
                } else if (PostgresConnection.isTextType((String)iList3.get(n2))) {
                    var16_18 = iList.get(n2).toString();
                    var16_18 = ((String)var16_18).replaceAll("'", "''");
                    stringBuilder2.append("'");
                    stringBuilder2.append((String)var16_18);
                    stringBuilder2.append("'");
                } else {
                    stringBuilder2.append(iList.get(n2));
                }
                stringBuilder.append(iList2.get(n2));
                if (n2 != n - 1) {
                    stringBuilder.append(",");
                    stringBuilder2.append(",");
                }
                ++n2;
            }
            object = (String)object + string + "(" + String.valueOf(stringBuilder) + ") VALUES(" + String.valueOf(stringBuilder2) + ")";
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("PostgresConnection.getInsertString:" + sQLException.toString()), (IScope)iScope);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw GamaRuntimeException.error((String)("PostgresConnection.getInsertString:" + parseException.toString()), (IScope)iScope);
        }
        return object;
    }

    @Override
    public void close() throws Exception {
        this.dataStore.dispose();
    }
}

