/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.gaml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import gama.gaml.skills.Skill;
import gama.gaml.types.Types;
import java.sql.Connection;

@GamlAnnotations.skill(name="SQLSKILL", concept={"database", "skill"})
@GamlAnnotations.doc(value="This skill allows agents to be provided with actions and attributes in order to connect to SQL databases")
public class SQLSkill
extends Skill {
    @GamlAnnotations.action(name="testConnection", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")})}, doc={@GamlAnnotations.doc(value="Action used to test the connection to a database", examples={@GamlAnnotations.example(value="if (!first(DB_Accessor).testConnection(PARAMS)) {\r\n\t\t\twrite \"Connection impossible\";\r\n\t\t\tdo pause;\r\n\t\t}\r\n")})})
    public boolean testConnection(IScope iScope) {
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                Connection connection = SqlUtils.createConnectionObject(iScope).connectDB();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @GamlAnnotations.action(name="executeUpdate", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")}), @GamlAnnotations.arg(name="updateComm", type=4, optional=false, doc={@GamlAnnotations.doc(value="SQL commands such as Create, Update, Delete, Drop with question mark")}), @GamlAnnotations.arg(name="values", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of values that are used to replace question mark")})}, doc={@GamlAnnotations.doc(value="Action used to execute any update query (CREATE, DROP, INSERT...) to the database (query written in SQL).", examples={@GamlAnnotations.example(value="do executeUpdate params: PARAMS updateComm: \"DROP TABLE IF EXISTS registration\";"), @GamlAnnotations.example(value="do executeUpdate params: PARAMS updateComm: \"INSERT INTO registration \" + \"VALUES(100, 'Zara', 'Ali', 18);\";"), @GamlAnnotations.example(value="do executeUpdate params: PARAMS updateComm: \"INSERT INTO registration \" + \"VALUES(?, ?, ?, ?);\" values: [101, 'Mr', 'Mme', 45];")})})
    public int executeUpdate_QM(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("updateComm", 4);
        IList iList = (IList)iScope.getArg("values", 5);
        int n = -1;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (SqlConnection sqlConnection = SqlUtils.createConnectionObject(iScope);){
                n = iList.size() > 0 ? sqlConnection.executeUpdateDB(iScope, string, (IList<Object>)iList) : sqlConnection.executeUpdateDB(iScope, string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLSkill.executeUpdateDB: " + exception.toString()), (IScope)iScope);
        }
        DEBUG.OUT((Object)(string + " was run"));
        return n;
    }

    @GamlAnnotations.action(name="insert", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")}), @GamlAnnotations.arg(name="into", type=4, optional=false, doc={@GamlAnnotations.doc(value="Table name")}), @GamlAnnotations.arg(name="columns", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of column name of table")}), @GamlAnnotations.arg(name="values", type=5, optional=false, doc={@GamlAnnotations.doc(value="List of values that are used to insert into table. Columns and values must have same size")})}, doc={@GamlAnnotations.doc(value="Action used to insert new data in a database", examples={@GamlAnnotations.example(value="do insert params: PARAMS into: \"registration\" values: [102, 'Mahnaz', 'Fatma', 25];"), @GamlAnnotations.example(value="do insert params: PARAMS into: \"registration\" columns: [\"id\", \"first\", \"last\"] values: [103, 'Zaid tim', 'Kha'];")})})
    public int insert(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("into", 4);
        IList iList = (IList)iScope.getArg("columns", 5);
        IList iList2 = (IList)iScope.getArg("values", 5);
        int n = -1;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (SqlConnection sqlConnection = SqlUtils.createConnectionObject(iScope);){
                n = iList.size() > 0 ? sqlConnection.insertDB(iScope, string, (IList<Object>)iList, (IList<Object>)iList2) : sqlConnection.insertDB(iScope, string, (IList<Object>)iList2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLSkill.insert: " + exception.toString()), (IScope)iScope);
        }
        DEBUG.OUT((Object)"Insert into  was run");
        return n;
    }

    @GamlAnnotations.action(name="select", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")}), @GamlAnnotations.arg(name="select", type=4, optional=false, doc={@GamlAnnotations.doc(value="select string with question marks")}), @GamlAnnotations.arg(name="values", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of values that are used to replace question marks")})}, doc={@GamlAnnotations.doc(value="Action used to restrieve data from a database", examples={@GamlAnnotations.example(value="list<list> t <- list<list> (select(PARAMS, \"SELECT * FROM registration\"));")})})
    public IList select_QM(IScope iScope) throws GamaRuntimeException {
        String string = (String)iScope.getArg("select", 4);
        IList iList = (IList)iScope.getArg("values", 5);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (SqlConnection sqlConnection = SqlUtils.createConnectionObject(iScope);){
                Object object = iList.size() > 0 ? sqlConnection.executeQueryDB(iScope, string, (IList<Object>)iList) : sqlConnection.selectDB(iScope, string);
                return object;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLSkill.select_QM: " + exception.toString()), (IScope)iScope);
        }
    }

    @GamlAnnotations.action(name="list2Matrix", args={@GamlAnnotations.arg(name="param", type=5, optional=false, doc={@GamlAnnotations.doc(value="Param: a list of records and metadata")}), @GamlAnnotations.arg(name="getName", type=3, optional=true, doc={@GamlAnnotations.doc(value="getType: a boolean value, optional parameter", comment="if it is true then the action will return columnNames and data. default is true")}), @GamlAnnotations.arg(name="getType", type=3, optional=true, doc={@GamlAnnotations.doc(value="getType: a boolean value, optional parameter", comment="if it is true then the action will return columnTypes and data. default is false")})}, doc={@GamlAnnotations.doc(value="Action that transforms the list of list of data and metadata (resulting from a query) into a matrix.", examples={@GamlAnnotations.example(value="list<list> t <- list<list> (select(PARAMS, \"SELECT * FROM registration\"));\r\nwrite list2Matrix(t, true, true);")})})
    public IMatrix list2Matrix(IScope iScope) throws GamaRuntimeException {
        try {
            int n;
            boolean bl = iScope.hasArg("getName") ? (Boolean)iScope.getArg("getName", 3) : true;
            boolean bl2 = iScope.hasArg("getType") ? (Boolean)iScope.getArg("getType", 3) : false;
            IList iList = (IList)iScope.getArg("param", 5);
            IList iList2 = (IList)iList.get(0);
            IList iList3 = (IList)iList.get(1);
            IList iList4 = (IList)iList.get(2);
            int n2 = iList2.size();
            int n3 = iList4.size();
            GamaObjectMatrix gamaObjectMatrix = new GamaObjectMatrix(n2, n3 + (bl2 ? 1 : 0) + (bl ? 1 : 0), Types.NO_TYPE);
            if (bl) {
                n = 0;
                while (n < n2) {
                    gamaObjectMatrix.set(iScope, n, 0, iList2.get(n));
                    ++n;
                }
            }
            if (bl2) {
                n = 0;
                while (n < n2) {
                    gamaObjectMatrix.set(iScope, n, 0 + (bl ? 1 : 0), iList3.get(n));
                    ++n;
                }
            }
            n = 0;
            while (n < n3) {
                IList iList5 = (IList)iList4.get(n);
                int n4 = 0;
                while (n4 < n2) {
                    gamaObjectMatrix.set(iScope, n4, n + (bl2 ? 1 : 0) + (bl ? 1 : 0), iList5.get(n4));
                    ++n4;
                }
                ++n;
            }
            return gamaObjectMatrix;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

