/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.gaml.species;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

@GamlAnnotations.species(name="AgentDB", doc={@GamlAnnotations.doc(value="An abstract species that can be extended to provide agents with capabilities to access databases")})
@GamlAnnotations.doc(value="AgentDB is an abstract species that can be extended to provide agents with capabilities to access databases")
public class AgentDB
extends GamlAgent {
    private Connection conn = null;
    private SqlConnection sqlConn = null;
    private boolean isConnection = false;
    private Map<String, String> params = null;

    public AgentDB(IPopulation iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
    }

    @GamlAnnotations.action(name="isConnected", doc={@GamlAnnotations.doc(value="To check if connection to the server was successfully established or not.", returns="Returns true if connection to the server was successfully established, otherwise, it returns false.")})
    public boolean isConnected(IScope iScope) throws GamaRuntimeException {
        return this.isConnection;
    }

    @GamlAnnotations.action(name="close", doc={@GamlAnnotations.doc(value="Close the established database connection.", returns="Returns null if the connection was successfully closed, otherwise, it returns an error.")})
    public Object close(IScope iScope) throws GamaRuntimeException {
        block3: {
            try {
                this.conn.close();
                this.isConnection = false;
            }
            catch (SQLException sQLException) {
                throw GamaRuntimeException.error((String)("AgentDB.close error:" + sQLException.toString()), (IScope)iScope);
            }
            catch (NullPointerException nullPointerException) {
                if (this.conn != null) break block3;
                throw GamaRuntimeException.error((String)"AgentDB.close error: cannot close a database connection that does not exist.", (IScope)iScope);
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="connect", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")})}, doc={@GamlAnnotations.doc(value="Establish a database connection.", returns="Returns null if connection to the server was successfully established, otherwise, it returns an error.")})
    public Object connectDB(IScope iScope) throws GamaRuntimeException {
        this.params = (Map)iScope.getArg("params", 10);
        if (this.isConnection) {
            throw GamaRuntimeException.error((String)"AgentDB.connection error: a connection is already opened", (IScope)iScope);
        }
        try {
            this.sqlConn = SqlUtils.createConnectionObject(iScope);
            this.conn = this.sqlConn.connectDB();
            this.isConnection = true;
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("AgentDB.connect:" + exception.toString()), (IScope)iScope);
        }
        return null;
    }

    @GamlAnnotations.action(name="testConnection", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")})}, doc={@GamlAnnotations.doc(value="To test a database connection .", returns="Returns true if connection to the server was successfully established, otherwise, it returns false.")})
    public boolean testConnection(IScope iScope) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                Connection connection = SqlUtils.createConnectionObject(iScope).connectDB();
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @GamlAnnotations.action(name="select", args={@GamlAnnotations.arg(name="select", type=4, optional=false, doc={@GamlAnnotations.doc(value="select string")}), @GamlAnnotations.arg(name="values", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of values that are used to replace question marks")})}, doc={@GamlAnnotations.doc(value="Make a connection to DBMS and execute the select statement.", returns="Returns the obtained result from executing the select statement.")})
    public IList select(IScope iScope) throws GamaRuntimeException {
        if (!this.isConnection) {
            throw GamaRuntimeException.error((String)"AgentDB.select: Connection was not established ", (IScope)iScope);
        }
        String string = (String)iScope.getArg("select", 4);
        IList iList = (IList)iScope.getArg("values", 5);
        try {
            Object object = iList.size() > 0 ? this.sqlConn.executeQueryDB(iScope, this.conn, string, (IList<Object>)iList) : this.sqlConn.selectDB(iScope, this.conn, string);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("AgentDB.select: " + exception.toString()), (IScope)iScope);
        }
    }

    @GamlAnnotations.action(name="executeUpdate", args={@GamlAnnotations.arg(name="updateComm", type=4, optional=false, doc={@GamlAnnotations.doc(value="SQL commands such as Create, Update, Delete, Drop with question mark")}), @GamlAnnotations.arg(name="values", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of values that are used to replace question mark")})}, doc={@GamlAnnotations.doc(value="- Make a connection to DBMS - Executes the SQL statement in this PreparedStatement object, which must be an SQL\n\t INSERT, UPDATE or DELETE statement; or an SQL statement that returns nothing, such as a DDL statement.", returns="Returns the number of updated rows. ")})
    public int executeUpdate(IScope iScope) throws GamaRuntimeException {
        if (!this.isConnection) {
            throw GamaRuntimeException.error((String)"AgentDB.select: Connection was not established ", (IScope)iScope);
        }
        String string = (String)iScope.getArg("updateComm", 4);
        IList iList = (IList)iScope.getArg("values", 5);
        int n = -1;
        try {
            n = iList.size() > 0 ? this.sqlConn.executeUpdateDB(iScope, this.conn, string, (IList<Object>)iList) : this.sqlConn.executeUpdateDB(iScope, this.conn, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("AgentDB.executeUpdate: " + exception.toString()), (IScope)iScope);
        }
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)(string + " was run"));
        }
        return n;
    }

    @GamlAnnotations.action(name="getParameter", args={}, doc={@GamlAnnotations.doc(value="Returns the list used parameters to make a connection to DBMS (dbtype, url, port, database, user and passwd).", returns="Returns the list of used parameters to make a connection to DBMS. ")})
    public Object getParamater(IScope iScope) throws GamaRuntimeException {
        return this.params;
    }

    @GamlAnnotations.action(name="setParameter", args={@GamlAnnotations.arg(name="params", type=10, optional=false, doc={@GamlAnnotations.doc(value="Connection parameters")})}, doc={@GamlAnnotations.doc(value="Sets the parameters to use in order to make a connection to the DBMS (dbtype, url, port, database, user and passwd).", returns="null. ")})
    public Object setParameter(IScope iScope) throws GamaRuntimeException {
        this.params = (Map)iScope.getArg("params", 10);
        if (this.isConnection) {
            try {
                this.conn.close();
                this.isConnection = false;
            }
            catch (SQLException sQLException) {
                throw GamaRuntimeException.error((String)("AgentDB.close error:" + sQLException.toString()), (IScope)iScope);
            }
        }
        return null;
    }

    @GamlAnnotations.action(name="insert", args={@GamlAnnotations.arg(name="into", type=4, optional=false, doc={@GamlAnnotations.doc(value="Table name")}), @GamlAnnotations.arg(name="columns", type=5, optional=true, doc={@GamlAnnotations.doc(value="List of column name of table")}), @GamlAnnotations.arg(name="values", type=5, optional=false, doc={@GamlAnnotations.doc(value="List of values that are used to insert into table. Columns and values must have same size")})}, doc={@GamlAnnotations.doc(value="- Make a connection to DBMS - Executes the insert statement.", returns="Returns the number of updated rows. ")})
    public int insert(IScope iScope) throws GamaRuntimeException {
        if (!this.isConnection) {
            throw GamaRuntimeException.error((String)"AgentDB.select: Connection was not established ", (IScope)iScope);
        }
        String string = (String)iScope.getArg("into", 4);
        IList iList = (IList)iScope.getArg("columns", 5);
        IList iList2 = (IList)iScope.getArg("values", 5);
        int n = -1;
        try {
            n = iList.size() > 0 ? this.sqlConn.insertDB(iScope, this.conn, string, (IList<Object>)iList, (IList<Object>)iList2) : this.sqlConn.insertDB(iScope, this.conn, string, (IList<Object>)iList2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw GamaRuntimeException.error((String)("AgentDB.insert: " + exception.toString()), (IScope)iScope);
        }
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)"Insert into  was run");
        }
        return n;
    }
}

