/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.utils.sql.mysql;

import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlConnection;
import gama.extension.database.utils.sql.SqlUtils;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.mysql.MySQLDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class MySqlConnection
extends SqlConnection {
    public static final String MYSQL = "mysql";
    private static final String WKT2GEO = "GeomFromText";
    private static final String PREFIX_TIMESTAMP = "cast('";
    private static final String MID_TIMESTAMP = "' as ";
    private static final String SUPFIX_TIMESTAMP = ")";
    JDBCDataStore dataStore;

    public MySqlConnection(IScope iScope, String string, String string2, String string3, String string4, String string5, String string6, Boolean bl) {
        super(string, string2, string3, string4, string5, string6, bl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(MySQLDataStoreFactory.DBTYPE.key, this.vender);
        hashMap.put(MySQLDataStoreFactory.HOST.key, string2);
        hashMap.put(MySQLDataStoreFactory.PORT.key, string3);
        hashMap.put(MySQLDataStoreFactory.DATABASE.key, string4);
        hashMap.put(MySQLDataStoreFactory.USER.key, string5);
        hashMap.put(MySQLDataStoreFactory.PASSWD.key, string6);
        try {
            this.dataStore = (JDBCDataStore)DataStoreFinder.getDataStore(hashMap);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error((String)"Error in  creating the MySQL connection.", (IScope)iScope);
        }
    }

    @Override
    public Connection connectDB() throws ClassNotFoundException, InstantiationException, SQLException, IllegalAccessException {
        Connection connection = null;
        try {
            connection = this.dataStore.getConnection(Transaction.AUTO_COMMIT);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return connection;
    }

    @Override
    protected IList<IList<Object>> resultSet2GamaList(ResultSetMetaData resultSetMetaData, ResultSet resultSet) {
        IList iList = GamaListFactory.create((IType)Types.LIST);
        try {
            List<Integer> list = this.getGeometryColumns(resultSetMetaData);
            int n = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                IList iList2 = GamaListFactory.create();
                int n2 = 1;
                while (n2 <= n) {
                    if (list.contains(n2)) {
                        iList2.add((Object)SqlUtils.inputStream2Geometry(resultSet.getBinaryStream(n2)));
                    } else {
                        iList2.add(resultSet.getObject(n2));
                    }
                    ++n2;
                }
                iList.add((Object)iList2);
            }
        }
        catch (Exception exception) {}
        return iList;
    }

    @Override
    protected boolean colIsGeometryType(ResultSetMetaData resultSetMetaData, int n) throws SQLException {
        return MYSQL.equalsIgnoreCase(this.vender) && (resultSetMetaData.getColumnType(n) == -2 || resultSetMetaData.getColumnType(n) == -4);
    }

    @Override
    protected IList<Object> getColumnTypeName(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        IList iList = GamaListFactory.create();
        int n2 = 1;
        while (n2 <= n) {
            if (this.colIsGeometryType(resultSetMetaData, n2)) {
                iList.add((Object)"GEOMETRY");
            } else {
                iList.add((Object)resultSetMetaData.getColumnTypeName(n2).toUpperCase());
            }
            ++n2;
        }
        return iList;
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList, IList<Object> iList2) throws GamaRuntimeException {
        int n = iList.size();
        Object object = "INSERT INTO ";
        Object object2 = "SELECT ";
        Object object3 = "";
        Object object4 = "";
        if (iList2.size() != n) {
            throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
        }
        int n2 = 0;
        while (n2 < n) {
            object3 = n2 == n - 1 ? (String)object3 + (String)iList.get(n2) : (String)object3 + (String)iList.get(n2) + ",";
            ++n2;
        }
        object2 = (String)object2 + (String)object3 + " FROM " + string + " LIMIT 1 ;";
        if (DEBUG.IS_ON()) {
            DEBUG.OUT((Object)("MySqlConnection.getInsertString.select command:" + (String)object2));
        }
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((String)object2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IList<Object> iList3 = this.getColumnName(resultSetMetaData);
            IList<Object> iList4 = this.getColumnTypeName(resultSetMetaData);
            if (DEBUG.IS_ON()) {
                DEBUG.OUT((Object)("list of column Name:" + String.valueOf(iList3)));
                DEBUG.OUT((Object)("list of column type:" + String.valueOf(iList4)));
            }
            object4 = "";
            IProjection iProjection = this.getSavingGisProjection(iScope);
            int n3 = 0;
            while (n3 < n) {
                if (iList2.get(n3) == null) {
                    object4 = (String)object4 + "NULL";
                } else if ("GEOMETRY".equalsIgnoreCase((String)iList4.get(n3))) {
                    var18_21 = new WKTReader();
                    Geometry geometry = var18_21.read(iList2.get(n3).toString());
                    if (this.transformed.booleanValue()) {
                        geometry = iProjection.inverseTransform(geometry);
                    }
                    object4 = (String)object4 + "GeomFromText('" + geometry.toString() + "')";
                } else if (MySqlConnection.isTextType((String)iList4.get(n3))) {
                    var18_21 = iList2.get(n3).toString();
                    var18_21 = ((String)var18_21).replaceAll("'", "''");
                    object4 = (String)object4 + "'" + (String)var18_21 + "'";
                } else {
                    object4 = "TIMESTAMP".equalsIgnoreCase((String)iList4.get(n3)) ? (String)object4 + "TIMESTAMP('" + iList2.get(n3).toString() + "')" : ("YEAR".equalsIgnoreCase((String)iList4.get(n3)) ? (String)object4 + "YEAR('" + iList2.get(n3).toString() + "')" : ("DATETIME".equalsIgnoreCase((String)iList4.get(n3)) ? (String)object4 + PREFIX_TIMESTAMP + iList2.get(n3).toString() + "' as DATETIME)" : ("DATE".equalsIgnoreCase((String)iList4.get(n3)) ? (String)object4 + PREFIX_TIMESTAMP + iList2.get(n3).toString() + "' as DATE)" : ("TIME".equalsIgnoreCase((String)iList4.get(n3)) ? (String)object4 + PREFIX_TIMESTAMP + iList2.get(n3).toString() + "' as TIME)" : (String)object4 + iList2.get(n3).toString()))));
                }
                if (n3 != n - 1) {
                    object4 = (String)object4 + ",";
                }
                ++n3;
            }
            object = (String)object + string + "(" + (String)object3 + ") VALUES(" + (String)object4 + SUPFIX_TIMESTAMP;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("MySqlConection.getInsertString:" + sQLException.toString()), (IScope)iScope);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw GamaRuntimeException.error((String)("MySqlConection.getInsertString:" + parseException.toString()), (IScope)iScope);
        }
        return object;
    }

    @Override
    protected String getInsertString(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        Object object = "INSERT INTO ";
        Object object2 = "SELECT ";
        Object object3 = "";
        Object object4 = "";
        object2 = (String)object2 + " *  FROM " + string + " LIMIT 1 ;";
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((String)object2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            IList<Object> iList2 = this.getColumnName(resultSetMetaData);
            IList<Object> iList3 = this.getColumnTypeName(resultSetMetaData);
            int n = iList2.size();
            if (iList.size() != iList2.size()) {
                throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
            }
            object3 = "";
            object4 = "";
            int n2 = 0;
            while (n2 < n) {
                if (iList.get(n2) == null) {
                    object4 = (String)object4 + "NULL";
                } else if ("GEOMETRY".equalsIgnoreCase((String)iList3.get(n2))) {
                    var16_18 = new WKTReader();
                    Geometry geometry = var16_18.read(iList.get(n2).toString());
                    if (this.transformed.booleanValue()) {
                        geometry = this.getSavingGisProjection(iScope).inverseTransform(geometry);
                    }
                    object4 = (String)object4 + "GeomFromText('" + geometry.toString() + "')";
                } else if ("CHAR".equalsIgnoreCase((String)iList3.get(n2)) || "VARCHAR".equalsIgnoreCase((String)iList3.get(n2)) || "NVARCHAR".equalsIgnoreCase((String)iList3.get(n2)) || "TEXT".equalsIgnoreCase((String)iList3.get(n2))) {
                    var16_18 = iList.get(n2).toString();
                    var16_18 = ((String)var16_18).replaceAll("'", "''");
                    object4 = (String)object4 + "'" + (String)var16_18 + "'";
                } else {
                    object4 = "TIMESTAMP".equalsIgnoreCase((String)iList3.get(n2)) ? (String)object4 + "TIMESTAMP('" + iList.get(n2).toString() + "')" : ("YEAR".equalsIgnoreCase((String)iList3.get(n2)) ? (String)object4 + "YEAR('" + iList.get(n2).toString() + "')" : ("DATETIME".equalsIgnoreCase((String)iList3.get(n2)) ? (String)object4 + PREFIX_TIMESTAMP + iList.get(n2).toString() + "' as DATETIME)" : ("DATE".equalsIgnoreCase((String)iList3.get(n2)) ? (String)object4 + PREFIX_TIMESTAMP + iList.get(n2).toString() + "' as DATE)" : ("TIME".equalsIgnoreCase((String)iList3.get(n2)) ? (String)object4 + PREFIX_TIMESTAMP + iList.get(n2).toString() + "' as TIME)" : (String)object4 + iList.get(n2).toString()))));
                }
                object3 = (String)object3 + iList2.get(n2).toString();
                if (n2 != n - 1) {
                    object3 = (String)object3 + ",";
                    object4 = (String)object4 + ",";
                }
                ++n2;
            }
            object = (String)object + string + "(" + (String)object3 + ") VALUES(" + (String)object4 + SUPFIX_TIMESTAMP;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("MySqlConection.getInsertString:" + sQLException.toString()), (IScope)iScope);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            throw GamaRuntimeException.error((String)("MySqlConection.getInsertString:" + parseException.toString()), (IScope)iScope);
        }
        return object;
    }

    @Override
    public void close() throws Exception {
        this.dataStore.dispose();
    }
}

