/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.database.utils.sql;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.Projection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.database.utils.sql.SqlUtils;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;

public abstract class SqlConnection
implements AutoCloseable {
    public static final String GEOMETRYTYPE = "GEOMETRY";
    protected static final String CHAR = "CHAR";
    protected static final String VARCHAR = "VARCHAR";
    protected static final String NVARCHAR = "NVARCHAR";
    protected static final String TEXT = "TEXT";
    protected static final String BLOB = "BLOB";
    protected static final String TIMESTAMP = "TIMESTAMP";
    protected static final String DATETIME = "DATETIME";
    protected static final String DATE = "DATE";
    protected static final String YEAR = "YEAR";
    protected static final String TIME = "TIME";
    protected static final String NULLVALUE = "NULL";
    protected static final String SQLITEDriver = "org.sqlite.JDBC";
    protected String vender = "";
    protected String url = "";
    protected String port = "";
    protected String dbName = "";
    protected String userName = "";
    protected String password = "";
    protected Boolean transformed = false;
    protected String extension = null;
    private IProjection gis = null;
    private Map<String, Object> params;

    public void setGis(Projection projection) {
        this.gis = projection;
    }

    public IProjection getGis() {
        return this.gis;
    }

    public boolean getTransform() {
        return this.transformed;
    }

    protected IProjection getSavingGisProjection(IScope iScope) {
        Boolean bl = this.params.containsKey("longitudeFirst") ? (Boolean)this.params.get("longitudeFirst") : true;
        String string = (String)this.params.get("crs");
        if (string != null) {
            try {
                return iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, string);
            }
            catch (FactoryException factoryException) {
                throw GamaRuntimeException.error((String)("No factory found for decoding the EPSG " + string + " code. GAMA may be unable to save any GIS data"), (IScope)iScope);
            }
        }
        String string2 = (String)this.params.get("srid");
        if (string2 != null) {
            try {
                return iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, Cast.asInt((IScope)iScope, (Object)string2), bl.booleanValue());
            }
            catch (FactoryException factoryException) {
                throw GamaRuntimeException.error((String)("No factory found for decoding the EPSG " + string2 + " code. GAMA may be unable to save any GIS data"), (IScope)iScope);
            }
        }
        try {
            return iScope.getSimulation().getProjectionFactory().forSavingWith(iScope, (Integer)GamaPreferences.External.LIB_OUTPUT_CRS.getValue());
        }
        catch (FactoryException factoryException) {
            throw GamaRuntimeException.error((String)("No factory found for decoding the EPSG " + String.valueOf(GamaPreferences.External.LIB_OUTPUT_CRS.getValue()) + " code. GAMA may be unable to save any GIS data"), (IScope)iScope);
        }
    }

    public void setParams(Map<String, Object> map) {
        this.params = map;
    }

    SqlConnection(String string) {
        this.dbName = string;
    }

    SqlConnection(String string, String string2) {
        this.vender = string;
        this.dbName = string2;
    }

    protected SqlConnection(String string, String string2, Boolean bl) {
        this.vender = string;
        this.dbName = string2;
        this.transformed = bl;
    }

    SqlConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        this.vender = string;
        this.url = string2;
        this.port = string3;
        this.dbName = string4;
        this.userName = string5;
        this.password = string6;
    }

    public SqlConnection(String string, String string2, String string3, String string4, String string5, String string6, Boolean bl) {
        this.vender = string;
        this.url = string2;
        this.port = string3;
        this.dbName = string4;
        this.userName = string5;
        this.password = string6;
        this.transformed = bl;
    }

    public abstract Connection connectDB() throws ClassNotFoundException, InstantiationException, SQLException, IllegalAccessException;

    protected abstract IList<IList<Object>> resultSet2GamaList(ResultSetMetaData var1, ResultSet var2);

    protected abstract boolean colIsGeometryType(ResultSetMetaData var1, int var2) throws SQLException;

    protected List<Integer> getGeometryColumns(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 1;
        while (n2 <= n) {
            if (this.colIsGeometryType(resultSetMetaData, n2)) {
                arrayList.add(n2);
            }
            ++n2;
        }
        return arrayList;
    }

    protected IList<Object> getColumnTypeName(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        IList iList = GamaListFactory.create();
        int n2 = 1;
        while (n2 <= n) {
            if (this.colIsGeometryType(resultSetMetaData, n2)) {
                iList.add((Object)GEOMETRYTYPE);
            } else {
                iList.add((Object)resultSetMetaData.getColumnTypeName(n2).toUpperCase());
            }
            ++n2;
        }
        return iList;
    }

    public static boolean isTextType(String string) {
        return CHAR.equalsIgnoreCase(string) || VARCHAR.equalsIgnoreCase(string) || NVARCHAR.equalsIgnoreCase(string) || TEXT.equalsIgnoreCase(string);
    }

    protected abstract String getInsertString(IScope var1, Connection var2, String var3, IList<Object> var4, IList<Object> var5) throws GamaRuntimeException;

    protected abstract String getInsertString(IScope var1, Connection var2, String var3, IList<Object> var4) throws GamaRuntimeException;

    public IList<? super IList<? super IList>> selectDB(IScope iScope, String string) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = this.connectDB();){
                return this.selectDB(iScope, connection, string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.selectDB: " + exception.toString()), (IScope)iScope);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IList<? super IList<? super IList>> selectDB(IScope iScope, Connection connection, String string) {
        IList<Object> iList = GamaListFactory.create((IType)Types.LIST.of((IType)Types.LIST));
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try {
                Statement statement = connection.createStatement();
                try {
                    try (ResultSet resultSet = statement.executeQuery(string);){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        if (DEBUG.IS_ON()) {
                            DEBUG.OUT((Object)("MetaData:" + resultSetMetaData.toString()));
                        }
                        iList.add(this.getColumnName(resultSetMetaData));
                        IList<Object> iList2 = this.getColumnTypeName(resultSetMetaData);
                        iList.add(iList2);
                        IList<IList<Object>> iList3 = this.resultSet2GamaList(resultSet);
                        iList.add(iList3);
                        if (iList2.contains((Object)GEOMETRYTYPE) && this.transformed.booleanValue()) {
                            this.gis = iScope.getSimulation().getProjectionFactory().getWorld();
                            if (this.gis != null) {
                                Envelope3D envelope3D = iScope.getSimulation().getEnvelope();
                                this.gis = iScope.getSimulation().getProjectionFactory().fromParams(iScope, this.params, envelope3D);
                                iList = SqlUtils.transform(iScope, this.gis, (IList<? super IList<Object>>)iList, false);
                            }
                        }
                        if (DEBUG.IS_ON()) {
                            DEBUG.OUT((Object)("list of column name:" + String.valueOf(iList.get(0))));
                            DEBUG.OUT((Object)("list of column type:" + String.valueOf(iList.get(1))));
                            DEBUG.OUT((Object)("list of data:" + String.valueOf(iList.get(2))));
                        }
                        statement.close();
                        resultSet.close();
                    }
                    if (statement == null) return iList;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return iList;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            throw GamaRuntimeException.error((String)("SQLConnection.selectDB: " + sQLException.toString()), (IScope)iScope);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executeUpdateDB(IScope iScope, String string) throws GamaRuntimeException {
        int n = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Connection connection = this.connectDB();
                try {
                    try (Statement statement = connection.createStatement();){
                        n = statement.executeUpdate(string);
                    }
                    if (connection == null) return n;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (connection == null) throw throwable;
                    connection.close();
                    throw throwable;
                }
                connection.close();
                return n;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.executeUpdateDB: " + exception.toString()), (IScope)iScope);
        }
    }

    public int executeUpdateDB(IScope iScope, Connection connection, String string) throws GamaRuntimeException {
        int n = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Statement statement = connection.createStatement();){
                n = statement.executeUpdate(string);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            throw GamaRuntimeException.error((String)("SQLConnection.executeUpdateDB: " + sQLException.toString()), (IScope)iScope);
        }
        return n;
    }

    private IList<IList<Object>> resultSet2GamaList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        return this.resultSet2GamaList(resultSetMetaData, resultSet);
    }

    protected IList<Object> getColumnName(ResultSetMetaData resultSetMetaData) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        IList iList = GamaListFactory.create();
        int n2 = 1;
        while (n2 <= n) {
            iList.add((Object)resultSetMetaData.getColumnName(n2).toUpperCase());
            ++n2;
        }
        return iList;
    }

    public String getURL() {
        return this.url;
    }

    public String getVendor() {
        return this.vender;
    }

    public String getUser() {
        return this.userName;
    }

    public static Envelope3D getBounds(IList<? super IList<? super IList>> iList) {
        IList iList2 = (IList)iList.get(1);
        int n = iList2.indexOf((Object)GEOMETRYTYPE);
        if (n < 0) {
            return null;
        }
        IList iList3 = (IList)iList.get(2);
        int n2 = iList3.size();
        if (n2 == 0) {
            return null;
        }
        IList iList4 = (IList)iList3.get(0);
        Geometry geometry = (Geometry)iList4.get(n);
        Envelope3D envelope3D = Envelope3D.of((Geometry)geometry);
        double d = envelope3D.getMaxX();
        double d2 = envelope3D.getMaxY();
        double d3 = envelope3D.getMinX();
        double d4 = envelope3D.getMinY();
        int n3 = 1;
        while (n3 < n2 && n3 < Integer.MAX_VALUE) {
            iList4 = (IList)iList3.get(n3);
            geometry = (Geometry)iList4.get(n);
            envelope3D = Envelope3D.of((Geometry)geometry);
            double d5 = envelope3D.getMaxX();
            double d6 = envelope3D.getMaxY();
            double d7 = envelope3D.getMinX();
            double d8 = envelope3D.getMinY();
            d = d > d5 ? d : d5;
            d2 = d2 > d6 ? d2 : d6;
            d3 = d3 < d7 ? d3 : d7;
            d4 = d4 < d8 ? d4 : d8;
            envelope3D.init(d3, d, d4, d2);
            ++n3;
        }
        return envelope3D;
    }

    public int insertDB(IScope iScope, Connection connection, String string, IList<Object> iList, IList<Object> iList2) throws GamaRuntimeException {
        int n = -1;
        if (iList2.size() != iList.size()) {
            throw new IndexOutOfBoundsException("Size of columns list and values list are not equal");
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Statement statement = connection.createStatement();){
                String string2 = this.getInsertString(iScope, connection, string, iList, iList2);
                if (DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("SQLConnection.insertBD.STR:" + string2));
                }
                n = statement.executeUpdate(string2);
                if (DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("SQLConnection.insertBD.rec_no:" + n));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLConnection.insertBD " + sQLException.toString()), (IScope)iScope);
        }
        return n;
    }

    public int insertDB(IScope iScope, String string, IList<Object> iList, IList<Object> iList2) throws GamaRuntimeException {
        int n = -1;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = this.connectDB();){
                n = this.insertDB(iScope, connection, string, iList, iList2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.insertBD " + exception.toString()), (IScope)iScope);
        }
        return n;
    }

    public int insertDB(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        int n = -1;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Statement statement = connection.createStatement();){
                n = statement.executeUpdate(this.getInsertString(iScope, connection, string, iList));
                if (DEBUG.IS_ON()) {
                    DEBUG.OUT((Object)("SQLConnection.insertBD.rec_no:" + n));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw GamaRuntimeException.error((String)("SQLConnection.insertBD " + sQLException.toString()), (IScope)iScope);
        }
        return n;
    }

    public int insertDB(IScope iScope, String string, IList<Object> iList) throws GamaRuntimeException {
        int n = -1;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = this.connectDB();){
                n = this.insertDB(iScope, connection, string, iList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.insertBD " + exception.toString()), (IScope)iScope);
        }
        return n;
    }

    public IList<Object> executeQueryDB(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        IList<Object> iList2 = GamaListFactory.create();
        int n = iList.size();
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                IList<IList<Object>> iList3;
                int n2 = 0;
                while (n2 < n) {
                    preparedStatement.setObject(n2 + 1, iList.get(n2));
                    ++n2;
                }
                Throwable throwable2 = null;
                Object var12_16 = null;
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (DEBUG.IS_ON()) {
                        DEBUG.OUT((Object)("MetaData:" + resultSetMetaData.toString()));
                    }
                    iList2.add(this.getColumnName(resultSetMetaData));
                    IList<Object> iList4 = this.getColumnTypeName(resultSetMetaData);
                    iList2.add(iList4);
                    iList3 = this.resultSet2GamaList(resultSet);
                    if (iList4.contains((Object)GEOMETRYTYPE) && this.transformed.booleanValue()) {
                        this.gis = iScope.getSimulation().getProjectionFactory().getWorld();
                        if (this.gis != null) {
                            Envelope3D envelope3D = iScope.getSimulation().getEnvelope();
                            this.gis = iScope.getSimulation().getProjectionFactory().fromParams(iScope, this.params, envelope3D);
                            iList2 = SqlUtils.transform(iScope, this.gis, (IList<? super IList<Object>>)iList2, false);
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                iList2.add(iList3);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            throw GamaRuntimeException.error((String)("SQLConnection.selectDB: " + sQLException.toString()), (IScope)iScope);
        }
        return iList2;
    }

    public IList<Object> executeQueryDB(IScope iScope, String string, IList<Object> iList) throws GamaRuntimeException {
        IList<Object> iList2;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Connection connection = this.connectDB();){
                iList2 = this.executeQueryDB(iScope, connection, string, iList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.executeQuery: " + exception.toString()), (IScope)iScope);
        }
        return iList2;
    }

    public int executeUpdateDB(IScope iScope, Connection connection, String string, IList<Object> iList) throws GamaRuntimeException {
        int n = -1;
        int n2 = iList.size();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                int n3 = 0;
                while (n3 < n2) {
                    preparedStatement.setObject(n3 + 1, iList.get(n3));
                    ++n3;
                }
                n = preparedStatement.executeUpdate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            throw GamaRuntimeException.error((String)("SQLConnection.selectDB: " + sQLException.toString()), (IScope)iScope);
        }
        return n;
    }

    public int executeUpdateDB(IScope iScope, String string, IList<Object> iList) throws GamaRuntimeException {
        int n = -1;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = this.connectDB();){
                n = this.executeUpdateDB(iScope, connection, string, iList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error((String)("SQLConnection.executeUpdateDB: " + exception.toString()), (IScope)iScope);
        }
        return n;
    }

    public void setTransformed(boolean bl) {
        this.transformed = bl;
    }
}

