/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.fipa;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.messaging.GamaMailbox;
import gama.core.messaging.MessagingSkill;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.extension.fipa.Conversation;
import gama.extension.fipa.FIPAMessage;
import gama.extension.fipa.FIPAProtocol;
import gama.extension.fipa.MessageBroker;
import gama.extension.fipa.Performative;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Iterator;
import java.util.List;

@GamlAnnotations.doc(value="The fipa skill offers some primitives and built-in variables which enable agent to communicate with each other using the FIPA interaction protocol. ")
@GamlAnnotations.skill(name="fipa", concept={"fipa", "skill", "communication"})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="conversations", type=5, of=98, init="[]", doc={@GamlAnnotations.doc(value="A list containing the current conversations of agent. Ended conversations are automatically removed from this list.")}), @GamlAnnotations.variable(name="accept_proposals", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'accept_proposal' performative messages in the agent's mailbox")}), @GamlAnnotations.variable(name="agrees", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'agree' performative messages.")}), @GamlAnnotations.variable(name="cancels", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'cancel' performative messages.")}), @GamlAnnotations.variable(name="cfps", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'cfp' (call for proposal) performative messages.")}), @GamlAnnotations.variable(name="failures", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'failure' performative messages.")}), @GamlAnnotations.variable(name="informs", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'inform' performative messages.")}), @GamlAnnotations.variable(name="proposes", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'propose' performative messages .")}), @GamlAnnotations.variable(name="queries", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'query' performative messages.")}), @GamlAnnotations.variable(name="refuses", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'propose' performative messages.")}), @GamlAnnotations.variable(name="reject_proposals", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'reject_proposal' performative messages.")}), @GamlAnnotations.variable(name="requests", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'request' performative messages.")}), @GamlAnnotations.variable(name="requestWhens", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'request-when' performative messages.")}), @GamlAnnotations.variable(name="subscribes", type=5, of=24, doc={@GamlAnnotations.doc(value="A list of 'subscribe' performative messages.")})})
public class FIPASkill
extends MessagingSkill {
    @GamlAnnotations.action(name="start_conversation", args={@GamlAnnotations.arg(name="to", type=5, optional=false, doc={@GamlAnnotations.doc(value="A list of receiver agents")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the message. A list of any GAML type")}), @GamlAnnotations.arg(name="performative", type=4, optional=true, doc={@GamlAnnotations.doc(value="A string, representing the message performative")}), @GamlAnnotations.arg(name="protocol", type=4, optional=true, doc={@GamlAnnotations.doc(value="A string representing the name of interaction protocol")})}, doc={@GamlAnnotations.doc(value="Starts a conversation/interaction protocol.")})
    public FIPAMessage primStartConversation(IScope iScope) throws GamaRuntimeException {
        String string;
        FIPAMessage fIPAMessage = new FIPAMessage(iScope);
        IList iList = Cast.asList((IScope)iScope, (Object)iScope.getArg("to", 5));
        if (iList == null || iList.isEmpty() || iList.contains(null)) {
            throw GamaRuntimeException.error((String)"receivers can not be empty or null", (IScope)iScope);
        }
        fIPAMessage.setReceivers(iList);
        fIPAMessage.setSender(this.getCurrentAgent(iScope));
        IList iList2 = Cast.asList((IScope)iScope, (Object)iScope.getArg("contents", 5));
        if (iList2 != null) {
            fIPAMessage.setContents(iList2);
        }
        if ((string = Cast.asString((IScope)iScope, (Object)iScope.getArg("performative", 4))) == null) {
            throw GamaRuntimeException.error((String)"performative can not be null", (IScope)iScope);
        }
        fIPAMessage.setPerformative(Performative.valueOf(string));
        if (fIPAMessage.getPerformative() == null) {
            throw GamaRuntimeException.error((String)(string + " performative is unknown"), (IScope)iScope);
        }
        String string2 = Cast.asString((IScope)iScope, (Object)iScope.getArg("protocol", 4));
        if (string2 == null) {
            string2 = FIPAProtocol.Names.no_protocol.name();
        }
        MessageBroker.getInstance(iScope).scheduleForDelivery(iScope, fIPAMessage, string2);
        return fIPAMessage;
    }

    public FIPAMessage primSendMessage(IScope iScope) throws GamaRuntimeException {
        return this.primStartConversation(iScope);
    }

    @GamlAnnotations.action(name="reply", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="performative", type=4, optional=false, doc={@GamlAnnotations.doc(value="The performative of the replying message")}), @GamlAnnotations.arg(name="contents", type=5, optional=true, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message. This action should be only used to reply a message in a 'no-protocol' conversation and with a 'user defined performative'. For performatives supported by GAMA (i.e., standard FIPA performatives), please use the 'action' with the same name of 'performative'. For example, to reply a message with a 'request' performative message, the modeller should use the 'request' action.")})
    public Object primReplyToMessage(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        String string = Cast.asString((IScope)iScope, (Object)iScope.getArg("performative", 4));
        if (string == null) {
            throw GamaRuntimeException.error((String)"'performative' argument is mandatory", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.valueOf(string), this.getContentArg(iScope));
    }

    @GamlAnnotations.getter(value="conversations")
    public List<Conversation> getConversations(IAgent iAgent) throws GamaRuntimeException {
        this.getMessages(iAgent.getScope(), iAgent);
        return MessageBroker.getInstance(iAgent.getScope()).getConversationsFor(iAgent);
    }

    private Object replyMessage(IScope iScope, IList<FIPAMessage> iList, Performative performative, IList iList2) throws GamaRuntimeException {
        for (FIPAMessage fIPAMessage : iList) {
            fIPAMessage.setUnread(false);
            IAgent iAgent = fIPAMessage.getSender();
            IList iList3 = GamaListFactory.create((IType)Types.AGENT);
            iList3.add((Object)iAgent);
            Conversation conversation = fIPAMessage.getConversation();
            FIPAMessage fIPAMessage2 = new FIPAMessage(this.getCurrentAgent(iScope), (IList<IAgent>)iList3, iList2, performative, conversation);
            MessageBroker.getInstance(iScope).scheduleForDelivery(iScope, fIPAMessage2);
        }
        return iList;
    }

    private IList getContentArg(IScope iScope) {
        return Cast.asList((IScope)iScope, (Object)iScope.getArg("contents", 5));
    }

    private IList<FIPAMessage> getMessageArg(IScope iScope) {
        return Cast.asList((IScope)iScope, (Object)iScope.getArg("message", 5));
    }

    @GamlAnnotations.action(name="accept_proposal", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with an 'accept_proposal' performative message.")})
    public Object primAcceptProposal(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.accept_proposal, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="agree", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with an 'agree' performative message.")})
    public Object primAgree(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            return null;
        }
        return this.replyMessage(iScope, iList, Performative.agree, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="cancel", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'cancel' peformative message.")})
    public Object primCancel(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.cancel, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="cfp", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'cfp' performative message.")})
    public Object primCfp(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.cfp, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="end_conversation", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Reply a message with an 'end_conversation' peprformative message. This message marks the end of a conversation. In a 'no-protocol' conversation, it is the responsible of the modeler to explicitly send this message to mark the end of a conversation/interaction protocol. Please note that if the contents of the messages of the conversation are not read, then this command has no effect (i.e. it  must be read by at least one of the agents in the conversation)")})
    public Object primEndConversation(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.end_conversation, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="failure", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'failure' performative message.")})
    public Object primFailure(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.failure, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="inform", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with an 'inform' performative message.")})
    public Object primInform(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.inform, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="propose", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'propose' performative message.")})
    public Object primPropose(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.propose, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="query", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'query' performative message.")})
    public Object primQuery(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.query, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="refuse", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The contents of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'refuse' performative message.")})
    public Object primRefuse(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.refuse, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="reject_proposal", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'reject_proposal' performative message.")})
    public Object primRejectProposal(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.reject_proposal, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="request", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'request' performative message.")})
    public Object primRequest(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.request, this.getContentArg(iScope));
    }

    @GamlAnnotations.action(name="subscribe", args={@GamlAnnotations.arg(name="message", type=24, optional=false, doc={@GamlAnnotations.doc(value="The message to be replied")}), @GamlAnnotations.arg(name="contents", type=5, optional=false, doc={@GamlAnnotations.doc(value="The content of the replying message")})}, doc={@GamlAnnotations.doc(value="Replies a message with a 'subscribe' performative message.")})
    public Object primSubscribe(IScope iScope) throws GamaRuntimeException {
        IList<FIPAMessage> iList = this.getMessageArg(iScope);
        if (iList == null || iList.size() == 0) {
            throw GamaRuntimeException.error((String)"No message to reply", (IScope)iScope);
        }
        return this.replyMessage(iScope, iList, Performative.subscribe, this.getContentArg(iScope));
    }

    private IList<FIPAMessage> getMessages(IScope iScope, IAgent iAgent) {
        IList<FIPAMessage> iList = MessageBroker.getInstance(iScope).getMessagesFor(iAgent);
        IList<FIPAMessage> iList2 = MessageBroker.getInstance(iScope).deliverMessagesFor(iScope, iAgent);
        iList.addAll(iList2);
        Iterator iterator = iList.iterator();
        while (iterator.hasNext()) {
            FIPAMessage fIPAMessage = (FIPAMessage)((Object)iterator.next());
            if (fIPAMessage.isUnread()) continue;
            iterator.remove();
        }
        return iList;
    }

    @GamlAnnotations.getter(value="mailbox", initializer=true)
    public GamaMailbox<FIPAMessage> getMailbox(IScope iScope, IAgent iAgent) {
        GamaMailbox gamaMailbox = super.getMailbox(iScope, iAgent);
        gamaMailbox.clear();
        gamaMailbox.addAll(this.getMessages(iScope, iAgent));
        return gamaMailbox;
    }

    @GamlAnnotations.getter(value="accept_proposals")
    public IList<FIPAMessage> getAcceptProposalMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.accept_proposal);
    }

    @GamlAnnotations.getter(value="agrees")
    public IList<FIPAMessage> getAgreeMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.agree);
    }

    @GamlAnnotations.getter(value="cancels")
    public IList<FIPAMessage> getCancelMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.cancel);
    }

    @GamlAnnotations.getter(value="cfps")
    public IList<FIPAMessage> getCfpMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.cfp);
    }

    @GamlAnnotations.getter(value="failures")
    public IList<FIPAMessage> getFailureMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.failure);
    }

    @GamlAnnotations.getter(value="informs")
    public IList<FIPAMessage> getInformMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.inform);
    }

    @GamlAnnotations.getter(value="proposes")
    public IList<FIPAMessage> getProposeMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.propose);
    }

    @GamlAnnotations.getter(value="queries")
    public IList<FIPAMessage> getQueryMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.query);
    }

    @GamlAnnotations.getter(value="refuses")
    public IList<FIPAMessage> getRefusesMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.refuse);
    }

    @GamlAnnotations.getter(value="reject_proposals")
    public IList<FIPAMessage> getRejectProposalMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.reject_proposal);
    }

    @GamlAnnotations.getter(value="requests")
    public IList<FIPAMessage> getRequestMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.request);
    }

    @GamlAnnotations.getter(value="requestWhens")
    public IList<FIPAMessage> getRequestWhenMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.request_when);
    }

    @GamlAnnotations.getter(value="subscribes")
    public IList<FIPAMessage> getSubscribeMsgs(IScope iScope, IAgent iAgent) {
        return this.filter(iScope, iAgent, Performative.subscribe);
    }

    private IList<FIPAMessage> filter(IScope iScope, IAgent iAgent, Performative performative) {
        IList<FIPAMessage> iList = this.getMessages(iScope, iAgent);
        if (iList.isEmpty()) {
            return GamaListFactory.EMPTY_LIST;
        }
        IList iList2 = GamaListFactory.create((IType)iScope.getType("message"));
        for (FIPAMessage fIPAMessage : iList) {
            boolean bl = fIPAMessage.isUnread();
            Performative performative2 = fIPAMessage.getPerformative();
            if (!bl || performative2 != performative) continue;
            iList2.add((Object)fIPAMessage);
        }
        return iList2;
    }
}

