/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.fipa;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.extension.fipa.FIPAMessage;
import gama.extension.fipa.Performative;
import gama.extension.fipa.ProtocolNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DefaultDirectedGraph;

public abstract class FIPAProtocol
extends DefaultDirectedGraph<ProtocolNode, Object> {
    private final ProtocolNode root;
    private String name;

    public FIPAProtocol(String string) {
        super(Object.class);
        this.name = string;
        this.root = this.populateProtocolGraph();
    }

    public final String getName() {
        return this.name;
    }

    void addTree(ProtocolNode protocolNode, ProtocolNode ... protocolNodeArray) {
        Graphs.addOutgoingEdges((Graph)this, (Object)protocolNode, Arrays.asList(protocolNodeArray));
    }

    ProtocolNode pNode(Performative performative) {
        ProtocolNode protocolNode2;
        for (ProtocolNode protocolNode2 : this.vertexSet()) {
            if (protocolNode2.getPerformative() != performative || protocolNode2.isSentByInitiator()) continue;
            return protocolNode2;
        }
        protocolNode2 = new ProtocolNode(this, performative, false);
        this.addVertex(protocolNode2);
        return protocolNode2;
    }

    ProtocolNode iNode(Performative performative) {
        ProtocolNode protocolNode2;
        for (ProtocolNode protocolNode2 : this.vertexSet()) {
            if (protocolNode2.getPerformative() != performative || !protocolNode2.isSentByInitiator()) continue;
            return protocolNode2;
        }
        protocolNode2 = new ProtocolNode(this, performative, true);
        this.addVertex(protocolNode2);
        return protocolNode2;
    }

    protected abstract ProtocolNode populateProtocolGraph();

    public final boolean hasProtocol() {
        return this.root != null;
    }

    protected ProtocolNode getNode(IScope iScope, FIPAMessage fIPAMessage, ProtocolNode protocolNode, Performative performative, boolean bl) throws GamaRuntimeException {
        ProtocolNode protocolNode22;
        if (protocolNode == null) {
            if (this.root != null && this.root.getPerformative() == performative) {
                return this.root;
            }
            return null;
        }
        List list = Graphs.successorListOf((Graph)this, (Object)protocolNode);
        if (list.size() == 0) {
            throw GamaRuntimeException.warning((String)"Message received in a conversation which has already ended!", (IScope)iScope);
        }
        ArrayList<ProtocolNode> arrayList = new ArrayList<ProtocolNode>();
        for (ProtocolNode protocolNode22 : list) {
            if (performative != protocolNode22.getPerformative()) continue;
            arrayList.add(protocolNode22);
        }
        if (arrayList.isEmpty()) {
            throw GamaRuntimeException.warning((String)("Protocol : " + this.getName() + ". Unexpected message received of performative : " + fIPAMessage.getPerformativeName()), (IScope)iScope);
        }
        protocolNode22 = null;
        for (ProtocolNode protocolNode3 : arrayList) {
            if (bl != protocolNode3.isSentByInitiator()) continue;
            protocolNode22 = protocolNode3;
            break;
        }
        if (protocolNode22 == null) {
            throw GamaRuntimeException.warning((String)"Couldn't match expected message types and participant", (IScope)iScope);
        }
        return protocolNode22;
    }

    public static enum Names {
        fipa_brokering(new FIPAProtocol("fipa_brokering"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.proxy), this.iNode(Performative.cancel), this.pNode(Performative.refuse), this.pNode(Performative.agree));
                this.addTree(this.iNode(Performative.cancel), this.iNode(Performative.proxy), this.pNode(Performative.failure), this.pNode(Performative.inform));
                this.addTree(this.pNode(Performative.agree), this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.proxy);
            }
        }),
        fipa_contract_net(new FIPAProtocol("fipa_contract_net"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.cfp), this.pNode(Performative.failure), this.iNode(Performative.cancel), this.pNode(Performative.refuse), this.pNode(Performative.propose));
                this.addTree(this.pNode(Performative.propose), this.iNode(Performative.failure), this.iNode(Performative.cancel), this.iNode(Performative.accept_proposal), this.iNode(Performative.reject_proposal));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                this.addTree(this.iNode(Performative.accept_proposal), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.cfp);
            }
        }),
        fipa_iterated_contract_net(new FIPAProtocol("fipa_iterated_contract_net"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.cfp), this.pNode(Performative.failure), this.iNode(Performative.cancel), this.pNode(Performative.refuse), this.pNode(Performative.propose));
                this.addTree(this.pNode(Performative.propose), this.iNode(Performative.failure), this.iNode(Performative.cancel), this.iNode(Performative.accept_proposal), this.iNode(Performative.reject_proposal), this.iNode(Performative.cfp));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                this.addTree(this.iNode(Performative.accept_proposal), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.cfp);
            }
        }),
        fipa_propose(new FIPAProtocol("fipa_propose"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.propose), this.pNode(Performative.reject_proposal), this.pNode(Performative.accept_proposal), this.iNode(Performative.cancel));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.propose);
            }
        }),
        fipa_query(new FIPAProtocol("fipa_query"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.query), this.pNode(Performative.refuse), this.pNode(Performative.agree), this.iNode(Performative.cancel));
                this.addTree(this.pNode(Performative.agree), this.pNode(Performative.inform), this.pNode(Performative.failure));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.inform), this.pNode(Performative.failure));
                return this.iNode(Performative.query);
            }
        }),
        fipa_request(new FIPAProtocol("fipa_request"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.request), this.pNode(Performative.not_understood), this.iNode(Performative.cancel), this.pNode(Performative.agree), this.pNode(Performative.refuse));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                this.addTree(this.pNode(Performative.agree), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.request);
            }
        }),
        fipa_request_when(new FIPAProtocol("fipa_request_when"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.request_when), this.iNode(Performative.cancel), this.pNode(Performative.refuse), this.pNode(Performative.agree));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.failure), this.pNode(Performative.inform));
                this.addTree(this.iNode(Performative.agree), this.pNode(Performative.failure), this.pNode(Performative.inform));
                return this.iNode(Performative.request_when);
            }
        }),
        fipa_subscribe(new FIPAProtocol("fipa_subscribe"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                this.addTree(this.iNode(Performative.subscribe), this.pNode(Performative.refuse), this.pNode(Performative.agree), this.iNode(Performative.cancel));
                this.addTree(this.pNode(Performative.agree), this.pNode(Performative.inform), this.iNode(Performative.cancel), this.pNode(Performative.failure));
                this.addTree(this.pNode(Performative.inform), this.iNode(Performative.cancel), this.pNode(Performative.failure));
                this.addTree(this.iNode(Performative.cancel), this.pNode(Performative.inform), this.pNode(Performative.failure));
                return this.iNode(Performative.subscribe);
            }
        }),
        no_protocol(new FIPAProtocol("no_protocol"){

            @Override
            protected ProtocolNode populateProtocolGraph() {
                return null;
            }
        });

        FIPAProtocol protocol;

        private Names(FIPAProtocol fIPAProtocol) {
            this.protocol = fIPAProtocol;
        }
    }
}

