/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.matrix.IMatrix;
import gama.extension.image.GamaImageFile;
import gama.extension.image.ImageCache;

@GamlAnnotations.file(name="gif", extensions={"gif"}, buffer_type=8, buffer_content=1, buffer_index=7, concept={"image", "file"}, doc={@GamlAnnotations.doc(value="GIF files represent a particular type of image files, which can be animated")})
public class GamaGifFile
extends GamaImageFile {
    @GamlAnnotations.doc(value="This file constructor allows to read a gif file", examples={@GamlAnnotations.example(value="gif_file f <- gif_file(\"file.gif\");", isExecutable=false)})
    public GamaGifFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This file constructor allows to store a matrix in a gif file (it does not save it - just store it in memory)", examples={@GamlAnnotations.example(value="gif_file f <- gif_file(\"file.gif\",matrix([10,10],[10,10]));", isExecutable=false)})
    public GamaGifFile(IScope iScope, String string, IMatrix<Integer> iMatrix) {
        super(iScope, string, iMatrix);
    }

    public boolean isAnimated() {
        return ImageCache.getInstance().getFrameCount(this.localPath) > 0;
    }

    protected String getHttpContentType() {
        return "image/gif";
    }
}

