/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.core.util.matrix.GamaField;
import gama.extension.image.GamaImageType;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.imageio.ImageIO;

public class ImageSaver
extends AbstractSaver {
    public static final Set<String> FILE_FORMATS = Set.of("image", "jpg", "jpeg", "png", "gif");

    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws IOException {
        Object object;
        String string;
        File file3 = file2;
        Object object2 = file3.getAbsolutePath();
        String string2 = "image".equals(saveOptions.type) ? "png" : (string = "jpeg".equals(saveOptions.type) ? "jpg" : saveOptions.type);
        if ("image".equals(string)) {
            string = "png";
        }
        if ("jpeg".equals(string)) {
            string = "jpg";
        }
        if (!((String)object2).contains("." + string)) {
            object2 = (String)object2 + "." + string;
            file3 = new File((String)object2);
        }
        if (file3.exists() && !file3.delete()) {
            return;
        }
        Object object3 = iExpression.value(iScope);
        boolean bl = false;
        if (object3 instanceof GamaField) {
            GamaField gamaField = (GamaField)object3;
            this.saveField(iScope, gamaField, file3, string);
            ProjectionFactory.saveTargetCRSAsPRJFile((IScope)iScope, (String)file3.getAbsolutePath());
            bl = true;
        } else {
            object = Cast.asSpecies((IScope)iScope, (Object)object3);
            if (object != null && object.isGrid()) {
                this.saveGrid(iScope, (ISpecies)object, file3, string);
                ProjectionFactory.saveTargetCRSAsPRJFile((IScope)iScope, (String)file3.getAbsolutePath());
                bl = true;
            }
        }
        if (!bl) {
            object = GamaImageType.staticCast(iScope, iExpression.value(iScope), false);
            if (object == null) {
                return;
            }
            ImageIO.write((RenderedImage)object, string, file2);
        }
    }

    private void saveGrid(IScope iScope, ISpecies iSpecies, File file2, String string) throws IOException {
        Object object;
        GridPopulation gridPopulation = (GridPopulation)iSpecies.getPopulation(iScope);
        int n = gridPopulation.getNbCols();
        int n2 = gridPopulation.getNbRows();
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        double d = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinX();
        double d2 = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinY();
        double d3 = gridPopulation.getAgent(Integer.valueOf(0)).getGeometry().getWidth();
        double d4 = gridPopulation.getAgent(Integer.valueOf(0)).getGeometry().getHeight();
        d += d3 / 2.0;
        d2 += d4 / 2.0;
        Object object2 = null;
        DataBufferInt dataBufferInt = null;
        try {
            object = new FileWriter(file2.getAbsolutePath().replace(".png", ".pgw").replace(".jpg", ".jgw"));
            try {
                ((Writer)object).write(d3 + "\n0.0\n0.0\n" + d4 + "\n" + d + "\n" + d2);
            }
            finally {
                if (object != null) {
                    ((OutputStreamWriter)object).close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object2 == null) {
                object2 = throwable;
            } else if (object2 != throwable) {
                ((Throwable)object2).addSuppressed(throwable);
            }
            throw object2;
        }
        object2 = new BufferedImage(n, n2, 1);
        dataBufferInt = (DataBufferInt)((BufferedImage)object2).getRaster().getDataBuffer();
        object = dataBufferInt.getData();
        System.arraycopy(gridPopulation.getTopology().getPlaces().getDisplayData(), 0, object, 0, ((Object)object).length);
        ImageIO.write((RenderedImage)object2, string, file2);
    }

    private void saveField(IScope iScope, GamaField gamaField, File file2, String string) throws IOException {
        if (gamaField.isEmpty(iScope)) {
            return;
        }
        int n = gamaField.numCols;
        int n2 = gamaField.numRows;
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        double d = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinX();
        double d2 = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinY();
        double d3 = iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getWidth() / (double)n;
        double d4 = iScope.getSimulation().getProjectionFactory().getWorld().getProjectedEnvelope().getHeight() / (double)n2;
        d += d3 / 2.0;
        d2 += d4 / 2.0;
        Object object = null;
        double[] dArray = null;
        try (FileWriter fileWriter = new FileWriter(file2.getAbsolutePath().replace(".png", ".pgw").replace(".jpg", ".jgw"));){
            fileWriter.write(d3 + "\n0.0\n0.0\n" + d4 + "\n" + d + "\n" + d2);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        object = new BufferedImage(n, n2, 1);
        dArray = gamaField.getMinMax();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                double d5 = gamaField.get(iScope, n4, n3);
                int n5 = Maths.round((Double)((d5 - dArray[0]) / (dArray[1] - dArray[0]) * 255.0));
                ((BufferedImage)object).setRGB(n4, n2 - 1 - n3, GamaColor.get((int)n5, (int)n5, (int)n5).getRGB());
                ++n4;
            }
            ++n3;
        }
        ImageIO.write((RenderedImage)object, string, file2);
    }

    public Set<String> computeFileTypes() {
        return Sets.union(Set.of(ImageIO.getWriterFileSuffixes()), FILE_FORMATS);
    }

    public IType getDataType() {
        return Types.get((int)80);
    }

    public BiMap<String, String> getSynonyms() {
        return ImmutableBiMap.of((Object)"jpg", (Object)"jpeg");
    }
}

