/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IAsset;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IField;
import gama.extension.image.ImageOperators;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="alpha", type=3, doc={@GamlAnnotations.doc(value="Returns wether the image has an alpha (transparency) component or not")}), @GamlAnnotations.variable(name="height", type=1, doc={@GamlAnnotations.doc(value="Returns the height (in pixels) of this image")}), @GamlAnnotations.variable(name="width", type=1, doc={@GamlAnnotations.doc(value="Returns the width (in pixels) of this image")})})
public class GamaImage
extends BufferedImage
implements IImageProvider,
IAsset,
IFieldMatrixProvider,
IValue {
    String id;

    public String getId() {
        return this.id;
    }

    GamaImage(int n, int n2, int n3, String string) {
        super(n, n2, n3);
        this.id = string;
    }

    private GamaImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl, String string) {
        super(colorModel, writableRaster, bl, null);
        this.id = string;
    }

    @GamlAnnotations.getter(value="width")
    public int getWidth(IScope iScope) {
        return this.getWidth();
    }

    @GamlAnnotations.getter(value="height")
    public int getHeight(IScope iScope) {
        return this.getHeight();
    }

    @GamlAnnotations.getter(value="alpha")
    public boolean getAlpha(IScope iScope) {
        return this.getType() == 2;
    }

    public static GamaImage from(Image image, boolean bl) {
        return GamaImage.from(image, bl, "image" + System.currentTimeMillis());
    }

    public static GamaImage from(Image image, boolean bl, String string) {
        if (image == null) {
            return null;
        }
        GamaImage gamaImage = new GamaImage(image.getWidth(null), image.getHeight(null), bl ? 2 : 1, string);
        Graphics2D graphics2D = gamaImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return gamaImage;
    }

    public static GamaImage from(IScope iScope, GamaField gamaField) {
        int n = gamaField.numCols;
        int n2 = gamaField.numRows;
        GamaImage gamaImage = new GamaImage(n, n2, 1, "field" + System.currentTimeMillis());
        if (gamaField.getBandsNumber(iScope) > 1) {
            IList iList = gamaField.getBands(iScope);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    double d = (Double)((IField)iList.get(1)).get(iScope, n4, n3);
                    double d2 = (Double)((IField)iList.get(2)).get(iScope, n4, n3);
                    double d3 = (Double)((IField)iList.get(3)).get(iScope, n4, n3);
                    gamaImage.setRGB(n4, n2 - 1 - n3, (int)d << 16 | (int)d2 << 8 | (int)d3);
                    ++n4;
                }
                ++n3;
            }
        } else {
            double[] dArray = gamaField.getMinMax();
            double d = dArray[1] - dArray[0];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    double d4 = gamaField.get(iScope, n6, n5);
                    double d5 = (d4 - dArray[0]) / d;
                    gamaImage.setRGB(n6, n2 - 1 - n5, GamaImage.grayDoubleToRGB(d5));
                    ++n6;
                }
                ++n5;
            }
        }
        return gamaImage;
    }

    private static int grayDoubleToRGB(double d) {
        int n = (int)(d * 256.0);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return 65793 * n;
    }

    public static GamaImage from(GamaSpatialMatrix gamaSpatialMatrix) {
        GamaImage gamaImage = new GamaImage(gamaSpatialMatrix.numCols, gamaSpatialMatrix.numRows, 2, "matrix" + System.currentTimeMillis());
        int[] nArray = ((DataBufferInt)gamaImage.getRaster().getDataBuffer()).getData();
        System.arraycopy(gamaSpatialMatrix.getDisplayData(), 0, nArray, 0, nArray.length);
        return gamaImage;
    }

    public static GamaImage from(IScope iScope, GamaIntMatrix gamaIntMatrix) {
        BufferedImage bufferedImage = gamaIntMatrix.getImage(iScope);
        return GamaImage.from(bufferedImage, true, "matrix" + System.currentTimeMillis());
    }

    public static GamaImage ofDimensions(int n, int n2) {
        return new GamaImage(n, n2, 2, "image" + System.currentTimeMillis());
    }

    public static GamaImage ofDimensions(int n, int n2, boolean bl) {
        return new GamaImage(n, n2, bl ? 2 : 1, "image" + System.currentTimeMillis());
    }

    public static GamaImage ofDimensions(int n, int n2, int n3) {
        return new GamaImage(n, n2, n3, "image" + System.currentTimeMillis());
    }

    public static GamaImage bestFor(Image image, int n, int n2) {
        BufferedImage bufferedImage;
        return GamaImage.ofDimensions(n, n2, image instanceof BufferedImage && (bufferedImage = (BufferedImage)image).getTransparency() == 1 ? 1 : 2);
    }

    public int getRows(IScope iScope) {
        return this.getHeight();
    }

    public int getCols(IScope iScope) {
        return this.getWidth();
    }

    public BufferedImage getImage(IScope iScope, boolean bl) {
        return this;
    }

    public int getBandsNumber(IScope iScope) {
        return this.getColorModel().getNumComponents();
    }

    public double[] getBand(IScope iScope, int n) {
        double[] dArray = new double[this.getWidth() * this.getHeight()];
        int[] nArray = new int[dArray.length];
        PixelGrabber pixelGrabber = new PixelGrabber(this, 0, 0, this.getWidth(), this.getHeight(), nArray, 0, this.getWidth());
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = nArray[n2] & (n + 1) * 255;
            ++n2;
        }
        return dArray;
    }

    public static GamaImage from(ColorModel colorModel, WritableRaster writableRaster, boolean bl) {
        return new GamaImage(colorModel, writableRaster, bl, "raster" + System.currentTimeMillis());
    }

    public void setId(String string) {
        this.id = string;
    }

    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return this.id;
    }

    public GamaImage copy(IScope iScope) throws GamaRuntimeException {
        return GamaImage.from(this, this.getAlpha(iScope));
    }

    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "width", (Object)this.getWidth(), "height", (Object)this.getHeight(), "type", (Object)this.getType(), "pixels", (Object)ImageOperators.matrix(null, this));
    }
}

