/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.util.Provider;
import com.github.weisj.jsvg.util.ShapeUtil;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaListFactory;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

class GamaShapeSVGOutput
implements Output,
Iterable<IShape> {
    List<IShape> shapes = GamaListFactory.create();
    private AffineTransform currentTransform;
    private Stroke currentStroke;
    private Shape currentClip;

    public GamaShapeSVGOutput() {
        this.currentStroke = new BasicStroke();
        this.currentTransform = new AffineTransform();
        this.currentClip = null;
    }

    private GamaShapeSVGOutput(GamaShapeSVGOutput gamaShapeSVGOutput) {
        this.shapes = gamaShapeSVGOutput.shapes;
        this.currentStroke = gamaShapeSVGOutput.currentStroke;
        this.currentTransform = new AffineTransform(gamaShapeSVGOutput.currentTransform);
        this.currentClip = gamaShapeSVGOutput.currentClip != null ? new Area(gamaShapeSVGOutput.currentClip) : null;
    }

    private void addShape(Shape shape) {
        Shape shape2 = this.currentClip != null ? ShapeUtil.intersect((Shape)this.currentClip, (Shape)shape, (boolean)true, (boolean)false) : shape;
        Geometry geometry = ShapeReader.read((PathIterator)shape2.getPathIterator(null, 1.0), (GeometryFactory)GeometryUtils.GEOMETRY_FACTORY);
        this.addShape(geometry);
    }

    private void addShape(Geometry geometry) {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = geometryCollection.getNumGeometries();
            int n2 = 0;
            while (n2 < n) {
                this.addShape(geometryCollection.getGeometryN(n2));
                ++n2;
            }
        } else {
            this.shapes.add((IShape)GamaShapeFactory.createFrom((Geometry)geometry));
        }
    }

    private void append(Shape shape, AffineTransform affineTransform) {
        AffineTransform affineTransform2 = new AffineTransform(this.currentTransform);
        affineTransform2.concatenate(affineTransform);
        this.addShape(ShapeUtil.transformShape((Shape)shape, (AffineTransform)affineTransform2));
    }

    private void append(Shape shape) {
        this.addShape(ShapeUtil.transformShape((Shape)shape, (AffineTransform)this.currentTransform));
    }

    public void fillShape(Shape shape) {
        this.append(shape);
    }

    public void drawShape(Shape shape) {
        this.append(this.currentStroke.createStrokedShape(shape));
    }

    public void drawImage(BufferedImage bufferedImage) {
        this.append(new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void drawImage(Image image, ImageObserver imageObserver) {
        this.append(new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(null), image.getHeight(null)));
    }

    public void drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.append(new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(null), image.getHeight(null)), affineTransform);
    }

    public void setPaint(Paint paint) {
    }

    public void setPaint(Provider<Paint> provider) {
    }

    public void setStroke(Stroke stroke) {
        this.currentStroke = stroke;
    }

    public Stroke stroke() {
        return this.currentStroke;
    }

    public void applyClip(Shape shape) {
        Shape shape2 = ShapeUtil.transformShape((Shape)shape, (AffineTransform)this.currentTransform);
        this.currentClip = this.currentClip != null ? ShapeUtil.intersect((Shape)this.currentClip, (Shape)shape2, (boolean)true, (boolean)false) : shape2;
    }

    public void setClip(Shape shape) {
        this.currentClip = shape != null ? ShapeUtil.transformShape((Shape)shape, (AffineTransform)this.currentTransform) : null;
    }

    public Optional<Float> contextFontSize() {
        return Optional.empty();
    }

    public Output createChild() {
        return new GamaShapeSVGOutput(this);
    }

    public void dispose() {
    }

    public void debugPaint(Consumer<Graphics2D> consumer) {
    }

    public Rectangle2D clipBounds() {
        float f = 8.5070587E37f;
        return this.currentClip != null ? this.currentClip.getBounds2D() : new Rectangle2D.Float(-f, -f, 2.0f * f, 2.0f * f);
    }

    public RenderingHints renderingHints() {
        return null;
    }

    public Object renderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public AffineTransform transform() {
        return new AffineTransform(this.currentTransform);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.currentTransform = new AffineTransform(affineTransform);
    }

    public void applyTransform(AffineTransform affineTransform) {
        this.currentTransform.concatenate(affineTransform);
    }

    public void rotate(double d) {
        this.currentTransform.rotate(d);
    }

    public void scale(double d, double d2) {
        this.currentTransform.scale(d, d2);
    }

    public void translate(double d, double d2) {
        this.currentTransform.translate(d, d2);
    }

    public float currentOpacity() {
        return 1.0f;
    }

    public void applyOpacity(float f) {
    }

    public Output.SafeState safeState() {
        return new ShapeOutputSafeState(this);
    }

    public boolean supportsFilters() {
        return false;
    }

    public boolean supportsColors() {
        return false;
    }

    public boolean isSoftClippingEnabled() {
        return false;
    }

    @Override
    public Iterator<IShape> iterator() {
        return this.shapes.iterator();
    }

    private static class ShapeOutputSafeState
    implements Output.SafeState {
        private final GamaShapeSVGOutput shapeOutput;
        private final Stroke oldStroke;
        private final AffineTransform oldTransform;
        private final Area oldClip;

        private ShapeOutputSafeState(GamaShapeSVGOutput gamaShapeSVGOutput) {
            this.shapeOutput = gamaShapeSVGOutput;
            this.oldStroke = gamaShapeSVGOutput.stroke();
            this.oldTransform = gamaShapeSVGOutput.transform();
            this.oldClip = gamaShapeSVGOutput.currentClip != null ? new Area(gamaShapeSVGOutput.currentClip) : null;
        }

        public void restore() {
            this.shapeOutput.currentStroke = this.oldStroke;
            this.shapeOutput.currentTransform = this.oldTransform;
            this.shapeOutput.currentClip = this.oldClip;
        }
    }
}

