/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.root.PlatformAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.util.GamaColor;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.extension.image.GamaImage;
import gama.extension.image.ImageConstants;
import gama.extension.image.ImageHelper;
import gama.extension.image.SnapshotMaker;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public class ImageOperators
implements ImageConstants {
    @GamlAnnotations.operator(value={"snapshot"}, can_be_const=false)
    @GamlAnnotations.doc(value="Takes a snapshot of the display whose name is passed in parameter and returns the image. The search for the display begins in the current agent's simulation and, if not found, its experiment. Returns nil if no display can be found or the snapshot cannot be taken.")
    public static GamaImage snapshot(IScope iScope, String string) {
        return ImageOperators.snapshot(iScope, iScope.getAgent(), string);
    }

    @GamlAnnotations.operator(value={"snapshot"}, can_be_const=false)
    @GamlAnnotations.doc(value="Takes a snapshot of the display whose name is passed in parameter and returns the image. The search for the display begins in the agent passed in parameter and, if not found, its experiment. The size of the snapshot will be that of the viewReturns nil if no display can be found or the snapshot cannot be taken.")
    public static GamaImage snapshot(IScope iScope, IAgent iAgent, String string) {
        ITopLevelAgent iTopLevelAgent;
        if (iAgent == null) {
            return null;
        }
        ITopLevelAgent iTopLevelAgent2 = iAgent instanceof ITopLevelAgent ? (iTopLevelAgent = (ITopLevelAgent)iAgent) : iAgent.getTopLevelHost();
        IOutput iOutput = null;
        while (iTopLevelAgent2 != null && iOutput == null) {
            iOutput = iTopLevelAgent2.getOutputManager().getOutputWithOriginalName(string);
            iTopLevelAgent2 = iTopLevelAgent2.getTopLevelHost();
        }
        if (!(iOutput instanceof LayeredDisplayOutput)) {
            return null;
        }
        LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
        IDisplaySurface iDisplaySurface = layeredDisplayOutput.getSurface();
        return SnapshotMaker.getInstance().captureImage(iDisplaySurface, null);
    }

    @GamlAnnotations.operator(value={"snapshot"}, can_be_const=false)
    @GamlAnnotations.doc(value="Takes a snapshot of the display whose name is passed in parameter and returns the image. The search for the display begins in the agent passed in parameter and, if not found, its experiment. A custom size (a point representing width x height) can be given Returns nil if no display can be found or the snapshot cannot be taken.")
    public static GamaImage snapshot(IScope iScope, IAgent iAgent, String string, GamaPoint gamaPoint) {
        ITopLevelAgent iTopLevelAgent;
        if (iAgent == null) {
            return null;
        }
        ITopLevelAgent iTopLevelAgent2 = iAgent instanceof ITopLevelAgent ? (iTopLevelAgent = (ITopLevelAgent)iAgent) : iAgent.getTopLevelHost();
        IOutput iOutput = null;
        while (iTopLevelAgent2 != null && iOutput == null) {
            iOutput = iTopLevelAgent2.getOutputManager().getOutputWithOriginalName(string);
            iTopLevelAgent2 = iTopLevelAgent2.getTopLevelHost();
        }
        if (!(iOutput instanceof LayeredDisplayOutput)) {
            return null;
        }
        LayeredDisplayOutput layeredDisplayOutput = (LayeredDisplayOutput)iOutput;
        IDisplaySurface iDisplaySurface = layeredDisplayOutput.getSurface();
        return SnapshotMaker.getInstance().captureImage(iDisplaySurface, gamaPoint);
    }

    public static String imgToBase64String(GamaImage gamaImage, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)gamaImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @GamlAnnotations.operator(value={"send_image_to_websocket"}, can_be_const=false)
    @GamlAnnotations.doc(value="Send the given image to the websocket in Base64 using the given format.")
    public static GamaImage sendImageWebsocket(IScope iScope, GamaImage gamaImage, String string) {
        PlatformAgent platformAgent = GAMA.getPlatformAgent();
        platformAgent.sendMessage(iScope, (Object)ImageOperators.imgToBase64String(gamaImage, string), GamaServerMessage.Type.SimulationImage);
        return gamaImage;
    }

    @GamlAnnotations.operator(value={"send_image_to_websocket"}, can_be_const=false)
    @GamlAnnotations.doc(value="Send the given image to the websocket using Base64 assuming the format is png.")
    public static GamaImage sendImageWebsocket(IScope iScope, GamaImage gamaImage) {
        return ImageOperators.sendImageWebsocket(iScope, gamaImage, "png");
    }

    @GamlAnnotations.operator(value={"grayscale"})
    @GamlAnnotations.doc(value="Used to convert any image to a grayscale color palette and return it. The original image is left untouched")
    public static GamaImage grayscale(IScope iScope, GamaImage gamaImage) {
        try {
            return ImageHelper.apply(gamaImage, OP_GRAYSCALE);
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"darker"})
    @GamlAnnotations.doc(value="Used to return an image 10% darker. This operation can be applied multiple times in a row if greater than 10% changes in brightness are desired.")
    public static GamaImage darker(IScope iScope, GamaImage gamaImage) {
        try {
            return ImageHelper.apply(gamaImage, OP_DARKER);
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"darker"})
    @GamlAnnotations.doc(value="Used to return an image darker by a percentage (between 0 - no change - and 1 - 100% darker). If the percentage is below zero or above 1, returns the image untouched")
    public static GamaImage darker(IScope iScope, GamaImage gamaImage, double d) {
        try {
            if (d < 0.0 || d > 1.0) {
                return gamaImage;
            }
            float f = (float)(1.0 - d);
            return ImageHelper.apply(gamaImage, new RescaleOp(f, 0.0f, HINTS));
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"brighter"})
    @GamlAnnotations.doc(value="Used to return an image 10% brigther. This operation can be applied multiple times in a row if greater than 10% changes in brightness are desired.")
    public static GamaImage brigther(IScope iScope, GamaImage gamaImage) {
        try {
            return ImageHelper.apply(gamaImage, OP_BRIGHTER);
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"brighter"})
    @GamlAnnotations.doc(value="Used to return an image brighter by a percentage (between 0 - no change - and 1 - 100% brighter). If the percentage is below zero or above 1, returns the image untouched")
    public static GamaImage brigther(IScope iScope, GamaImage gamaImage, double d) {
        try {
            if (d < 0.0 || d > 1.0) {
                return gamaImage;
            }
            float f = (float)d;
            return ImageHelper.apply(gamaImage, new RescaleOp(1.0f + f, 0.0f, HINTS));
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"antialiased"})
    @GamlAnnotations.doc(value="Application of a very light blur kernel that acts like an anti-aliasing filter when applied to an image. This operation can be applied multiple times in a row if greater.")
    public static GamaImage antialiased(IScope iScope, GamaImage gamaImage) {
        try {
            return ImageHelper.apply(gamaImage, OP_ANTIALIAS);
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"antialiased"})
    @GamlAnnotations.doc(value="Application of a very light blur kernel that acts like an anti-aliasing filter when applied to an image. If the last argument is > 0,  applies the filter the equivalent number of times. If it is equal or smaller than zero, the image is returned untouched")
    public static GamaImage antialiased(IScope iScope, GamaImage gamaImage, int n) {
        try {
            return ImageHelper.apply(gamaImage, OP_ANTIALIAS, n);
        }
        catch (Exception exception) {
            return gamaImage;
        }
    }

    @GamlAnnotations.operator(value={"*"})
    @GamlAnnotations.doc(value="Applies a proportional scaling ratio to the image passed in parameter and returns a new scaled image. A ratio of 0 will return nil, a ratio of 1 will return the original image. Automatic scaling and resizing methods are used. The original image is left untouched")
    public static GamaImage scaled_by(IScope iScope, GamaImage gamaImage, Double d) {
        if (d == 0.0) {
            return null;
        }
        if (d == 1.0) {
            return gamaImage;
        }
        int n = (int)Math.round((double)gamaImage.getWidth() * d);
        int n2 = (int)Math.round((double)gamaImage.getHeight() * d);
        return ImageHelper.resize(gamaImage, ImageHelper.Mode.FIT_TO_WIDTH, n, n2);
    }

    @GamlAnnotations.operator(value={"with_width"})
    @GamlAnnotations.doc(value="Applies a proportional scaling to the image passed in parameter to  return a new scaled image with the corresponding width. A width of 0 will return nil, a width equal to the width of the image will return the original image. Automatic scaling and resizing methods are used. The original image is left untouched")
    public static GamaImage with_width(IScope iScope, GamaImage gamaImage, Integer n) {
        return gamaImage == null || (double)n.intValue() <= 0.0 ? null : (n.intValue() == gamaImage.getWidth() ? gamaImage : ImageHelper.resize(gamaImage, ImageHelper.Mode.FIT_TO_WIDTH, n, n));
    }

    @GamlAnnotations.operator(value={"with_height"})
    @GamlAnnotations.doc(value="Applies a proportional scaling to the image passed in parameter to return a new scaled image with the corresponding height. A height of 0 will return nil, a height equal to the height of the image will return the original image. Automatic scaling and resizing methods are used. The original image is left untouched")
    public static GamaImage with_height(IScope iScope, GamaImage gamaImage, Integer n) {
        return gamaImage == null || (double)n.intValue() <= 0.0 ? null : (n.intValue() == gamaImage.getHeight() ? gamaImage : ImageHelper.resize(gamaImage, ImageHelper.Mode.FIT_TO_HEIGHT, n, n));
    }

    @GamlAnnotations.operator(value={"with_size"})
    @GamlAnnotations.doc(value="Applies a non-proportional scaling to the image passed in parameter to return a new scaled image with the corresponding width and height. A height of 0 or a width of 0 will return nil. If the width and height parameters are repectively equal to the width and height of the original image, it is returned. Automatic scaling and resizing methods are used. The original image is left untouched")
    public static GamaImage with_size(IScope iScope, GamaImage gamaImage, Integer n, Integer n2) {
        return gamaImage == null || (double)n2.intValue() <= 0.0 || (double)n.intValue() <= 0.0 ? null : (n2.intValue() == gamaImage.getHeight() && n.intValue() == gamaImage.getWidth() ? gamaImage : ImageHelper.resize(gamaImage, ImageHelper.Mode.FIT_EXACT, n, n2));
    }

    @GamlAnnotations.operator(value={"horizontal_flip"})
    @GamlAnnotations.doc(value="Returns an image flipped horizontally by reflecting the original image around the y axis. The original image is left untouched")
    public static GamaImage horizontalFlip(IScope iScope, GamaImage gamaImage) {
        return ImageHelper.rotate(gamaImage, 0);
    }

    @GamlAnnotations.operator(value={"vertical_flip"})
    @GamlAnnotations.doc(value="Returns an image flipped vertically by reflecting the original image around the x axis. The original image is left untouched")
    public static GamaImage verticalFlip(IScope iScope, GamaImage gamaImage) {
        return ImageHelper.rotate(gamaImage, 1);
    }

    @GamlAnnotations.operator(value={"rotated_by"})
    @GamlAnnotations.doc(value="Returns the image rotated using the angle in degrees passed in parameter. A positive angle means a clockwise rotation, and a negative one a counter-clockwise. The original image is left untouched")
    public static GamaImage rotated(IScope iScope, GamaImage gamaImage, double d) {
        double d2 = Math.abs(d) % 360.0 * Math.signum(d);
        if (d2 == Math.floor(d2)) {
            switch ((int)d2) {
                case 0: {
                    return gamaImage;
                }
                case -270: 
                case 90: {
                    return ImageHelper.rotate(gamaImage, 90);
                }
                case -180: 
                case 180: {
                    return ImageHelper.rotate(gamaImage, 180);
                }
                case -90: 
                case 270: {
                    return ImageHelper.rotate(gamaImage, 270);
                }
            }
        }
        double d3 = Math.toRadians(d2);
        double d4 = Math.abs(Math.sin(d3));
        double d5 = Math.abs(Math.cos(d3));
        int n = gamaImage.getWidth();
        int n2 = gamaImage.getHeight();
        int n3 = (int)Math.floor((double)n * d5 + (double)n2 * d4);
        int n4 = (int)Math.floor((double)n2 * d5 + (double)n * d4);
        GamaImage gamaImage2 = GamaImage.ofDimensions(n3, n4, 2);
        Graphics2D graphics2D = gamaImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.setComposite(AlphaComposite.getInstance(3));
        graphics2D.setRenderingHints(HINTS);
        graphics2D.translate((n3 - n) / 2, (n4 - n2) / 2);
        graphics2D.rotate(d3, (double)n / 2.0, (double)n2 / 2.0);
        graphics2D.drawImage((Image)gamaImage, 0, 0, null);
        graphics2D.dispose();
        gamaImage2.setId(gamaImage.getId() + "rotated" + d);
        return gamaImage2;
    }

    @GamlAnnotations.operator(value={"tinted_with", "*"})
    @GamlAnnotations.doc(value="Returns the image tinted using the color passed in parameter. This effectively multiplies the colors of the image by it. The original image is left untouched")
    public static GamaImage tint(IScope iScope, GamaImage gamaImage, GamaColor gamaColor) {
        GamaImage gamaImage2 = GamaImage.ofDimensions(gamaImage.getWidth(), gamaImage.getHeight(), 3);
        Graphics2D graphics2D = gamaImage2.createGraphics();
        graphics2D.drawImage((Image)gamaImage, 0, 0, null);
        graphics2D.dispose();
        ColorModel colorModel = gamaImage2.getColorModel();
        WritableRaster writableRaster = gamaImage2.getRaster();
        float f = (float)gamaColor.getRed() / 255.0f;
        float f2 = (float)gamaColor.getGreen() / 255.0f;
        float f3 = (float)gamaColor.getBlue() / 255.0f;
        float f4 = (float)gamaColor.getAlpha() / 255.0f;
        int n = 0;
        while (n < gamaImage2.getWidth()) {
            int n2 = 0;
            while (n2 < gamaImage2.getHeight()) {
                int n3 = colorModel.getAlpha(writableRaster.getDataElements(n, n2, null));
                int n4 = colorModel.getRed(writableRaster.getDataElements(n, n2, null));
                int n5 = colorModel.getGreen(writableRaster.getDataElements(n, n2, null));
                int n6 = colorModel.getBlue(writableRaster.getDataElements(n, n2, null));
                n4 = (int)((float)n4 * f);
                n5 = (int)((float)n5 * f2);
                n6 = (int)((float)n6 * f3);
                n3 = (int)((float)n3 * f4);
                gamaImage2.setRGB(n, n2, n3 << 24 | n4 << 16 | n5 << 8 | n6);
                ++n2;
            }
            ++n;
        }
        gamaImage2.setId(gamaImage.getId() + "tinted" + gamaColor.getRGB());
        return gamaImage2;
    }

    @GamlAnnotations.operator(value={"tinted_with"})
    @GamlAnnotations.doc(value="Returns the image tinted using the color passed in parameter and a factor between 0 and 1, determining the transparency of the dyeing to apply. The original image is left untouched")
    public static GamaImage tint(IScope iScope, GamaImage gamaImage, GamaColor gamaColor, double d) {
        int n = gamaImage.getWidth();
        int n2 = gamaImage.getHeight();
        GamaImage gamaImage2 = GamaImage.ofDimensions(n, n2, 2);
        Graphics2D graphics2D = gamaImage2.createGraphics();
        graphics2D.drawImage((Image)gamaImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcAtop.derive(Math.min(1.0f, Math.max((float)d, 0.0f))));
        graphics2D.setColor((Color)gamaColor);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        gamaImage2.setId(gamaImage.getId() + "tinted" + String.valueOf(gamaColor) + "|" + d);
        return gamaImage2;
    }

    @GamlAnnotations.operator(value={"blend"}, can_be_const=true)
    @GamlAnnotations.doc(value="Blend two images with an optional ratio between 0 and 1 (determines the transparency of the second image, applied as an overlay to the first). The size of the resulting image is that of the first parameter. The original image is left untouched", masterDoc=true, examples={@GamlAnnotations.example(value="blend(img1, img2, 0.3)", equals="to a composed image with the two", isExecutable=false)})
    public static GamaImage blend(IScope iScope, GamaImage gamaImage, GamaImage gamaImage2, double d) {
        GamaImage gamaImage3 = ImageHelper.copyToOptimalImage(gamaImage);
        Graphics2D graphics2D = gamaImage3.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver.derive(Math.min(1.0f, Math.max((float)d, 0.0f))));
        int n = (gamaImage3.getWidth() - gamaImage2.getWidth()) / 2;
        int n2 = (gamaImage3.getHeight() - gamaImage2.getHeight()) / 2;
        graphics2D.drawImage((Image)gamaImage2, n, n2, null);
        graphics2D.dispose();
        gamaImage3.setId(gamaImage.getId() + "|" + gamaImage2.getId());
        return gamaImage3;
    }

    @GamlAnnotations.operator(value={"blurred"})
    @GamlAnnotations.doc(value="Application of a blurrying filter to the image passed in parameter. This operation can be applied multiple times. The original image is left untouched")
    public static GamaImage blur(IScope iScope, GamaImage gamaImage) {
        return ImageHelper.apply(gamaImage, OP_BLUR);
    }

    @GamlAnnotations.operator(value={"blurred"})
    @GamlAnnotations.doc(value="Application of a blurrying filter to the image passed in parameter. This operation is applied multiple times if the last argument is > 0. The original image is left untouched")
    public static GamaImage blur(IScope iScope, GamaImage gamaImage, int n) {
        return ImageHelper.apply(gamaImage, OP_BLUR, n);
    }

    @GamlAnnotations.operator(value={"sharpened"})
    @GamlAnnotations.doc(value="Application of a sharpening filter to the image passed in parameter. This operation can be applied multiple times. The original image is left untouched")
    public static GamaImage sharpen(IScope iScope, GamaImage gamaImage) {
        return ImageHelper.apply(gamaImage, OP_SHARPEN);
    }

    @GamlAnnotations.operator(value={"sharpened"})
    @GamlAnnotations.doc(value="Application of a sharpening filter to the image passed in parameter. This operation is applied multiple times if the last argument is > 0. The original image is left untouched")
    public static GamaImage sharpen(IScope iScope, GamaImage gamaImage, int n) {
        return ImageHelper.apply(gamaImage, OP_SHARPEN, n);
    }

    @GamlAnnotations.operator(value={"clipped_with", "cropped_to"})
    @GamlAnnotations.doc(value="Used to crop the given image using a rectangle starting at the top-left x, y coordinates and expanding using the width and height. If one of the dimensions of the resulting image is 0, of if they are equal to that of the given image, returns it.  The original image is left untouched")
    public static GamaImage cropped(IScope iScope, GamaImage gamaImage, int n, int n2, int n3, int n4) {
        int n5 = gamaImage.getWidth();
        int n6 = gamaImage.getHeight();
        int n7 = Math.min(n5, Math.max(0, n3));
        int n8 = Math.min(n6, Math.max(0, n4));
        int n9 = Math.min(n5, Math.max(0, n));
        int n10 = Math.min(n6, Math.max(0, n2));
        if (n9 == n7 || n7 == 0 || n8 == 0 || n10 == n8) {
            return gamaImage;
        }
        if (n9 == 0 && n10 == 0 && n7 == n5 && n8 == n6) {
            return gamaImage;
        }
        GamaImage gamaImage2 = GamaImage.bestFor(gamaImage, n7, n8);
        Graphics graphics = gamaImage2.getGraphics();
        graphics.drawImage(gamaImage, 0, 0, n7, n8, n9, n10, n9 + n7, n10 + n8, null);
        graphics.dispose();
        gamaImage2.setId(gamaImage.getId() + "crop" + n + "|" + n2 + "|" + n3 + "|" + n4);
        return gamaImage2;
    }

    @GamlAnnotations.operator(value={"copy_to_clipboard"}, can_be_const=false, category={"System"}, concept={"system"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="bool copied  <- copy_to_clipboard(img);")}, value="Tries to copy the given image to the clipboard and returns whether it has been correctly copied or not (for instance it might be impossible in a headless environment)")
    public static Boolean copyToClipboard(IScope iScope, GamaImage gamaImage) {
        if (gamaImage == null || ImageConstants.clipboard == null) {
            return false;
        }
        ImageConstants.clipboard.setContents(new ImageHelper.TransferableImage(gamaImage), null);
        return true;
    }

    @GamlAnnotations.operator(can_be_const=true, value={"image"})
    @GamlAnnotations.doc(value="Builds a new blank image of the specified dimensions, which does not accept transparency")
    public static GamaImage image(int n, int n2) {
        return GamaImage.ofDimensions(n, n2, 2);
    }

    @GamlAnnotations.operator(can_be_const=true, value={"image"})
    @GamlAnnotations.doc(value="Builds a new image with the specified dimensions and already filled with the given rgb color")
    public static GamaImage image(int n, int n2, GamaColor gamaColor) {
        GamaImage gamaImage = GamaImage.ofDimensions(n, n2, 2);
        Graphics2D graphics2D = gamaImage.createGraphics();
        graphics2D.setColor((Color)gamaColor);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return gamaImage;
    }

    @GamlAnnotations.operator(can_be_const=true, value={"image"})
    @GamlAnnotations.doc(value="Builds a new blank image with the specified dimensions and indicates if it will support transparency or not")
    public static GamaImage image(int n, int n2, boolean bl) {
        return GamaImage.ofDimensions(n, n2, bl ? 2 : 1);
    }

    @GamlAnnotations.operator(value={"matrix"}, content_type=1, can_be_const=true)
    @GamlAnnotations.doc(value="Returns the matrix<int> value of the image passed in parameter, where each pixel is represented by the RGB int value. The dimensions of the matrix are those of the image. ")
    public static IMatrix matrix(IScope iScope, GamaImage gamaImage) {
        int n = gamaImage.getWidth();
        int n2 = gamaImage.getHeight();
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                gamaIntMatrix.set(iScope, n3, n4, (Object)gamaImage.getRGB(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return gamaIntMatrix;
    }
}

