/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import gama.core.util.matrix.GamaField;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.extension.image.GamaImage;
import gama.extension.image.GamaImageFile;
import gama.extension.image.GamaSVGFile;
import gama.extension.image.ImageConstants;
import gama.extension.image.ImageHelper;
import gama.extension.image.ImageOperators;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaFileType;
import gama.gaml.types.GamaType;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

@GamlAnnotations.type(name="image", id=80, wraps={GamaImage.class}, kind=104, doc={@GamlAnnotations.doc(value="Represents ARGB image objects that can be passed directly as arguments to draw statements and other similar functions. An image can be created from many different sources : a field, a grid, a file containing an image, and a number of operators allow to apply filters or to combine them. They can of course be saved on disk")}, concept={"type", "image", "display"})
public class GamaImageType
extends GamaType<GamaImage> {
    public static final int ID = 80;

    @GamlAnnotations.doc(value="Cast any object to an image", usages={@GamlAnnotations.usage(value="if the operand is a point, returns an empty image of dimensions x and y", examples={@GamlAnnotations.example(value="image i <- image({100,100}); // equivalent to image(100, 100)")}), @GamlAnnotations.usage(value="if the operand is a grid species, returns an image of the same dimension where each cell gives its color to the corresponding pixel", examples={@GamlAnnotations.example(value="image f <- image(my_grid);")}), @GamlAnnotations.usage(value="if the operand is a field (or a matrix of float), return an image, where each cell gives a gray value to the corresponding pixel (after normalization)", examples={@GamlAnnotations.example(value="image f <- image(my_field);")}), @GamlAnnotations.usage(value="if the operand is a string, tries to load the corresponding file (if any) as an image_file and returns its contents, otherwise returns nil if it doesnt exist or if the path does not represent an image file", examples={@GamlAnnotations.example(value="image f <- image('/images/image.png');")}), @GamlAnnotations.usage(value="in all other cases, return nil", examples={@GamlAnnotations.example(value="image f <- image(12); // --> nil")})})
    public GamaImage cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaImageType.staticCast(iScope, object, bl);
    }

    public static GamaImage staticCast(IScope iScope, Object object, boolean bl) throws GamaRuntimeException {
        ISpecies iSpecies;
        if (object instanceof GamaImage) {
            GamaImage gamaImage = (GamaImage)object;
            if (bl) {
                return GamaImage.from(gamaImage, gamaImage.getAlpha(iScope));
            }
            return gamaImage;
        }
        if (object instanceof GamaIntMatrix) {
            GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)object;
            return GamaImage.from(iScope, gamaIntMatrix);
        }
        if (object instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)object;
            return GamaImage.from(bufferedImage, true);
        }
        if (object instanceof Image) {
            Image image = (Image)object;
            return ImageHelper.copyToOptimalImage(image);
        }
        if (object instanceof GamaSVGFile) {
            GamaSVGFile gamaSVGFile = (GamaSVGFile)((Object)object);
            return GamaImage.from(gamaSVGFile.getImage(iScope, true), true, gamaSVGFile.getOriginalPath());
        }
        if (object instanceof GamaImageFile) {
            GamaImageFile gamaImageFile = (GamaImageFile)((Object)object);
            return GamaImage.from(gamaImageFile.getImage(iScope, true), true, gamaImageFile.getOriginalPath());
        }
        if (object instanceof GamaPoint) {
            GamaPoint gamaPoint = (GamaPoint)object;
            return ImageOperators.image((int)gamaPoint.getX(), (int)gamaPoint.getY());
        }
        if (object instanceof String) {
            String string = (String)object;
            return GamaImageType.staticCast(iScope, GamaFileType.createFile((IScope)iScope, (String)string, (boolean)false, null), false);
        }
        if (object instanceof GamaField) {
            GamaField gamaField = (GamaField)object;
            return GamaImage.from(iScope, gamaField);
        }
        if (object instanceof ISpecies && (iSpecies = (ISpecies)object).isGrid()) {
            return GamaImage.from((GamaSpatialMatrix)iSpecies.getPopulation(iScope).getTopology().getPlaces());
        }
        return null;
    }

    public GamaImage getDefault() {
        return null;
    }

    public boolean canCastToConst() {
        return true;
    }

    public boolean isDrawable() {
        return true;
    }

    public GamaImage copyFromClipboard(IScope iScope) {
        if (ImageConstants.clipboard == null) {
            return null;
        }
        Transferable transferable = ImageConstants.clipboard.getContents(null);
        if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return null;
        }
        try {
            return GamaImageType.staticCast(iScope, transferable.getTransferData(DataFlavor.imageFlavor), false);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    public GamaImage deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return GamaImage.from(iScope, GamaIntMatrix.from((IScope)iScope, (IMatrix)Cast.asMatrix((IScope)iScope, (Object)iMap.get((Object)"pixels"))));
    }
}

