/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.attributes.ViewBox;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.DocumentLimits;
import com.github.weisj.jsvg.parser.LoaderContext;
import com.github.weisj.jsvg.parser.SVGLoader;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.awt.NullPlatformSupport;
import com.github.weisj.jsvg.renderer.awt.PlatformSupport;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.core.util.file.IGamaFile;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.extension.image.GamaImageFile;
import gama.extension.image.GamaShapeSVGOutput;
import gama.extension.image.ImageCache;
import gama.extension.image.ImageHelper;
import gama.extension.image.ImageOperators;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;

@GamlAnnotations.file(name="svg", extensions={"svg"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"svg"}, doc={@GamlAnnotations.doc(value="Represents 2D geometries described in a SVG file. The internal representation is a list of geometries. Using the 'image' operator on the file allows to retrieve the full image")})
public class GamaSVGFile
extends GamaGeometryFile {
    static RenderingHints RENDER_HINTS = new RenderingHints(null);
    private SVGDocument document;
    static LoaderContext lc;

    static {
        DEBUG.OFF();
        RENDER_HINTS.putAll(Map.of(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY, RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE, RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC, RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY, RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY, RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        RENDER_HINTS.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        lc = LoaderContext.builder().documentLimits(new DocumentLimits(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)).build();
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a svg file", examples={@GamlAnnotations.example(value="file f <-svg_file(\"file.svg\");", isExecutable=false)})
    public GamaSVGFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry((IScope)iScope, (IContainer)this.getBuffer());
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create((IType)Types.STRING);
    }

    private SVGDocument getDocument(IScope iScope) {
        if (this.document == null) {
            SVGLoader sVGLoader = new SVGLoader();
            File file2 = this.getFile(iScope);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
                    this.document = sVGLoader.load(inputStream, file2.toURI(), lc);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.document;
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        try {
            GamaShapeSVGOutput gamaShapeSVGOutput = new GamaShapeSVGOutput();
            this.getDocument(iScope).renderWithPlatform((PlatformSupport)NullPlatformSupport.INSTANCE, (Output)gamaShapeSVGOutput, null);
            this.setBuffer((IAddressableContainer)GamaListFactory.createWithoutCasting((IType)Types.GEOMETRY, (Iterable)gamaShapeSVGOutput));
        }
        catch (Exception exception) {
            throw GamaRuntimeException.create((Throwable)exception, (IScope)iScope);
        }
    }

    public BufferedImage getImage(IScope iScope, boolean bl) {
        FloatSize floatSize = this.getDocument(iScope).size();
        return this.getImage(iScope, bl, Math.round(floatSize.width), Math.round(floatSize.height));
    }

    public BufferedImage getImage(IScope iScope, boolean bl, int n, int n2) {
        if (bl) {
            String string = this.getPath(iScope) + n + "x" + n2;
            BufferedImage bufferedImage = ImageCache.getInstance().getImage(string);
            if (bufferedImage == null) {
                bufferedImage = this.getImage(iScope, false, n, n2);
                ImageCache.getInstance().forceCacheImage(bufferedImage, string);
            }
            return bufferedImage;
        }
        SVGDocument sVGDocument = this.getDocument(iScope);
        GamaImage gamaImage = ImageHelper.createPremultipliedBlankImage(n, n2);
        Graphics2D graphics2D = gamaImage.createGraphics();
        try {
            try {
                graphics2D.addRenderingHints(RENDER_HINTS);
                sVGDocument.renderWithPlatform((PlatformSupport)NullPlatformSupport.INSTANCE, graphics2D, new ViewBox((float)n, (float)n2));
            }
            catch (RuntimeException runtimeException) {
                graphics2D.dispose();
            }
        }
        finally {
            graphics2D.dispose();
        }
        return gamaImage;
    }

    @GamlAnnotations.operator(can_be_const=true, value={"image"})
    @GamlAnnotations.doc(value="Builds a new image from the specified file, passing the width and height in parameter ")
    public static GamaImage image(IScope iScope, IGamaFile iGamaFile, int n, int n2) {
        if (iGamaFile instanceof GamaSVGFile) {
            GamaSVGFile gamaSVGFile = (GamaSVGFile)iGamaFile;
            return GamaImage.from(gamaSVGFile.getImage(iScope, true, n, n2), true, iGamaFile.getPath(iScope) + n + "x" + n2);
        }
        if (iGamaFile instanceof GamaImageFile) {
            GamaImageFile gamaImageFile = (GamaImageFile)iGamaFile;
            return ImageOperators.with_size(iScope, GamaImage.from(gamaImageFile.getImage(iScope, true), true, gamaImageFile.getOriginalPath()), n, n2);
        }
        return null;
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        FloatSize floatSize = this.getDocument(iScope).size();
        return Envelope3D.of((double)0.0, (double)floatSize.getWidth(), (double)0.0, (double)floatSize.getHeight(), (double)0.0, (double)0.0);
    }
}

