/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IImageProvider;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaFile;
import gama.core.util.file.GamaGridFile;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.file.IGamaFile;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.extension.image.ImageCache;
import gama.gaml.operators.spatial.SpatialProjections;
import gama.gaml.statements.Facets;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.geotools.data.PrjFileReader;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;

@GamlAnnotations.file(name="image", extensions={"tiff", "jpg", "jpeg", "png", "pict", "bmp"}, buffer_type=8, buffer_content=1, buffer_index=7, concept={"image", "file"}, doc={@GamlAnnotations.doc(value="Image files can be of 6 different formats: tiff, jpeg, png, pict or bmp. Their internal representation is a matrix of colors")})
public class GamaImageFile
extends GamaFile<IMatrix<Integer>, Integer>
implements IFieldMatrixProvider,
IImageProvider,
IGamaFile.Drawable {
    private boolean isGeoreferenced = false;
    private String extension = null;

    @GamlAnnotations.doc(value="This file constructor allows to read an image file (tiff, jpg, jpeg, png, pict, bmp)", examples={@GamlAnnotations.example(value="file f <-image_file(\"file.png\");", isExecutable=false)})
    public GamaImageFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an image file (tiff, jpg, jpeg, png, pict, bmp) and to force the extension of the file (can be useful for images coming from URL)", examples={@GamlAnnotations.example(value="file f <-image_file(\"http://my_url\", \"png\");", isExecutable=false)})
    public GamaImageFile(IScope iScope, String string, String string2) throws GamaRuntimeException {
        super(iScope, string);
        this.extension = string2;
    }

    @GamlAnnotations.doc(value="This file constructor allows to store a matrix in a image file (it does not save it - just store it in memory)", examples={@GamlAnnotations.example(value="file f <-image_file(\"file.png\");", isExecutable=false)})
    public GamaImageFile(IScope iScope, String string, IMatrix<Integer> iMatrix) {
        super(iScope, string, iMatrix);
        ImageCache.getInstance().clearCache(this.getPath(iScope));
    }

    public GamaImageFile(IScope iScope, String string, BufferedImage bufferedImage) {
        super(iScope, string, null);
        ImageCache.getInstance().forceCacheImage(bufferedImage, string);
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    public IContainerType getGamlType() {
        return Types.FILE.of((IType)Types.POINT, (IType)Types.INT);
    }

    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer((IAddressableContainer)(this.isPgmFile() || "pgm".equals(this.getExtension(iScope)) ? this.matrixValueFromPgm(iScope, null) : this.matrixValueFromImage(iScope, null)));
    }

    protected boolean isPgmFile() {
        return false;
    }

    protected void flushBuffer(IScope iScope, Facets facets) throws GamaRuntimeException {
        if (!this.writable || this.getBuffer() == null || ((IMatrix)this.getBuffer()).isEmpty(iScope)) {
            return;
        }
        try {
            File file2 = this.getFile(iScope);
            file2.setWritable(true);
            ImageIO.write((RenderedImage)GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)((IMatrix)this.getBuffer())), this.getExtension(iScope), file2);
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
        }
    }

    protected IMatrix _matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        this.getContents(iScope);
        if (gamaPoint != null) {
            return this.matrixValueFromImage(iScope, gamaPoint).matrixValue(iScope, iType, bl);
        }
        return ((IMatrix)this.getBuffer()).matrixValue(iScope, iType, bl);
    }

    protected BufferedImage loadImage(IScope iScope, boolean bl) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageCache.getInstance().getImageFromFile(iScope, this.getPath(iScope), bl, null, this.extension);
            if (bufferedImage == null) {
                throw GamaRuntimeException.error((String)("This image format (." + this.getExtension(iScope) + ") is not recognized. Please use a proper operator to read it (for example, pgm_file to read a .pgm format"), (IScope)iScope);
            }
        }
        catch (Exception exception) {
            GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)exception, (IScope)iScope), (boolean)true);
            return null;
        }
        return bufferedImage;
    }

    public BufferedImage getImage(IScope iScope, boolean bl) {
        return this.loadImage(iScope, bl);
    }

    private IMatrix matrixValueFromImage(IScope iScope, GamaPoint gamaPoint) throws GamaRuntimeException {
        BufferedImage bufferedImage = this.loadImage(iScope, true);
        return GamaImageFile.matrixValueFromImage(iScope, bufferedImage, gamaPoint);
    }

    public static IMatrix matrixValueFromImage(IScope iScope, BufferedImage bufferedImage, GamaPoint gamaPoint) {
        Object object;
        int n;
        int n2;
        BufferedImage bufferedImage2 = bufferedImage;
        if (gamaPoint == null) {
            n2 = bufferedImage.getWidth();
            n = bufferedImage.getHeight();
        } else {
            n2 = (int)gamaPoint.getX();
            n = (int)gamaPoint.getY();
            bufferedImage2 = new BufferedImage(n2, n, 1);
            object = bufferedImage2.createGraphics();
            ((Graphics)object).drawImage(bufferedImage, 0, 0, n2, n, null);
            ((Graphics)object).dispose();
        }
        object = new GamaIntMatrix(n2, n);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                object.set(iScope, n3, n4, (Object)bufferedImage2.getRGB(n3, n4));
                ++n4;
            }
            ++n3;
        }
        return object;
    }

    private IMatrix matrixValueFromPgm(IScope iScope, GamaPoint gamaPoint) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFile(iScope)));){
                String string = bufferedReader.readLine();
                if (string != null && !"P2".equals(string)) {
                    throw new UnsupportedEncodingException("File is not in PGM ascii format");
                }
                string = bufferedReader.readLine();
                if (string == null) {
                    return GamaMatrixType.with((IScope)iScope, (Object)0, (GamaPoint)gamaPoint, (IType)Types.INT);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                bufferedReader.readLine();
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append(' ');
                    string2 = bufferedReader.readLine();
                }
                string = stringBuilder.toString();
                stringTokenizer = new StringTokenizer(string);
                GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(n, n2);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = 0;
                    while (n4 < n) {
                        Integer n5 = Integer.valueOf(stringTokenizer.nextToken());
                        gamaIntMatrix.set(iScope, n4, n3, (Object)n5);
                        ++n4;
                    }
                    ++n3;
                }
                return gamaIntMatrix;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            throw GamaRuntimeException.create((Throwable)throwable, (IScope)iScope);
        }
    }

    public String getGeoDataFile(IScope iScope) {
        String string = this.getExtension(iScope);
        String string2 = null;
        Object object = this.getPath(iScope).replaceAll(string, "");
        if ("jpg".equals(string)) {
            object = (String)object + "jgw";
        } else if ("png".equals(string)) {
            object = (String)object + "pgw";
        } else if ("tiff".equals(string) || "tif".equals(string)) {
            object = (String)object + "tfw";
            string2 = "";
        } else {
            return null;
        }
        File file2 = new File((String)object);
        if (file2.exists()) {
            return object;
        }
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    public Envelope3D computeEnvelope(IScope var1_1) {
        block52: {
            var2_2 = this.getGeoDataFile(var1_1);
            var3_3 = 1.0;
            var5_4 = 1.0;
            var7_5 = 0.0;
            var9_6 = 0.0;
            var11_7 = false;
            var12_8 = false;
            var13_9 = this.getExtension(var1_1);
            if (var2_2 != null && !"".equals(var2_2)) {
                try {
                    var14_10 = null;
                    var15_14 = null;
                    try {
                        var16_19 = Files.newInputStream(new File(var2_2).toPath(), new OpenOption[0]);
                        try {
                            var17_22 = new InputStreamReader(var16_19);
                            try {
                                var18_24 = new BufferedReader(var17_22);
                                try {
                                    var19_27 = var18_24.readLine();
                                    if (var19_27 != null) {
                                        var20_29 = var19_27.split(" ");
                                        var3_3 = Double.parseDouble(var20_29[var20_29.length - 1]);
                                    }
                                    var11_7 = var3_3 < 0.0;
                                    var19_27 = var18_24.readLine();
                                    var19_27 = var18_24.readLine();
                                    var19_27 = var18_24.readLine();
                                    if (var19_27 != null) {
                                        var20_29 = var19_27.split(" ");
                                        var5_4 = Double.parseDouble(var20_29[var20_29.length - 1]);
                                    }
                                    var12_8 = var5_4 < 0.0;
                                    var19_27 = var18_24.readLine();
                                    if (var19_27 != null) {
                                        var20_29 = var19_27.split(" ");
                                        var7_5 = Double.parseDouble(var20_29[var20_29.length - 1]);
                                    }
                                    if ((var19_27 = var18_24.readLine()) != null) {
                                        var20_29 = var19_27.split(" ");
                                        var9_6 = Double.parseDouble(var20_29[var20_29.length - 1]);
                                    }
                                    this.isGeoreferenced = true;
                                }
                                finally {
                                    if (var18_24 != null) {
                                        var18_24.close();
                                    }
                                }
                                ** if (var17_22 == null) goto lbl-1000
                            }
                            catch (Throwable var15_15) {
                                if (var14_10 == null) {
                                    var14_10 = var15_15;
                                } else if (var14_10 != var15_15) {
                                    var14_10.addSuppressed(var15_15);
                                }
                                if (var17_22 != null) {
                                    var17_22.close();
                                }
                                throw var14_10;
                            }
lbl-1000:
                            // 1 sources

                            {
                                var17_22.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            ** if (var16_19 == null) goto lbl-1000
                        }
                        catch (Throwable var15_16) {
                            if (var14_10 == null) {
                                var14_10 = var15_16;
                            } else if (var14_10 != var15_16) {
                                var14_10.addSuppressed(var15_16);
                            }
                            if (var16_19 != null) {
                                var16_19.close();
                            }
                            throw var14_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            var16_19.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block52;
                        }
                    }
                    catch (Throwable var15_17) {
                        if (var14_10 == null) {
                            var14_10 = var15_17;
                        } else if (var14_10 != var15_17) {
                            var14_10.addSuppressed(var15_17);
                        }
                        throw var14_10;
                    }
                }
                catch (Throwable var14_12) {
                    throw GamaRuntimeException.create((Throwable)var14_12, (IScope)var1_1);
                }
            }
            if (("tiff".equals(var13_9) || "tif".equals(var13_9)) && (var15_14 = (var14_10 = new GamaGridFile(null, this.getPath(var1_1))).computeEnvelope(var1_1)) != null) {
                var16_20 = new GamaPoint(var15_14.getMinX(), var15_14.getMinY());
                var17_23 = new GamaPoint(var15_14.getMaxX(), var15_14.getMaxY());
                if (var2_2 != null) {
                    try {
                        var18_25 = var1_1.getSimulation().getProjectionFactory().forSavingWith(var1_1, var14_10.gis.getTargetCRS(var1_1));
                        var16_20 = GamaShapeFactory.createFrom((Geometry)var18_25.transform(var16_20.getInnerGeometry())).getLocation();
                        var17_23 = GamaShapeFactory.createFrom((Geometry)var18_25.transform(var17_23.getInnerGeometry())).getLocation();
                    }
                    catch (FactoryException var19_28) {
                        var19_28.printStackTrace();
                    }
                }
                this.isGeoreferenced = true;
                return Envelope3D.of((double)var16_20.x, (double)var17_23.x, (double)var16_20.y, (double)var17_23.y, (double)0.0, (double)0.0);
            }
        }
        var14_13 = this.getCols(var1_1);
        var15_18 = this.getRows(var1_1);
        var16_21 = var7_5;
        var18_26 = var7_5 + var3_3 * (double)var14_13;
        var20_30 = var9_6;
        var22_31 = var9_6 + var5_4 * (double)var15_18;
        var24_32 = new GamaPoint(var11_7 != false ? Math.max(var16_21, var18_26) : Math.min(var16_21, var18_26), var12_8 != false ? Math.max(var20_30, var22_31) : Math.min(var20_30, var22_31));
        var25_33 = new GamaPoint(var11_7 != false ? Math.min(var16_21, var18_26) : Math.max(var16_21, var18_26), var12_8 != false ? Math.min(var20_30, var22_31) : Math.max(var20_30, var22_31));
        if (var2_2 != null) {
            var26_34 = this.getPath(var1_1);
            var27_35 = var26_34.replace(com.google.common.io.Files.getFileExtension((String)var26_34), "prj");
            var28_36 = new File(var27_35);
            var29_37 = "EPSG:3857";
            if (var28_36.exists()) {
                var30_38 = null;
                try {
                    var30_38 = FileChannel.open(var28_36.toPath(), new OpenOption[]{StandardOpenOption.READ});
                }
                catch (IOException v0) {}
                if (var30_38 != null) {
                    try {
                        var31_39 = null;
                        var32_41 = null;
                        try {
                            var33_43 = new PrjFileReader((ReadableByteChannel)var30_38);
                            try {
                                if (var33_43.getCoordinateReferenceSystem() != null && (var34_44 = var1_1.getSimulation().getProjectionFactory().forSavingWith(var1_1, var33_43.getCoordinateReferenceSystem())) != null) {
                                    var24_32 = GamaShapeFactory.createFrom((Geometry)var34_44.transform(var24_32.getInnerGeometry())).getLocation();
                                    var25_33 = GamaShapeFactory.createFrom((Geometry)var34_44.transform(var25_33.getInnerGeometry())).getLocation();
                                    return Envelope3D.of((double)var24_32.x, (double)var25_33.x, (double)var24_32.y, (double)var25_33.y, (double)0.0, (double)0.0);
                                }
                            }
                            finally {
                                if (var33_43 != null) {
                                    var33_43.close();
                                }
                            }
                        }
                        catch (Throwable var32_42) {
                            if (var31_39 == null) {
                                var31_39 = var32_42;
                            } else if (var31_39 != var32_42) {
                                var31_39.addSuppressed(var32_42);
                            }
                            throw var31_39;
                        }
                    }
                    catch (IOException | FactoryException v1) {}
                }
            }
            var24_32 = SpatialProjections.to_GAMA_CRS((IScope)var1_1, (IShape)var24_32, (String)var29_37).getLocation();
            var25_33 = SpatialProjections.to_GAMA_CRS((IScope)var1_1, (IShape)var25_33, (String)var29_37).getLocation();
        }
        return Envelope3D.of((double)var24_32.x, (double)var25_33.x, (double)var24_32.y, (double)var25_33.y, (double)0.0, (double)0.0);
    }

    public boolean isGeoreferenced() {
        return this.isGeoreferenced;
    }

    public double getNoData(IScope iScope) {
        return Double.MAX_VALUE;
    }

    public int getRows(IScope iScope) {
        BufferedImage bufferedImage = this.loadImage(iScope, true);
        if (bufferedImage == null) {
            return 0;
        }
        return bufferedImage.getHeight();
    }

    public int getCols(IScope iScope) {
        BufferedImage bufferedImage = this.loadImage(iScope, true);
        if (bufferedImage == null) {
            return 0;
        }
        return bufferedImage.getWidth();
    }

    public int getBandsNumber(IScope iScope) {
        BufferedImage bufferedImage = this.getImage(iScope, true);
        return bufferedImage.getColorModel().getNumComponents();
    }

    public String getExtension() {
        return this.extension;
    }

    public double[] getBand(IScope iScope, int n) {
        BufferedImage bufferedImage = this.getImage(iScope, true);
        double[] dArray = new double[bufferedImage.getWidth() * bufferedImage.getHeight()];
        int[] nArray = new int[dArray.length];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = nArray[n2] & (n + 1) * 255;
            ++n2;
        }
        return dArray;
    }

    public boolean hasGeoDataAvailable(IScope iScope) {
        return this.getGeoDataFile(iScope) != null;
    }

    @GamlAnnotations.file(name="pgm", extensions={"pgm"}, buffer_type=8, buffer_content=1, doc={@GamlAnnotations.doc(value="PGM files are special image files in 256 gray levels")})
    public static class GamaPgmFile
    extends GamaImageFile {
        @GamlAnnotations.doc(value="This file constructor allows to read a pgm file", examples={@GamlAnnotations.example(value="file f <-pgm_file(\"file.pgm\");", isExecutable=false)})
        public GamaPgmFile(IScope iScope, String string) throws GamaRuntimeException {
            super(iScope, string);
        }

        @Override
        protected boolean isPgmFile() {
            return true;
        }

        @Override
        protected void flushBuffer(IScope iScope, Facets facets) throws GamaRuntimeException {
            throw GamaRuntimeException.error((String)("Saving is not yet impletemented for files of type " + this.getExtension(iScope)), (IScope)iScope);
        }
    }
}

