/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.ISnapshotMaker;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.charts.ChartLayer;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import gama.extension.image.ImageHelper;
import gama.gaml.operators.Files;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jfree.chart.JFreeChart;

public class SnapshotMaker
implements ISnapshotMaker {
    Robot robot;
    private static SnapshotMaker instance;

    static {
        DEBUG.ON();
    }

    SnapshotMaker() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            this.robot = null;
        }
    }

    public void takeAndSaveSnapshot(IDisplaySurface iDisplaySurface, GamaPoint gamaPoint) {
        if (iDisplaySurface == null) {
            return;
        }
        IScope.IGraphicsScope iGraphicsScope = iDisplaySurface.getScope();
        if (iGraphicsScope.interrupted()) {
            return;
        }
        GamaImage gamaImage = this.captureImage(iDisplaySurface, gamaPoint);
        if (gamaImage == null) {
            return;
        }
        String string = this.buildPath((IScope)iGraphicsScope, iDisplaySurface);
        try {
            if (string == null || !ImageIO.write((RenderedImage)gamaImage, "png", new File(string))) {
                throw new RuntimeException("Impossible to write image");
            }
            gamaImage.flush();
        }
        catch (Exception exception) {
            GamaRuntimeException gamaRuntimeException = GamaRuntimeException.create((Throwable)exception, (IScope)iGraphicsScope);
            gamaRuntimeException.addContext("Unable to create output stream for snapshot image");
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
        }
    }

    private String buildPath(IScope iScope, IDisplaySurface iDisplaySurface) {
        Object object;
        try {
            Files.newFolder((IScope)iScope, (String)"snapshots");
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create folder snapshots");
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            gamaRuntimeException.printStackTrace();
            return null;
        }
        String string = iDisplaySurface.getData().getAutosavePath();
        if (string == null || string.isBlank()) {
            String string2 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)("snapshots/" + GAMA.getModel().getName() + "_display_" + iDisplaySurface.getOutput().getName()), (boolean)false);
            object = string2 + "_cycle_" + iScope.getClock().getCycle() + "_time_" + System.currentTimeMillis() + ".png";
        } else {
            object = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)("snapshots/" + string), (boolean)false);
            if (!((String)object).endsWith(".png")) {
                object = (String)object + ".png";
            }
        }
        return object;
    }

    public GamaImage captureImage(IDisplaySurface iDisplaySurface, GamaPoint gamaPoint) {
        int n;
        DEBUG.OUT((Object)("Entring image capture at cycle " + iDisplaySurface.getScope().getClock().getCycle()));
        GamaImage gamaImage = null;
        Rectangle rectangle = iDisplaySurface.getBoundsForRobotSnapshot();
        int n2 = gamaPoint == null || gamaPoint.x <= 0.0 ? rectangle.width : (int)gamaPoint.x;
        int n3 = n = gamaPoint == null || gamaPoint.y <= 0.0 ? rectangle.height : (int)gamaPoint.y;
        if (((Boolean)GamaPreferences.Displays.DISPLAY_FAST_SNAPSHOT.getValue()).booleanValue() && this.robot != null) {
            try {
                DEBUG.OUT((Object)("Fast snapshot with dimensions " + String.valueOf(rectangle)));
                BufferedImage bufferedImage = this.robot.createScreenCapture(rectangle);
                gamaImage = ImageHelper.scaleImage(bufferedImage, n2, n);
                bufferedImage.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (gamaImage == null) {
            DEBUG.OUT((Object)("Slow snapshot with dimensions " + n2 + " " + n));
            gamaImage = this.takeSnapshotOfChart(iDisplaySurface.getManager().getOnlyChart(), n2, n);
        }
        if (gamaImage == null) {
            gamaImage = (GamaImage)iDisplaySurface.getImage(n2, n);
        }
        return gamaImage;
    }

    private GamaImage takeSnapshotOfChart(ChartLayer chartLayer, int n, int n2) {
        if (chartLayer == null) {
            return null;
        }
        ChartOutput chartOutput = chartLayer.getChart();
        if (chartOutput == null) {
            return null;
        }
        DEBUG.OUT((Object)("Chart is rendered on " + n + " " + n2));
        GamaImage gamaImage = GamaImage.ofDimensions(n, n2, true);
        JFreeChart jFreeChart = chartOutput.getJFChart();
        Graphics2D graphics2D = gamaImage.createGraphics();
        jFreeChart.draw(graphics2D, (Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, n, n2));
        graphics2D.dispose();
        return gamaImage;
    }

    public void takeAndSaveScreenshot(IScope iScope, String string) {
        Object object;
        Object object2;
        Object object3;
        if (iScope == null || this.robot == null) {
            return;
        }
        if (string == null || string.isBlank()) {
            object3 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)("snapshots/" + GAMA.getModel().getName() + "_screen"), (boolean)false);
            object2 = (String)object3 + "_cycle_" + iScope.getClock().getCycle() + "_time_" + System.currentTimeMillis() + ".png";
        } else {
            object2 = FileUtils.constructAbsoluteFilePath((IScope)iScope, (String)("snapshots/" + string), (boolean)false);
            if (!((String)object2).endsWith(".png")) {
                object2 = (String)object2 + ".png";
            }
        }
        object3 = null;
        try {
            Rectangle rectangle = SnapshotMaker.getScreenTotalArea();
            object = this.robot.createScreenCapture(rectangle);
            object3 = GamaImage.from(object, false);
            object.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (object3 == null) {
            return;
        }
        try {
            Files.newFolder((IScope)iScope, (String)"snapshots");
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create folder snapshots");
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)gamaRuntimeException, (boolean)false);
            gamaRuntimeException.printStackTrace();
            return;
        }
        try {
            ImageIO.write((RenderedImage)object3, "png", new File((String)object2));
            ((Image)object3).flush();
        }
        catch (IOException iOException) {
            object = GamaRuntimeException.create((Throwable)iOException, (IScope)iScope);
            object.addContext("Unable to create output stream for snapshot image");
            GAMA.reportError((IScope)GAMA.getRuntimeScope(), (GamaRuntimeException)((Object)object), (boolean)false);
        }
    }

    public static synchronized SnapshotMaker getInstance() {
        if (instance == null) {
            instance = new SnapshotMaker();
        }
        return instance;
    }

    public static Rectangle getScreenTotalArea() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle = new Rectangle();
        GraphicsDevice[] graphicsDeviceArray2 = graphicsDeviceArray;
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray2[n2];
            Rectangle rectangle2 = graphicsDevice.getDefaultConfiguration().getBounds();
            rectangle.width += rectangle2.width;
            rectangle.height = Math.max(rectangle.height, rectangle2.height);
            ++n2;
        }
        return rectangle;
    }
}

