/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.GeneralSynchronizer;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.interfaces.ILayerManager;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.display.AWTDisplayGraphics;
import gama.core.outputs.display.LayerManager;
import gama.core.outputs.layers.IEventLayerListener;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.extension.image.GamaImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.geom.Envelope;

@GamlAnnotations.display(value={"image"})
@GamlAnnotations.doc(value="A display used to save the graphical representations of agents into image files")
public class ImageDisplaySurface
implements IDisplaySurface {
    private final LayeredDisplayOutput output;
    private GamaImage bufferImage = null;
    private int width = 500;
    private int height = 500;
    private IGraphics displayGraphics;
    ILayerManager manager;
    protected IScope.IGraphicsScope scope;
    private final LayeredDisplayData data;

    public ImageDisplaySurface(Object ... objectArray) {
        this.output = (LayeredDisplayOutput)objectArray[0];
        DEBUG.LOG((Object)("Image Display Surface created for simulation " + String.valueOf(this.output.getScope().getSimulation())));
        this.data = this.output.getData();
        this.resizeImage(this.width, this.height, true);
    }

    public void outputReloaded() {
        this.scope = this.output.getScope().copyForGraphics("in image surface of " + this.output.getName());
        if (!((Boolean)GamaPreferences.Runtime.ERRORS_IN_DISPLAYS.getValue()).booleanValue()) {
            this.scope.disableErrorReporting();
        }
        if (this.manager == null) {
            this.manager = new LayerManager((IDisplaySurface)this, this.output);
        } else {
            this.manager.outputChanged();
        }
    }

    public IScope.IGraphicsScope getScope() {
        return this.scope;
    }

    public ILayerManager getManager() {
        return this.manager;
    }

    public boolean resizeImage(int n, int n2, boolean bl) {
        if (!bl && this.width == n && this.height == n2) {
            return false;
        }
        this.width = n;
        this.height = n2;
        GamaImage gamaImage = this.bufferImage;
        this.bufferImage = GamaImage.ofDimensions(this.width, this.height);
        Graphics2D graphics2D = this.bufferImage.createGraphics();
        if (this.displayGraphics != null) {
            this.displayGraphics.dispose();
        }
        this.displayGraphics = new AWTDisplayGraphics(graphics2D);
        ((AWTDisplayGraphics)this.displayGraphics).setUntranslatedGraphics2D(this.bufferImage.createGraphics());
        this.displayGraphics.setDisplaySurface((IDisplaySurface)this);
        if (this.getScope() != null && this.getScope().isPaused()) {
            this.updateDisplay(true);
        } else if (gamaImage != null) {
            graphics2D.drawImage(gamaImage, 0, 0, n, n2, null);
        }
        if (gamaImage != null) {
            gamaImage.flush();
        }
        return true;
    }

    public void updateDisplay(boolean bl, GeneralSynchronizer generalSynchronizer) {
        this.drawAllDisplays();
        if (generalSynchronizer != null) {
            generalSynchronizer.release();
        }
    }

    private void drawAllDisplays() {
        if (this.displayGraphics == null) {
            return;
        }
        this.displayGraphics.fillBackground((Color)this.data.getBackgroundColor());
        this.manager.drawLayersOn(this.displayGraphics);
    }

    public void dispose() {
        if (this.displayGraphics != null) {
            this.displayGraphics.dispose();
        }
        if (this.bufferImage != null) {
            this.bufferImage.flush();
        }
        if (this.manager != null) {
            this.manager.dispose();
        }
        GAMA.releaseScope((IScope)this.scope);
    }

    public GamaImage getImage(int n, int n2) {
        DEBUG.LOG((Object)("Asking to snapshot step " + this.scope.getClock().getCycle() + "  from " + String.valueOf(Thread.currentThread()) + " in simulation " + this.scope.getSimulation().getIndex()));
        this.setSize(n, n2);
        this.drawAllDisplays();
        return this.bufferImage;
    }

    public void zoomIn() {
    }

    public void zoomOut() {
    }

    public void zoomFit() {
    }

    public void toggleLock() {
    }

    public void focusOn(IShape iShape) {
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addListener(IEventLayerListener iEventLayerListener) {
    }

    public double getEnvWidth() {
        return this.data.getEnvWidth();
    }

    public double getEnvHeight() {
        return this.data.getEnvHeight();
    }

    public double getDisplayWidth() {
        return this.getWidth();
    }

    public double getDisplayHeight() {
        return this.getHeight();
    }

    public double getZoomLevel() {
        return 1.0;
    }

    public void setSize(int n, int n2) {
        this.resizeImage(n, n2, false);
    }

    public void removeListener(IEventLayerListener iEventLayerListener) {
    }

    public Collection<IEventLayerListener> getLayerListeners() {
        return Collections.EMPTY_LIST;
    }

    public GamaPoint getModelCoordinatesFrom(int n, int n2, Point point, Point point2) {
        return NULL_POINT;
    }

    public IList<IAgent> selectAgent(int n, int n2) {
        return GamaListFactory.EMPTY_LIST;
    }

    public LayeredDisplayOutput getOutput() {
        return this.output;
    }

    public void runAndUpdate(Runnable runnable) {
        runnable.run();
    }

    public LayeredDisplayData getData() {
        return this.data;
    }

    public void layersChanged() {
    }

    public void changed(LayeredDisplayData.Changes changes, Object object) {
    }

    public Envelope getVisibleRegionForLayer(ILayer iLayer) {
        return null;
    }

    public int getFPS() {
        return 0;
    }

    public boolean isDisposed() {
        return false;
    }

    public void getModelCoordinatesInfo(StringBuilder stringBuilder) {
    }

    public void dispatchKeyEvent(char c) {
    }

    public void dispatchSpecialKeyEvent(int n) {
    }

    public void dispatchMouseEvent(int n, int n2, int n3) {
    }

    public void setMousePosition(int n, int n2) {
    }

    public void draggedTo(int n, int n2) {
    }

    public void selectAgentsAroundMouse() {
    }

    public void setMenuManager(Object object) {
    }

    public boolean isVisible() {
        return true;
    }

    public IGraphics getIGraphics() {
        return this.displayGraphics;
    }

    public Rectangle getBoundsForRobotSnapshot() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public boolean shouldWaitToBecomeRendered() {
        return false;
    }
}

