/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

class GifImageContainer {
    public static final int STATUS_OK = 0;
    public static final int STATUS_FORMAT_ERROR = 1;
    public static final int STATUS_OPEN_ERROR = 2;
    protected BufferedInputStream in;
    protected int status;
    protected int width;
    protected int height;
    protected boolean gctFlag;
    protected int gctSize;
    protected int[] gct;
    protected int[] lct;
    protected int[] act;
    protected int bgIndex;
    protected int bgColor;
    protected int lastBgColor;
    protected boolean lctFlag;
    protected boolean interlace;
    protected int lctSize;
    protected int ix;
    protected int iy;
    protected int iw;
    protected int ih;
    protected Rectangle lastRect;
    protected BufferedImage image;
    protected BufferedImage lastImage;
    protected final byte[] block = new byte[256];
    protected int blockSize = 0;
    protected int dispose = 0;
    protected int lastDispose = 0;
    protected boolean transparency = false;
    protected int delay = 0;
    protected int transIndex;
    protected static final int MaxStackSize = 4096;
    protected short[] prefix;
    protected byte[] suffix;
    protected byte[] pixelStack;
    protected byte[] pixels;
    protected ArrayList<GifFrame> frames;
    protected int frameCount;
    protected int currentFrame;
    protected Timer timer;
    private final TimerTask task = new TimerTask(){

        @Override
        public void run() {
            ++GifImageContainer.this.currentFrame;
        }
    };

    GifImageContainer() {
    }

    public int getDuration() {
        return this.frames.stream().mapToInt(GifFrame::delay).sum();
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public BufferedImage getImage() {
        return this.getFrame(this.currentFrame % this.frameCount);
    }

    protected void setPixels() {
        int n;
        int[] nArray = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
        if (this.lastDispose > 0) {
            if (this.lastDispose == 3) {
                n = this.frameCount - 2;
                this.lastImage = n > 0 ? this.getFrame(n - 1) : null;
            }
            if (this.lastImage != null) {
                int[] nArray2 = ((DataBufferInt)this.lastImage.getRaster().getDataBuffer()).getData();
                System.arraycopy(nArray2, 0, nArray, 0, this.width * this.height);
                if (this.lastDispose == 2) {
                    Graphics2D graphics2D = this.image.createGraphics();
                    Color color = null;
                    color = this.transparency ? new Color(0, 0, 0, 0) : new Color(this.lastBgColor);
                    graphics2D.setColor(color);
                    graphics2D.setComposite(AlphaComposite.Src);
                    graphics2D.fill(this.lastRect);
                    graphics2D.dispose();
                }
            }
        }
        n = 1;
        int n2 = 8;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.ih) {
            int n5 = n4;
            if (this.interlace) {
                if (n3 >= this.ih) {
                    switch (++n) {
                        case 2: {
                            n3 = 4;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n3 = 1;
                            n2 = 2;
                        }
                    }
                }
                n5 = n3;
                n3 += n2;
            }
            if ((n5 += this.iy) < this.height) {
                int n6 = n5 * this.width;
                int n7 = n6 + this.ix;
                int n8 = n7 + this.iw;
                if (n6 + this.width < n8) {
                    n8 = n6 + this.width;
                }
                int n9 = n4 * this.iw;
                while (n7 < n8) {
                    int n10;
                    int n11;
                    if ((n11 = this.act[n10 = this.pixels[n9++] & 0xFF]) != 0) {
                        nArray[n7] = n11;
                    }
                    ++n7;
                }
            }
            ++n4;
        }
    }

    public BufferedImage getFrame(int n) {
        BufferedImage bufferedImage = null;
        if (n >= 0 && n < this.frameCount) {
            bufferedImage = this.frames.get(n).image();
        }
        return bufferedImage;
    }

    public Dimension getFrameSize() {
        return new Dimension(this.width, this.height);
    }

    public int read(InputStream inputStream) {
        this.init();
        InputStream inputStream2 = inputStream;
        if (inputStream2 != null) {
            if (!(inputStream2 instanceof BufferedInputStream)) {
                inputStream2 = new BufferedInputStream(inputStream2);
            }
            this.in = (BufferedInputStream)inputStream2;
            this.readHeader();
            if (!this.err()) {
                this.readContents();
                if (this.frameCount < 0) {
                    this.status = 1;
                }
            }
        } else {
            this.status = 2;
        }
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {}
        return this.status;
    }

    protected void decodeImageData() {
        int n = this.iw * this.ih;
        if (this.pixels == null || this.pixels.length < n) {
            this.pixels = new byte[n];
        }
        if (this.prefix == null) {
            this.prefix = new short[4096];
        }
        if (this.suffix == null) {
            this.suffix = new byte[4096];
        }
        if (this.pixelStack == null) {
            this.pixelStack = new byte[4097];
        }
        int n2 = this.read();
        int n3 = 1 << n2;
        int n4 = n3 + 1;
        int n5 = n3 + 2;
        int n6 = -1;
        int n7 = n2 + 1;
        int n8 = (1 << n7) - 1;
        int n9 = 0;
        while (n9 < n3) {
            this.prefix[n9] = 0;
            this.suffix[n9] = (byte)n9;
            ++n9;
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        while (n17 < n) {
            if (n12 == 0) {
                if (n15 < n7) {
                    if (n14 == 0) {
                        n14 = this.readBlock();
                        if (n14 <= 0) break;
                        n10 = 0;
                    }
                    n16 += (this.block[n10] & 0xFF) << n15;
                    n15 += 8;
                    ++n10;
                    --n14;
                    continue;
                }
                n9 = n16 & n8;
                n16 >>= n7;
                n15 -= n7;
                if (n9 > n5 || n9 == n4) break;
                if (n9 == n3) {
                    n7 = n2 + 1;
                    n8 = (1 << n7) - 1;
                    n5 = n3 + 2;
                    n6 = -1;
                    continue;
                }
                if (n6 == -1) {
                    this.pixelStack[n12++] = this.suffix[n9];
                    n6 = n9;
                    n13 = n9;
                    continue;
                }
                int n18 = n9;
                if (n9 == n5) {
                    this.pixelStack[n12++] = (byte)n13;
                    n9 = n6;
                }
                while (n9 > n3) {
                    this.pixelStack[n12++] = this.suffix[n9];
                    n9 = this.prefix[n9];
                }
                n13 = this.suffix[n9] & 0xFF;
                if (n5 >= 4096) break;
                this.pixelStack[n12++] = (byte)n13;
                this.prefix[n5] = (short)n6;
                this.suffix[n5] = (byte)n13;
                if ((++n5 & n8) == 0 && n5 < 4096) {
                    ++n7;
                    n8 += n5;
                }
                n6 = n18;
            }
            this.pixels[n11++] = this.pixelStack[--n12];
            ++n17;
        }
        n17 = n11;
        while (n17 < n) {
            this.pixels[n17] = 0;
            ++n17;
        }
    }

    protected boolean err() {
        return this.status != 0;
    }

    protected void init() {
        this.status = 0;
        this.frameCount = 0;
        this.frames = new ArrayList();
        this.gct = null;
        this.lct = null;
    }

    protected int read() {
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (IOException iOException) {
            this.status = 1;
        }
        return n;
    }

    protected int readBlock() {
        this.blockSize = this.read();
        int n = 0;
        if (this.blockSize > 0) {
            try {
                int n2 = 0;
                while (n < this.blockSize) {
                    n2 = this.in.read(this.block, n, this.blockSize - n);
                    if (n2 != -1) {
                        n += n2;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {}
            if (n < this.blockSize) {
                this.status = 1;
            }
        }
        return n;
    }

    protected int[] readColorTable(int n) {
        int n2 = 3 * n;
        int[] nArray = null;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        try {
            n3 = this.in.read(byArray);
        }
        catch (IOException iOException) {}
        if (n3 < n2) {
            this.status = 1;
        } else {
            nArray = new int[256];
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                int n6 = byArray[n5++] & 0xFF;
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                nArray[n4++] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
            }
        }
        return nArray;
    }

    protected void readContents() {
        boolean bl = false;
        while (!bl && !this.err()) {
            int n = this.read();
            block0 : switch (n) {
                case 44: {
                    this.readImage();
                    break;
                }
                case 33: {
                    n = this.read();
                    switch (n) {
                        case 249: {
                            this.readGraphicControlExt();
                            break block0;
                        }
                        case 255: {
                            this.readBlock();
                            StringBuilder stringBuilder = new StringBuilder();
                            int n2 = 0;
                            while (n2 < 11) {
                                stringBuilder.append((char)this.block[n2]);
                                ++n2;
                            }
                            if ("NETSCAPE2.0".equals(stringBuilder.toString())) {
                                this.readNetscapeExt();
                                break block0;
                            }
                            this.skip();
                            break block0;
                        }
                    }
                    this.skip();
                    break;
                }
                case 59: {
                    bl = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    this.status = 1;
                }
            }
        }
        if (this.frameCount > 0 && this.getDuration() > 0) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(this.task, 0L, (long)(this.getDuration() / this.frameCount));
        }
    }

    protected void readGraphicControlExt() {
        this.read();
        int n = this.read();
        this.dispose = (n & 0x1C) >> 2;
        if (this.dispose == 0) {
            this.dispose = 1;
        }
        this.transparency = (n & 1) != 0;
        this.delay = this.readShort() * 10;
        this.transIndex = this.read();
        this.read();
    }

    protected void readHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < 6) {
            stringBuilder.append((char)this.read());
            ++n;
        }
        if (!stringBuilder.toString().startsWith("GIF")) {
            this.status = 1;
            return;
        }
        this.readLSD();
        if (this.gctFlag && !this.err()) {
            this.gct = this.readColorTable(this.gctSize);
            this.bgColor = this.gct[this.bgIndex];
        }
    }

    protected void readImage() {
        this.ix = this.readShort();
        this.iy = this.readShort();
        this.iw = this.readShort();
        this.ih = this.readShort();
        int n = this.read();
        this.lctFlag = (n & 0x80) != 0;
        this.interlace = (n & 0x40) != 0;
        this.lctSize = 2 << (n & 7);
        if (this.lctFlag) {
            this.lct = this.readColorTable(this.lctSize);
            this.act = this.lct;
        } else {
            this.act = this.gct;
            if (this.bgIndex == this.transIndex) {
                this.bgColor = 0;
            }
        }
        int n2 = 0;
        if (this.transparency) {
            n2 = this.act[this.transIndex];
            this.act[this.transIndex] = 0;
        }
        if (this.act == null) {
            this.status = 1;
        }
        if (this.err()) {
            return;
        }
        this.decodeImageData();
        this.skip();
        if (this.err()) {
            return;
        }
        ++this.frameCount;
        this.image = new BufferedImage(this.width, this.height, 3);
        this.setPixels();
        this.frames.add(new GifFrame(this.image, this.delay));
        if (this.transparency) {
            this.act[this.transIndex] = n2;
        }
        this.resetFrame();
    }

    protected void readLSD() {
        this.width = this.readShort();
        this.height = this.readShort();
        int n = this.read();
        this.gctFlag = (n & 0x80) != 0;
        this.gctSize = 2 << (n & 7);
        this.bgIndex = this.read();
        this.read();
    }

    protected void readNetscapeExt() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    protected int readShort() {
        return this.read() | this.read() << 8;
    }

    protected void resetFrame() {
        this.lastDispose = this.dispose;
        this.lastRect = new Rectangle(this.ix, this.iy, this.iw, this.ih);
        this.lastImage = this.image;
        this.lastBgColor = this.bgColor;
        this.lct = null;
    }

    protected void skip() {
        do {
            this.readBlock();
        } while (this.blockSize > 0 && !this.err());
    }

    public void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.frames != null) {
            this.frames.clear();
        }
        if (this.image != null) {
            this.image.flush();
        }
        if (this.lastImage != null) {
            this.lastImage.flush();
        }
    }

    record GifFrame(BufferedImage image, int delay) {
    }
}

