/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.ode.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.maths.ode.MathConstants;
import gama.extension.maths.ode.statements.SystemOfEquationsStatement;
import gama.extension.maths.ode.utils.solver.AdamsBashforthSolver;
import gama.extension.maths.ode.utils.solver.AdamsMoultonSolver;
import gama.extension.maths.ode.utils.solver.DormandPrince54Solver;
import gama.extension.maths.ode.utils.solver.DormandPrince853Solver;
import gama.extension.maths.ode.utils.solver.EulerSolver;
import gama.extension.maths.ode.utils.solver.GillSolver;
import gama.extension.maths.ode.utils.solver.GraggBulirschStoerSolver;
import gama.extension.maths.ode.utils.solver.HighamHall54Solver;
import gama.extension.maths.ode.utils.solver.LutherSolver;
import gama.extension.maths.ode.utils.solver.MidpointSolver;
import gama.extension.maths.ode.utils.solver.Rk4Solver;
import gama.extension.maths.ode.utils.solver.Solver;
import gama.extension.maths.ode.utils.solver.ThreeEighthesSolver;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Set;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="equation", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the equation system identifier to be numerically solved")}), @GamlAnnotations.facet(name="method", type={4}, optional=true, doc={@GamlAnnotations.doc(value="integration method (can be one of \"Euler\", \"ThreeEighthes\", \"Midpoint\", \"Gill\", \"Luther\", \"rk4\" or \"dp853\", \"AdamsBashforth\", \"AdamsMoulton\", \"DormandPrince54\", \"GraggBulirschStoer\",  \"HighamHall54\") (default value: \"rk4\") or the corresponding constant")}), @GamlAnnotations.facet(name="t0", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the first bound of the integration interval (defaut value: cycle*step, the time at the begining of the current cycle.)")}), @GamlAnnotations.facet(name="tf", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the second bound of the integration interval. Can be smaller than t0 for a backward integration (defaut value: cycle*step, the time at the begining of the current cycle.)")}), @GamlAnnotations.facet(name="step_size", type={2}, optional=true, doc={@GamlAnnotations.doc(value="integration step, use with fixed step integrator methods (default value: 0.005*step)")}), @GamlAnnotations.facet(name="min_step", type={2}, optional=true, doc={@GamlAnnotations.doc(value="minimal step, (used with dp853 method only), (sign is irrelevant, regardless of integration direction, forward or backward), the last step can be smaller than this value")}), @GamlAnnotations.facet(name="max_step", type={2}, optional=true, doc={@GamlAnnotations.doc(value="maximal step, (used with dp853 method only), (sign is irrelevant, regardless of integration direction, forward or backward), the last step can be smaller than this value")}), @GamlAnnotations.facet(name="scalAbsoluteTolerance", type={2}, optional=true, doc={@GamlAnnotations.doc(value="allowed absolute error (used with dp853 method only)")}), @GamlAnnotations.facet(name="scalRelativeTolerance", type={2}, optional=true, doc={@GamlAnnotations.doc(value="allowed relative error (used with dp853 method only)")}), @GamlAnnotations.facet(name="nSteps", type={2}, optional=true, doc={@GamlAnnotations.doc(value="Adams-Bashforth and Adams-Moulton methods only. The number of past steps used for computation excluding the one being computed (default value: 2")})}, omissible="equation")
@GamlAnnotations.inside(kinds={3, 11})
@validator(value=SolveValidator.class)
@GamlAnnotations.doc(value="Solves all equations which matched the given name, with all systems of agents that should solved simultaneously.", usages={@GamlAnnotations.usage(value="", examples={@GamlAnnotations.example(value="solve SIR method: #rk4 step_size:0.001;", isExecutable=false)})})
public class SolveStatement
extends AbstractStatement
implements MathConstants {
    static final Set<String> Fixed_Step_Integrators = Set.of("Euler", "ThreeEighthes", "Midpoint", "Gill", "Luther", "rk4");
    static final Set<String> Adaptive_Stepsize_Integrators = Set.of("dp853", "AdamsBashforth", "AdamsMoulton", "DormandPrince54", "GraggBulirschStoer", "HighamHall54");
    final String equationName = this.getFacet(new String[]{"equation"}).literalValue();
    String solverName;
    SystemOfEquationsStatement systemOfEquations;
    final IExpression solverExp = this.getFacet(new String[]{"method"});
    final IExpression stepExp = this.getFacet(new String[]{"step_size"}) == null ? new ConstantExpression((Object)0.005) : this.getFacet(new String[]{"step_size"});
    final IExpression nStepsExp = this.getFacet(new String[]{"nSteps"});
    final IExpression minStepExp = this.getFacet(new String[]{"min_step"});
    final IExpression maxStepExp = this.getFacet(new String[]{"max_step"});
    final IExpression absTolerExp = this.getFacet(new String[]{"scalAbsoluteTolerance"});
    final IExpression relTolerExp = this.getFacet(new String[]{"scalRelativeTolerance"});
    final IExpression timeInitExp = this.getFacet(new String[]{"t0"});
    final IExpression timeFinalExp = this.getFacet(new String[]{"tf"});

    public SolveStatement(IDescription iDescription) {
        super(iDescription);
    }

    private boolean initSystemOfEquations(IScope iScope) {
        if (this.solverName == null) {
            if (this.solverExp == null) {
                this.solverName = "rk4";
            } else {
                this.solverName = Cast.asString((IScope)iScope, (Object)this.solverExp.value(iScope));
                if (Adaptive_Stepsize_Integrators.contains(this.solverName)) {
                    if (this.minStepExp == null || this.maxStepExp == null || this.absTolerExp == null || this.relTolerExp == null) {
                        throw GamaRuntimeException.error((String)"For Adaptive Stepsize Integrators, the facets min_step, max_step, scalAbsoluteTolerance and scalRelativeTolerance have to be defined. Example: min_step:0.01 max_step:0.1 scalAbsoluteTolerance:0.0001 scalRelativeTolerance:0.0001", (IScope)iScope);
                    }
                } else if (!Fixed_Step_Integrators.contains(this.solverName)) {
                    throw GamaRuntimeException.error((String)"The method must be either 'Euler', 'ThreeEighthes', 'Midpoint', 'Gill', 'Luther', 'rk4', 'dp853','AdamsBashforth', 'AdamsMoulton', 'DormandPrince54', 'GraggBulirschStoer' or 'HighamHall54'", (IScope)iScope);
                }
            }
        }
        if (this.systemOfEquations == null) {
            this.systemOfEquations = (SystemOfEquationsStatement)iScope.getAgent().getSpecies().getStatement(SystemOfEquationsStatement.class, this.equationName);
        }
        return this.systemOfEquations != null;
    }

    @GamlAnnotations.operator(value={"internal_integrated_value"}, content_type=2, category={"Containers-related operators"}, concept={"equation"})
    @GamlAnnotations.doc(value="For internal use only. Corresponds to the implementation, for agents, of the access to containers with [index]")
    public static IList internal_integrated_value(IScope iScope, IExpression iExpression, IExpression iExpression2) throws GamaRuntimeException {
        IAgent iAgent = Cast.asAgent((IScope)iScope, (Object)iExpression.value(iScope));
        IMap iMap = (IMap)iAgent.getAttribute("__integrated_values");
        if (iMap != null) {
            return (IList)iMap.get((Object)(String.valueOf(iAgent) + iExpression2.getName()));
        }
        return GamaListFactory.EMPTY_LIST;
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        if (!this.initSystemOfEquations(iScope)) {
            return null;
        }
        double d = iScope.getSimulation().getTimeStep(iScope);
        double d2 = Cast.asFloat((IScope)iScope, (Object)this.stepExp.value(iScope));
        if (this.getFacet(new String[]{"step"}) == null && this.getFacet(new String[]{"step_size"}) == null) {
            d2 *= d;
        }
        Solver solver = this.createSolver(iScope, d2);
        double d3 = this.timeInitExp == null ? (double)iScope.getSimulation().getClock().getCycle() * d : Cast.asFloat((IScope)iScope, (Object)this.timeInitExp.value(iScope));
        double d4 = this.timeFinalExp == null ? (double)(iScope.getSimulation().getClock().getCycle() + 1) * d : Cast.asFloat((IScope)iScope, (Object)this.timeFinalExp.value(iScope));
        solver.solve(iScope, this.systemOfEquations, d3, d4, this.getIntegratedValues(iScope));
        return null;
    }

    private Solver createSolver(IScope iScope, double d) {
        IMap<String, IList<Double>> iMap = this.getIntegratedValues(iScope);
        int n = 2;
        double d2 = 0.1;
        double d3 = 0.1;
        double d4 = 0.1;
        double d5 = 0.1;
        if (Adaptive_Stepsize_Integrators.contains(this.solverName)) {
            d2 = Cast.asFloat((IScope)iScope, (Object)this.minStepExp.value(iScope));
            d3 = Cast.asFloat((IScope)iScope, (Object)this.maxStepExp.value(iScope));
            d4 = Cast.asFloat((IScope)iScope, (Object)this.absTolerExp.value(iScope));
            d5 = Cast.asFloat((IScope)iScope, (Object)this.relTolerExp.value(iScope));
            if (this.nStepsExp != null) {
                n = Cast.asInt((IScope)iScope, (Object)this.nStepsExp.value(iScope));
            }
        }
        return switch (this.solverName) {
            case "Euler" -> new EulerSolver(d, iMap);
            case "ThreeEighthes" -> new ThreeEighthesSolver(d, iMap);
            case "Midpoint" -> new MidpointSolver(d, iMap);
            case "Gill" -> new GillSolver(d, iMap);
            case "Luther" -> new LutherSolver(d, iMap);
            case "rk4" -> new Rk4Solver(d, iMap);
            case "dp853" -> new DormandPrince853Solver(d2, d3, d4, d5, iMap);
            case "DormandPrince54" -> new DormandPrince54Solver(d2, d3, d4, d5, iMap);
            case "GraggBulirschStoer" -> new GraggBulirschStoerSolver(d2, d3, d4, d5, iMap);
            case "HighamHall54" -> new HighamHall54Solver(d2, d3, d4, d5, iMap);
            case "AdamsBashforth" -> new AdamsBashforthSolver(n, d2, d3, d4, d5, iMap);
            case "AdamsMoulton" -> new AdamsMoultonSolver(n, d2, d3, d4, d5, iMap);
            default -> new Rk4Solver(d, iMap);
        };
    }

    private IMap<String, IList<Double>> getIntegratedValues(IScope iScope) {
        IMap iMap = (IMap)iScope.getAgent().getAttribute("__integrated_values");
        if (iMap == null) {
            iMap = GamaMapFactory.create((IType)Types.STRING, (IType)Types.LIST, (int)0);
            iScope.getAgent().setAttribute("__integrated_values", (Object)iMap);
        }
        return iMap;
    }

    public static class SolveValidator
    implements IDescriptionValidator<IDescription> {
        public void validate(IDescription iDescription) {
            IExpression iExpression = iDescription.getFacetExpr(new String[]{"method"});
            if (iExpression != null && iExpression.isConst() && iExpression.isContextIndependant()) {
                String string = iExpression.literalValue();
                if (string != null) {
                    if (Adaptive_Stepsize_Integrators.contains(string)) {
                        if (!(iDescription.hasFacet("min_step") && iDescription.hasFacet("max_step") && iDescription.hasFacet("scalAbsoluteTolerance") && iDescription.hasFacet("scalRelativeTolerance"))) {
                            iDescription.error("For Adaptive Stepsize Integrators, the facets min_step, max_step, scalAbsoluteTolerance and scalRelativeTolerance have to be defined. Example: min_step:0.01 max_step:0.1 scalAbsoluteTolerance:0.0001 scalRelativeTolerance:0.0001", "gaml.general.issue");
                        }
                    } else if (!Fixed_Step_Integrators.contains(string)) {
                        iDescription.error("The method facet must have for value either \"Euler\", \"ThreeEighthes\", \"Midpoint\", \"Gill\", \"Luther\", \"rk4\" or \"dp853\",\"AdamsBashforth\", \"AdamsMoulton\", \"DormandPrince54\", \"GraggBulirschStoer\", \"HighamHall54\"", "gaml.general.issue");
                    }
                } else {
                    iDescription.error("The method facet must have for value either \"Euler\", \"ThreeEighthes\", \"Midpoint\", \"Gill\", \"Luther\", \"rk4\" or \"dp853\", \"AdamsBashforth\", \"AdamsMoulton\", \"DormandPrince54\", \"GraggBulirschStoer\", \"HighamHall54\"", "gaml.general.issue");
                }
            }
        }
    }
}

