/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.ode.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.AbstractNAryOperator;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.statements.AbstractStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="left", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the left part of the equation (it should be a variable or a call to the diff() or diff2() operators) ")}), @GamlAnnotations.facet(name="right", type={2}, optional=false, doc={@GamlAnnotations.doc(value="the right part of the equation (it is mandatory that it can be evaluated as a float")})}, omissible="right")
@GamlAnnotations.inside(symbols={"equation"})
@validator(value=SingleEquationValidator.class)
@serializer(value=SIngleEquationSerializer.class)
@GamlAnnotations.doc(value="Allows to implement an equation in the form function(n, t) = expression. The left function is only here as a placeholder for enabling a simpler syntax and grabbing the variable as its left member.", usages={@GamlAnnotations.usage(value="The syntax of the = statement is a bit different from the other statements. It has to be used as follows (in an equation):", examples={@GamlAnnotations.example(value="float t;", isExecutable=false), @GamlAnnotations.example(value="float S;", isExecutable=false), @GamlAnnotations.example(value="float I;", isExecutable=false), @GamlAnnotations.example(value="equation SI { ", isExecutable=false), @GamlAnnotations.example(value="   diff(S,t) = (- 0.3 * S * I / 100);", isExecutable=false), @GamlAnnotations.example(value="   diff(I,t) = (0.3 * S * I / 100);", isExecutable=false), @GamlAnnotations.example(value="} ", isExecutable=false)})}, see={"equation", "solve"})
public class SingleEquationStatement
extends AbstractStatement {
    public static final Map<String, Integer> orderNames = GamaMapFactory.create();
    private IExpression function;
    private IExpression expression;
    private final List<IExpression> var = new ArrayList<IExpression>();
    private IExpression var_t;

    static {
        orderNames.put("internal_zero_order_equation", 0);
        orderNames.put("diff", 1);
        orderNames.put("diff2", 2);
    }

    public IExpression getFunction() {
        return this.function;
    }

    public void setFunction(IExpression iExpression) {
        this.function = iExpression;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression iExpression) {
        this.expression = iExpression;
    }

    public List<IExpression> getVars() {
        return this.var;
    }

    public IExpression getVarTime() {
        return this.var_t;
    }

    public IExpression getVar(int n) {
        return this.var.get(n);
    }

    public void setVar_t(IVarExpression iVarExpression) {
        this.var_t = iVarExpression;
    }

    public SingleEquationStatement(IDescription iDescription) {
        super(iDescription);
        this.function = this.getFacet(new String[]{"left"});
        this.expression = this.getFacet(new String[]{"right"});
    }

    public void establishVar() {
        if (this.getOrder() == 0) {
            return;
        }
        int n = 0;
        n = 0;
        while (n < ((AbstractNAryOperator)this.function).numArg() - 1) {
            IExpression iExpression = ((AbstractNAryOperator)this.function).arg(n);
            this.var.add(n, iExpression);
            ++n;
        }
        this.var_t = ((AbstractNAryOperator)this.function).arg(n);
    }

    protected Double privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Double d = (Double)this.expression.value(iScope);
        return d;
    }

    public Object executeOn(IScope iScope) throws GamaRuntimeException {
        return this.expression.value(iScope);
    }

    public int getOrder() {
        return orderNames.get(this.function.getName());
    }

    @GamlAnnotations.operator(value={"diff"}, concept={"equation", "math"})
    @GamlAnnotations.doc(value="A placeholder function for expressing equations")
    public static Double diff(IScope iScope, Double d, Double d2) {
        return Double.NaN;
    }

    @GamlAnnotations.operator(value={"diff2"}, concept={"equation", "math"})
    @GamlAnnotations.doc(value="A placeholder function for expressing equations")
    public static Double diff2(IScope iScope, Double d, Double d2) {
        return Double.NaN;
    }

    @GamlAnnotations.operator(value={"internal_zero_order_equation"}, concept={"equation", "math"}, internal=true)
    @GamlAnnotations.doc(value="An internal placeholder function")
    public static Double f(IScope iScope, IExpression iExpression) {
        return Double.NaN;
    }

    public String toString() {
        return this.function.toString() + " = " + this.expression.toString();
    }

    public static class SIngleEquationSerializer
    extends SymbolSerializer<SymbolDescription> {
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(symbolDescription.getFacet("left").serializeToGaml(bl)).append(" = ").append(symbolDescription.getFacet("right").serializeToGaml(bl)).append(";");
        }
    }

    public static class SingleEquationValidator
    implements IDescriptionValidator<IDescription> {
        public void validate(IDescription iDescription) {
            boolean bl;
            IExpressionDescription iExpressionDescription = iDescription.getFacet("left");
            IExpression iExpression = iExpressionDescription.getExpression();
            IExpressionDescription iExpressionDescription2 = iDescription.getFacet("right");
            IExpression iExpression2 = iExpressionDescription2.getExpression();
            boolean bl2 = bl = iExpression instanceof IOperator && orderNames.containsKey(iExpression.getName());
            if (!bl) {
                iDescription.error("The left-hand member of an equation should be a variable or a call to the diff() or diff2() operators", "gaml.unknown.operator.issue", iExpressionDescription.getTarget(), new String[0]);
                return;
            }
            IType iType = ((IOperator)iExpression).arg(0).getGamlType();
            if (!iType.isTranslatableInto((IType)Types.FLOAT)) {
                iDescription.error("The variable of the left-hand member of an equation is expected to be of type float", "gaml.wrong.type.issue", iExpressionDescription.getTarget(), new String[0]);
                return;
            }
            if (iExpression2 == null || !iExpression2.getGamlType().isTranslatableInto((IType)Types.FLOAT)) {
                iDescription.error("The right-hand member of an equation is expected to be of type float", "gaml.wrong.type.issue", iExpressionDescription2.getTarget(), new String[0]);
            }
        }
    }
}

