/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.ode.utils.solver;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.extension.maths.ode.statements.SystemOfEquationsStatement;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import java.util.Map;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

public abstract class Solver {
    final FirstOrderIntegrator integrator;
    Double lastT = -999.0;

    Solver(double d, FirstOrderIntegrator firstOrderIntegrator, final IMap<String, IList<Double>> iMap) {
        this.integrator = firstOrderIntegrator;
        if (iMap != null) {
            firstOrderIntegrator.addStepHandler(new StepHandler(){

                public void init(double d, double[] dArray, double d2) {
                }

                public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
                    double d = stepInterpolator.getCurrentTime();
                    double[] dArray = stepInterpolator.getInterpolatedState();
                    if (Solver.this.lastT < 0.0) {
                        Solver.this.storeIntegratedValues(d, dArray, (IMap<String, IList<Double>>)iMap);
                    } else if (Maths.abs((Double)(Solver.this.lastT - d)) > 1.0E-11) {
                        Solver.this.storeIntegratedValues(d, dArray, (IMap<String, IList<Double>>)iMap);
                    }
                    Solver.this.lastT = d;
                }
            });
        }
    }

    public void solve(IScope iScope, SystemOfEquationsStatement systemOfEquationsStatement, double d, double d2, IMap<String, IList<Double>> iMap) {
        systemOfEquationsStatement.executeInScope(iScope, () -> {
            Map<Integer, IAgent> map = systemOfEquationsStatement.getEquationAgents(iScope);
            IMap<Integer, GamaPair<IAgent, IExpression>> iMap2 = systemOfEquationsStatement.getVariableDiff(iScope.getAgent());
            double[] dArray = new double[iMap2.size()];
            int n = 0;
            int n2 = iMap2.size();
            n = 0;
            while (n < n2) {
                block17: {
                    IAgent iAgent = map.get(n);
                    String string = String.valueOf(iAgent) + ((IExpression)((GamaPair)iMap2.get((Object)n)).getValue()).toString();
                    if (iMap.get((Object)string) == null) {
                        iMap.put((Object)string, (Object)GamaListFactory.create(Double.class));
                    }
                    if (!iAgent.dead()) {
                        boolean bl = iScope.push(iAgent);
                        try {
                            try {
                                dArray[n] = Cast.asFloat((IScope)iScope, (Object)((IExpression)((GamaPair)iMap2.get((Object)n)).getValue()).value(iScope));
                                if (Double.isInfinite(dArray[n])) {
                                    GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)new NotANumberException(), (IScope)iScope), (boolean)true);
                                }
                            }
                            catch (Exception exception) {
                                DEBUG.OUT((Object)exception.getMessage());
                                if (bl) {
                                    iScope.pop(iAgent);
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                iScope.pop(iAgent);
                            }
                            throw throwable;
                        }
                        if (bl) {
                            iScope.pop(iAgent);
                        }
                    }
                }
                ++n;
            }
            if (iMap.get((Object)(String.valueOf(iScope.getAgent()) + systemOfEquationsStatement.variable_time.getName())) == null) {
                iMap.put((Object)(String.valueOf(iScope.getAgent()) + systemOfEquationsStatement.variable_time.getName()), (Object)GamaListFactory.create(Double.class));
            }
            if (iScope.getClock().getCycle() == 0) {
                this.storeIntegratedValues(d, dArray, iMap);
            }
            if (dArray.length > 0) {
                try {
                    this.integrator.integrate((FirstOrderDifferentialEquations)systemOfEquationsStatement, d, dArray, d2, dArray);
                }
                catch (Exception exception) {
                    DEBUG.OUT((Object)exception.toString());
                }
            }
            systemOfEquationsStatement.assignValue(iScope, d2, dArray);
        });
    }

    void storeIntegratedValues(double d, double[] dArray, IMap<String, IList<Double>> iMap) {
        if (iMap != null) {
            ((IList)iMap.valueAt(dArray.length)).add((Object)d);
            int n = 0;
            while (n < dArray.length) {
                ((IList)iMap.valueAt(n)).add((Object)dArray[n]);
                ++n;
            }
        }
    }
}

