/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.ode.statements;

import com.google.common.collect.Lists;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.extension.maths.ode.statements.SingleEquationStatement;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.UnaryOperator;
import gama.gaml.expressions.variables.AgentVariableExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.GamlSpecies;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the equation identifier")}), @GamlAnnotations.facet(name="vars", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the list of variables used in predefined equation systems")}), @GamlAnnotations.facet(name="params", type={5}, optional=true, doc={@GamlAnnotations.doc(value="the list of parameters used in predefined equation systems")}), @GamlAnnotations.facet(name="simultaneously", type={5}, of=14, optional=true, doc={@GamlAnnotations.doc(value="a list of species containing a system of equations (all systems will be solved simultaneously)")})}, omissible="name")
@GamlAnnotations.inside(kinds={0, 1})
@GamlAnnotations.doc(value="The equation statement is used to create an equation system from several single equations.", usages={@GamlAnnotations.usage(value="The basic syntax to define an equation system is:", examples={@GamlAnnotations.example(value="float t;", isExecutable=false), @GamlAnnotations.example(value="float S;", isExecutable=false), @GamlAnnotations.example(value="float I;", isExecutable=false), @GamlAnnotations.example(value="equation SI { ", isExecutable=false), @GamlAnnotations.example(value="   diff(S,t) = (- 0.3 * S * I / 100);", isExecutable=false), @GamlAnnotations.example(value="   diff(I,t) = (0.3 * S * I / 100);", isExecutable=false), @GamlAnnotations.example(value="} ", isExecutable=false)}), @GamlAnnotations.usage(value="If the type: facet is used, a predefined equation system is defined using variables vars: and parameters params: in the right order. All possible predefined equation systems are the following ones (see [EquationPresentation161 EquationPresentation161] for precise definition of each classical equation system): ", examples={@GamlAnnotations.example(value="equation eqSI type: SI vars: [S,I,t] params: [N,beta];", isExecutable=false), @GamlAnnotations.example(value="equation eqSIS type: SIS vars: [S,I,t] params: [N,beta,gamma];", isExecutable=false), @GamlAnnotations.example(value="equation eqSIR type:SIR vars:[S,I,R,t] params:[N,beta,gamma];", isExecutable=false), @GamlAnnotations.example(value="equation eqSIRS type: SIRS vars: [S,I,R,t] params: [N,beta,gamma,omega,mu];", isExecutable=false), @GamlAnnotations.example(value="equation eqSEIR type: SEIR vars: [S,E,I,R,t] params: [N,beta,gamma,sigma,mu];", isExecutable=false), @GamlAnnotations.example(value="equation eqLV type: LV vars: [x,y,t] params: [alpha,beta,delta,gamma];", isExecutable=false)}), @GamlAnnotations.usage(value="If the simultaneously: facet is used, system of all the agents will be solved simultaneously.")}, see={"=", "solve"})
public class SystemOfEquationsStatement
extends AbstractStatementSequence
implements FirstOrderDifferentialEquations {
    public static final String ___equations = "___equations";
    public static final String ___variables_diff = "___variables_diff";
    private final IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> equations = GamaMapFactory.create();
    private final IMap<Integer, GamaPair<IAgent, IExpression>> variables_diff = GamaMapFactory.create();
    public IExpression variable_time = null;
    private IScope currentScope;
    IExpression simultan = null;

    public SystemOfEquationsStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
        this.simultan = this.getFacet(new String[]{"simultaneously"});
    }

    public void setChildren(Iterable<? extends ISymbol> iterable) {
        ArrayList arrayList = Lists.newArrayList(iterable);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Collector.AsList asList = Collector.getList();){
            for (ISymbol iSymbol : arrayList) {
                if (iSymbol instanceof SingleEquationStatement) {
                    SingleEquationStatement singleEquationStatement = (SingleEquationStatement)iSymbol;
                    singleEquationStatement.establishVar();
                    int n = 0;
                    while (n < singleEquationStatement.getVars().size()) {
                        IExpression iExpression = singleEquationStatement.getVar(n);
                        if (singleEquationStatement.getOrder() > 0) {
                            GamaPair gamaPair = new GamaPair(null, (Object)singleEquationStatement, Types.AGENT, Types.NO_TYPE);
                            this.equations.put((Object)this.equations.size(), (Object)gamaPair);
                            GamaPair gamaPair2 = new GamaPair(null, (Object)iExpression, Types.AGENT, Types.NO_TYPE);
                            this.variables_diff.put((Object)this.variables_diff.size(), (Object)gamaPair2);
                        }
                        ++n;
                    }
                    this.variable_time = singleEquationStatement.getVarTime();
                    continue;
                }
                asList.add((Object)iSymbol);
            }
            super.setChildren((Iterable)asList.items());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void assignValue(IScope iScope, double d, double[] dArray) {
        IAgent iAgent;
        GamaPair gamaPair;
        IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap = this.getEquations(this.currentScope.getAgent());
        IMap<Integer, GamaPair<IAgent, IExpression>> iMap2 = this.getVariableDiff(iScope.getAgent());
        int n = 0;
        int n2 = iMap.size();
        while (n < n2) {
            block16: {
                gamaPair = (GamaPair)iMap.get((Object)n);
                if (((SingleEquationStatement)((Object)gamaPair.getValue())).getOrder() != 0) {
                    iAgent = (IAgent)gamaPair.getKey();
                    boolean bl = false;
                    if (iAgent != null && !iAgent.dead()) {
                        bl = iScope.push(iAgent);
                        try {
                            try {
                                if (((SingleEquationStatement)((Object)gamaPair.getValue())).getVarTime() instanceof IVarExpression) {
                                    ((IVarExpression)((SingleEquationStatement)((Object)gamaPair.getValue())).getVarTime()).setVal(iScope, (Object)d, false);
                                }
                                if (((GamaPair)iMap2.get((Object)n)).getValue() instanceof IVarExpression) {
                                    ((IVarExpression)((GamaPair)iMap2.get((Object)n)).getValue()).setVal(iScope, (Object)dArray[n], false);
                                }
                            }
                            catch (Throwable throwable) {
                                GAMA.reportAndThrowIfNeeded((IScope)iScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)iScope), (boolean)true);
                                if (bl) {
                                    iScope.pop(iAgent);
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                iScope.pop(iAgent);
                            }
                            throw throwable;
                        }
                        if (bl) {
                            iScope.pop(iAgent);
                        }
                    }
                }
            }
            ++n;
        }
        n = 0;
        n2 = iMap.size();
        while (n < n2) {
            gamaPair = (GamaPair)iMap.get((Object)n);
            if (((SingleEquationStatement)((Object)gamaPair.getValue())).getOrder() == 0) {
                iAgent = ((UnaryOperator)((SingleEquationStatement)((Object)gamaPair.getValue())).getFunction()).arg(0);
                Object object = ((SingleEquationStatement)((Object)gamaPair.getValue())).getExpression().value(this.currentScope);
                if (iAgent instanceof AgentVariableExpression) {
                    ((AgentVariableExpression)iAgent).setVal(this.currentScope, object, false);
                }
            }
            ++n;
        }
        this.setEquations(iScope.getAgent(), iMap);
        this.setVariableDiff(iScope.getAgent(), iMap2);
    }

    public void computeDerivatives(double d, double[] dArray, double[] dArray2) throws MaxCountExceededException, DimensionMismatchException {
        IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap = this.getEquations(this.currentScope.getAgent());
        this.assignValue(this.currentScope, d, dArray);
        Map<Integer, IAgent> map = this.getEquationAgents(this.currentScope);
        int n = 0;
        int n2 = this.getDimension();
        while (n < n2) {
            if (iMap.get((Object)n) != null) {
                try {
                    ExecutionResult executionResult = this.currentScope.execute((IExecutable)((GamaPair)iMap.get((Object)n)).getValue(), map.get(n), null);
                    dArray2[n] = Cast.asFloat((IScope)this.currentScope, (Object)executionResult.getValue());
                }
                catch (Throwable throwable) {
                    GAMA.reportAndThrowIfNeeded((IScope)this.currentScope, (GamaRuntimeException)GamaRuntimeException.create((Throwable)throwable, (IScope)this.currentScope), (boolean)true);
                }
            }
            ++n;
        }
        this.setEquations(this.currentScope.getAgent(), iMap);
    }

    public int getDimension() {
        int n = 0;
        IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap = this.getEquations(this.currentScope.getAgent());
        for (GamaPair gamaPair : iMap.values()) {
            if (((SingleEquationStatement)((Object)gamaPair.getValue())).getOrder() <= 0) continue;
            ++n;
        }
        return n;
    }

    private void setCurrentScope(IScope iScope) {
        this.currentScope = iScope;
    }

    private Set<IAgent> getExternalAgents(IScope iScope) {
        if (iScope.getAgent() == null) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet linkedHashSet = (LinkedHashSet)iScope.getAgent().getAttribute("__externalAgents");
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            iScope.getAgent().setAttribute("__externalAgents", linkedHashSet);
        }
        return linkedHashSet;
    }

    public IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> getEquations(IAgent iAgent) {
        if (iAgent == null) {
            return GamaMapFactory.create();
        }
        IMap iMap = (IMap)iAgent.getAttribute(___equations);
        if (iMap == null) {
            iMap = GamaMapFactory.create();
            iAgent.setAttribute(___equations, (Object)iMap);
        }
        return iMap;
    }

    public void setEquations(IAgent iAgent, IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute(___equations, iMap);
    }

    public IMap<Integer, GamaPair<IAgent, IExpression>> getVariableDiff(IAgent iAgent) {
        if (iAgent == null) {
            return GamaMapFactory.create();
        }
        IMap iMap = (IMap)iAgent.getAttribute(___variables_diff);
        if (iMap == null) {
            iMap = GamaMapFactory.create();
            this.currentScope.getAgent().setAttribute(___variables_diff, (Object)iMap);
        }
        return iMap;
    }

    public void setVariableDiff(IAgent iAgent, IMap<Integer, GamaPair<IAgent, IExpression>> iMap) {
        if (iAgent == null) {
            return;
        }
        iAgent.setAttribute(___variables_diff, iMap);
    }

    public Map<Integer, IAgent> getEquationAgents(IScope iScope) {
        if (iScope.getAgent() == null) {
            return new HashMap<Integer, IAgent>();
        }
        HashMap hashMap = (HashMap)iScope.getAgent().getAttribute("__equationAgents");
        if (hashMap == null) {
            hashMap = new HashMap();
            iScope.getAgent().setAttribute("__equationAgents", hashMap);
        }
        return hashMap;
    }

    private void beginWithScope(IScope iScope) {
        this.setCurrentScope(iScope);
        this.addInternalAgents(iScope);
        this.addInternalEquations(iScope);
        this.addExternalAgents(iScope);
        this.addExternalEquations(iScope);
    }

    private void finishWithScope(IScope iScope) {
        this.removeExternalEquations(iScope);
        this.getEquationAgents(iScope).clear();
        this.getExternalAgents(iScope).clear();
        this.getEquations(iScope.getAgent()).clear();
        this.getVariableDiff(iScope.getAgent()).clear();
        this.setEquations(iScope.getAgent(), null);
        this.setVariableDiff(iScope.getAgent(), null);
        this.setCurrentScope(null);
    }

    public synchronized void executeInScope(IScope iScope, Runnable runnable) {
        this.beginWithScope(iScope);
        runnable.run();
        this.finishWithScope(iScope);
    }

    private void addInternalAgents(IScope iScope) {
        int n = 0;
        while (n < this.equations.size()) {
            this.getEquationAgents(iScope).put(n, iScope.getAgent());
            ++n;
        }
    }

    private void addInternalEquations(IScope iScope) {
        int n = 0;
        while (n < this.equations.size()) {
            this.addEquationsOf(iScope.getAgent());
            ++n;
        }
    }

    private void addExternalAgents(IScope iScope) {
        this.addExternalAgents(iScope, this.simultan, this.getExternalAgents(iScope));
    }

    private void addExternalEquations(IScope iScope) {
        for (IAgent iAgent : this.getExternalAgents(iScope)) {
            if (iAgent.dead()) continue;
            this.addEquationsOf(iAgent);
        }
    }

    private void removeExternalEquations(IScope iScope) {
        if (iScope.getAgent() == null) {
            return;
        }
        IMap iMap = (IMap)iScope.getAgent().getAttribute("__integrated_values");
        for (IAgent iAgent : this.getExternalAgents(iScope)) {
            if (iAgent.dead()) continue;
            iAgent.setAttribute("__integrated_values", (Object)iMap);
            this.removeEquationsOf(iAgent);
        }
    }

    private void addEquationsOf(IAgent iAgent) {
        Object object2;
        IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap = this.getEquations(this.currentScope.getAgent());
        IMap<Integer, GamaPair<IAgent, IExpression>> iMap2 = this.getVariableDiff(this.currentScope.getAgent());
        for (Object object2 : iMap.values()) {
            if (!((IAgent)object2.getKey()).equals(iAgent)) continue;
            return;
        }
        object2 = (SystemOfEquationsStatement)iAgent.getSpecies().getStatement(SystemOfEquationsStatement.class, this.getName());
        if (object2 != null) {
            GamaPair gamaPair;
            SingleEquationStatement singleEquationStatement;
            if (!iAgent.equals(this.currentScope.getAgent())) {
                int n = 0;
                int n2 = object2.equations.size();
                while (n < n2) {
                    this.getEquationAgents(this.currentScope).put(this.getEquationAgents(this.currentScope).size(), iAgent);
                    ++n;
                }
            }
            for (GamaPair gamaPair2 : object2.equations.values()) {
                singleEquationStatement = (SingleEquationStatement)((Object)gamaPair2.getValue());
                gamaPair = new GamaPair((Object)iAgent, (Object)singleEquationStatement, Types.AGENT, Types.NO_TYPE);
                iMap.put((Object)iMap.size(), (Object)gamaPair);
            }
            for (GamaPair gamaPair2 : object2.variables_diff.values()) {
                singleEquationStatement = (IExpression)gamaPair2.getValue();
                gamaPair = new GamaPair((Object)iAgent, (Object)singleEquationStatement, Types.AGENT, Types.NO_TYPE);
                iMap2.put((Object)iMap2.size(), (Object)gamaPair);
            }
        }
        this.setEquations(this.currentScope.getAgent(), iMap);
        this.setVariableDiff(this.currentScope.getAgent(), iMap2);
    }

    private void removeEquationsOf(IAgent iAgent) {
        IMap<Integer, GamaPair<IAgent, SingleEquationStatement>> iMap = this.getEquations(this.currentScope.getAgent());
        IMap<Integer, GamaPair<IAgent, IExpression>> iMap2 = this.getVariableDiff(this.currentScope.getAgent());
        if (iMap != null) {
            iMap.values().removeIf(gamaPair -> ((IAgent)gamaPair.getKey()).equals(iAgent));
        }
        this.setEquations(this.currentScope.getAgent(), iMap);
        this.setVariableDiff(this.currentScope.getAgent(), iMap2);
    }

    private void addExternalAgents(IScope iScope, Object object, Set<IAgent> set) {
        if (object instanceof IExpression) {
            this.addExternalAgents(iScope, ((IExpression)object).value(iScope), set);
        } else if (object instanceof IAgent && !object.equals(iScope.getAgent()) && !((IAgent)object).dead()) {
            set.add((IAgent)object);
        } else if (object instanceof GamlSpecies) {
            this.addExternalAgents(iScope, ((GamlSpecies)object).getPopulation(iScope), set);
        } else if (object instanceof IList) {
            for (Object t : ((IList)object).iterable(iScope)) {
                this.addExternalAgents(iScope, t, set);
            }
        }
    }
}

