/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.matrix;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.GamaObjectMatrix;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class MatrixOperators {
    @GamlAnnotations.operator(value={"."}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are matrix, returns the dot product of them", examples={@GamlAnnotations.example(value="matrix([[1,1],[1,2]]) . matrix([[1,1],[1,2]])", equals="matrix([[2,3],[3,5]])")})})
    @GamlAnnotations.test(value="matrix([[1,1],[1,2]]) . matrix([[1,1],[1,2]]) = matrix([[2,3],[3,5]])")
    public static IMatrix matrixMultiplication(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) throws GamaRuntimeException {
        try {
            if (iMatrix instanceof GamaIntMatrix && iMatrix2 instanceof GamaIntMatrix) {
                return MatrixOperators.toGamaIntMatrix(MatrixOperators.getRealMatrix(iMatrix).multiply(MatrixOperators.getRealMatrix(iMatrix2)));
            }
            return MatrixOperators.toGamaFloatMatrix(MatrixOperators.getRealMatrix(iMatrix).multiply(MatrixOperators.getRealMatrix(iMatrix2)));
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw GamaRuntimeException.error((String)" The dimensions of the matrices do not correspond", (IScope)iScope);
        }
    }

    @GamlAnnotations.operator(value={"determinant", "det"}, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="The determinant of the given matrix", masterDoc=true, examples={@GamlAnnotations.example(value="determinant(matrix([[1,2],[3,4]]))", equals="-2")})
    public static Double getDeterminant(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return new LUDecomposition(MatrixOperators.getRealMatrix(iMatrix)).getDeterminant();
    }

    @GamlAnnotations.operator(value={"trace"}, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="The trace of the given matrix (the sum of the elements on the main diagonal).", masterDoc=true, examples={@GamlAnnotations.example(value="trace(matrix([[1,2],[3,4]]))", equals="5")})
    public static Double getTrace(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return MatrixOperators.getRealMatrix(iMatrix).getTrace();
    }

    @GamlAnnotations.operator(value={"eigenvalues"}, content_type=2, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="The list of the eigen values of the given matrix", masterDoc=true, examples={@GamlAnnotations.example(value="eigenvalues(matrix([[5,-3],[6,-4]]))", equals="[2.0000000000000004,-0.9999999999999998]")})
    public static IList<Double> getEigen(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return MatrixOperators.fromApacheMatrixtoDiagList(iScope, new EigenDecomposition(MatrixOperators.getRealMatrix(iMatrix)).getD());
    }

    @GamlAnnotations.operator(value={"transpose"}, can_be_const=true, content_type=-299, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="The transposition of the given matrix", masterDoc=true, examples={@GamlAnnotations.example(value="transpose(matrix([[5,-3],[6,-4]]))", equals="matrix([[5,6],[-3,-4]])")})
    public static IMatrix transpose(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return iMatrix.reverse(iScope);
    }

    @GamlAnnotations.operator(value={"inverse"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="The inverse matrix of the given matrix. If no inverse exists, returns a matrix that has properties that resemble that of an inverse.", masterDoc=true, examples={@GamlAnnotations.example(value="inverse(matrix([[4,3],[3,2]]))", equals="matrix([[-2.0,3.0],[3.0,-4.0]])")})
    public static IMatrix<Double> inverse(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        return MatrixOperators.toGamaFloatMatrix(new LUDecomposition(MatrixOperators.getRealMatrix(iMatrix)).getSolver().getInverse());
    }

    @GamlAnnotations.operator(value={"append_vertically"}, content_type=-21, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="A matrix resulting from the concatenation of the columns  of the two given matrices. ", masterDoc=false, examples={@GamlAnnotations.example(value="matrix([[1,2],[3,4]]) append_vertically matrix([[1,2],[3,4]])", equals="matrix([[1,2,1,2],[3,4,3,4]])")})
    public static IMatrix opAppendVertically(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) {
        if (iMatrix instanceof GamaIntMatrix) {
            if (iMatrix2 instanceof GamaIntMatrix) {
                return ((GamaIntMatrix)iMatrix)._opAppendVertically(iScope, (GamaIntMatrix)iMatrix2);
            }
            if (iMatrix2 instanceof GamaFloatMatrix) {
                return GamaFloatMatrix.from((IScope)iScope, (IMatrix)iMatrix2)._opAppendVertically(iScope, (GamaFloatMatrix)iMatrix2);
            }
        } else if (iMatrix instanceof GamaFloatMatrix) {
            if (iMatrix2 instanceof GamaIntMatrix) {
                return ((GamaFloatMatrix)iMatrix)._opAppendVertically(iScope, GamaFloatMatrix.from((IScope)iScope, (IMatrix)iMatrix2));
            }
            if (iMatrix2 instanceof GamaFloatMatrix) {
                return ((GamaFloatMatrix)iMatrix)._opAppendVertically(iScope, (GamaFloatMatrix)iMatrix2);
            }
        }
        if (iMatrix instanceof GamaObjectMatrix && iMatrix2 instanceof GamaObjectMatrix) {
            return ((GamaObjectMatrix)iMatrix)._opAppendVertically(iScope, iMatrix2);
        }
        return iMatrix;
    }

    @GamlAnnotations.operator(value={"append_horizontally"}, content_type=-21, category={"Matrix-related operators"}, concept={"matrix"})
    @GamlAnnotations.doc(value="A matrix resulting from the concatenation of the rows of the two given matrices.", masterDoc=false)
    public static IMatrix opAppendHorizontally(IScope iScope, IMatrix iMatrix, IMatrix iMatrix2) {
        if (iMatrix instanceof GamaIntMatrix) {
            if (iMatrix2 instanceof GamaIntMatrix) {
                return ((GamaIntMatrix)iMatrix)._opAppendHorizontally(iScope, (GamaIntMatrix)iMatrix2);
            }
            if (iMatrix2 instanceof GamaFloatMatrix) {
                return GamaFloatMatrix.from((IScope)iScope, (IMatrix)iMatrix)._opAppendHorizontally(iScope, (GamaFloatMatrix)iMatrix2);
            }
        } else if (iMatrix instanceof GamaFloatMatrix) {
            if (iMatrix2 instanceof GamaIntMatrix) {
                return ((GamaFloatMatrix)iMatrix)._opAppendHorizontally(iScope, GamaFloatMatrix.from((IScope)iScope, (IMatrix)iMatrix2));
            }
            if (iMatrix2 instanceof GamaFloatMatrix) {
                return GamaFloatMatrix.from((IScope)iScope, (IMatrix)iMatrix)._opAppendHorizontally(iScope, (GamaFloatMatrix)iMatrix2);
            }
        }
        if (iMatrix instanceof GamaObjectMatrix && iMatrix2 instanceof GamaObjectMatrix) {
            return ((GamaObjectMatrix)iMatrix)._opAppendHorizontally(iScope, iMatrix2);
        }
        return iMatrix;
    }

    public static RealMatrix getRealMatrix(IMatrix iMatrix) {
        int n = iMatrix.getRows(null);
        int n2 = iMatrix.getCols(null);
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n, n2);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                array2DRowRealMatrix.setEntry(n3, n4, Cast.asFloat(null, (Object)iMatrix.get(null, n4, n3)).doubleValue());
                ++n4;
            }
            ++n3;
        }
        return array2DRowRealMatrix;
    }

    public static void updateMatrix(IMatrix iMatrix, RealMatrix realMatrix) {
        int n = iMatrix.getRows(null);
        int n2 = iMatrix.getCols(null);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                iMatrix.set(null, n4, n3, (Object)realMatrix.getEntry(n3, n4));
                ++n4;
            }
            ++n3;
        }
    }

    public static GamaIntMatrix toGamaIntMatrix(RealMatrix realMatrix) {
        GamaIntMatrix gamaIntMatrix = new GamaIntMatrix(realMatrix.getColumnDimension(), realMatrix.getRowDimension());
        MatrixOperators.updateMatrix((IMatrix)gamaIntMatrix, realMatrix);
        return gamaIntMatrix;
    }

    public static GamaFloatMatrix toGamaFloatMatrix(RealMatrix realMatrix) {
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(realMatrix.getColumnDimension(), realMatrix.getRowDimension());
        MatrixOperators.updateMatrix((IMatrix)gamaFloatMatrix, realMatrix);
        return gamaFloatMatrix;
    }

    public static IList<Double> fromApacheMatrixtoDiagList(IScope iScope, RealMatrix realMatrix) {
        IList iList = GamaListFactory.create((IType)Types.FLOAT);
        int n = 0;
        while (n < realMatrix.getColumnDimension()) {
            iList.add((Object)realMatrix.getEntry(n, n));
            ++n;
        }
        return iList;
    }
}

