/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.maths.pde.diffusion.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.topology.grid.FieldDiffuser;
import gama.core.metamodel.topology.grid.IDiffusionTarget;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.SimulationLocal;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.matrix.IMatrix;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AbstractStatement;
import java.util.Arrays;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="var", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the variable to be diffused. If diffused over a field, then this name will serve to identify the diffusion")}), @GamlAnnotations.facet(name="on", type={14, 31, 5}, optional=false, doc={@GamlAnnotations.doc(value="the list of agents (in general cells of a grid), or a field on which the diffusion will occur")}), @GamlAnnotations.facet(name="matrix", type={8}, of=2, optional=true, doc={@GamlAnnotations.doc(value="the diffusion matrix (\"kernel\" or \"filter\" in image processing). Can have any size, as long as dimensions are odd values.")}), @GamlAnnotations.facet(name="method", type={-201}, optional=true, values={"convolution", "dot_product"}, doc={@GamlAnnotations.doc(value="the diffusion method. One of 'convolution' or 'dot_product'")}), @GamlAnnotations.facet(name="min", type={2}, optional=true, doc={@GamlAnnotations.doc(value="if a value is smaller than this value, it will not be diffused. By default, this value is equal to 0.0. This value cannot be smaller than 0.")}), @GamlAnnotations.facet(name="mask", type={8}, of=2, optional=true, doc={@GamlAnnotations.doc(value="a matrix that masks the diffusion ( created from an image for instance). The cells corresponding to the values smaller than \"-1\" in the mask matrix will not diffuse, and the other will diffuse.")}), @GamlAnnotations.facet(name="proportion", type={2}, optional=true, doc={@GamlAnnotations.doc(value="a diffusion rate")}), @GamlAnnotations.facet(name="propagation", type={-200}, values={"diffusion", "gradient"}, optional=true, doc={@GamlAnnotations.doc(value="represents both the way the signal is propagated and the way to treat multiple propagation of the same signal occurring at once from different places. If propagation equals 'diffusion', the intensity of a signal is shared between its neighbors with respect to 'proportion', 'variation' and the number of neighbors of the environment places (4, 6 or 8). I.e., for a given signal S propagated from place P, the value transmitted to its N neighbors is : S' = (S / N / proportion) - variation. The intensity of S is then diminished by S `*` proportion on P. In a diffusion, the different signals of the same name see their intensities added to each other on each place. If propagation equals 'gradient', the original intensity is not modified, and each neighbors receives the intensity : S / proportion - variation. If multiple propagation occur at once, only the maximum intensity is kept on each place. If 'propagation' is not defined, it is assumed that it is equal to 'diffusion'.")}), @GamlAnnotations.facet(name="radius", type={1}, optional=true, doc={@GamlAnnotations.doc(value="a diffusion radius (in number of cells from the center)")}), @GamlAnnotations.facet(name="variation", type={2}, optional=true, doc={@GamlAnnotations.doc(value="an absolute value to decrease at each neighbors")}), @GamlAnnotations.facet(name="cycle_length", type={1}, optional=true, doc={@GamlAnnotations.doc(value="the number of diffusion operation applied in one simulation step")}), @GamlAnnotations.facet(name="avoid_mask", type={3}, optional=true, doc={@GamlAnnotations.doc(value="if true, the value will not be diffused in the masked cells, but will be restitute to the neighboring cells, multiplied by the proportion value (no signal lost). If false, the value will be diffused in the masked cells, but masked cells won't diffuse the value afterward (lost of signal). (default value : false)")})}, omissible="var")
@GamlAnnotations.inside(kinds={3, 11})
@validator(value=DiffusionValidator.class)
@GamlAnnotations.doc(value="This statements allows a value to diffuse among a species on agents (generally on a grid) depending on a given diffusion matrix.", usages={@GamlAnnotations.usage(value="A basic example of diffusion of the variable phero defined in the species cells, given a diffusion matrix math_diff is:", examples={@GamlAnnotations.example(value="matrix<float> math_diff <- matrix([[1/9,1/9,1/9],[1/9,1/9,1/9],[1/9,1/9,1/9]]);", isExecutable=false), @GamlAnnotations.example(value="diffuse var: phero on: cells matrix: math_diff;", isExecutable=false)}), @GamlAnnotations.usage(value="The diffusion can be masked by obstacles, created from a bitmap image:", examples={@GamlAnnotations.example(value="diffuse var: phero on: cells matrix: math_diff mask: mymask;", isExecutable=false)}), @GamlAnnotations.usage(value="A convenient way to have an uniform diffusion in a given radius is (which is equivalent to the above diffusion):", examples={@GamlAnnotations.example(value="diffuse var: phero on: cells proportion: 1/9 radius: 1;", isExecutable=false)})})
public class DiffusionStatement
extends AbstractStatement {
    SimulationLocal<DiffusionData> dataSupplier = SimulationLocal.withInitial(iScope -> new DiffusionData(iScope));

    public DiffusionStatement(IDescription iDescription) {
        super(iDescription);
    }

    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        DiffusionData diffusionData = (DiffusionData)this.dataSupplier.get(iScope);
        IMatrix iMatrix = Cast.asMatrix((IScope)iScope, (Object)this.getFacetValue(iScope, "mask"));
        double[][] dArray = this.translateMatrix(iScope, Cast.asMatrix((IScope)iScope, (Object)this.getFacetValue(iScope, "matrix")));
        double[][] dArray2 = this.computeMask(iScope, iMatrix);
        if (dArray == null) {
            dArray = this.computeDiffusionMatrix(iScope);
        }
        if (diffusionData.cycleLength != 1) {
            dArray = this.computeMatrix(dArray, diffusionData.cycleLength, diffusionData.isGradient);
        }
        FieldDiffuser.getDiffuser((IScope)iScope).addDiffusion(diffusionData.variableName, diffusionData.terrain, diffusionData.useConvolution, diffusionData.isGradient, dArray, dArray2, diffusionData.minValue, diffusionData.avoidMask);
        return null;
    }

    public double[][] translateMatrix(IScope iScope, IMatrix<?> iMatrix) {
        if (iMatrix == null) {
            return null;
        }
        int n = iMatrix.getRows(iScope);
        int n2 = iMatrix.getCols(iScope);
        double[][] dArray = new double[n2][n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[n4][n3] = Cast.asFloat((IScope)iScope, (Object)iMatrix.get(iScope, n4, n3));
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }

    private double[][] computeMatrix(double[][] dArray, int n, boolean bl) {
        double[][] dArray2 = dArray;
        int n2 = 2;
        while (n2 <= n) {
            double[][] dArray3;
            double[][] dArray4 = dArray3 = new double[(dArray.length - 1) * n2 + 1][(dArray[0].length - 1) * n2 + 1];
            int n3 = dArray3.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] dArray5 = dArray4[n4];
                Arrays.fill(dArray5, 0.0);
                ++n4;
            }
            int n5 = 0;
            while (n5 < dArray2.length) {
                n4 = 0;
                while (n4 < dArray2[0].length) {
                    n3 = 0;
                    while (n3 < dArray.length) {
                        int n6 = 0;
                        while (n6 < dArray[0].length) {
                            if (bl) {
                                if (dArray3[n5 + n3][n4 + n6] < dArray2[n5][n4] * dArray[n3][n6]) {
                                    dArray3[n5 + n3][n4 + n6] = dArray2[n5][n4] * dArray[n3][n6];
                                }
                            } else {
                                double[] dArray6 = dArray3[n5 + n3];
                                int n7 = n4 + n6;
                                dArray6[n7] = dArray6[n7] + dArray2[n5][n4] * dArray[n3][n6];
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                    ++n4;
                }
                ++n5;
            }
            dArray2 = dArray3;
            ++n2;
        }
        return dArray2;
    }

    private double[][] computeMask(IScope iScope, IMatrix<?> iMatrix) {
        double[][] dArray = null;
        if (iMatrix != null) {
            int n = iMatrix.getRows(iScope);
            int n2 = iMatrix.getCols(iScope);
            double[][] dArray2 = new double[n2][n];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    dArray2[n4][n3] = Cast.asFloat((IScope)iScope, (Object)iMatrix.get(iScope, n4, n3)) < -1.0 ? 0.0 : 1.0;
                    ++n4;
                }
                ++n3;
            }
            dArray = dArray2;
        } else {
            IList iList;
            Object object = this.getFacetValue(iScope, "on");
            DiffusionData diffusionData = (DiffusionData)this.dataSupplier.get(iScope);
            if (!(object instanceof IDiffusionTarget) && !(iList = Cast.asList((IScope)iScope, (Object)object)).isEmpty()) {
                ISpecies iSpecies = ((IAgent)iList.get(0)).getSpecies();
                if (!iSpecies.isGrid()) {
                    throw GamaRuntimeException.error((String)"Diffusion statement works only on grid agents", (IScope)iScope);
                }
                dArray = new double[diffusionData.terrain.getCols(iScope)][diffusionData.terrain.getRows(iScope)];
                for (IAgent iAgent : iList) {
                    int n = iAgent.getIndex();
                    int n5 = diffusionData.terrain.getCols(iScope);
                    dArray[n - n / n5 * n5][n / n5] = 1.0;
                }
            }
        }
        return dArray;
    }

    public double[][] computeDiffusionMatrix(IScope iScope) {
        double[][] dArray;
        block13: {
            int n;
            int n2;
            DiffusionData diffusionData;
            int n3;
            double d;
            double d2;
            block12: {
                d2 = Cast.asFloat((IScope)iScope, (Object)this.getFacetValue(iScope, "proportion"));
                d = Cast.asFloat((IScope)iScope, (Object)this.getFacetValue(iScope, "variation"));
                n3 = Cast.asInt((IScope)iScope, (Object)this.getFacetValue(iScope, "radius"));
                diffusionData = (DiffusionData)this.dataSupplier.get(iScope);
                if (n3 == 0) {
                    n3 = 1;
                }
                if (d2 == 0.0) {
                    d2 = 1.0;
                }
                if (!diffusionData.isGradient) break block12;
                int n4 = n3 * 2 + 1;
                dArray = new double[n4][n4];
                int n5 = 0;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = 0;
                    while (n7 < n4) {
                        n5 = diffusionData.nbNeighbors == 8 ? Math.max(Math.abs(n6 - n4 / 2), Math.abs(n7 - n4 / 2)) : Math.abs(n6 - n4 / 2) + Math.abs(n7 - n4 / 2);
                        dArray[n6][n7] = d2 / Math.pow(diffusionData.nbNeighbors, n5) - (double)n5 * d;
                        if (dArray[n6][n7] < 0.0) {
                            dArray[n6][n7] = 0.0;
                        }
                        ++n7;
                    }
                    ++n6;
                }
                break block13;
            }
            dArray = new double[3][3];
            int n8 = 0;
            if (diffusionData.nbNeighbors == 8) {
                n2 = 0;
                while (n2 < 3) {
                    n = 0;
                    while (n < 3) {
                        n8 = Math.max(Math.abs(n2 - 1), Math.abs(n - 1));
                        dArray[n2][n] = n8 == 0 ? 1.0 / ((double)diffusionData.nbNeighbors + 1.0) : (n8 == 1 ? d2 / ((double)diffusionData.nbNeighbors + 1.0) : 0.0);
                        ++n;
                    }
                    ++n2;
                }
            }
            if (diffusionData.nbNeighbors == 4) {
                dArray[0][1] = d2 / 5.0;
                dArray[1][0] = d2 / 5.0;
                dArray[1][2] = d2 / 5.0;
                dArray[2][1] = d2 / 5.0;
                dArray[1][1] = d2 / 5.0;
            }
            if (n3 > 1) {
                dArray = this.computeMatrix(dArray, n3, diffusionData.isGradient);
            }
            if (!(d > 0.0)) break block13;
            n2 = dArray.length;
            n = 0;
            while (n < n2) {
                int n9 = 0;
                while (n9 < n2) {
                    n8 = diffusionData.nbNeighbors == 8 ? Math.max(Math.abs(n - n2 / 2), Math.abs(n9 - n2 / 2)) : Math.abs(n - n2 / 2) + Math.abs(n9 - n2 / 2);
                    dArray[n][n9] = dArray[n][n9] - (double)n8 * d;
                    ++n9;
                }
                ++n;
            }
        }
        return dArray;
    }

    private class DiffusionData {
        IDiffusionTarget terrain;
        String variableName;
        double minValue;
        boolean useConvolution;
        boolean isGradient;
        boolean avoidMask;
        int cycleLength;
        int nbNeighbors;

        private DiffusionData(IScope iScope) {
            Object object;
            this.variableName = Cast.asString((IScope)iScope, (Object)DiffusionStatement.this.getFacetValue(iScope, "var"));
            this.minValue = Cast.asFloat((IScope)iScope, (Object)DiffusionStatement.this.getFacetValue(iScope, "min", 0.0));
            if (this.minValue < 0.0) {
                throw GamaRuntimeException.error((String)"Facet \"min_value\" cannot be smaller than 0 !", (IScope)iScope);
            }
            this.useConvolution = "convolution".equals(DiffusionStatement.this.getLiteral("method", "convolution"));
            this.isGradient = "gradient".equals(DiffusionStatement.this.getLiteral("propagation", "diffusion"));
            Object object2 = DiffusionStatement.this.getFacetValue(iScope, "on");
            if (object2 instanceof ISpecies) {
                object2 = ((ISpecies)object2).getPopulation(iScope).getTopology().getPlaces();
            } else if (object2 instanceof IList && (object = ((IList)object2).get(0)) instanceof IAgent) {
                object2 = ((IAgent)object).getPopulation().getTopology().getPlaces();
            }
            this.terrain = (IDiffusionTarget)object2;
            this.cycleLength = Cast.asInt((IScope)iScope, (Object)DiffusionStatement.this.getFacetValue(iScope, "cycle_length", 1));
            this.nbNeighbors = this.terrain.getNbNeighbours();
            this.avoidMask = false;
            if (DiffusionStatement.this.getFacet(new String[]{"avoid_mask"}) != null) {
                this.avoidMask = Cast.asBool((IScope)iScope, (Object)DiffusionStatement.this.getFacet(new String[]{"avoid_mask"}).value(iScope));
            }
        }
    }

    public static class DiffusionValidator
    implements IDescriptionValidator<StatementDescription> {
        public void validate(StatementDescription statementDescription) {
            double d;
            IExpression iExpression = statementDescription.getFacetExpr(new String[]{"on"});
            if (iExpression.getGamlType().isAgentType() && iExpression.getGamlType().getSpecies().isGrid()) {
                statementDescription.error("Diffusions can only be executed on grid species", "gaml.general.issue");
            }
            if ((iExpression = statementDescription.getFacetExpr(new String[]{"min"})) != null && iExpression.isConst() && (d = Cast.asFloat(null, (Object)iExpression.literalValue()).doubleValue()) < 0.0) {
                statementDescription.error("'min_value' facet cannot accept negative values (" + iExpression.serializeToGaml(false) + ")", "gaml.general.issue");
            }
            IExpressionDescription iExpressionDescription = statementDescription.getFacet("matrix");
            IExpressionDescription iExpressionDescription2 = statementDescription.getFacet("proportion");
            IExpressionDescription iExpressionDescription3 = statementDescription.getFacet("propagation");
            IExpressionDescription iExpressionDescription4 = statementDescription.getFacet("radius");
            IExpressionDescription iExpressionDescription5 = statementDescription.getFacet("variation");
            if (iExpressionDescription2 != null && iExpressionDescription != null) {
                statementDescription.error("\"matrix:\" and \"proportion:\" can not be used at the same time", "gaml.general.issue");
            }
            if (iExpressionDescription3 != null && iExpressionDescription != null) {
                statementDescription.error("\"matrix:\" and \"propagation:\" can not be used at the same time", "gaml.general.issue");
            }
            if (iExpressionDescription != null && iExpressionDescription4 != null) {
                statementDescription.error("\"matrix:\" and \"radius:\" can not be used at the same time", "gaml.general.issue");
            }
            if (iExpressionDescription != null && iExpressionDescription5 != null) {
                statementDescription.error("\"matrix:\" and \"variation:\" can not be used at the same time", "gaml.general.issue");
            }
        }
    }
}

