/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.websocket;

import gama.dev.DEBUG;
import gama.extension.network.tcp.ServerService;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class GamaServer
extends WebSocketServer {
    private final ServerService myService;

    public GamaServer(int n, ServerService serverService) throws UnknownHostException {
        super(new InetSocketAddress(n));
        this.myService = serverService;
    }

    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        System.out.println(webSocket.getRemoteSocketAddress().getAddress().getHostAddress() + " entered the room!");
    }

    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        this.broadcast(String.valueOf(webSocket) + " has left the room!");
        DEBUG.OUT((Object)(String.valueOf(webSocket) + " has left the room!"));
    }

    public void onMessage(WebSocket webSocket, String string) {
        DEBUG.OUT((Object)(String.valueOf(webSocket) + ": " + string));
        String string2 = string;
        if (!this.myService.getConnector().isRaw()) {
            string2 = string2.replace("@n@", "\n");
            string2 = string2.replace("@b@@r@", "\b\r");
        }
        this.myService.receivedMessage(webSocket.toString(), string2);
    }

    public void onMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.onMessage(webSocket, StandardCharsets.UTF_8.decode(byteBuffer).toString());
    }

    public void onError(WebSocket webSocket, Exception exception) {
        exception.printStackTrace();
    }

    public void onStart() {
        this.setConnectionLostTimeout(0);
        this.setConnectionLostTimeout(100);
    }
}

