/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.websocket;

import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.extension.network.common.CommandMessage;
import gama.extension.network.common.Connector;
import gama.extension.network.common.GamaNetworkException;
import gama.extension.network.common.MessageFactory;
import gama.extension.network.common.socket.SocketService;
import gama.extension.network.websocket.WebSocketClientService;
import gama.extension.network.websocket.WebSocketServerService;
import java.io.IOException;
import java.util.ArrayList;

public class WebSocketConnector
extends Connector {
    public static String _WEBSOCKET_SERVER = "__websocket_server";
    public static String _WEBSOCKET_SOCKET = "__websocket_socket";
    public static String _WEBSOCKET_CLIENT = "__websocket_client";
    public static Integer _WEBSOCKET_SO_TIMEOUT = 100;
    private SocketService socket;
    private final boolean isServer;
    private final ArrayList<String> remoteBoxName;

    public WebSocketConnector(IScope iScope, boolean bl, boolean bl2) {
        this.isServer = bl;
        this.setRaw(bl2);
        this.remoteBoxName = new ArrayList();
    }

    protected void extractAndApplyCommand(String string, String string2) {
        CommandMessage commandMessage = MessageFactory.unPackCommandMessage(string, string2);
        String string3 = commandMessage.getPlainContents();
        if (commandMessage.getCommand().equals((Object)CommandMessage.CommandType.NEW_GROUP)) {
            this.remoteBoxName.add(string3);
        }
        if (commandMessage.getCommand().equals((Object)CommandMessage.CommandType.REMOVE_GROUP)) {
            this.remoteBoxName.remove(string3);
        }
    }

    @Override
    protected void connectToServer(IAgent iAgent) throws GamaNetworkException {
        if (this.isConnected) {
            return;
        }
        String string = this.getConfigurationParameter("SERVER_URL");
        int n = Integer.parseInt(this.getConfigurationParameter("SERVER_PORT"));
        this.socket = this.isServer ? new WebSocketServerService(iAgent, n, this) : new WebSocketClientService(string, n, this);
        try {
            this.socket.startService();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setConnected();
    }

    @Override
    protected boolean isAlive(IAgent iAgent) throws GamaNetworkException {
        return this.socket.isOnline();
    }

    @Override
    protected void subscribeToGroup(IAgent iAgent, String string) throws GamaNetworkException {
        if (!this.localMemberNames.containsKey(string)) {
            this.remoteBoxName.add(string);
        }
        if (!this.isRaw()) {
            CommandMessage commandMessage = MessageFactory.buildCommandMessage(this.socket.getLocalAddress(), this.socket.getRemoteAddress(), CommandMessage.CommandType.NEW_GROUP, string);
            this.sendMessage(iAgent, this.socket.getRemoteAddress(), MessageFactory.packMessage(commandMessage));
        }
    }

    @Override
    protected void unsubscribeGroup(IAgent iAgent, String string) throws GamaNetworkException {
        this.remoteBoxName.remove(string);
        if (!this.isRaw()) {
            CommandMessage commandMessage = MessageFactory.buildCommandMessage(this.socket.getLocalAddress(), this.socket.getRemoteAddress(), CommandMessage.CommandType.REMOVE_GROUP, string);
            this.sendMessage(iAgent, this.socket.getRemoteAddress(), MessageFactory.packMessage(commandMessage));
        }
    }

    @Override
    protected void releaseConnection(IScope iScope) throws GamaNetworkException {
        this.socket.stopService();
        this.socket = null;
        this.isConnected = false;
    }

    @Override
    protected void sendMessage(IAgent iAgent, String string, String string2) throws GamaNetworkException {
        try {
            if (this.socket != null) {
                this.socket.sendMessage(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public SocketService getSocketService() {
        return this.socket;
    }
}

