/*
 * Decompiled with CFR 0.152.
 */
package gama.extension.network.serial;

import com.fazecast.jSerialComm.SerialPort;
import gama.dev.THREADS;
import gama.extension.network.serial.AlertBox;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.util.Scanner;

public class MyArduino {
    private SerialPort comPort;
    private String portDescription;
    private int baud_rate;

    public MyArduino() {
    }

    public MyArduino(String string) {
        this.portDescription = string;
        this.comPort = SerialPort.getCommPort((String)this.portDescription);
    }

    public MyArduino(String string, int n) {
        this.portDescription = string;
        this.comPort = SerialPort.getCommPort((String)this.portDescription);
        this.baud_rate = n;
        this.comPort.setBaudRate(this.baud_rate);
    }

    public boolean openConnection() {
        if (this.comPort.openPort()) {
            THREADS.WAIT((long)100L, (String[])new String[0]);
            return true;
        }
        AlertBox alertBox = new AlertBox(new Dimension(400, 100), "Error Connecting", "Try Another port");
        alertBox.display();
        return false;
    }

    public void closeConnection() {
        this.comPort.closePort();
    }

    public void setPortDescription(String string) {
        this.portDescription = string;
        this.comPort = SerialPort.getCommPort((String)this.portDescription);
    }

    public void setBaudRate(int n) {
        this.baud_rate = n;
        this.comPort.setBaudRate(this.baud_rate);
    }

    public String getPortDescription() {
        return this.portDescription;
    }

    public SerialPort getSerialPort() {
        return this.comPort;
    }

    public String serialRead() {
        this.comPort.setComPortTimeouts(1, 0, 0);
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(this.comPort.getInputStream());
        try {
            while (scanner.hasNext()) {
                stringBuilder.append(scanner.next()).append("\n");
            }
            scanner.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public String serialRead(int n) {
        this.comPort.setComPortTimeouts(1, 0, 0);
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Scanner scanner = new Scanner(this.comPort.getInputStream());
        try {
            while (scanner.hasNext() && n2 <= n) {
                stringBuilder.append(scanner.next()).append("\n");
                ++n2;
            }
            scanner.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public void serialWrite(String string) {
        this.comPort.setComPortTimeouts(4096, 0, 0);
        THREADS.WAIT((long)5L, (String[])new String[0]);
        PrintWriter printWriter = new PrintWriter(this.comPort.getOutputStream());
        printWriter.print(string);
        printWriter.flush();
    }

    public void serialWrite(String string, int n, int n2) {
        this.comPort.setComPortTimeouts(4096, 0, 0);
        THREADS.WAIT((long)5L, (String[])new String[0]);
        PrintWriter printWriter = new PrintWriter(this.comPort.getOutputStream());
        int n3 = 0;
        while (n3 < string.length()) {
            printWriter.write(string.substring(n3, n3 + n));
            printWriter.flush();
            System.out.println(string.substring(n3, n3 + n));
            THREADS.WAIT((long)n2, (String[])new String[0]);
            n3 += n;
        }
        printWriter.write(n);
        printWriter.flush();
    }

    public void serialWrite(char c) {
        this.comPort.setComPortTimeouts(4096, 0, 0);
        THREADS.WAIT((long)5L, (String[])new String[0]);
        PrintWriter printWriter = new PrintWriter(this.comPort.getOutputStream());
        printWriter.write(c);
        printWriter.flush();
    }

    public void serialWrite(char c, int n) {
        this.comPort.setComPortTimeouts(4096, 0, 0);
        THREADS.WAIT((long)5L, (String[])new String[0]);
        PrintWriter printWriter = new PrintWriter(this.comPort.getOutputStream());
        printWriter.write(c);
        printWriter.flush();
        THREADS.WAIT((long)n, (String[])new String[0]);
    }
}

